<?
/*          0: ah_in
            1: ah_hout
            2: ahd_in            
            3: ahd_out
            4: wd_in
            5: wd_out
            6: kwh_in
            7: kwh_out
            8: am_in
            9: am_out
            10: a_in
            11: a_out
            12: w_in
            13: w_out
            14: wm_in
            15: wm_out
            */
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : ajaxdata.cgi
 * 
 *  Description: Main ajax script used to pass values to index page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 ********************************************************************/
error_reporting(0);
 // clear the sysmsg
if ($_GET['clrmsg']) {
    $_GLOBALS['sysmsg']='';  
    $_GLOBALS['needreboot']=0;
}
include("/lang/lang.inc");
print("{");    
            if (!$_GLOBALS['v_role']) {
                $v=adc_read(0);
                $v=floatval($_GLOBALS['v_adc_mul'])*(floatval($v)+floatval($_GLOBALS['v_adc_offset']));
            } else $v=mb_get_val_by_role($_GLOBALS['v_role']);
            
            
         // iterate through all loaded groups, and update the ah and watt hour counters
            $numgrp=sizeof($_GLOBALS['grp']);
            $total=0;
            print('"grp":[');
            for ($grp=0;$grp < $numgrp; $grp++) {
                print("{\r\n");
                if ($_GLOBALS['grp'][$grp]['type']<=1) {
                    $numc=sizeof($_GLOBALS['grp'][$grp]['c']);
                    $numw=sizeof($_GLOBALS['grp'][$grp]['w']);
                    $current=0;
  		            $w=0;
                    $vgrp=$v;
                    
                    // if this particular group has a voltage sensor associate with it, use it
                    if ($_GLOBALS['grp'][$grp]['v']>0) {
                        $vgrp=mb_get_val_by_role($_GLOBALS['grp'][$grp]['v']);
                    }
                    for ($i=0;$i<$numc;$i++) {
                        $current = $current + mb_get_val_by_role($_GLOBALS['grp'][$grp]['c'][$i]['role']);
                    } 
                    if (($current>-0.1) && ($current<0.1)) 
                        $current=0;
                        
                    for ($i=0;$i<$numw;$i++) {
                        $w = $w + mb_get_val_by_role($_GLOBALS['grp'][$grp]['w'][$i]['role'])*$_GLOBALS['grp'][$grp]['w'][$i]['scale'];
                    } 
                        
                    print('"c":'.$current.",\r\n");
                    print('"wd_out":'.$_GLOBALS['grp'][$grp]['vals'][5].",\r\n");
                    print('"wd_in":'.$_GLOBALS['grp'][$grp]['vals'][4].",\r\n");
                    
                    print('"ahd":'.$_GLOBALS['grp'][$grp]['ahd'].",\r\n");
                    print('"whd":'.$_GLOBALS['grp'][$grp]['ahd'].",\r\n");
                    if ($w==0) {
                        if ($current>0) {
                            print('"w_in":'.($current*$vgrp).",\r\n");
                        } else {
                            print('"w_out":'.(-$current*$vgrp).",\r\n");
                        }
                    } else {
                        if ($w>0) {
                            print('"w_in":'.($w).",\r\n");
                        } else {
                            print('"w_out":'.(-$w).",\r\n");
                        }
                    }
                    $total+=$current;
                } else {
                    if ($_GLOBALS['grp'][$grp]['type']==2) {
                        if ($_GLOBALS['grp'][$grp]['h']) {
                            print('"h":'.mb_get_val_by_role($_GLOBALS['grp'][$grp]['h']).",\r\n");
                        } else print('"h":0,\r\n');
                        if ($_GLOBALS['grp'][$grp]['m']) {
                            print('"m":'.mb_get_val_by_role($_GLOBALS['grp'][$grp]['m']).",\r\n");
                        } else print('"m":0,\r\n');
                        if ($_GLOBALS['grp'][$grp]['l']) {
                            print('"l":'.mb_get_val_by_role($_GLOBALS['grp'][$grp]['l']).",\r\n");
                        } else {
                            if ($_GLOBALS['grp'][$grp]['m']) {
                                print('"l":'.mb_get_val_by_role($_GLOBALS['grp'][$grp]['m']).",\r\n");
                            } else print('"l":0,\r\n');
                        }
                        if ($_GLOBALS['grp'][$grp]['out']) {
                            print('"out":'.mb_get_val_by_role($_GLOBALS['grp'][$grp]['out']).",\r\n");
                        } else print('"out":0,\r\n');      
                         if ($_GLOBALS['grp'][$grp]['c']) {
                             $current=mb_get_val_by_role($_GLOBALS['grp'][$grp]['c']);
                             if (($current>-0.1) && ($current<=0.1)) 
                                $current=0;
                            print('"c":'.$current.",\r\n");
                        }
                    }
                }
		 if ($_GLOBALS['grp'][$grp]['wr']>0) {
			$w=mb_get_val_by_role($_GLOBALS['grp'][$grp]['wr']);
			print('"wr":'.$w.",\r\n");
		}
                print('"type":'.$_GLOBALS['grp'][$grp]['type'].',\r\n');
                print('"show":'.$_GLOBALS['grp'][$grp]['show'].',\r\n');
                print('"color":"'.$_GLOBALS['grp'][$grp]['color'].'",\r\n');
                print('"name":"'.$_GLOBALS['grp'][$grp]['name'].'"}\r\n');
                if ($grp<($numgrp-1)) print(",");
            }
            print("],\r\n");


            $numsw=sizeof($_GLOBALS['sw']);
            print('"sw":[');
            for ($sw=0;$sw < $numsw; $sw++) {
                print("{\r\n"); 
                $role=$_GLOBALS['sw'][$sw]['role'];
                $state= mb_get_val_by_role($role);
                print('"role":'.$role.",\r\n");
                print('"state":'.$state.",\r\n");
                print('"type":'.$_GLOBALS['sw'][$sw]['type'].",\r\n");
                print('"name":"'.$_GLOBALS['sw'][$sw]['name'].'"}\r\n');
                if ($sw<($numsw-1)) print(",");
            }
            
            print("],\r\n");
            $numr=sizeof($_GLOBALS['roles']);
            print('"roles":[');
            for ($sw=0;$sw < $numr; $sw++) {
                print("{\r\n");
                $role=$_GLOBALS['roles'][$sw]['role'];
                $val= mb_get_val_by_role($role);
                print('"role":'.$role.",\r\n");
                print('"val":'.$val.",\r\n");
                print('"name":"'.$_GLOBALS['roles'][$sw]['name'].'"}\r\n');
                if ($sw<($numr-1)) print(",");
            }
            
            print("],\r\n");     
            $numr=sizeof($_GLOBALS['vars']);
            print('"vars":[');
            for ($sw=0;$sw < $numr; $sw++) {
                print("{\r\n");
                $role=$_GLOBALS['vars'][$sw];
                
                $val= $_GLOBALS[$role];
                if (is_numeric($val)) 
                    print('"val":'.$val.",\r\n");
                else 
                    print('"val":"'.strval($val)."\",\r\n");
                print('"name":"'.$role.'"}\r\n');
                if ($sw<($numr-1)) print(",");
            }
            
            print("],\r\n");              
            print('"mode": '+$_GLOBALS['mode']+',\n');
            print('"voltage": "'+number_format($v,1)+'",\n');
             print('"freemem": "'+freemem()+'",\n');
             print('"loggedin": '+$_SESSION['logged_in']+',\n');
             if ($_GLOBALS['needreboot']) {
                print('"sysmsg": "'.lang("NEED_REBOOT").'",');
             } else {
                 if ($_GLOBALS['sysmsg']) print('"sysmsg": "'+$_GLOBALS['sysmsg']+'",'); 
             }
            
            print('"uptime":"'.(uptime()/1000).'",\n');
            print('"voltage_raw":"'+$vorg+'",\n');
            print('"time":"'+strftime("%c",time())+'",\n');
            print('"battery_percent":"'+intval($_GLOBALS['battery_percent'])+'",\n');
            print('"total_current":'+intval($_GLOBALS['total_current'])+',\n');
            print('"total_watts":'+intval($_GLOBALS['total_watts'])+',\n');
            for ($xi=0;$xi<sizeof($_GLOBALS['hooks']['ajax']);$xi++) {
                include($_GLOBALS['hooks']['ajax'][$xi]);
            }
            $bat_ah=$_GLOBALS['battery_ah'];
            if ($_GLOBALS['average_ah']>0) {
                $a=$_GLOBALS['average_ah']/$_GLOBALS['average_cnt'];
                $diff=(floatval($_GLOBALS['battery_ah'])-floatval($_GLOBALS['battery_cur_ah']));
                
                $hrs=$diff/$a;
                if ($_GLOBALS['battery_percent']>=100) {
                    print('"battery_status":"Battery is full."');
                } else {
                    if ($hrs>1) {
                        print('"battery_status":"Battery will be charged in about '+intval($hrs)+' hours at current rate."');
                    } else {
                         print('"battery_status":"Battery will be charged in about '+intval($hrs/60)+' minutes at current rate."');
                    }
                }
            } else {
                 if ($_GLOBALS['average_cnt']>0) {
                    $a=-$_GLOBALS['average_ah']/$_GLOBALS['average_cnt'];
                 } else {
                     $a=-$total;
                 }
                $diff=($_GLOBALS['battery_cur_ah']);
                $mid=($bat_ah/2);
                if ($diff<=$mid) {
                    $hrs=$diff/$a;
                    if ($total > (0-2)) {
                            print('"battery_status":"'.lang('BATTERY_DISCHARGING').'"');
                        } else {
                            if ($hrs < -1) {
                                print('"battery_status":"'.lang('BATTERY_EMPTY_IN').' '+intval($hrs)+' '.lang('HOURS').' '.lang('BATTERY_EMPTY_IN2').'"');
                            } else {
                                print('"battery_status":"'.lang('BATTERY_EMPTY_IN').' '+intval($hrs/60)+' '.lang('MINUTES').' '.lang('BATTERY_EMPTY_IN2').'"');
                            }
                        } 
                } else {
                    $hrs=($diff-$mid)/$a;
                    if ($total > (0-2)) {
                            print('"battery_status":"'.lang('BATTERY_DISCHARGING').'"');
                        } else {
                            if ($hrs>1) {
                                print('"battery_status":"'.lang('BATTERY_HALF_IN').' '+intval($hrs)+' '.lang('HOURS').' '.lang('BATTERY_HALF_IN2').'"');
                            } else {
                                print('"battery_status":"'.lang('BATTERY_HALF_IN').' '+intval($hrs/60)+' '.lang('MINUTES').' '.lang('BATTERY_HALF_IN2').'"');
                            }
                        } 
                    
                }
            }
            
           
            
            ?>
   
 }
 
