<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : datalogedit.cgi
 * 
 *  Description: Data log edit page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       06/01/14    v1.1 - memory issues solved
 * Akash Heimlich       03/04/18    v1.2 - different intervals to save
 *                      21/06/18    v2.0   WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="GroupEditCtrl"; 
$title=lang('PAGE_TITLE','datalogedit');
include("/app/header.inc");

$export_only=ini_get("/config/dataexport.ini","export","export_only",0);
$export_portal=ini_get("/config/dataexport.ini","export","export_portal",0);
$intervalportal=ini_get("/config/dataexport.ini","export","intervalportal",5);
    
$num_groups=ini_get("/config/datalog.ini","data","num_groups",0);
  if ($_GET['new']==1) {
    $_GET['data_idx']=$num_groups;
    $idx=$_GET['data_idx'];
    $grpname='New Group';
    $grpstatus=1;
    $grptype=0;
    $grpnumvar=0;
    $grpinterval=15;
    $grpmins=1;
  } else {
    $idx=$_GET['data_idx'];
    $grpname=ini_get("/config/datalog.ini","data","group".$idx."name","");
    $grpstatus=ini_get("/config/datalog.ini","data","group".$idx."status",0);
    $grptype=ini_get("/config/datalog.ini","data","group".$idx."type",0);
    $grpnumvar=ini_get("/config/datalog.ini","data","group".$idx."numvar",0);
    $grpinterval=ini_get("/config/datalog.ini","data","group".$idx."interval",15);
    $grpmins=ini_get("/config/datalog.ini","data","group".$idx."mins",1);
  }
  $idx=$_GET['data_idx'];
  //print_r($arr);
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/datalogging.cgi"><? print(lang('DATA_COLLECTION','datalogedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','datalogedit')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-exchange"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','datalogedit')) ?> - <? print ($grpname); ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','roleedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/datalogging.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','datalogedit')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1 || settings_locked' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','datalogedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','datalogedit')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','datalogedit')) ?></div>

<!-- VARIABLES -->
<div ng-init="group_index=<? print($_GET['data_idx']); ?>;"></div>
<div ng-init="group_id=<? print($idx); ?>;"></div>
<div ng-init="group_name='<? print($grpname); ?>';"></div>
<div ng-init="group_type='<? print($grptype); ?>';"></div>
<div ng-init="group_status=<? print($grpstatus); ?>;"></div>
<div ng-init="group_numvar=<? print($grpnumvar); ?>;"></div>
<div ng-init="group_interval=<? print($grpinterval); ?>;"></div>
<div ng-init="group_mins=<? print($grpmins); ?>;"></div>
<? 
for ($i=0;$i<$grpnumvar;$i++) {
  print('<div ng-init="datapoints.push({vartype:\''+ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'vartype')+'\',varval:\''+
        ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'varval')+'\',varscale:\''+
        (ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'varscale'))+'\',varfn:\''+
        (ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'varfn'))+'\',min:\''+
        (ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'min',0))+'\',max:\''+
        (ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'max',0))+'\'})"></div>');
  print('<div ng-init="olddatapoints.push({vartype:\''+ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'vartype')+'\',varval:\''+ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'varval')+'\',varscale:\''+(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'varscale'))+'\',varfn:\''+(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'varfn'))+'\',min:\''+(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'min',0))+'\',max:\''+(ini_get("/config/datalog.ini","data",'group'+$idx+'var'+$i+'max',0))+'\'})"></div>');
}  
 
?>

<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DATA_COLLECTION','datalogedit')) ?></h5>
        <p class="card-text">    
        
            <div class="form-group">
                <label for="group_name"><? print(lang('GROUP_NAME','datalogedit')) ?></label>
                <input type="text" class="form-control" ng-model="group_name"  class='span12' ng-maxlength=30 name='group_name' required aria-describedby="rnHelp" my-directive placeholder="<? print(lang('GROUP_NAME','datalogedit')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('GROUP_NAME_HELP','datalogedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.group_name.$invalid"><? print(lang('GROUP_NAME_INVALID','datalogedit')) ?></small>
            </div>			
            <div class="form-group">
                <label for="group_type"><? print(lang('GROUP_TYPE','datalogedit')) ?></label>
                <select ng-model="group_type" name='group_type' class="form-control">
			                <option value='0'><? print(lang('SPLIT_FILE','datalogedit')) ?></option>
                            <option value='1'><? print(lang('SINGLE_FILE','datalogedit')) ?></option>
                </select>
                <small class="form-text text-muted"><? print(lang('GROUP_TYPE_HELP','datalogedit')) ?></small>
	        </div>
            
            <div class="form-group">
                <label for="group_status"><? print(lang('GROUP_STATUS','datalogedit')) ?></label>
                <select ng-model="group_status" name='group_status' class="form-control">
			                <option value='0'><? print(lang('DISABLED','datalogedit')) ?></option>
                            <option value='1'><? print(lang('ENABLED','datalogedit')) ?></option>
                            <option value='2'><? print(lang('DELETED','datalogedit')) ?></option>
                </select>
                <small class="form-text text-muted"><? print(lang('GROUP_STATUS_HELP','datalogedit')) ?></small>
	        </div>
	        
	        <div class="form-group">
                <label for="group_interval"><? print(lang('GROUP_INTERVAL','datalogedit')) ?></label>
                <input class="form-control" type='number' ng-model="group_interval"  class='span12' name='group_interval' <? if ($export_portal && $export_only) print("readonly"); ?> required size='3' min="1" max="254" integer aria-describedby="diHelp" placeholder="<? print(lang('GROUP_INTERVAL','datalogedit')) ?>">
                <small id="diHelp" class="form-text text-muted"><? print(lang('GROUP_INTERVAL_HELP','datalogedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.group_interval.$invalid"><? print(lang('GROUP_INTERVAL_INVALID','datalogedit')) ?></small>
            </div>
            
            <div class="form-group">
                <label for="group_mins"><? print(lang('GROUP_MINS','datalogedit')) ?></label>
                <input class="form-control" type='number' ng-model="group_mins"  class='span12' name='group_mins' required size='3' min="1" max="60" integer aria-describedby="diHelp" placeholder="<? print(lang('GROUP_MINS','datalogedit')) ?>">
                <small id="diHelp" class="form-text text-muted"><? print(lang('GROUP_MINS_HELP','datalogedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.group_mins.$invalid"><? print(lang('GROUP_MINS_INVALID','datalogedit')) ?></small>
            </div>
        </p>
	</div>
</div>  		        
<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('DATA_POINTS','datalogedit')) ?></h5>
        
        <p class="card-text">    
			<div class="table-responsive">					
<a name='adddatapoint'></a>
<div style='float:right'><a name='addact'></a><button class="btn btn-large" ng-click="datapoints.push({edit:1})"><i class="icon-plus"></i> Add</button></div>
			
                <table class='table table-striped' summary="Device List">
                    <tr>
                        <th scope="col"></th>
                        <th scope="col">ID</th>
                        <th scope="col"><? print(lang('TYPE','datalogedit')) ?></th>
                        <th scope="col"><? print(lang('VALUE','datalogedit')) ?></th></th>
                        <th scope="col"><? print(lang('SCALE','datalogedit')) ?></th>
                        <th scope="col"><? print(lang('MIN','datalogedit')) ?></th>
                        <th scope="col"><? print(lang('MAX','datalogedit')) ?></th>
                        <th scope="col"><? print(lang('FUNCTION','datalogedit')) ?></th>
                        <th scope="col"><? print(lang('OPTIONS','datalogedit')) ?></th>
                    </tr>
                    <tr ng-repeat="item in datapoints">
                        <td><a name='datapoint{{$index}}'></a></td>
                        <td><span class="badge badge-pill badge-dark">{{$index+1}}</span></td>
                        <td><strong>{{makeValueType(item)}}</strong><div ng-show='item.edit==1'>
                            <select ng-model="item.vartype" class='form-control'>
                                <option value='1'><? print(lang('SYSTEM_VAR','datalogedit')) ?></option>
                                <option value='2'><? print(lang('DEVICE_VAR','datalogedit')) ?></option>
                                <option value='3'><? print(lang('GLOBAL_VAR','datalogedit')) ?></option>            
                                </select>
                            </div>
                        </td>            
                        <td><strong>{{makeValue(item)}}</strong><div ng-show='item.edit==1 && item.vartype==1'>
                            <select ng-model="item.varval" class='form-control'>
                            <? 
                            $num_sysvars=ini_get("/config/sysvars.ini","sysvars","num_sysvars",0);
                            
                            for ($i=1;$i<$num_sysvars;$i++) {
                                $st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title');
                                print("<option value='".$i."'>".$st."</option>\r\n");
                            } ?>
                                </select>
                            </div><div ng-show='item.edit==1 && item.vartype==2'>
                            <select ng-model="item.varval" class='form-control' >
                            <? 
                                $num_roles=ini_get("/config/roles.ini","roles","num_roles",0);
                                for ($i=0;$i<$num_roles;$i++) { 
                                    print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
                                }
                                ?>
                                </select>
                            </div>
                            <div ng-show='item.edit==1 && item.vartype==3'><input class='form-control' type='text' ng-model='item.varval'></div>
                        </td>            
                        <td><span ng-hide='item.edit==1'><strong>{{makeScale(item)}}</strong></span>
                            <div ng-show='item.edit==1'><input type='text' class='form-control' ng-model='item.varscale'></div>
                        </td>
                        <td><span ng-hide='item.edit==1'><strong>{{item.min}}</strong></span>
                            <div ng-show='item.edit==1'><input type='text' class='form-control' ng-model='item.min'></div>
                        </td>            
                        <td><span ng-hide='item.edit==1'><strong>{{item.max}}</strong></span>
                            <div ng-show='item.edit==1'><input type='text' class='form-control' ng-model='item.max'></div>
                        </td>            
                        
                        <td><strong>{{makeFn(item)}}</strong><div ng-show='item.edit==1'>
                        <select ng-model="item.varfn" class='form-control' >
                            <option value='0'><? print(lang('AVERAGE','datalogedit')) ?></option>
                            <option value='1'><? print(lang('MIN','datalogedit')) ?></option>
                            <option value='2'><? print(lang('MAX','datalogedit')) ?></option>            
                            <option value='3'><? print(lang('INSTANTANEOUS','datalogedit')) ?></option>            
                            </select>
                        </div>
                        </td>            
                        <td>
                            <div class="dropdown">
                                <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <? print(lang('ACTION','datalogedit')) ?> <span class="caret"></span>
                                </button>
                                
                                <div class="dropdown-menu dropdown-menu-right text-dark" >
                                    <a class="dropdown-item" ng-click='item.edit=1' href='#datapoint{{$index}}'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','datalogedit')) ?></a>
                                    <a class="dropdown-item" ng-click='item.edit=0' href='#datapoint{{$index}}'><i class="icon-check-empty"></i>&nbsp;<? print(lang('STOP_EDIT','datalogedit')) ?></a>
                                    <a class="dropdown-item" ng-click='datapoints.splice($index,1)' href='#adddatapoint'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','datalogedit')) ?></a>
                                </div>
                            </div>
                        
                        </td>
                    </tr>
                </table>
            </div>
        </p>
    </div>
</div>
</form>

    <script>
    var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);




function GroupEditCtrl($scope, $timeout,$http) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  $scope.datapoints = [];
  $scope.olddatapoints = [];
  $scope.infomsg="";
  $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
  
  function swapElement(array, indexA, indexB) {
     var tmp = array[indexA];
    array[indexA] = array[indexB];
    array[indexB] = tmp;
  }
  $scope.moveUp=function(arr,idx) {
     if (idx>0)
        swapElement(arr,idx-1,idx);
  }
  $scope.moveDown=function(arr,idx) {
     if (idx<arr.length-1)
        swapElement(arr,idx,idx+1);
  }  
  $scope.deleteDataPoint = function ( idx ) {
    $scope.datapoints.splice(idx, 1);
};

  $scope.makeValueType=function(item) {
    if (item.edit) return '';
    str='';
    switch (Number(item.vartype)) {
        case 0: str="Undefined";break;
        case 1: str="System Variable";break;
        case 2: str="Device Variable";break;
        case 3: str="Global Variable";break;
    }
    return str;
  }
  
  $scope.makeFn=function(item) {
    if (item.edit) return '';
    str='';
    switch (Number(item.varfn)) {
        case 0: str="AVERAGE";break;
        case 1: str="MIN";break;
        case 2: str="MAX";break;
        case 3: str="INSTANTANEOUS";break;
    }
    return str;
  }  
  $scope.makeScale=function(item) {
    if (item.edit) return '';
    str=item.varscale;
    return str;
  }
  
  $scope.makeValue=function(item) {
    if (item.edit) return '';
    str='';
    if (Number(item.vartype)==1)  { // preset role
      switch (Number(item.varval)) {
      <? 
      


      for ($i=0;$i<$num_sysvars;$i++) {
            $st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title',"");            
            print("case ".$i.":str='".$st."';break;\r\n");
        } ?>
      }
    }
    if (Number(item.vartype)==2)  { // role role
        switch (Number(item.varval)) {
        <? for ($i=0;$i<$num_roles;$i++) { 
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            ?>
        }
      }
      if (Number(item.vartype)==3)  { // global value
        str=item.varval;
      }
    return str;  
  }
  

   $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";  $scope.infomsg="";
      astr="name="+encodeURIComponent($scope.group_name);
      astr+="&type="+encodeURIComponent($scope.group_type);
      astr+="&status="+encodeURIComponent($scope.group_status);
      astr+="&interval="+$scope.group_interval;
      astr+="&mins="+$scope.group_mins;
      astr+="&numvar="+$scope.datapoints.length;
      $scope.loading=1;
      
      for (i=0;i<$scope.datapoints.length;i++) {
            if ((i>=$scope.olddatapoints.length) || ($scope.datapoints[i].vartype!=$scope.olddatapoints[i].vartype) ||
                ($scope.datapoints[i].varval!=$scope.olddatapoints[i].varval) ||
                ($scope.datapoints[i].varfn!=$scope.olddatapoints[i].varfn) ||
                ($scope.datapoints[i].min!=$scope.olddatapoints[i].min) ||
                ($scope.datapoints[i].max!=$scope.olddatapoints[i].max) ||
                ($scope.datapoints[i].varscale!=$scope.olddatapoints[i].varscale)) {
                    astr+="&var"+i+"vartype="+$scope.datapoints[i].vartype;     
                    astr+="&var"+i+"varval="+encodeURIComponent($scope.datapoints[i].varval);     
                    astr+="&var"+i+"varscale="+$scope.datapoints[i].varscale;
                    astr+="&var"+i+"min="+$scope.datapoints[i].min;   
                    astr+="&var"+i+"max="+$scope.datapoints[i].max;   
                    astr+="&var"+i+"varfn="+$scope.datapoints[i].varfn; 
                }
        }
        
      $http.post('/app/datalog_ajax.cgi?action=save&group_id='+$scope.group_id,astr)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          $scope.loading=0;
          if (data.status)
            $scope.successmsg="Settings saved.";
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.loading=0;
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
}
</script>
<? include("/app/footer.inc"); ?>


