<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : deviceadd.cgi
 * 
 *  Description: Manual device add page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      25/11/16    Modbus TCP Support added
 *						31/03/17	Added check for unique device name
 * Akash Heimlich       18/05/18    v2.0
 *                      02/10/18    v3.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceEditCtrl"; 
$title='Add Modbus Device ';
include("/app/header.inc");
$rs232_enabled=ini_get("/config/device.ini","general","rs232_enabled",0);

$mb_tcp_connected=0;
if (function_exists("getmbstat")) {
    $arr=getmbstat();
    $mb_tcp_enabled=$arr['TCP_ENABLED'];
    $mb_tcp_connected=$arr['TCP_STATE']==2;
    
}
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/devices.cgi"><? print(lang('MODBUS_DEVICES','deviceadd')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('DEVICE_ADD','deviceadd')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i> <? print(lang('ADD_TITLE','deviceadd')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/devices.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','deviceadd')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','deviceadd')) ?>
    <? print(lang('HELP2','deviceadd')) ?>
    <? print(lang('HELP3','deviceadd')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<!-- VARIABLES -->
<?  $num_devices=ini_get("/config/device.ini","general","num_devices",0); ?>
<style type='text/css'>
.radio-margin { margin-left:30px; /* Set as you wish */ }
</style>



<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ADD_SUBTITLE','deviceadd')) ?></h5>
        <p class="card-text">    

<form id="form" name="form" class="css-form">

<div ng-init="bus='0';"></div>
<div ng-init="device_index=<? print($_GET['device_idx']); ?>;"></div>
<div ng-init="device_id=1;"></div>
<div ng-init="device_name='Device<? 
$dev_id=$num_devices;
while (1) {
  $dev=mb_get_dev_by_name('Device'.$dev_id);
  //print_r($dev);
  if (!$dev) break;
  $dev_id++;
}
print($dev_id);
?>';"></div>
<div ng-init="status=1;"></div><div ng-init="poll_interval=1000;"></div>

<?  if (($_SERVER['HW_PLATFORM']==11) || $mb_tcp_enabled || $rs232_enabled) { ?>
  <div class="form-group">
    <label for="bus"><? print(lang('DEVICE_BUS','deviceadd')) ?></label>
    <select ng-model="bus"  required name='bus' class="form-control">
	    <option value='0'>Modbus RTU (RS-485)</option>
	    <option value='1'><? if ($_SERVER['HW_PLATFORM']==11 || $_SERVER['HW_PLATFORM']==20 || $_SERVER['HW_PLATFORM']==21 || $_SERVER['HW_PLATFORM']==22) { ?>Modbus RTU 2<? } else { ?>Modbus RTU (RS-232)<? } ?></option>
	    <option value='100'>Virtual Bus</option>
<? 			        
      $is_mega = $_SERVER['HW_PLATFORM']>=8;
      $modbus_tcp_port=array();
      $modbus_tcp_ip_address=array();
      // single modbus TCP for non-mega
      if (!$is_mega) {
            $max_tcp=1;
            $modbus_tcp_port[0]=ini_get("/config/device.ini","general","modbus_tcp_port",502);
            $modbus_tcp_ip_address[0]=ini_get("/config/device.ini","general","modbus_tcp_ip_address","0.0.0.0");
      } else {
            $max_tcp = intval($arr['TCP_COUNT']);
            for ($i=0;$i<$max_tcp;$i++) {
                $modbus_tcp_port[$i]=ini_get("/config/device.ini","general","modbus_tcp_port".$i,502);
                $modbus_tcp_ip_address[$i]=ini_get("/config/device.ini","general","modbus_tcp_ip_address".$i,"0.0.0.0");
            }
          
      }
      for ($i=0;$i<$max_tcp;$i++) {
          print("<option value='"+(2+$i)+"'>TCP Channel "+(1+$i)." - ".$modbus_tcp_ip_address[$i].":".$modbus_tcp_port[$i].($arr['TCP_STATE'.$i]==2?" - CONNECTED":"")."</option>");
          //if ($mb_tcp_connected) print("- CONNECTED"); ?>);
      }
?>
       
       </select>
    <small id="chanHelp" class="form-text text-muted"><? print(lang('DEVICE_BUS_HELP','deviceadd')) ?></small>
  </div>

<? } ?>
    <div class="form-group">
        <label for="device_id"><? print(lang('DEVICE_ID','deviceadd')) ?></label>
        <input class="form-control" type='number' ng-model="device_id"  class='span12' name='device_id' required size='3' min="1" max="254" integer aria-describedby="diHelp" placeholder="<? print(lang('DEVICE_ID','deviceadd')) ?>">
        <small id="diHelp" class="form-text text-muted"><? print(lang('DEVICE_ID_HELP','deviceadd')) ?></small>
        <small ng-cloak class='text-danger' ng-show="form.device_id.$invalid"><? print(lang('DEVICE_ID_INVALID','deviceadd')) ?></small>
    </div>
   
	
	<div class="form-group">
        <label for="device_name"><? print(lang('DEVICE_NAME','deviceadd')) ?></label>
        <input type="text" class="form-control" ng-model="device_name"  class='span12' name='device_name' requiredaria-describedby="dnHelp" my-directive placeholder="<? print(lang('DEVICE_NAME','deviceadd')) ?>">
        <small id="dnHelp" class="form-text text-muted"><? print(lang('DEVICE_NAME_HELP','deviceadd')) ?></small>
        <small ng-cloak class='text-danger' ng-show="form.device_name.$invalid"><? print(lang('DEVICE_NAME_INVALID','deviceadd')) ?></small>
    </div>
    <div class="form-group">
        <label for="bus"><? print(lang('DEVICE_TYPE','deviceadd')) ?></label>
        <select ng-model="device_type_id" required name='device_type_id' class="form-control">
            <option value='' selected><? print(lang('SELECT','deviceadd')) ?></option>
 <?
 $curdir=getcwd();
 chdir("/dev/");  
 $arr=findfirst("*.ini",255-8);

 while ($arr) {
    $devname=ini_get('/dev/'.$arr['filename'],'config','name');
    $devtype=ini_get('/dev/'.$arr['filename'],'config','device_type_id');
    if ($devname) 
        print("<option value='".$devtype."'>".$devname." (".$devtype.")</option>\r\n");
    
    $arr=findnext();
}
?></select>
        <small id="dtHelp" class="form-text text-muted"><? print(lang('DEVICE_TYPE_HELP','deviceadd')) ?></small>
        <small ng-cloak class='text-danger' ng-show="form.device_type.$invalid"><? print(lang('DEVICE_TYPE_INVALID','deviceadd')) ?></small>
    </div>
 
    <div class="form-group">
        <label for="guest_user_name"><? print(lang('POLL_INTERVAL','deviceadd')) ?></label>
        <div class="input-group">
      <input class="form-control" aria-label="<? print(lang('POLL_INTERVAL','deviceadd')) ?>" ng-model="poll_interval" type="number" size='3' min="0" max="60000" integer required>
      <div class="input-group-append">
        <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><? print(lang('POLL_CHOOSE','deviceadd')) ?></button>
         <ul class="dropdown-menu dropdown-menu-right">
                            <li class="dropdown-item"><a ng-click='poll_interval=0' href='#'>No polling</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=1000' href='#'>Every Second</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=2000' href='#'>Every 2 Seconds</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=60000' href='#'>Every Minute</a></li>
        </ul>
      </div>
    </div>
        <small id="pHelp" class="form-text text-muted"><? print(lang('POLL_INTERVAL_HELP','deviceadd')) ?></small>
        <small ng-cloak class='text-danger' ng-show="form.poll_interval.$invalid"><? print(lang('POLL_INTERVAL_INVALID','deviceadd')) ?></small>
    </div>
    
    <div class="form-group">
        <label for="status"><small class='text-muted'><? print(lang('STATUS','deviceadd')) ?></small></label>
        <div class="form-check">
          <input class="form-check-input" type="radio" ng-model="status" id="exampleRadios1" value="0">
          <label class="form-check-label" for="exampleRadios1">
            &nbsp;Disabled
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="radio" ng-model="status" id="exampleRadios2" value="1">
          <label class="form-check-label" for="exampleRadios2">
            &nbsp;Enabled
          </label>
        </div>  
        <small id="dnHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','deviceadd')) ?></small>
    </div>
  
   




</form>
    </p>
    </div>
</div>

      
    <script>
    var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/dev_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});

app.directive('myDirective', function() {
  return {
    require: 'ngModel',
    link: function(scope, element, attr, mCtrl) {
      function myValidation(value) {
        console.log(value);
        
        var regex = /^[0-9a-zA-Z\_]+$/;
        if(regex.test(value) == false){
            mCtrl.$setValidity('charE', false);
          
        } else {
            mCtrl.$setValidity('charE', true);
        }
        return value;
      }
      mCtrl.$parsers.push(myValidation);
    }
  };
});


function DeviceEditCtrl(dataService,$scope, $timeout,$http) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  $scope.infomsg="";
  //$scope.data=dataService.async($scope.device_index)
  $scope.restoreDefaults=function() {
  
//      $scope.device_id=$scope.saved_device_id;
      $scope.infomsg="Default values loaded.  Settings will not be saved until you click <i>Update Settings</i>."
      
  }
  $scope.calibrateDevice=function () {
    document.location="/app/devcalib.cgi?device_idx="+$scope.device_index;
  }
  $scope.getClass=function() {
    if ($scope.form.$invalid) return "disabled";
    return "";
  }
   $scope.saveSettings=function () {
      if ($scope.form.$invalid) return;
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      rolestr="";
      for (i=0;i<$scope.numroles;i++) {
           rolestr+="&role"+i+"="+$scope.$eval('role'+i);
      }
      //alert('device_type_id='+$scope.device_type_id+"&slave_id="+$scope.device_id+"&device_name="+$scope.device_name+"&poll_interval="+$scope.poll_interval+"&status="+$scope.status);
      //return;
//      $scope.form.$setPristine();
      $http.post('/app/dev_ajax.cgi?action=add',"device_type_id="+$scope.device_type_id+"&slave_id="+$scope.device_id+"&device_name="+$scope.device_name+"&poll_interval="+$scope.poll_interval+"&params="+$scope.bus+"&status="+$scope.status+rolestr)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          if (data.status) {
            alert("Created the device.  Click here to return to the list of devices. The device will only be usable after a system reboot");
            document.location='/app/devices.cgi';
          }
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
};
</script>
<? 
include("/app/footer.inc"); ?>



