<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : dir.cgi
 * 
 *  Description: Directory view page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       17/04/14    v1.1 - edit csv files, volumes 
 *
 * Latest revision: 	13/05/14
 *                   	11/05/18    revised for WattmonOS 3
 * @revision 3.02
 ********************************************************************/
$docroot=$_SERVER['DOCUMENT_ROOT']; 
include($docroot."/app/config.inc");

$angular_controller="DirListCtrl"; 
$title=lang('FILE_MANAGER','dir');

include($docroot."/app/header.inc");


?>
      <div class="row-fluid">
        
        <div class="span12">
           <? if ($_GET['cmd']=="untar") {
    if ($_GET['fn']) {
        print("Uncompressing Archive, this may take some time, please wait...");
    }
 }
 ?>
          <?

$download_ok=0;
if ($_GET['dir']) {
  chdir($_GET['dir']);
  $dir=$_GET['dir'];
  if (substr($dir,0,strlen($docroot))==$docroot) {
      $dir=substr($dir,strlen($docroot));
      $download_ok=1;
  }
} else {
    if ($docroot=='/') {
        
        $download_ok=1;
        $dir='/';
    }
    $_GET['dir']='/';
    chdir("\\");
}

if ($_GET['cmd']=="mkdir") {
    if (!mkdir($_GET['dir'].$_GET['newdir'])) {
        print("<div  class='alert alert-info'>".lang('FOLDER_CREATED_SUCCESSFULLY','dir',$_GET['newdir'])."</div>");
    } else {
        print("<div  class='alert alert-error'>".lang('DIR_CREATE_ERROR','dir')."</div>");
    }
} 
if ($_GET['cmd']=="del") {
    if ($_GET['fn']) {
        chdir($_GET['dir']);
        if (!unlink($_GET['fn'])) {
            print("<div class='alert alert-info'>".lang('DELETED_FILE','dir',$_GET['fn'])+"</div>");
        } else {
            print("<div  class='alert alert-error'>".lang('ERROR_DELETE_FILE','dir',$_GET['fn'])." "+"</div>");
        }
    }
}

if ($_GET['cmd']=="untar") {
    if ($_GET['fn']) {
        print("<pre>");
        max_execution_time(600);
        $dir=getcwd();
        $ok=1;
        if ($_GET['untar_dir']) {
            chdir($_GET['untar_dir']);
            if (substr($_GET['untar_dir'],0,2)=='1:') {
                if (sys_get("FLASH_STATUS")==4) {
                    print("</pre><div class='alert alert-danger'><strong>Please unlock the Flash before attempting this.</strong></div>");
                    $ok=0;
                }
            }
        }
        
        if ($ok && untar($dir.$_GET['fn'],1)) {
            $_GLOBALS['md5_sync_changed']=1;
            ini_set("/config/md5.ini",'config','md5_sync_changed',1);
            print("</pre>");
            print("<div class='alert alert-info'>".lang('UNTAR_FILE','dir',$_GET['fn'])." "+"</div>");
        } else {
            print("</pre>");
            print("<div class='alert alert-error'>".lang('ERROR_UNTAR_FILE','dir',$_GET['fn'])." "+"</div>");
        }
        chdir($dir);
    }
}
if ($_GET['cmd']=="rmdir") {
    if ($_GET['param']) {
        $r=rmdir($_GET['dir'].$_GET['param'],1);
        if (!$r) {
            print("<div  class='alert alert-info'>".lang('DELETED_DIR','dir',$_GET['param'])."  "+"</div>");
        } else {
            print("<div  class='alert alert-error'>".lang('ERROR_DELETE_DIR','dir',$_GET['param'])." "+" error= ".$r."</div>");
        }
    }
}

?>
<? $cur_drive=0;
if ($_SERVER['HW_PLATFORM']==11  || $_SERVER['HW_PLATFORM']>=20) { 
    $cur_drive=get_drive(); 
    if (substr($_GET['dir'],0,2)=='0:') $cur_drive=0;
    if (substr($_GET['dir'],0,2)=='1:') $cur_drive=1;
    if (substr($_GET['dir'],0,2)=='2:') $cur_drive=2;
}
?>

<a id='top' name='top'></a>
<div ng-init="directory='<? print($_GET['dir']); ?>';"></div>
<h1><? print(lang('INDEX_OF','dir')) ?> <span ng-cloak>{{directory}} <? if ($cur_drive==1) print("(Internal Flash)"); if ($cur_drive==2) print("(RAM Drive)");if ($cur_drive==0)  print("(SD Card)"); ?></span> <span ng-cloak ng-show="loading">
- <img src="/img/ajax-loader.gif" id="loading-indicator" /> <? print(lang('LOADING','dir')) ?>
</span>
</h1>
<div align='right'>
<p>
<? if ($_SERVER['HW_PLATFORM']==11  || $_SERVER['HW_PLATFORM']>=20) { ?>
<a class="btn btn-secondary <? if ($cur_drive==0) print("btn-raised"); ?>" href="/app/dir.cgi?dir=0:/" class="btn">SD CARD</a>
<? if (sys_get("FLASH_STATUS")!=1) { ?>
<a class="btn btn-secondary <? if ($cur_drive==1) print("btn-raised"); ?>"  href="/app/dir.cgi?dir=1:/" class="btn">FLASH</a>
<? } ?>
<a class="btn btn-secondary <? if ($cur_drive==2) print("btn-raised"); ?>"  href="/app/dir.cgi?dir=2:/" class="btn">RAM</a>
<? } ?>
  <a class="btn btn-primary" ng-hide='wprotect' target="_blank" href="/app/blockedit.cgi?dir={{directory}}&fn=" class="btn"><? print(lang('NEW_SCRIPT','dir')) ?></a>
  <a class="btn btn-primary" ng-hide='wprotect' target="_blank" href="/app/edit.cgi?dir={{directory}}&fn=" class="btn"><? print(lang('NEW_FILE','dir')) ?></a>
<? if ($_SERVER['HW_PLATFORM']==11  || $_SERVER['HW_PLATFORM']>=20) { ?>
    <a class="btn btn-secondary" href="#dyna" ng-click='sync()'><? if ($cur_drive==0) print("COPY TO FLASH"); else print("COPY TO SD"); ?></a>
<? } ?>
  <a class="btn btn-primary btn-raised" ng-hide='wprotect' data-toggle="collapse" href="#uploadBox" role="button" aria-expanded="false" aria-controls="uploadBox"><? print(lang('UPLOAD','dir')) ?></a>
  <button class="btn btn-primary" ng-hide='wprotect' type="button" data-toggle="collapse" data-target="#createFolder" aria-expanded="false" aria-controls="createFolder">NEW FOLDER</button>
  <a ng-click='refresh()' class="btn"><? print(lang('REFRESH','dir')) ?></a>
  <span class="bmd-form-group bmd-collapse pull-xs-right">
  <button class="btn bmd-btn-icon" for="search" data-toggle="collapse" data-target="#collapse-search" aria-expanded="false" aria-controls="collapse-search">
    <i class="icon-search"></i>
  </button>  
  <span id="collapse-search" class="collapse">
    <input name='search' id='search' ng-type='text' class='form-control' ng-model='search'/>
  </span>
</span>
</p>
<div class="row">
  <div class="col">
    <div class="collapse multi-collapse" id="uploadBox">
      <div class="card card-body pull-xs-left">
      <h3><? print(lang('UPLOAD','dir')) ?></h3>
      <form>
        <div class="form-group">
<input class='form-text' ng-non-bindable type="file" id="files" name="files[]" multiple />
<div ng-cloak ng-show="uploading0"><progress id="progress0" min="0" max="100" value="0">0% complete</progress>&nbsp;<span id='progress_percent0' >0%</span></div>
<div ng-cloak ng-show="uploading1"><progress id="progress1" min="0" max="100" value="0">0% complete</progress>&nbsp;<span id='progress_percent1' >0%</span></div>
<div ng-cloak ng-show="uploading2"><progress id="progress2" min="0" max="100" value="0">0% complete</progress>&nbsp;<span id='progress_percent2' >0%</span></div>
<div ng-cloak ng-show="uploading3"><progress id="progress3" min="0" max="100" value="0">0% complete</progress>&nbsp;<span id='progress_percent3' >0%</span></div>
<div ng-cloak ng-show="uploading4"><progress id="progress4" min="0" max="100" value="0">0% complete</progress>&nbsp;<span id='progress_percent4' >0%</span></div>
<small id="uploadHelp" class="form-text text-muted"><? print(lang('UPLOAD_DESC','dir')) ?></small><div id="status"></div>
        </div>

      </div>
      </form>
    </div>
  </div>
  <div class="col">
    <div class="collapse multi-collapse" id="createFolder">
      <div class="card card-body">
        <a name="addfolder"></a><? print(lang('CREATE_FOLDER','dir')) ?>: <input type='text' ng-model='folder' name='folder' id='folder' value=''>
<input type='button' ng-click='createFolder();' value='<? print(lang('CREATE','dir')) ?>'>
      </div>
    </div>
  </div>
</div>
{{info}}

</div><br>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-success" ng-cloak ng-show="filelist"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button><pre>{{filelist}}</pre></div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div id="dynamic_area"></div>
<a id='dyna' name='dyna'></a>
<table class='table dirtable table-striped' summary="<? print(lang('DIRECTORY_LISTING_OF','dir')) ?> {{directory}}">
<tr>
<th scope="col"></th>
<th scope="col"><a href="" ng-click="predicate = 'name'; reverse=!reverse"><? print(lang('NAME','dir')) ?></a></th>
<th scope="col"><a href="" ng-click="predicate = 'size'; reverse=!reverse"><? print(lang('SIZE','dir')) ?></a></th>
<th scope="col"><a href="" ng-click="predicate = ['attributes','-name']; reverse=!reverse"><? print(lang('TYPE','dir')) ?></a></th>
<th scope="col"><a href="" ng-click="predicate = 'time'; reverse=!reverse"><? print(lang('MODIFIED','dir')) ?></a></th>
<th scope="col"><? print(lang('OPTIONS','dir')) ?></th>
</tr>
<tr ng-repeat="item in items | filter:search | orderBy:predicate:reverse" ng-cloak>
<td class="{{item.class}}"></td><td>
    <span ng-show="item.type=='file'"><span ng-hide='canDelete(item)'>{{item.name}}</span><span ng-show='canDelete(item)'><a  href="{{directory}}{{item.name}}">{{item.name}}</a></span></span>
    <span ng-show="item.type=='directory'"><span ng-hide='canLinkFolder(item)'>{{item.name}}</span><span ng-show='canLinkFolder(item)'><a href='#top' ng-click="$parent.setFolder(item.path);">{{item.name}}</a></span></span>
</td>
<td style='text-align:right'>{{item.size}}</td><td>{{item.attributes}}</td><td>{{item.time}}</td>
<td><span ng-hide='wprotect'><span ng-show="canEdit(item)"><a target='_blank' class='btn btn-small' href='/app/edit.cgi?dir={{directory}}&fn={{item.name}}' alt='<? print(lang('EDIT','dir')) ?>' title='<? print(lang('EDIT','dir')) ?>'><i class="icon-edit" ></i></a>&nbsp;</span>
<span ng-show="canDesign(item)"><a target='_blank' class='btn btn-small' href='/app/blockedit.cgi?dir={{directory}}&fn={{item.name}}' alt='Design' title='Design'><i class="icon-cogs" ></i></a>&nbsp;</span>
<? if ($_SERVER['HW_PLATFORM']==11  || $_SERVER['HW_PLATFORM']>=20) { ?>
<span ng-show="canUntar(item)"><a target='_blank' class='btn btn-small' ng-click='checkUntarFile(item.name);' alt='<? print(lang('UNCOMPRESS','dir')) ?>' title='<? print(lang('UNCOMPRESS','dir')) ?>'><i class="icon-briefcase"></i> SD</a>&nbsp;</span>
<span ng-show="canUntar(item)"><a target='_blank' class='btn btn-small' ng-click='checkUntarFile2(item.name);' alt='<? print(lang('UNCOMPRESS','dir')) ?>' title='<? print(lang('UNCOMPRESS','dir')) ?>'><i class="icon-briefcase"></i> FL</a>&nbsp;</span>
<? } else { ?>
<span ng-show="canUntar(item)"><a target='_blank' class='btn btn-small' ng-click='checkUntarFile(item.name);' alt='<? print(lang('UNCOMPRESS','dir')) ?>' title='<? print(lang('UNCOMPRESS','dir')) ?>'><i class="icon-briefcase"></i></a>&nbsp;</span>
<span ng-show="canUntar(item)"><a target='_blank' class='btn btn-small' ng-click='checkUntarFileRoot(item.name);' alt='<? print(lang('UNCOMPRESS_ROOT','dir')) ?>' title='<? print(lang('UNCOMPRESS_ROOT','dir')) ?>'><i class="icon-briefcase"></i> /</a>&nbsp;</span>
<? } ?>
<span ng-show="canDelete(item)"><a target='_blank' class='btn btn-small' ng-click='checkDelFile(item.name);' alt='<? print(lang('DELETE','dir')) ?>' title='<? print(lang('DELETE','dir')) ?>'><i class="icon-trash"></i></a>&nbsp;</span>
<span ng-show="canDeleteFolder(item)"><a target='_blank' class='btn btn-small' ng-click='checkDelFolder(item.name);' alt='<? print(lang('DELETE','dir')) ?>' title='<? print(lang('DELETE','dir')) ?>'><i class="icon-trash"></i></a>&nbsp;</span>
</span>
</td>
</tr>
</table><script type="text/javascript">

</script>
 <script language='text/javascript'>
 // Check for the various File API support.
if (window.File && window.FileReader && window.FileList && window.Blob) {
  // Great success! All the File APIs are supported.se
} else {
  alert('The File APIs are not fully supported in this browser.');
}
</script>
<br>
<script>
  var theScope=0;
  function addFolder() {
     //alert(theScope.directory);
    document.location="/app/dir.cgi?dir="+theScope.directory+"&cmd=mkdir&newdir="+document.getElementById('folder').value;
    
  }
  progressBar=[];
  progressBar[0] = $('#progress0');
  progressBar[1] = $('#progress1');
  progressBar[2] = $('#progress2');
  progressBar[3] = $('#progress3');
  progressBar[4] = $('#progress4');
  
  var thePath="<? print($_GET['dir']); ?>";
  var thePathUp="<? $d=$_GET['dir'];
  if (strpos($d,':')) 
    $d=substr($d,0,1).'/'.substr($d,2); 
  print($d); ?>";
  
  function jump(h) {
    var top = document.getElementById(h).offsetTop;
    window.scrollTo(0, top);
  }
  
  function handleFileSelect(evt) {
    var files = evt.target.files; // FileList object

    // Loop through the FileList and render image files as thumbnails.
    for (var i = 0, f; f = files[i]; i++) {

      // Only process image files.
      if (!f.type.match('image.*')) {
      //  continue;
      }
      
    thePath=theScope.directory;
    thePathUp=theScope.directory.replace(':','/');
    

      var reader = new FileReader();
      theScope.$apply(function() {
        theScope["uploading"+i] = 1;
        
    });
      // Closure to capture the file information.
      reader.onload = (function(theFile) {
      
        var progress = i;
        return function(e) {
              $.ajax({
                type: "PUT",
                url: thePathUp+theFile.name,
                data: e.target.result,
                dataType: "html",
                contentType:"application/x-www-form-urlencoded",
                xhr: function () {
                    var xhr = $.ajaxSettings.xhr();
                    idx=i;
                    xhr.onprogress = function e() {
                        // For downloads
                        if (e.lengthComputable) {
                            console.log(e.loaded / e.total);
                        }
                    };
(function(progress) { 
    xhr.upload.onprogress = function(e) 
    {
        progressBar[progress].attr('value',(e.loaded / e.total) * 100);
        progressBar[progress].textContent = progressBar[progress].value; // Fallback for unsupported browsers.
        $("#progress_percent"+progress).html(Math.round((e.loaded / e.total) * 100)+" %");
        console.log(progress+" "+progressBar[progress].value);
    };
}(progress));
                //xhr.upload.onprogress=progress;
/*                    (function(uploadprogress) { 
    xhr.upload.onuploadprogress = function(e) 
    {
        //$('#' + progress).attr('value', e.loaded);
        //$('#' + progress).attr('max', e.total);
         if (e.lengthComputable) {
                             console.log(idx);
                            //console.log(progressBar.value+" %");
                        }
    };
}(uploadprogress));*/
                    ;
                    
                    return xhr;
                }
              }
                ).done(function( msg ) {
(function(progress) {                 
                    theScope.$apply(function() {
        theScope["uploading"+progress] = 0;
    });
}(progress));    
                    if (msg=="OK") msg="OK <img src='/img/check_mark.png'>";
                    document.getElementById("status").innerHTML+="<? print(lang('UPLOADED','dir')) ?>:"+theFile.name+":"+msg+"<br>";
                    theScope.refresh();
                });
        };
      })(f);

      // Read in the image file as a data URL.
      reader.readAsDataURL(f);
    }
  }
  document.getElementById('files').addEventListener('change', handleFileSelect, false);
  
  // clear field value once closed
  $(function() {
    $('#collapse-search').on('hidden.bs.collapse', function() {
      $('#search').val('')
    })
  });
</script>
</div>
        </div><!--/span-->
      </div><!--/row-->
      
      
 <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
var scope;
app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(path,$scope) {
    $scope.loading=1;
    return $http.get('/app/dir_ajax.cgi?dir='+path)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      console.log(data);
      $scope.loading=0;
      return data;
    }, function(reason) {
        alert('<? print(lang('FAILED','dir')) ?>: ' + reason);
        $scope.loading=0;
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});


String.prototype.format = String.prototype.f = function() {
    var s = this,
        i = arguments.length;

    while (i--) {
        s = s.replace(new RegExp('%s', 'gm'), arguments[i]);
    }
    return s;
};

function DirListCtrl(dataService,$scope, $timeout,$http) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  theScope=$scope;
  var curPath="/";
  $scope.uploading=0;
  $scope.predicate=['attributes','-name'];
  $scope.reverse=true;
  $scope.loading=1;
  $scope.successmsg='';
  $scope.errormsg='';
  $scope.directory="<? print($_GET['dir']); ?>";
  var pc=100;
  $scope.refresh=function() {
       //alert('setting folder to'+f);
       $scope.asyncData = dataService.async(thePath,$scope);
   }
   
  $scope.createFolder=function() {
      $scope.loading=1;
       $http.get('/app/dir_ajax.cgi?cmd=mkdir&newdir='+$scope.folder+"&dir="+$scope.directory)
        .then(function (response) {
          var data = response.data; 
          
         if (!Number(data.error)) {
            $scope.successmsg=data.status;
            $scope.errormsg="";
          } else {
            $scope.successmsg="";
            $scope.errormsg=data.status;
          
          }
          $scope.sysmsg=data.sysmsg;
            //var data = response.data;
          $scope.loading=0;
          $scope.asyncData=data;
          jump('top');
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('ERROR_SAVING','user')) ?>";
            $scope.successmsg="";
            $scope.loading=0;
            jump('top');
            //alert('Failed: ' + reason);
           
        });
  }
  
  $scope.delFile=function(fn) {
      $scope.loading=1;
       $http.get('/app/dir_ajax.cgi?cmd=del&fn='+fn+"&dir="+$scope.directory)
        .then(function (response) {
          var data = response.data; 
          if (!Number(data.error)) {
            $scope.successmsg=data.status;
            $scope.errormsg="";
          } else {
            $scope.successmsg="";
            $scope.errormsg=data.status;
          
          }
//          alert(data.status+" " +$scope.successmsg);
          $scope.errormsg=(Number(data.error)==1)?data.status:"";
          $scope.sysmsg=data.sysmsg;
          $scope.loading=0;
          $scope.asyncData=data;
          jump('top');
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('ERROR_SAVING','user')) ?>";
            $scope.successmsg="";
            $scope.loading=0;
            jump('top');

        });
  }
  
  $scope.setFolder=function (f) {
       //alert('setting folder to'+f);
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.asyncData = dataService.async(f,$scope);
       thePath=f;
   }
<? if ($_SERVER['HW_PLATFORM']==11  || $_SERVER['HW_PLATFORM']>=20) { ?>
$scope.checkUntarFile2= function (fn) {
    if (confirm("<? printf(lang('CONFIRM_UNTAR_FILE','dir')); ?>".f("1:"+$scope.directory+fn))) {
        st=$scope.directory;
        if (st.includes(':')) st=st.substr(2);
        document.location="/app/dir.cgi?dir="+$scope.directory+"&fn="+fn+"&cmd=untar&untar_dir=1:"+st;
       //$scope.untarFile(fn);
    }
  }
<? } ?>
  $scope.checkUntarFile= function (fn) {
    if (confirm("<? printf(lang('CONFIRM_UNTAR_FILE','dir')); ?>".f(fn))) {
        document.location="/app/dir.cgi?dir="+$scope.directory+"&fn="+fn+"&cmd=untar";
       //$scope.untarFile(fn);
    }
  }
   $scope.checkUntarFileRoot= function (fn) {
    if (confirm("<? printf(lang('CONFIRM_UNTAR_FILE_ROOT','dir')); ?>".f(fn))) {
        document.location="/app/dir.cgi?dir="+$scope.directory+"&fn="+fn+"&cmd=untar&untar_dir=/";
       //$scope.untarFile(fn);
    }
  }
  $scope.checkDelFile= function (fn) {
    if (confirm("<? print(lang('CONFIRM_DELETE_FILE','dir')) ?> ".f(fn))) {
        //document.location="/app/dir.cgi?dir="<? print($_GET['dir']); ?>"+$scope.directory+"&fn="+fn.name+"&cmd=del";
        //document.location="/app/dir.cgi?dir="+$scope.directory+"&fn="+fn+"&cmd=del";
        $scope.delFile(fn);
    }
  }
  $scope.checkDelFolder= function (fn) {
    if (confirm("<? print(lang('CONFIRM_DELETE_FOLDER','dir')) ?> ".f(fn))) {
//        document.location="/app/dir.cgi?dir="+$scope.directory+"&param="+fn+"&cmd=rmdir";
        $scope.loading=1;
       $http.get('/app/dir_ajax.cgi?cmd=rmdir&param='+fn+"&dir="+$scope.directory)
        .then(function (response) {
          var data = response.data; 
          if (!Number(data.error)) {
            $scope.successmsg=data.status;
            $scope.errormsg="";
          } else {
            $scope.successmsg="";
            $scope.errormsg=data.status;
          
          }
          //alert(data.status+" " +$scope.successmsg);
          $scope.errormsg=(Number(data.error)==1)?data.status:"";
          $scope.sysmsg=data.sysmsg;
          $scope.loading=0;
          $scope.asyncData=data;
          jump('top');
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('ERROR_SAVING','user')) ?>";
            $scope.successmsg="";
            $scope.loading=0;
            jump('top');

        });
    }
}
  $scope.canEdit=function (item) {
    canedit=0;
    if ((item.ext=="js")  || (item.ext=="php") || (item.ext=="ini") || (item.ext=="cgi") || (item.ext=="txt") || (item.ext=="css") || (item.ext=="inc") || (item.ext=="html") || (item.ext=="csv")|| (item.ext=="xml") || (item.ext=="cgx")) {
            //class="text";
            canedit=1;
        } else {
            if ((item.ext=="png") || (item.ext=="gif") || (item.ext=="jpg")) {
              //  class="image";
            } else {
                //if (ext=="pdf") {
                    //class="pdf";
                //} else class="unknown";
            }
        }
        if (canedit) {
            return 1;
        }
        return 0;
  }
  $scope.canDesign=function (item) {
    canedit=0;
    if ((item.ext=="cgx")) {
            //class="text";
            canedit=1;
    }
    if (canedit) {
       return 1;
    }
    return 0;
  }

  $scope.canDelete=function (item) {
/*    if (wprotect) {
        console.log(wprotect);
        return 0;
    }*/
      if ((item.name=='<? print(lang('TOP_DIRECTORY','dir')) ?>') || (item.name=='<? print(lang('PARENT_DIRECTORY','dir')) ?>')) return 0;
      if (item.name.substring(0,10)=='___invalid') return 0;
      if (item.type=="file") {
        return 1;
      }
      return 0;
   
  }
  $scope.canLinkFolder=function (item) {
    //if (wprotect) return 0;
      if (item.name.substring(0,10)=='___invalid') return 0;
      return 1;
   
  }
  $scope.canDeleteFolder=function (item) {
  //if (wprotect) return 0;
      if ((item.name=='<? print(lang('TOP_DIRECTORY','dir')) ?>') || (item.name=='<? print(lang('PARENT_DIRECTORY','dir')) ?>')) return 0;
       if ((item.type=="directory")) {
        return 1;
      }
      return 0;
   
  }

  $scope.sync=function() {
    st=$scope.directory;
    drv="<? print(get_drive()); ?>:";
    console.log(drv);
    if (st.includes(':')) {
        drv=st.substr(0,2);
        st=st.substr(2);
    }
    if (drv=="0:") drv2="1:"; else drv2="0:";
    
    if (confirm("Would you like to copy this folder to "+drv2+st+"?\r\nThis will NOT copy sub folders.")) {
        //document.location="/app/dir.cgi?dir="+$scope.directory+"&fn="+fn+"&cmd=untar&untar_dir=1:"+st;
        console.log("/scripts/md5_transfer.cgi?src="+drv+st+"&dest="+drv2+st);
        $scope.loading=1;
      $.ajax({
        method: 'get',
        url: "/scripts/md5_transfer.cgi?src="+drv+st+"&dest="+drv2+st,
        data:{'actionPerform':'actionPerform'},
        xhr: function(){
              var xhr = new window.XMLHttpRequest();
              //Upload progress, request sending to server
              xhr.upload.addEventListener("progress", function(evt){
              }, false);
              //Download progress, waiting for response from server
              xhr.addEventListener("progress", function(e){
                $('#dynamic_area').html(xhr.response);
                document.getElementById("dynamic_area").scrollIntoView({ 
                block: 'end', 
                behavior: 'smooth', 
                inline: 'end'
            });
              }, false);
              return xhr;
        },
        success: function (res) {
            theScope.$apply(function(){$scope.loading=0;});
        }
    });

       //$scope.untarFile(fn);
    }
  }


  
  $scope.canUntar=function (item) {
  
    canedit=0;
    if ((item.ext=="tar")  || (item.ext=="tgz") || (item.ext=="gz")) {
            canedit=1;
    }
        if (canedit) {
            return 1;
        }
        return 0;
  }
  $scope.$watch('asyncData', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        $scope.items = asyncData.items;
        $scope.status=asyncData.status;
        $scope.directory=asyncData.directory;
        $scope.info=asyncData.info;
        $scope.wprotect = asyncData.wprotect;
        
        
    }
  });
  $scope.asyncData = dataService.async($scope.directory,$scope);
 

  //poll();

}
//);
//app.ItemListCtrl.$inject=['$defer'];


</script>

<? include($docroot."/app/footer.inc"); ?>














