<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : graphlist.cgi
 * 
 *  Description: Graph list page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="GraphCtrl"; 
$title='Graphs';
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?><style>
    
    table {
        font: 90%/140% Verdana,Arial,Helvetica,sans-serif;
    }
    
[ng\:cloak], [ng-cloak], .ng-cloak {
  display: none !important;
}

.enabled0 td{
    background-color:#CCC!important;
    color:#333;
}
.enabled1 {

}
</style>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('GRAPH_LIST','graphlist')) ?></li>
  </ol>
</nav>

<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{successmsg}}</div><div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg && scanning"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>

<h4><i class="icon-th-list"></i> Graph List</h4>
<div class="row-fluid">
				<div class="box span12">
					<div class="box-content">
                        <table class='table table-striped' summary="Graph List">
                        <tr>
                        <th scope="col">ID</th>
                        <th scope="col">Graph Name</th></th>
                        </tr>
                        <tr ng-repeat="item in graphs" ng-show='item.status==1' ng-click='/app/graphview.cgi?graph_id={{$index}}'>
                            <td ><span class="badge badge-inverse">{{$index+1}}</span></td>
                            <td><strong><a href='/app/graphview.cgi?graph_id={{$index}}'>{{item.name}}</a></strong></td>    
                        </tr>
                        </table>
	                    <div class="clearfix"></div>
					</div>
				</div>
			</div>    

        </div><!--/span-->
      </div><!--/row-->

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http) {
  
  this.async = function() {
    return $http.get('/app/graph_ajax.cgi?action=list')
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
    });
    
  };
  
  return this;
});


function GraphCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  var pc=100;
  $scope.scanning=0;
  $scope.refresh=0;
$scope.helpvisible=0;
$scope.items=[];

$scope.asyncData = dataService.async();
$scope.poll=function(){
      $scope.asyncData = dataService.async();
     
    };
  $scope.edit=function(idx) {
    document.location="/app/graphedit.cgi?graph_idx="+idx;
  }
  
  $scope.addGraph=function() {
    document.location="/app/graphedit.cgi?new=1";
  }
  $scope.del=function(idx) {
   // alert('del '+item.id);
  //  alert('in del');
    $scope.selectedIdx=idx;
    $scope.action=1;
    $scope.question="Delete this graph?";
    $('#myModal').modal('show');
  }

  $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  
  $scope.doModal=function() {
      
          $scope.delGroup();
       
  }
  $scope.delGraph=function() {
    $('#myModal').modal('hide');
    $scope.errormsg="";
    $scope.successmsg="";
      
     $http.get('/app/graph_ajax.cgi?action=delete&graph_idx='+$scope.selectedIdx) 
    .then(function (response) {
        if (response.data.status==0) {
            $scope.errormsg="There was an error deleting the graph.";
        } else $scope.successmsg="Graph deleted successfully";
        
      poll();
      return response;
    }, function(reason) {
        $scope.errormsg="Error while updating";
    });
  }
  $scope.isActive=function(item) {
      if (item.status==0) 
        return "Disabled";
      if (item.status==1) 
        return "Active";
      if (item.status==2) 
        return "Deleted";
  }
  $scope.isDisabled=function(item) {
      if (item.status==0) return 1;
      return 0;
  }
  $scope.isError=function(item) {
      if (item.status!=0 && item.last_response>=2) return 1;
      return 0;
  }
  
  $scope.$watch('refresh', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('scanning', function(ref) {
      if (ref) poll();
  });
  $scope.$watch('asyncData', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        $scope.connectstatus=asyncData.loggedin?"loggedin":"loggedout";
        $scope.graphs = asyncData.graphs;
        
        pc=0;
    }
  });
  

}

</script>    
<? include("/app/footer.inc"); ?>