<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : graphview.cgi
 * 
 *  Description: Graph view page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       15/11/13    v1.1
 * Akash Heimlich       03/12/13    v1.2 - removed ini-get_array 
 *			19/01/15	allow modified csv files, 
					ignore missing elements
 *			21/02/15	allow negative values for temp
 *			15/7/15	 ignore elements in the future (>max)
 ********************************************************************/
$guest_ok=1;
include("/app/config.inc");
$angular_controller="GraphDayCtrl"; 
$title=lang('GRAPH_VIEW','graphview');
include("/app/header.inc");

$msg='';
$graph_id=intval($_GET['graph_id']);
$graph_idx=intval($_GET['graph_id']);
$graph_ini="/config/graph.ini";
$section="data";
$data_ini="/config/datalog.ini";
$title=ini_get($graph_ini,$section,'graph'.$graph_id."name")." Graph";
$graph_type=ini_get($graph_ini,$section,'graph'.$graph_id."type",0);
// need to figure out the axis used
$numaxis=0;
$numpoints=ini_get($graph_ini,$section,'graph'.$graph_id.'numvar');
// axis type = 0=w, 1=v, 2=kwh, 3=current,4=other
$axis=array();
$points=array();
$ds=intval(ini_get($graph_ini,$section,'graph'.$graph_id."datasrc"));
for ($i=0;$i<$numpoints;$i++) {
    $vx=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varidx");
    $vartype=ini_get($data_ini,$section,'group'.$ds."var".$vx."vartype");
    $varval=ini_get($data_ini,$section,'group'.$ds."var".ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varidx")."varval");
    $varscale=ini_get($data_ini,$section,'group'.$ds."var".ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varidx")."varscale");
    $points[$i]['idx']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varidx");
    $points[$i]['title']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."vartitle");
    $points[$i]['opt']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varopt");
    $points[$i]['type']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."vartype");
    $points[$i]['max']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varmax",0);
    $points[$i]['error']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varerror",0.0);
    $points[$i]['func']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varfunc");
    $points[$i]['color']=ini_get($graph_ini,$section,'graph'.$graph_id."var".$i."varcolor");
    $found=0;
    for ($naxis=0;$naxis<$numaxis;$naxis++) {
        if ($axis[$naxis]==$points[$i]['type']) {
            $found=1;
            break;
        }
    }
    if (!$found) {
        $axis[$numaxis]=$points[$i]['type'];
        $points[$i]['axis']=$numaxis;
        $numaxis++;
    } else $points[$i]['axis']=$naxis;
}
//print("<pre>");
//print_r($points);
//print("</pre>");
if ($numaxis>2) {
    $msg="You have more than two axis defined.  Additional axis will be discarded.";
    $numaxis=2;
}
$axis1=0;
if ($numaxis==2)
    $axis2=1;

print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>
<script src="<? print($url_prefix); ?>/lib/angularcookies.js"></script>
<link rel="stylesheet" type="text/css" media="all" href="<? print($url_prefix); ?>/css/jsDatePick_ltr.min.css" />

<script type="text/javascript">
	
</script>
<style type="text/css">
      #containergraph {
        /*width : 600px;*/
        width:100%;
        height: 384px;
        margin: 8px auto;
        margin-bottom:30px;
      }
    </style>
    

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/graphlist.cgi"><? print(lang('GRAPHS','graphview')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print($title); ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-calender"></i> <? print($title); ?> - {{curdate}}</h2>
<ul class="nav navbar-light bg-light">
    <li class="nav-item">
        <button class='btn btn-small' ng-click='prevDay();'>&lt;</button>
    </li>
    <li class="nav-item" style='padding-top:8px'>
        <span>{{curdate}}</span>
    </li>
    <li class="nav-item">
        <button class='btn btn-small' ng-click='nextDay();'>&gt;</button>
    </li>
    <li class="nav-item" ng-show='view==0'>
        <button class='btn btn-small' id='dateButton'><? print(lang('SELECT','graphview')) ?></button>
    </li>
    <li class="nav-item">
        <a class='btn btn-small' href='/app/graphview.cgi?graph_id=<? print($_GET['graph_id']); ?>&view=0'><? print(lang('DAY_VIEW','graphview')) ?></a>
    </li>
    <li class="nav-item">
        <a class='btn btn-small' href='/app/graphview.cgi?graph_id=<? print($_GET['graph_id']); ?>&view=1'><? print(lang('MONTH_VIEW','graphview')) ?></a>
    </li>
    <li class='nav-item nav-justify-end'>
        <div ng-cloak ng-show='loading==1' ><img src="/img/ajax-loader-1.gif" title="img/ajax-loader-1.gif" > {{msg}} <progress min="0" max="100" value="0">0% complete</progress></div> 
    </div>
</ul>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<my-directive></my-directive>
<div class="row-fluid">
	<div class="box span12">
		<div class="box-content">
        <? for ($i=0;$i<$numpoints;$i++) {
            if ($points[$i]['func']>1) {
                print("<span ng-cloak class='badge text-light ' style='background:".$points[$i]['color']."'>".$points[$i]['title'].": {{points[".$i."].result | number:2}}");
                if ($points[$i]['func']==3) print(" ".lang('PER_HOUR','graphview'));
                if ($points[$i]['func']==5) print(" ".lang('PER_HOUR','graphview'));
                if ($points[$i]['func']==6) print(" ".lang('AVERAGE','graphview'));
                if ($points[$i]['func']==7) print(" ".lang('KWH','graphview'));
                if ($points[$i]['func']==9) print(" ".lang('HOURS_ZERO','graphview'));
                if ($points[$i]['func']==10) print(" ".lang('HOURS_NONZERO','graphview'));
                print("</span>&nbsp;");
            }
            if ($points[$i]['func']==1) {
                print("<span ng-cloak class='badge text-light '  style='background:".$points[$i]['color']."'>".$points[$i]['title'].": {{points[".$i."].last | number:2}}");                
                print("</span>&nbsp;");
                
            }
        } ?>

        <div id="containergraph" resize class="span11"></div>
    <!--[if IE]>
    <script type="text/javascript" src="/static/lib/FlashCanvas/bin/flashcanvas.js"></script>
    <![endif]-->
        
	</div>
</div>

      
 <script>
var app = angular.module('myApp', ['ngCookies']);     
var graphCtrl;

app.directive('myDirective', ['$window', function ($window) {

     return {
        link: link,
        restrict: 'E'
        
     };

     function link(scope, element, attrs){

       scope.width = $window.innerWidth;

       angular.element($window).bind('resize', function(){

         scope.width = $window.innerWidth;

         // manuall $digest required as resize event
         // is outside of angular
         scope.$digest();
       });

     }

 }]);

function GraphDayCtrl($scope,$http,$timeout,$cookies) {
   var self = this;
   graphCtrl=this;
   if (!$cookies.dateSet) {
    <? 
$batt=floatval(ini_get("/config/battery.ini","battery","battery_full_voltage",0));
print("max_v=1+"+$batt+";\r\n");
if ($_GET['y']) 
    print("yr='"+$_GET['y']+"';"); 
else 
    print("yr='"+strftime("%Y",time())+"';\r\n");
if ($_GET['m']) 
    print("m='"+$_GET['m']+"';\r\n"); 
else 
    print("m='"+strftime("%m",time())+"';\r\n");
if ($_GET['d']) 
    print("d='"+$_GET['d']+"';\r\n"); 
else 
    print("d='"+strftime("%d",time())+"';\r\n");
?>       
  } else {
    if ($cookies.y) 
        yr=$cookies.y;
    if ($cookies.m) 
        m=$cookies.m;
    if ($cookies.d) 
        d=$cookies.d;
  }
        
        
    l   = 0; // The letter 'L' - NOT a one    
    <? 
    if ($_GET['view']==0) {
        print('time = Math.round((Date.UTC(yr,m-1,d))/1000);\r\n');
        print('var dt = new Date();var n = dt.getTimezoneOffset();var toffset=n*60;');
        print('max=60*24; // 24 hours of data\r\n');
        print('maxtime=time+max*60;\r\n');
        print('$scope.view=0;\r\n');
        print('$scope.per_bar=60;\r\n');
        print('$scope.graph_type='.$graph_type.';\r\n');
    }
    if ($_GET['view']==1) {
        print('time = Math.round((Date.UTC(yr,m-1,1))/1000);\r\n');
        print('max=31*24; // 1 month of data\r\n');
        print('maxtime=time+max*3600;\r\nvar toffset=0\r\n');
        print('$scope.view=1;\r\n');
        print('$scope.per_bar=24;\r\n');
        print('$scope.graph_type='.$graph_type.';\r\n');
    }
    ?>
    maxval1=0;
    minval1=0;
    minval2=0;
    maxval2=0;
    numaxis=<? print($numaxis); ?>;
    axis1=<? print($axis1); ?>;
    axis2=<? print($axis2); ?>;
    
    points=[<? 
    $maxval=0;
    for ($i=0;$i<$numpoints;$i++) {
        print("{idx:".$points[$i]["idx"].",color:'".$points[$i]['color']."',error:".$points[$i]['error'].",max:".$points[$i]['max'].",opt:".$points[$i]['opt'].",func:".$points[$i]['func'].",data:[],axis:".$points[$i]['axis'].",title:'".$points[$i]['title']."',result:0}"); 
        if ($i<($numpoints-1)) print(",");
        if ($points[$i]['max']>0) {
            if ($points[$i]['max']>$maxval) $maxval=$points[$i]['max'];
        }
    }
        ?>];
    maxval1=<? print(intval($maxval)); ?>;    
    $scope.points=points;
    container=document.getElementById("containergraph");
    var
        ticks = [
            [-40, "Lower"], 20, 0, 20, [40, "Upper"]
        ],
        // Ticks for the Y-Axis
        graph;

    function ticksFn(n) {
        return (n/60) + ':00';
    }

    function myFormat(a) {
        return a.y+" ";
    }
    
    function updateGraph() {
//        if ($scope.view==0)
  //          $scope.curdate=d+"/"+m+"/"+yr;
        //else 
        console.log("Update graph");
        if ($scope.view==1) 
            $scope.curdate=m+"/"+yr;
//alert("max1="+maxval1+" min1="+minval1+" max2="+maxval2+" min2="+minval2);
            if ((minval1<0) || (minval2<0)) {
                
                if (maxval2>-minval2) {
                    minval2=-maxval2;                    
                } else maxval2=-minval2;
                if (maxval1>-minval1) {
                    minval1=-maxval1;
                } else maxval1=-minval1;
            }
        //alert("max1="+maxval1+" min1="+minval1+" max2="+maxval2+" min2="+minval2);
        ticks2 = [
                minval2, Math.round((maxval2-minval2)*0.25+minval2),Math.round((maxval2-minval2)*0.5+minval2),Math.round((maxval2-minval2)*0.75+minval2), [Math.round(maxval2),Math.round(maxval2)]
            ];
        ticks = [
            minval1, Math.round((maxval1-minval1)*0.25+minval1),Math.round((maxval1-minval1)*0.5+minval1),Math.round((maxval1-minval1)*0.75+minval1), [Math.round(maxval1),Math.round(maxval1)]
        ];
        pointarr=[];
        colorarr=[];
        for (i=0; i < points.length; i++) {
            if ((points[i].axis==axis1) || (points[i].axis==axis2)) {
                if ($scope.graph_type==0)
                    pointarr[pointarr.length]={data:points[i].data,label:points[i].title,lines:{show:true,fill:((points[i].opt==1)||(points[i].opt==3))?true:false},yaxis:(points[i].axis==axis1?1:2)};
                else 
                    pointarr[pointarr.length]={data:points[i].data,label:points[i].title,lines:{show:false,fill:((points[i].opt==1)||(points[i].opt==3))?true:false},yaxis:(points[i].axis==axis1?1:2)};
                colorarr[colorarr.length]=points[i].color;
            }
        }
        
        
       
        
        //graph = Flotr.draw(container, pointarr, 
        options={
        colors: colorarr,
       
        xaxis: {
            //noTicks: 6,
            <? if ($_GET['view']==0) {
                if (!$graph_type) {
                    print('ticks:[[0,"00:00"],[2*max/24,"02:00"],[4*max/24,"04:00"],[6*max/24,"06:00"],');            
                    print('[8*max/24,"08:00"],[10*max/24,"10:00"],[12*max/24,"12:00"],[14*max/24,"14:00"],');
                    print('[16*max/24,"16:00"],[18*max/24,"18:00"],[20*max/24,"20:00"],[22*max/24,"22:00"]');
                } else {
                    print('ticks:[[0,"00:00"],[2,"02:00"],[4,"04:00"],[6,"06:00"],');            
                    print('[8,"08:00"],[10,"10:00"],[12,"12:00"],[14,"14:00"],');
                    print('[16,"16:00"],[18,"18:00"],[20,"20:00"],[22,"22:00"]');
                
                }
            }
            if ($_GET['view']==1) {
                print('noTicks:31, ticks:[[0,"1"]');
                
                for ($i=2;$i<31;$i++) {
                    if (!$graph_type) {
                        print(',['+$i+'*max/31,"'.$i.'"]');
                    } else
                        print(',['+$i+',"'.$i.'"]');
                }
            }
            ?>
            
            ],
             margin:false,
            //tickFormatter: ticksFn,
            // Displays tick values between brackets.
            min: 0,
            // Part of the series is not displayed.
            max: ($scope.graph_type==0?max:max/$scope.per_bar) // Part of the series is not displayed.
        },
        yaxis: {
            <? if ($numaxis>1) print("ticks: ticks,"); ?>
            // Set Y-Axis ticks
            autoscale:<? if ($numaxis>1 || $maxval>0) print("false"); else print("true"); ?>,
            <? if ($numaxis>1) print("min:minval1,"); ?>
            <? if ($numaxis>1  || $maxval>0) print("max: maxval1,"); ?>
            labelsAngle:90
        },
        y2axis:{
            <? if ($numaxis>1) print("ticks: ticks2,"); ?>
            autoscale:<? if ($numaxis>1) print("false"); else print("true"); ?>,
            <? if ($numaxis>1) print("min:minval2,"); ?>
            <? if ($numaxis>1) print("max: maxval2,"); ?>
            labelsAngle:90
            
             // Maximum value along Y-Axis
        },
        grid: {
            verticalLines: true,
           /* backgroundColor: {
                colors: [
                    [0, '#fff'],
                    [1, '#fff']
                ],
                start: 'top',
                end: 'bottom'
            }*/
        },
        legend: {
            show:false,
            position: 'none'
        },
<? if ($graph_type) { ?>
        series:{lines:{show:false},bars:{show:true}},
        lines: {
            show: false,
            lineWidth: 0,
        },
        bars: {
            show: true,
            order:1,
            //barWidth: 1000000,
            barWidth: 0.5,
            stacked:true,
             //horizontal: true,
            lineWidth: 1,
/*            fillColor: {
                colors: ['#74DF00', '#74DF00'],
                start: 'top',
                end: 'bottom'
            },*/
           fillOpacity: 1,
           shadowSize: 1
        },
<? } ?>
        mouse: {
            track:true,
            trackAll: ($scope.graph_type==0?true:false),
            trackFormatter:myFormat,
            relative:true
        }/*,
        
        selection: {
            mode: 'x',
            fps: 30
        }*/
    };
    
     function drawGraph(opts) {
        console.log("Draw Graph!");
            // Clone the options, so the 'options' variable always keeps intact.
            var o = Flotr._.extend(Flotr._.clone(options), opts || {});
    
            // Return a new graph.
            return Flotr.draw(
                container, pointarr, o);
        }
    graph=drawGraph();
        
    // Hook into the 'flotr:select' event.
    Flotr.EventAdapter.observe(container, 'flotr:select', function(area) {

        // Draw graph with new area
        graph = drawGraph({
            xaxis: {
                min: area.x1,
                max: area.x2,
                ticks:[
                    [area.x1,Math.floor(area.x1/60)+":"+(area.x1 % 60>=10?Math.floor(area.x1 % 60):"0"+Math.floor(area.x1 % 60))],
                    [area.x1+(area.x2-area.x1)*1/4,Math.floor((area.x1+(area.x2-area.x1)*1/4)/60)+":"+(Math.floor(area.x1+(area.x2-area.x1)*1/4) % 60>=10?Math.floor((area.x1+(area.x2-area.x1)*1/4) % 60):"0"+Math.floor((area.x1+(area.x2-area.x1)*1/4) % 60))],
                    [area.x1+(area.x2-area.x1)*2/4,Math.floor((area.x1+(area.x2-area.x1)*2/4)/60)+":"+(Math.floor(area.x1+(area.x2-area.x1)*2/4) % 60>=10?Math.floor((area.x1+(area.x2-area.x1)*2/4) % 60):"0"+Math.floor((area.x1+(area.x2-area.x1)*2/4) % 60))],
                    [area.x1+(area.x2-area.x1)*3/4,Math.floor((area.x1+(area.x2-area.x1)*3/4)/60)+":"+(Math.floor(area.x1+(area.x2-area.x1)*3/4) % 60>=10?Math.floor((area.x1+(area.x2-area.x1)*3/4) % 60):"0"+Math.floor((area.x1+(area.x2-area.x1)*3/4) % 60))],
                    [area.x2,Math.floor(area.x2/60)+":"+(area.x2 % 60>=10?Math.floor(area.x2 % 60):"0"+Math.floor(area.x2 % 60))]
                ]   
                
//                ticks:[[area.x1/60,area.x1/60],[(area.x1+(area.x2-area.x1)/4)/60,(area.x1+(area.x2-area.x1)/4)/60],[(area.x1+2*(area.x2-area.x1)/4)/60,(area.x1+2*(area.x2-area.x1)/4)/60],
                    //[(area.x1+3*(area.x2-area.x1)/4)/60,(area.x1+3*(area.x2-area.x1)/4)/60]]   
            },
            yaxis: {
                min: area.y1,
                max: area.y2
            }
        });
    });

    // When graph is clicked, draw the graph with default area.
    Flotr.EventAdapter.observe(container, 'flotr:click', function() {
        drawGraph();
    });
    
    }
    //setTimeout(update,1000);

$scope.getData = function() {
    //alert('get');
    if (Number(m)<10) m="0"+Number(m);
    if (Number(d)<10) d="0"+Number(d);
    if ($scope.view==0) {
        fn="/logs/"+yr+"/"+m+"/"+yr+m+d+"_<? print($ds); ?>.csv";
    } else if ($scope.view==1) {
        fn="/logs/"+yr+"/"+m+"/"+yr+m+"_<? print($ds); ?>.csv"
    }
     for (var j=0;j<points.length;j++) {
                points[j].data.length=0;
                points[j].result=0;
                points[j].time=0;
            }
            for (var i=0;i<max;i++) {                
                for (var j=0;j<points.length;j++) {
                    points[j].data.push([i,0]);
                }
            }
            
            
      var x = new XMLHttpRequest();
      $scope.loading=1;
      //$scope.msg='Downloading CSV file';
      var progressBar = document.querySelector('progress');
      
      x.open('GET', fn, true);
      //x.responseType = "blob";
      x.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = Math.round((e.loaded / e.total) * 100);
                    progressBar.textContent = Math.round(progressBar.value*100)/100; // Fallback for unsupported browsers.
                }
                };
            //});      
            
    //$http.get(fn)
    //    .then(function (response) {
    
      x.onload=function() {
        $scope.$apply(function() {
            console.log("Got data!");
            $scope.msg='';
            var sdata = x.response;//.data;      
            $scope.loading=0;
          //  var sdata = response.data;      
            var data = sdata.split('\n');
            maxval=0;
            minval=100;
            
        // IMPORTANT: Must convert the data (which is a string) to numbers
           
            div=60;
            if ($scope.view==1) div=3600;
            maxlen=0;
            for (var i=0; i < data.length; ++i) {
                        
                var lst = data[i].split(',');  
                if (lst.length>maxlen) maxlen=lst.length;
                for (var j=0; j<lst.length; ++j) {        
                        lst[j] = (Number(lst[j]));
                }
                // for newly added csv, just pad with 0
                if (lst.length<maxlen) {
                    for (var j=lst.length; j<maxlen; ++j) {        
                        lst[j] = 0;
                    }
                }
                idx = Math.round((Math.round(lst[0])-time)/div);
                if ((Math.round((Math.round(lst[0])-time)/div)>0) && (Math.round((Math.round(lst[0])-time)/div)<=max) && (lst.length>=points.length))
                {
                    for (j=0;j<points.length;j++) {
                        // get rid of noise
                        if (Math.abs(lst[1+points[j].idx]) < Number(points[j].error)) {
                           // alert('made '+points[j].error+', val was '+lst[1+points[j].idx]);
                            lst[1+points[j].idx]=0; 
                            
                        } 
                        if ((points[j].max>0) && Math.abs(lst[1+points[j].idx]) > Number(points[j].max)) {
                           // alert('made '+points[j].error+', val was '+lst[1+points[j].idx]);
                            lst[1+points[j].idx]=0; 
                            
                        }
                        
                        if (1+points[j].idx>=lst.length) {
                            lst[1+points[j].idx]=0;
                        
                        }
                            points[j].result+=lst[1+points[j].idx];
                            points[j].last=lst[1+points[j].idx];                        
                        
                        if (points[j].opt<2) {
                            if (points[j].func==4) {
                                points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,points[j].result];
                            } else if (points[j].func==5) {
                                points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,points[j].result/60];
                            } else if (points[j].func==8) {
                                points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,points[j].result/(60*1000)]; //*1000
                            } else {
                                if (points[j].func==11) 
                                    points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,lst[1+points[j].idx]/1000];
                                else
                                    points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,lst[1+points[j].idx]];
                                if (points[j].func==9) {
                                    if (Math.abs(lst[1+points[j].idx])<1) points[j].time++;
                                }
                                if (points[j].func==10) {
                                    if (Math.abs(Number(lst[1+points[j].idx]))>=1) points[j].time++;
                                }
                                
                            }
                        }
                        else {
                            if ((points[j].func==4) ) {
                                points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,-points[j].result];
                            } else if (points[j].func==5) {
                                points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,-points[j].result/60];
                            } else if (points[j].func==8) {
                                points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,-points[j].result/60000];
                            } else {
                                if (points[j].func==11) 
                                    points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,-lst[1+points[j].idx]/1000];
                                else 
                                    points[j].data[Math.round((Math.round(lst[0])-time)/div)]=[idx,-lst[1+points[j].idx]];
                                 if (points[j].func==9) {
                                    if (Math.abs(lst[1+points[j].idx])<1) points[j].time++;
                                }
                                if (points[j].func==10) {
                                    if (Math.abs(Number(lst[1+points[j].idx]))>=1) points[j].time++;
                                }
                            }
                        }
                        if (points[j].axis==axis1) {
                            if (points[j].data[Math.round((Math.round(lst[0])-time)/div)][1] > maxval1)  {
                               maxval1 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]+1;
                            }
                            
                            if (points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]<minval1)  {
                                minval1 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]-2;
                            }
                        }
                        if ((points[j].axis==axis2) && (numaxis>1)) {
                            if (points[j].data[Math.round((Math.round(lst[0])-time)/div)][1] > maxval2)  {
                               maxval2 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]+1;
                            }
                            
                            if (points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]<minval2)  {
                                minval2 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]-2;
                            }
                        }
                    }
                }
            }
            for (i=0;i<points.length;i++) {
                if ($scope.view==0) {
                    if (points[i].func==3) points[i].result/=60;
                    if (points[i].func==5) points[i].result/=60;
                    if (points[i].func==7) points[i].result/=60000;
                    if (points[i].func==11) points[i].result/=60000;
                    if (points[i].func==8) points[i].result/=60000;
                
                    if (max>0) if (points[i].func==6) points[i].result/=max;
                    if (points[i].func==9) points[i].result=points[i].time/60;
                    if (points[i].func==10) points[i].result=points[i].time/60;
                } else {
                    if (points[i].func==7) points[i].result/=1000;
                    if (points[i].func==8) points[i].result/=1000;
                    if (points[i].func==11) points[i].result/=1000;
                    if (points[i].func==9) points[i].result=points[i].time;
                    if (points[i].func==10) points[i].result=points[i].time;
                
                }
                
            }
            // scale this a bit so points don't overlap
            maxval2=maxval2*1.5; 
              // alert(maxval);
            if (!$scope.graph_type) {
              $scope.points=points;
            } else {
                // go through and consolide the points
               // alert(max+" "+$scope.per_bar);
                for (i=0;i<points.length;i++) {
                   data2=[];
                   
                   for (j=0;j<max/$scope.per_bar;j++) { 
                      data2.push([j,0]);
                   }
                   for (j=0;j<points[i].data.length;j++) {
                    if ($scope.view==0) {
                      // alert(points[i].func);
                        switch (points[i].func) {
                            case 3:
                            case 5: data2[Math.floor(j/$scope.per_bar)][1]+=points[i].data[j][1]/60;
                                    break;
                            case 7:
                            case 8:
                            case 11:data2[Math.floor(j/$scope.per_bar)][1]+=points[i].data[j][1]/60000;
                                    break;
                            case 9:
                            case 10: if (points[i].data[j][1]) 
                                            data2[Math.floor(j/$scope.per_bar)][1]+=$scope.per_bar;
                                    break;
                            default:
                                data2[Math.floor(j/$scope.per_bar)][1]=(data2[Math.floor(j/$scope.per_bar)][1] + points[i].data[j][1]) / 2;
                        }

                    } else {

                        switch (points[i].func) {
                            case 7:
                            case 8:
                            case 11:data2[Math.floor(j/$scope.per_bar)][1]+=points[i].data[j][1]/1000;
                                    break;
                            case 9:
                            case 10: if (points[i].data[j][1]) 
                                            data2[Math.floor(j/$scope.per_bar)][1]+=$scope.per_bar;
                                    break;
                            default:
                                data2[Math.floor(j/$scope.per_bar)][1]=(data2[Math.floor(j/$scope.per_bar)][1] + points[i].data[j][1]) / 2;
                        }
                    
                    }
                   }
                    points[i].data=data2;
                }
                
                $scope.points=points;
            }
            updateGraph();
            return data;
        });
      };
        /*, 
            function(reason) {
                    updateGraph();
                    $scope.successmsg="";
            
           
                });
            
        
        
    }    */
    x.send();
 }
    $scope.nextDay=function() {
        if ($scope.view==0) {
            var date = new Date((time+toffset+86400)*1000); // next day
            time = time+86400;
            yr=date.getYear()+1900;
            m=date.getMonth()+1;
            if (m<10) m='0'+m;
            d=date.getDate();
            if (d<10) d='0'+d;
            $scope.curdate=d+"/"+m+"/"+yr;
/*            $cookies.dateSet=String(1);
            $cookies.d=String(d);
            $cookies.m=String(m);
            $cookies.y=String(yr);*/
        }
        if ($scope.view==1) {
            var date=new Date(yr, m, 1, 0, 0, 1, 0);
            //time = date.getTime();
            time = Math.round((Date.UTC(yr,m,1))/1000);
            //alert(time);
            yr=Number(date.getYear())+1900;
            m=date.getMonth()+1;
            if (m<10) m='0'+m;
            d=date.getDate();
            if (d<10) d='0'+d;
            $scope.curdate=m+"/"+yr;
        }
        console.log("nextDay:"+$scope.curdate+" "+time);
        maxtime=time+max*3600;
        //$scope.getData();
    }

    $scope.prevDay=function() {
        if ($scope.view==0) {
            var date = new Date((time+toffset-86400)*1000); // next day
            time = time-86400;
            yr=date.getYear()+1900;        
            m=date.getMonth()+1;
            if (m<10) m='0'+m;
            d=date.getDate();
            if (d<10) d='0'+d;
            $scope.curdate=d+"/"+m+"/"+yr;
/*            $cookies.dateSet=String(1);
            $cookies.d=String(d);
            $cookies.m=String(m);
            $cookies.y=String(yr);
  */          
        }
        if ($scope.view==1) {
            var date=new Date(yr, m-2, 1, 0, 0, 1, 0);
            time = Math.round((Date.UTC(yr,m-2,1))/1000);
            //alert(time);
            yr=date.getYear()+1900;
            m=date.getMonth()+1;
            if (m<10) m='0'+m;
            d=date.getDate();
            if (d<10) d='0'+d;
            $scope.curdate=m+"/"+yr;
        }
        console.log("prevDay:"+$scope.curdate+" "+time);
        maxtime=time+max*3600;
        //$scope.getData();
    
    }

    $scope.reload=function() {
        $scope.getData();
    }
    $scope.clearDate=function() {
        $cookies.dateSet=0;
   

    }
    
    //alert('here');
    //$timeout($scope.getData(),1000);
    
 $scope.$watch('curdate', function(curdate) {
    if(angular.isDefined(curdate)) {
        console.log("Date Changed - Reloading");
        console.log($scope.curdate);
        $scope.getData();
    }
  });
  
//  $scope.getData();
  $scope.curdate=d+"/"+m+"/"+yr;
  $scope.loading=0;
  $gscope=$scope;
  
  
    $scope.g_calendarObject=new JsDatePick({
			useMode:2,
			target:"dateButton",
			dateFormat:"%d/%m/%Y",
			isStripped:1,
			cellColorScheme:"beige",
			imgPath:"/ccs/img/"
		});
	$scope.g_calendarObject.setOnSelectedDelegate(function(){
        var obj = $scope.g_calendarObject.getSelectedDay();
    
        $scope.$apply(function(){
            y=obj.year;
            yr=y;
            m=obj.month;
            d=obj.day;
            time = Math.round((Date.UTC(y,m-1,d))/1000);
            $scope.curdate=(obj.day<10?"0"+obj.day:obj.day) + "/" + (obj.month<10?"0"+obj.month:obj.month) + "/" + obj.year;
            maxtime=time+max*3600;
            console.log("calendarSet:"+$scope.curdate+" "+time);
        });
        
        return 0;
    });
    $scope.$watch('width', function(old, newv){
         updateGraph();
    })
 
}
 

  
</script>
</div>
</div>
<script type="text/javascript" src="<? print($url_prefix); ?>/lib/jsDatePick.jquery.min.1.3.js"></script>
<? include("/app/footer.inc"); ?>





