<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : groupedit.cgi
 * 
 *  Description: Group edit page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       18/12/13    v1.0
 * Akash Heimlich       21/06/18    v2.0 WattmonOS 3
  ********************************************************************/
include("/app/config.inc");
$angular_controller="GroupEditCtrl"; 
$title='Group Settings';
include("/app/header.inc");
print('<script src="/lib/jscolor.js"></script>');
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/groups.cgi"><? print(lang('GROUPS','groupedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','groupedit')) ?></li>
  </ol>
</nav>


<!-- VARIABLES -->
<?
  $group_id=$_GET['group_id'];
  $group_ini='/config/groups.ini';
  $group_section='groups';
  //if (!$group_id) $group_id=-1;
?>
<div ng-init="group_id=<? print($group_id); ?>;"></div>
<div ng-init="group_name='<? if ($group_id>=0) {
    print(ini_get($group_ini,$group_section,'group'.$group_id,'Group'+$group_id));
    } else print(lang('NEW_GROUP','groupedit')); ?>';"></div>
<div ng-init="group_type=<? print(ini_get($group_ini,$group_section,'group'.$group_id+"type",0)); ?>;"></div>
<div ng-init="group_show=<? print(ini_get($group_ini,$group_section,'group'.$group_id+"show",0)); ?>;"></div>
<div ng-init="rated_watts=<? print(ini_get($group_ini,$group_section,'group'.$group_id+"rated_watts",0)); ?>;"></div>
<div ng-init="group_icon='<? print(ini_get($group_ini,$group_section,'group'.$group_id+"icon","/img/group/sun.png")); ?>';"></div>
<div ng-init="group_color='<? print(ini_get($group_ini,$group_section,'group'.$group_id+"color","#008000")); ?>';"></div>


<!-- NAVBAR -->
<h4 ><i class="icon-cog"></i> <? print(lang('CONFIGURE_TITLE','groupedit')) ?>&nbsp;<? print(ini_get($group_ini,$group_section,'group'.$group_id,'New Group')); ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/groups.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','groupedit')) ?></a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','groupedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','groupedit')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','groupedit')) ?></div>

<form name="form" class="css-form form-horizontal" novalidate>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('CONFIGURE_TITLE','groupedit')) ?></h5>
        <p class="card-text">
            <div class="form-group">
                <label for="group_id"><? print(lang('GROUP_ID','groupedit')) ?></label>
                <input class="form-control" type='number' ng-model="group_id"  class='span12' name='group_id' required size='3' min="-1" max="254" integer aria-describedby="diHelp" placeholder="<? print(lang('GROUP_ID','groupedit')) ?>">
                <small id="diHelp" class="form-text text-muted"><? print(lang('GROUP_ID_HELP','groupedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.group_id.$invalid"><? print(lang('GROUP_ID_INVALID','groupedit')) ?></small>
            </div>

	        <div class="form-group">
                <label for="group_name"><? print(lang('GROUP_NAME','groupedit')) ?></label>
                <input type="text" class="form-control" ng-model="group_name"  class='span12' name='group_name' requiredaria-describedby="dnHelp" my-directive placeholder="<? print(lang('GROUP_NAME','groupedit')) ?>">
                <small id="dnHelp" class="form-text text-muted"><? print(lang('GROUP_NAME_HELP','groupedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.group_name.$invalid"><? print(lang('GROUP_NAME_INVALID','groupedit')) ?></small>
            </div>
            <div class="form-group">
                <label for="group_type"><? print(lang('GROUP_TYPE','groupedit')) ?></label>
                <select ng-model="group_type" name='group_type' class="custom-select custom-select-sm">
                    <option value='0'><? print(lang('NOT_CONSOLIDATED','groupedit')) ?></option>
                    <option value='1'><? print(lang('CONSOLIDATED','groupedit')) ?></option>
                    <option value='2'><? print(lang('TANK','groupedit')) ?></option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('GROUP_TYPE_HELP','groupedit')) ?></small>
            </div>
            <div class="form-group"  ng-show="group_type<2"> 
                <label for="rated_watts"><? print(lang('RATED_WATTS','groupedit')) ?></label>
                <input class="form-control" type='number' ng-model="rated_watts"  class='span12' name='rated_watts' required size='5' integer aria-describedby="diHelp" placeholder="<? print(lang('RATED_WATTS','groupedit')) ?>">
                <small id="diHelp" class="form-text text-muted"><? print(lang('RATED_WATTS_HELP','groupedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.rated_watts.$invalid"><? print(lang('RATED_WATTS_INVALID','groupedit')) ?></small>
            </div>
            <div class="form-group">
                <label for="group_show"><? print(lang('GROUP_VISIBLE','groupedit')) ?></label>
                <select ng-model="group_show" name='group_show' class="custom-select custom-select-sm">
                    <option value='0'><? print(lang('HIDDEN','groupedit')) ?></option>
                    <option value='1'><? print(lang('VISIBLE','groupedit')) ?></option>
                </select>
                <small id="langH" class="form-text text-muted"><? print(lang('GROUP_VISIBLE_HELP','groupedit')) ?></small>
            </div>
            
            <div class="form-group">
		        <label class="control-label"><? print(lang('GROUP_ICON','groupedit')) ?></label>
		        <div class="controls">
		            <img src='{{group_icon}}'>
			        <input type='hidden' ng-model="group_icon">
                    <div class="btn-group">
                        <button class="btn dropdown-toggle" data-toggle="dropdown">
                            Select <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu">
                        <?
                        chdir("/img/group/");
                        $arr=findfirst("*.png",255-8);
                        
                        while ($arr) {
                            print('<li><a href="#" ng-click="selIcon(\'/img/group/'.$arr['filename'].'\')"><img src="/img/group/'.$arr['filename'].'" width=24></a></li>\r\n');
                            $arr=findnext();
                        }
                            ?>
                        </ul>
                    </div>
			   </div>
		    </div>	 

	        <div class="form-group">
                <label for="group_color"><? print(lang('GROUP_COLOR','groupedit')) ?></label>
                <input type="text" class="form-control color" ng-model="group_color"  class='span12' d="group_color"  name='group_color' required aria-describedby="cdnHelp" my-directive placeholder="<? print(lang('GROUP_COLOR','groupedit')) ?>">
                <small id="cdnHelp" class="form-text text-muted"><? print(lang('GROUP_COLOR_HELP','groupedit')) ?></small>
            </div>
	   </p>
	</div>
</div>
</form>

<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/role_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});

app.directive('color',function($timeout){
  return {
    require : '?ngModel',
    restrict : 'C',
    link : function(scope,element,attrs,ngModelCtrl){
      if(!ngModelCtrl){
        return;
      }
      //document.getElementById('myField1')
      
      //el=document.getElementById(elid);
       $timeout(function () {
                    // This code will run after
                    // templateUrl has been loaded, cloned
                    // and transformed by directives.
                    elid=element.attr('id');//.children()[0];
                    //alert(elid);
                    var myPicker = new jscolor.color(document.getElementById(elid), {});
                }, 0);
      
      scope.$watch('onChange', function(nVal) { 
        if (nVal)
         ngModelCtrl.$setViewValue(nVal); 
      });                   
      element.bind('change', function() {
                
                var currentValue = element.val();
                //alert(element.val());                
                if( scope.onChange !== currentValue ) {
                    scope.$apply(function() {
                        //scope.onChange = currentValue;
                        ngModelCtrl.$setViewValue('#'+currentValue);//element.html());
                    });
                }
            });
            
    
    }
  };
});

function GroupEditCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  $scope.infomsg="";
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
  

  $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      group_url='/app/group_ajax.cgi?action=save&group_id='+$scope.group_id;
      group_params="group_name="+$scope.group_name+"&group_type="+$scope.group_type+"&group_show="+$scope.group_show+"&rated_watts="+$scope.rated_watts+"&group_color="+$scope.group_color+"&group_icon="+$scope.group_icon;
      //alert(role_params);
      //return;
      $http.post(group_url,group_params)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          if (data.status)
            $scope.successmsg="Settings saved.";
            if ($scope.group_id==-1)
                document.location='/app/groups.cgi';
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    $scope.selIcon=function(fn) {
        $scope.group_icon=fn;
    }
}


</script>
<? include("/app/footer.inc"); ?>      

