<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : helpfuncref.cgi
 * 
 *  Description: About page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *			16/06/14    v1.1 - added net statistics 
 ********************************************************************/
include("/app/config.inc");
$angular_controller="NetworkCtrl"; 
$title='Help';
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');


?>

      <div class="row-fluid">
        <div class='span12' >    
         <ul class="breadcrumb">
  <li><a href="/">Home</a> <span class="divider">/</span></li>
  
  <li class="active">Function Reference</li>
</ul>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> Close</button>
                </div>
                
            </div> <!-- container -->
<div class="alert alert-success" ng-cloak ng-show="successmsg && form.$pristine"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>
<div class="page-header">
  <h1><i class="icon-wrench"></i> Function Reference</h1>
</div>

<div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-pencil"></i> Function Reference</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content">
   

<p>uPHP functions have an identical syntax to PHP functions in most cases. Below is a list of all the functions that have been implemented.</p>
<p> </p>
<table class="table table-striped" border="0" cellspacing="0">
<tbody>
<tr>
<td align="left" height="17"><strong>FUNCTION NAME</strong></td>
<td align="left"><strong>PARAMETERS</strong></td>
<td align="left"><strong>RETURN</strong></td>
<td align="left"><strong>DESCRIPTION</strong></td>
</tr>
<tr>
<td align="left" height="17">array</td>
<td align="left">values</td>
<td align="left">array object</td>
<td align="left">create an array with values</td>
</tr>
<tr>
<td align="left" height="17">adc_read</td>
<td align="left">channel</td>
<td align="left">number</td>
<td align="left">read onboard ADC channel</td>
</tr>
<tr>
<td align="left" height="17">array_keys</td>
<td align="left">array</td>
<td align="left">array</td>
<td align="left">return keys for an array</td>
</tr>
<tr>
<td align="left" height="17">call_user_func</td>
<td align="left">string function_name, optional parameters</td>
<td align="left">mixed result</td>
<td align="left">calls a user defined function with optional parameters</td>
</tr>
<tr>
<td align="left" height="17">charat</td>
<td align="left">string,index</td>
<td align="left">number (ascii code)</td>
<td align="left">return ASCII code for character in string at index</td>
</tr>
<tr>
<td align="left" height="17">chdir</td>
<td align="left">string</td>
<td align="left">number</td>
<td align="left"> </td>
</tr>
<tr>
<td align="left" height="17">chr</td>
<td align="left">number</td>
<td align="left">String (1 character)</td>
<td align="left">return character for number</td>
</tr>
<tr>
<td align="left" height="17">cos</td>
<td align="left">number or float</td>
<td align="left">float</td>
<td align="left">return cosine of number</td>
</tr>
<tr>
<td align="left" height="17">debug</td>
<td align="left">string</td>
<td align="left">none</td>
<td align="left">print to debug output</td>
</tr>
<tr>
<td align="left" height="17">debugout</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">Enabled (1) or disable (0) output to the standard output</td>
</tr>
<tr>
<td align="left" height="17">die</td>
<td align="left">none</td>
<td align="left">none</td>
<td align="left">kill script</td>
</tr>
<tr>
<td align="left" height="17">disk_free_space</td>
<td align="left">int [volume]</td>
<td align="left">number</td>
<td align="left">get free space on SD</td>
</tr>
<tr>
<td align="left" height="17">disk_total_space</td>
<td align="left">int [volume]</td>
<td align="left">number</td>
<td align="left">get total space on SD</td>
</tr>
<tr>
<td align="left" height="17">error_reporting</td>
<td align="left">int debug_level</td>
<td align="left">none</td>
<td align="left">sets the debug output level</td>
</tr>
<tr>
<td align="left" height="17">exec</td>
<td align="left">string filename, number msinterval</td>
<td align="left"> </td>
<td align="left">run a script</td>
</tr>
<tr>
<td align="left" height="17">explode</td>
<td align="left">string delimiter,string value</td>
<td align="left">array</td>
<td align="left">turn a string into an array</td>
</tr>
<tr>
<td align="left" height="17">fclose</td>
<td align="left">number handle</td>
<td align="left"> </td>
<td align="left">Closes a file, stream or socket with the passed handle</td>
</tr>
<tr>
<td align="left" height="17">feof</td>
<td align="left">number handle</td>
<td align="left">number</td>
<td align="left">Returns 0 if no more data is available, or 1 if there is data</td>
</tr>
<tr>
<td align="left" height="17">fgets</td>
<td align="left">number handle, optional number bytes</td>
<td align="left">string</td>
<td align="left">returns a single line from the file or stream, optionally upto the number of bytes specified</td>
</tr>
<tr>
<td align="left" height="17">file_exists</td>
<td align="left">string filename</td>
<td align="left">number</td>
<td align="left">Returns 1 if the file exists</td>
</tr>
<tr>
<td align="left" height="17">filesize</td>
<td align="left">number handle</td>
<td align="left">number</td>
<td align="left">for files returns the number of bytes in file, for stream returns the number of bytes pending</td>
</tr>
<tr>
<td align="left" height="17">findfirst</td>
<td align="left">string pattern, number flags</td>
<td align="left">array</td>
<td align="left">Start searching the current folder for files matching the pattern and with specified flags. Returns an array with the first matching info</td>
</tr>
<tr>
<td align="left" height="17">findnext</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">Return next matching file information as array</td>
</tr>
<tr>
<td align="left" height="17">firmwareupdate</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">initiates a firmware update sequence and reboots the device</td>
</tr>
<tr>
<td align="left" height="17">floatval</td>
<td align="left">Mixed value</td>
<td align="left">number</td>
<td align="left">returns the floating point value of the number or string</td>
</tr>
<tr>
<td align="left" height="17">flush</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">Flushes current output to the browser</td>
</tr>
<tr>
<td align="left" height="17">fopen</td>
<td align="left">string filename, string status</td>
<td align="left">Number handle</td>
<td align="left">Opens a file for reading or writing, returns the handle for future operations</td>
</tr>
<tr>
<td align="left" height="17">fread</td>
<td align="left">number handle, number bytes</td>
<td align="left">string</td>
<td align="left">returns number bytes from the stream</td>
</tr>
<tr>
<td align="left" height="17">freemem</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">Returns bytes free</td>
</tr>
<tr>
<td align="left" height="17">fseek</td>
<td align="left">number handle, number position, number position_type</td>
<td align="left"> </td>
<td align="left">Locate file pointer inside the open file to position. If position_type is 0, it seeks from the start. If position_type is 1, it seeks from the current position. If position_type=2 it seeks from the end</td>
</tr>
<tr>
<td align="left" height="17">fseropen</td>
<td align="left">number baudrate, optional number blocking</td>
<td align="left">number handle</td>
<td align="left">Opens the serial port at the specified baud rate</td>
</tr>
<tr>
<td align="left" height="17">fsockopen</td>
<td align="left">string host, optional number timeout</td>
<td align="left">Number handle</td>
<td align="left">Attempts to create a socket to the host with the protocol specified and returns a handle or 0 if failed</td>
</tr>
<tr>
<td align="left" height="17">fwrite</td>
<td align="left">number handle, mixed value</td>
<td align="left">number (1=OK)</td>
<td align="left">writes data to the stream or file</td>
</tr>
<tr>
<td align="left" height="17">get3gstat</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">Returns an array of the status of the USB Dongle network interface</td>
</tr>
<tr>
<td align="left" height="17">getcwd</td>
<td align="left"> </td>
<td align="left">string</td>
<td align="left">Gets the current directory</td>
</tr>
<tr>
<td align="left" height="17">getethstat</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">Returns an array of the status of the LAN interface</td>
</tr>
<tr>
<td align="left" height="17">getmac</td>
<td align="left"> </td>
<td align="left">string</td>
<td align="left">Returns the network MAC address</td>
</tr>
<tr>
<td align="left" height="17">getusbstat</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">Returns information about the USB host status</td>
</tr>
<tr>
<td align="left" height="17">header</td>
<td align="left">string</td>
<td align="left">none</td>
<td align="left">add to http header</td>
</tr>
<tr>
<td align="left" height="17">htmlspecialchars</td>
<td align="left">string</td>
<td align="left">string</td>
<td align="left">convert characters for display in html</td>
</tr>
<tr>
<td align="left" height="17">implode</td>
<td align="left">array, string separator</td>
<td align="left">string</td>
<td align="left">Implodes the array with the separator and returns a string</td>
</tr>
<tr>
<td align="left" height="17">ini_get</td>
<td align="left">string ini, string section, string key, mixed defvalue</td>
<td align="left">mixed</td>
<td align="left">returns the value associated with the key if it exists, or the default value otherwise</td>
</tr>
<tr>
<td align="left" height="17">ini_get_array</td>
<td align="left">string ini, string section</td>
<td align="left">array</td>
<td align="left">returns a key/value array of all items in the section</td>
</tr>
<tr>
<td align="left" height="17">ini_put_array</td>
<td align="left">string ini, optional string section</td>
<td align="left"> </td>
<td align="left">writes the values in the key/value array to the ini file or to the section inside, if specified.</td>
</tr>
<tr>
<td align="left" height="17">ini_set</td>
<td align="left">string ini, string section, string key, mixed value</td>
<td align="left">number (1=OK)</td>
<td align="left">writes the value to the section in an INI file</td>
</tr>
<tr>
<td align="left" height="17">intval</td>
<td align="left">string or float</td>
<td align="left">number</td>
<td align="left">integer value of the parameter</td>
</tr>
<tr>
<td align="left" height="17">is_array</td>
<td align="left">mixed value</td>
<td align="left">number</td>
<td align="left">Returns 1 if the variable or value is an array</td>
</tr>
<tr>
<td align="left" height="17">is_float</td>
<td align="left">mixed value</td>
<td align="left">number</td>
<td align="left">Returns 1 if the variable or value is a floating point value</td>
</tr>
<tr>
<td align="left" height="17">is_int</td>
<td align="left">mixed value</td>
<td align="left">number</td>
<td align="left">Returns 1 if the variable or value is an integer</td>
</tr>
<tr>
<td align="left" height="17">is_numeric</td>
<td align="left">mixed value</td>
<td align="left">number</td>
<td align="left">Returns 1 if the value is numeric (integer or float)</td>
</tr>
<tr>
<td align="left" height="17">is_string</td>
<td align="left">mixed value</td>
<td align="left">number</td>
<td align="left">Returns 1 if the variable or value is a string</td>
</tr>
<tr>
<td align="left" height="17">isset</td>
<td align="left">variable</td>
<td align="left">number</td>
<td align="left">Returns 1 if the variable exists or 0 if not</td>
</tr>
<tr>
<td align="left" height="17">json_encode</td>
<td align="left">array,type [0=object,1=array)</td>
<td align="left">string</td>
<td align="left">encode an array as a string</td>
</tr>
<tr>
<td align="left" height="17">ln</td>
<td align="left">number</td>
<td align="left">float</td>
<td align="left">return natural logarithm of number</td>
</tr>
<tr>
<td align="left" height="17">log</td>
<td align="left">string</td>
<td align="left">none</td>
<td align="left">print to log</td>
</tr>
<tr>
<td align="left" height="17">log10</td>
<td align="left">number</td>
<td align="left">float</td>
<td align="left">return log10 of number</td>
</tr>
<tr>
<td align="left" height="17">mail</td>
<td align="left">string recipient, string title, string body</td>
<td align="left">number</td>
<td align="left">0=success, other number contains SMTP error code</td>
</tr>
<tr>
<td align="left" height="17">max_execution_time</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">set maximum execution time in seconds</td>
</tr>
<tr>
<td align="left" height="17">mb_add_dev</td>
<td align="left">number device_id, number device_type_id, string name, number poll_interval, number status</td>
<td align="left">Number (0=OK)</td>
<td align="left">adds a device to the list of polled devices</td>
</tr>
<tr>
<td align="left" height="17">mb_delete_device</td>
<td align="left">number device_id</td>
<td align="left">number (1=OK)</td>
<td align="left">delete a device from the list of active device with the slave ID passed</td>
</tr>
<tr>
<td align="left" height="17">mb_get_dev_by_id</td>
<td align="left">number id</td>
<td align="left">array</td>
<td align="left">modbus device details</td>
</tr>
<tr>
<td align="left" height="17">mb_get_dev_by_index</td>
<td align="left">number index</td>
<td align="left">array</td>
<td align="left">modbus device details</td>
</tr>
<tr>
<td align="left" height="17">mb_get_dev_by_name</td>
<td align="left">string name</td>
<td align="left">array</td>
<td align="left">modbus device details</td>
</tr>
<tr>
<td align="left" height="17">mb_get_dev_info</td>
<td align="left">number device type id</td>
<td align="left">array</td>
<td align="left">modbus device details</td>
</tr>
<tr>
<td align="left" height="17">mb_get_role_array</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">array of all roles and their values</td>
</tr>
<tr>
<td align="left" height="17">mb_get_status_by_role</td>
<td align="left">number role_id</td>
<td align="left">number (1=OK)</td>
<td align="left">status of the device attached to the role</td>
</tr>
<tr>
<td align="left" height="17">mb_get_val_by_role</td>
<td align="left">number role_id</td>
<td align="left">number</td>
<td align="left">value of the role in the system</td>
</tr>
<tr>
<td align="left" height="17">mb_num_devices</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">number of devices on the modbus</td>
</tr>
<tr>
<td align="left" height="17">mb_scan_complete</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">1=complete, 0=ongoing</td>
</tr>
<tr>
<td align="left" height="17">mb_scan_percent</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">percentage completed of scan</td>
</tr>
<tr>
<td align="left" height="17">mb_send_command</td>
<td align="left">mixed, multiple parameters</td>
<td align="left">array of numbers</td>
<td align="left">send a sequence of characters to the rs485 bus and get reply</td>
</tr>
<tr>
<td align="left" height="17">mb_set_dev_var</td>
<td align="left">string or number device name or id, param string, value</td>
<td align="left">number, 1=OK</td>
<td align="left">set a variable on a modbus device</td>
</tr>
<tr>
<td align="left" height="17">mb_set_val_by_role</td>
<td align="left">number role_id, number value</td>
<td align="left">number, 1=OK</td>
<td align="left">set a role value on a modbus device</td>
</tr>
<tr>
<td align="left" height="17">mb_start_scan</td>
<td align="left">number start, number end</td>
<td align="left"> </td>
<td align="left">initiates an automatic scan of modbus bus</td>
</tr>
<tr>
<td align="left" height="17">microtime</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">number of milliseconds since boot</td>
</tr>
<tr>
<td align="left" height="17">mkdir</td>
<td align="left">string</td>
<td align="left">number</td>
<td align="left">FR_OK or erro code</td>
</tr>
<tr>
<td align="left" height="17">mktime</td>
<td align="left">number hr,min,sec,month,day,year</td>
<td align="left">number</td>
<td align="left">linux timestamp of date</td>
</tr>
<tr>
<td align="left" height="17">net_disable3g</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">Disable usb dongle net connectivity</td>
</tr>
<tr>
<td align="left" height="17">net_enable3g</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">Enabled usb dongle net connectivity if available</td>
</tr>
<tr>
<td align="left" height="17">netstat</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">returns information about the current http connections</td>
</tr>
<tr>
<td align="left" height="17">number_format</td>
<td align="left">mixed num, number digits</td>
<td align="left">string</td>
<td align="left">formats the number with the specified number of digits of precision</td>
</tr>
<tr>
<td align="left" height="17">nvram_backup</td>
<td align="left">string filename</td>
<td align="left"> </td>
<td align="left">writes contents of nvram to the file in filename</td>
</tr>
<tr>
<td align="left" height="17">nvram_defrag</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">defragments nvram if required</td>
</tr>
<tr>
<td align="left" height="17">nvram_dump</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">dumps the contents of nvram to the standard output</td>
</tr>
<tr>
<td align="left" height="17">nvram_free</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">number of free bytes in nvram</td>
</tr>
<tr>
<td align="left" height="17">nvram_get</td>
<td align="left">string key, mixed def_value</td>
<td align="left">string</td>
<td align="left">returns the value of the key in nvram, or the def_value if not yet assigned</td>
</tr>
<tr>
<td align="left" height="17">nvram_restore</td>
<td align="left">string filename</td>
<td align="left"> </td>
<td align="left">reads contents of filename into nvram</td>
</tr>
<tr>
<td align="left" height="17">nvram_set</td>
<td align="left">string key, string value</td>
<td align="left"> </td>
<td align="left">sets a key and value in nvram</td>
</tr>
<tr>
<td align="left" height="17">nvram_unset</td>
<td align="left">string key</td>
<td align="left"> </td>
<td align="left">clears a key from nvram</td>
</tr>
<tr>
<td align="left" height="17">ord</td>
<td align="left">string char</td>
<td align="left">number num</td>
<td align="left">Returns the ASCII number of the character</td>
</tr>
<tr>
<td align="left" height="17">ow_first</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">Initiates a onewire scan and returns the first device found</td>
</tr>
<tr>
<td align="left" height="17">ow_next</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">Returns the next device found or 0 if none</td>
</tr>
<tr>
<td align="left" height="17">ow_read</td>
<td align="left"> </td>
<td align="left">number val</td>
<td align="left">Reads a byte from the onewire bus</td>
</tr>
<tr>
<td align="left" height="17">ow_read_temp</td>
<td align="left">optional array</td>
<td align="left">number</td>
<td align="left">Returns the temperature in degrees celcius for the device</td>
</tr>
<tr>
<td align="left" height="17">ow_reset</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">Resets the onewire bus</td>
</tr>
<tr>
<td align="left" height="17">ow_write</td>
<td align="left">number val</td>
<td align="left"> </td>
<td align="left">Writes a byte to the onewire bus</td>
</tr>
<tr>
<td align="left" height="17">phpinfo</td>
<td align="left"> </td>
<td align="left">string</td>
<td align="left">returns information about the system</td>
</tr>
<tr>
<td align="left" height="17">pin_configure</td>
<td align="left">number pin, number pin_type</td>
<td align="left"> </td>
<td align="left">configures an IO pin as a digital input, output, or analog input</td>
</tr>
<tr>
<td align="left" height="17">pin_get</td>
<td align="left">number pin</td>
<td align="left">number</td>
<td align="left">get the value of digital input pin</td>
</tr>
<tr>
<td align="left" height="17">pin_set</td>
<td align="left">Number pin_number, number value</td>
<td align="left"> </td>
<td align="left">sets a digital output to value (1 or 0)</td>
</tr>
<tr>
<td align="left" height="17">ping</td>
<td align="left">string host</td>
<td align="left">array</td>
<td align="left">sends an ICMP ping and puts the result in the array</td>
</tr>
<tr>
<td align="left" height="17">power</td>
<td align="left">number num, number factor</td>
<td align="left">number</td>
<td align="left">returns num to the power of factor</td>
</tr>
<tr>
<td align="left" height="17">print</td>
<td align="left">mixed</td>
<td align="left"> </td>
<td align="left">output data to the current output stream such as web page or terminal</td>
</tr>
<tr>
<td align="left" height="17">print_r</td>
<td align="left">array</td>
<td align="left"> </td>
<td align="left">dump the contents of an array to the current output</td>
</tr>
<tr>
<td align="left" height="17">printf</td>
<td align="left">string format, optional values</td>
<td align="left"> </td>
<td align="left">prints a formatted string to the standard output</td>
</tr>
<tr>
<td align="left" height="17">process_kill</td>
<td align="left">number process_id</td>
<td align="left"> </td>
<td align="left">sends a kill request to the process number</td>
</tr>
<tr>
<td align="left" height="17">process_list</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">returns an array of the currently running scripts</td>
</tr>
<tr>
<td align="left" height="17">rename</td>
<td align="left">string source, stirng dest</td>
<td align="left">number</td>
<td align="left">Renames or moves a file from source to dest name</td>
</tr>
<tr>
<td align="left" height="17">reset</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">Resets the processor</td>
</tr>
<tr>
<td align="left" height="17">rmdir</td>
<td align="left">string dir</td>
<td align="left">number</td>
<td align="left">Removes a directory, returns 0 if successful</td>
</tr>
<tr>
<td align="left" height="17">session_destroy</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">clears the current sessions data</td>
</tr>
<tr>
<td align="left" height="17">session_is_new</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">Returns 1 if the session is just initiated</td>
</tr>
<tr>
<td align="left" height="17">session_start</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">initiates a new session and sends the cookie data for it</td>
</tr>
<tr>
<td align="left" height="17">set_search_path</td>
<td align="left">string</td>
<td align="left"> </td>
<td align="left">sets the search path for the telnet client</td>
</tr>
<tr>
<td align="left" height="17">setethpower</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">Enables or disables the ethernet controller</td>
</tr>
<tr>
<td align="left" height="17">setpriority</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">sets the priority of the script (2 is high, 1 is low)</td>
</tr>
<tr>
<td align="left" height="17">settime</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">Set system from linux timestamp</td>
</tr>
<tr>
<td align="left" height="17">setusbpower</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">sets the USB host power on or off (1 or 0)</td>
</tr>
<tr>
<td align="left" height="17">sin</td>
<td align="left">number</td>
<td align="left">number</td>
<td align="left">Returns the sin value of the number</td>
</tr>
<tr>
<td align="left" height="17">sizeof</td>
<td align="left">array</td>
<td align="left">number</td>
<td align="left">returns the number of elements in an array</td>
</tr>
<tr>
<td align="left" height="17">sleep</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">Sleep for specified milliseconds</td>
</tr>
<tr>
<td align="left" height="17">spi_clearcs</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">clears the CS output of the SPI bus</td>
</tr>
<tr>
<td align="left" height="17">spi_read</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">reads a byte from the SPI bus</td>
</tr>
<tr>
<td align="left" height="17">spi_setcs</td>
<td align="left"> </td>
<td align="left"> </td>
<td align="left">sets the CS output of the SPI bus</td>
</tr>
<tr>
<td align="left" height="17">spi_write</td>
<td align="left">number</td>
<td align="left"> </td>
<td align="left">writes a byte to the SPI bus</td>
</tr>
<tr>
<td align="left" height="17">sprintf</td>
<td align="left">string format, optional values</td>
<td align="left">string</td>
<td align="left">formats a string using the format specified using the passed parameters and returns a string</td>
</tr>
<tr>
<td align="left" height="17">sqr</td>
<td align="left">number</td>
<td align="left">number</td>
<td align="left">Returns the square of a number</td>
</tr>
<tr>
<td align="left" height="17">sqrt</td>
<td align="left">number</td>
<td align="left">number</td>
<td align="left">Returns the square root of a number</td>
</tr>
<tr>
<td align="left" height="17">stats</td>
<td align="left"> </td>
<td align="left">array</td>
<td align="left">Returns system statistics</td>
</tr>
<tr>
<td align="left" height="17">strftime</td>
<td align="left">string format, number time</td>
<td align="left">string</td>
<td align="left">formats the passed time using the format string</td>
</tr>
<tr>
<td align="left" height="17">strlen</td>
<td align="left">string str</td>
<td align="left">number</td>
<td align="left">Returns the length of a string</td>
</tr>
<tr>
<td align="left" height="17">strpos</td>
<td align="left">string haystack, string needle</td>
<td align="left">number</td>
<td align="left">Returns the position of the first occurence of needle in haystack or -1 if not found</td>
</tr>
<tr>
<td align="left" height="17">strrpos</td>
<td align="left">string haystack, string needle</td>
<td align="left">number</td>
<td align="left">Returns the last occurence of haystack in needle, or -1 if not found</td>
</tr>
<tr>
<td align="left" height="17">strtolower</td>
<td align="left">string</td>
<td align="left">string</td>
<td align="left">returns the lowercase version of the string</td>
</tr>
<tr>
<td align="left" height="17">strtoupper</td>
<td align="left">string</td>
<td align="left">string</td>
<td align="left">returns the uppercase version of the string</td>
</tr>
<tr>
<td align="left" height="17">strval</td>
<td align="left">Mixed value</td>
<td align="left">string</td>
<td align="left">Returns the string value of the passed parameter</td>
</tr>
<tr>
<td align="left" height="17">substr</td>
<td align="left">string str, number start, number len</td>
<td align="left">string</td>
<td align="left">returns a substring of the passed string from start for len characters. If len is blank it will return the string until the end</td>
</tr>
<tr>
<td align="left" height="17">tar_finish</td>
<td align="left">number handle</td>
<td align="left"> </td>
<td align="left">adds the ending header to a TAR file</td>
</tr>
<tr>
<td align="left" height="17">tar_put</td>
<td align="left">number handle, string filename</td>
<td align="left">number (1=OK)</td>
<td align="left">adds a file to the currently open file handle in TAR format</td>
</tr>
<tr>
<td align="left" height="17">time</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">Returns the current system timestamp</td>
</tr>
<tr>
<td align="left" height="17">timefromfat</td>
<td align="left">number</td>
<td align="left">number</td>
<td align="left">converts a FAT filetime to a native timestamp</td>
</tr>
<tr>
<td align="left" height="17">ucfirst</td>
<td align="left">string</td>
<td align="left">string</td>
<td align="left">convert string to lowercase except for first character</td>
</tr>
<tr>
<td align="left" height="17">unlink</td>
<td align="left">string filename</td>
<td align="left">Number (0=OK)</td>
<td align="left">removes a file (deletes it)</td>
</tr>
<tr>
<td align="left" height="17">untar</td>
<td align="left">string filename, number verbose</td>
<td align="left"> </td>
<td align="left">untars a file into the current folder, optionally verbose</td>
</tr>
<tr>
<td align="left" height="17">uptime</td>
<td align="left"> </td>
<td align="left">number</td>
<td align="left">uptime in milliseconds</td>
</tr>
</tbody>
</table>
<p> </p>

      <div class="clearfix"></div>    <!-- actionlist-->
					</div>
				</div>
			</div>  
			
        </div><!--/span-->
      </div><!--/row-->
      
      
<script type='text/javascript'>
var app = angular.module('myApp', []);

/**
* Network controller object used by Angular.JS
* @param $scope Application scope
* @param $http  HTTP object used for ajax requests
*/
function NetworkCtrl($scope,$http) {
    var self = this;
    $scope.infomsg="";
    
    
}
</script>
<? include("/app/footer.inc"); ?>

