<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : interface.cgi
 * 
 *  Description: User interface settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       09/07/18    v2.0 WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="UserEditCtrl"; 
$title=lang('PAGE_TITLE','interface');
include("/app/header.inc");
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','interface')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('PAGE_TITLE','interface')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('CLOSE','roleedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','interface')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1 || settings_locked' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','interface')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','interface')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','interface')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>
<!-- VARIABLES -->
<? 
  //$users=ini_get_array("/config/user.ini");
  $local_only=ini_get("/config/uphp.ini","debug","local_only","1");
  $notifications=ini_get("/config/uphp.ini","debug","notifications",0);
  $ajax_refresh_time=ini_get("/config/uphp.ini","debug","ajax_refresh_time","1");
  $max_execution_time=ini_get("/config/uphp.ini","debug","max_execution_time","10");
  $max_low_mem_errors=ini_get("/config/uphp.ini","debug","max_low_mem_errors","400");
?>

<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="local_only='<? print($local_only); ?>';"></div>
<div ng-init="notifications='<? print($notifications); ?>';"></div>
<div ng-init="ajax_refresh_time='<? print($ajax_refresh_time); ?>';"></div>
<div ng-init="max_execution_time='<? print($max_execution_time); ?>';"></div>
<div ng-init="max_low_mem_errors=<? print($max_low_mem_errors); ?>;"></div>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('PAGE_TITLE','interface')) ?></h5>
        <p class="card-text">    
            <div class="form-group"  ng-cloak>
                <label for="local_only"><small class='text-muted'><? print(lang('OPTIMIZATION','interface')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="local_only"  value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ESSENTIAL_FILES','interface')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="local_only" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ALL_FILES','interface')) ?>
                  </label>
                </div>  
                <small class="form-text text-muted"><? print(lang('OPTIMIZATION_HELP','interface')) ?></small>
            </div>         
	        <div class="form-group"  ng-cloak>
                <label for="notifications"><small class='text-muted'><? print(lang('NOTIFICATIONS','interface')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="notifications"  value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('NO_NOTIFICATION','interface')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="notifications" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('SHOW_NOTIFICATION','interface')) ?>
                  </label>
                </div>  
                <small class="form-text text-muted"><? print(lang('NOTIFICATIONS_HELP','interface')) ?></small>
            </div>
            <div class="form-group" ng-cloak>
                <label for="ajax_refresh_time"><? print(lang('REFRESH_TIME','interface')) ?></label>
                <select ng-model="ajax_refresh_time" name='ajax_refresh_time' class="form-control">
	                <option value="1">1 <? print(lang('SECOND','interface')) ?></option>
                    <option value="5">5 <? print(lang('SECONDS','interface')) ?></option>
                    <option value="10">10 <? print(lang('SECONDS','interface')) ?></option>
                    <option value="30">30 <? print(lang('SECONDS','interface')) ?></option>
                </select>
                <small class="form-text text-muted"><? print(lang('REFRESH_TIME_HELP','interface')) ?></small>
	        </div>      
	        <div class="form-group" ng-cloak>
                <label for="max_execution_time"><? print(lang('MAX_EXECUTION_TIME','interface')) ?></label>
                <select ng-model="max_execution_time" name='max_execution_time' class="form-control">
                    <option value="10">10 <? print(lang('SECONDS','interface')) ?></option>
                    <option value="20">20 <? print(lang('SECONDS','interface')) ?></option>
                    <option value="60">60 <? print(lang('SECONDS','interface')) ?></option>
                </select>
                <small class="form-text text-muted"><? print(lang('REFRESH_TIME_HELP','interface')) ?></small>
	        </div>   
		    <div class="form-group">
                <label for="max_low_mem_errors"><? print(lang('MAX_LOW_MEMORY','interface')) ?></label>
                <input class="form-control" type='number' ng-model="max_low_mem_errors"  class='span12' name='max_low_mem_errors' min=100 required integer aria-describedby="rHelp" placeholder="<? print(lang('MAX_LOW_MEMORY','interface')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('MAX_LOW_MEMORY_HELP','interface')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.max_low_mem_errors.$invalid"><? print(lang('MAX_LOW_MEMORY_INVALID','interface')) ?></small>
            </div>
        </p>          
	</div>
</div>  		        		        
</form>

<script>
var app = angular.module('myApp', []);
function UserEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
  $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       $scope.loading=1;
       //alert();
       //
       $http.post('/app/configsave.cgi?config=uphp.ini&section=debug',"local_only="+$scope.local_only+"&max_low_mem_errors="+$scope.max_low_mem_errors+"&max_execution_time="+$scope.max_execution_time+"&ajax_refresh_time="+$scope.ajax_refresh_time+"&notifications="+$scope.notifications)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          $scope.loading=0;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            $scope.loading=0;
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>
