<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : network3g.cgi
 * 
 *  Description: 3G Network settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       19/06/18    v2.0 WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="NetworkCtrl"; 
$title='Cellular Data Settings';
include("/app/header.inc");

if ($_GET['reboot']==1) {
    setusbpower(0);
    sleep(500);
    setusbpower(1);
}
$stat=get3gstat(); 
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','network3g')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-group"></i> <? print(lang('PAGE_TITLE','network')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','network3g')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/network3g.cgi?reboot=1';"><i class="icon-wrench"></i> <? print(lang('RESTART','network3g')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/network3g.cgi';"><i class="icon-refresh"></i> <? print(lang('REFRESH','network3g')) ?></a>
  </li>
  
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','network3g')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
  <? print(lang('HELP1','network')) ?><br>
  <? print(lang('HELP2','network')) ?><br>
  <? print(lang('HELP3','network')) ?><br>

  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<!--VARIABLES-->
<? if ($stat['enabled']) {
            if ($stat['connected']) {
                if ($stat['ip_address']=='0.0.0.0') $stat['ip_address']="being obtained.";
                print('<div class="alert alert-success">Your are connected to Cellular Data.  Your IP is '.$stat['ip_address']."</div>"); 
            } else print('<div class="alert alert-error">You are not connected to Cellular Data.</div>');
    } else {
        print('<div class="alert alert-warning">Cellular Data is current disabled.</div>');
    }
         
  $apn=ini_get("/config/3g.ini","3g","apn","");
  $enabled=ini_get("/config/3g.ini","3g","enabled",0);
  $dial=ini_get("/config/3g.ini","3g","dial","");
  $mtu=ini_get("/config/3g.ini","3g","mtu",500);
  $username3g=ini_get("/config/3g.ini","3g","username","");
  $password3g=ini_get("/config/3g.ini","3g","password","");
  $mode=ini_get("/config/3g.ini","3g","mode",0);
  $interval=ini_get("/config/3g.ini","3g","packet_interval",1);
?>
<div ng-init="enabled=<? print($enabled); ?>;"></div>
<div ng-init="apn='<? print($apn); ?>';"></div>
<div ng-init="mode='<? print($mode); ?>';"></div>
<div ng-init="packet_interval='<? print($interval); ?>';"></div>
<div ng-init="mtu=<? print($mtu); ?>;"></div>
<div ng-init="dial='<? print($dial); ?>';"></div>
<div ng-init="username3g='<? print($username3g); ?>';"></div>
<div ng-init="password3g='<? print($password3g); ?>';"></div>          

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('NETWORK_SETTINGS','network3g')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="enabled"><small class='text-muted'><? print(lang('STATUS','network3g')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('DISABLED','network3g')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('ENABLED','network3g')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','network3g')) ?></small>
            </div> 
<? if ($_SERVER['HW_PLATFORM'] < 20) { ?>
            <div class="form-group">
                <label for="mode"><? print(lang('CONNECTION_MODE','network3g')) ?></label>
                <select ng-show='enabled' ng-cloak ng-model="mode" name='mode' class="custom-select custom-select-sm">
			                <option value='0'>GPRS/Edge 2G Mode Only</option>
                            <option value='1'>3G Mode Only</option>
                            <option value='2'>Prefer GPRS/Edge 2G Mode</option>
                            <option value='3'>Prefer 3G Mode</option>
							<option value='4'>4G Mode</option>

                </select>
                <small id="ddHelp" class="form-text text-muted"><? print(lang('CONNECTION_HELP','network3g')) ?></small>
            </div> 
<?  } ?>            
            <div class="form-group" ng-show='enabled' ng-cloak>
                <label for="apn"><? print(lang('APN','network3g')) ?></label>
                <input type="text" class="form-control" id="apn" ng-model="apn" aria-describedby="userHelp" placeholder="<? print(lang('APN_HELP','network3g')) ?>">
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('APN_HELP','network3g')) ?></small>
            </div>
            <div class="form-group" ng-show='enabled' ng-cloak>
                <label for="dial"><? print(lang('NUMBER','network3g')) ?></label>
                <input type="text" class="form-control" id="dial" ng-model="dial" aria-describedby="auserHelp" placeholder="<? print(lang('NUMBER_HELP','network3g')) ?>">
                <small id="auserHelp" class="form-text text-muted"><? print(lang('NUMBER_HELP','network3g')) ?></small>
            </div>                
		    <div class="form-group" ng-show='enabled' ng-cloak>
                <label for="username3g"><? print(lang('USERNAME','network3g')) ?></label>
                <input type="text" class="form-control" id="username3g" ng-model="username3g" aria-describedby="buserHelp" placeholder="<? print(lang('USERNAME_HELP','network3g')) ?>">
                <small id="buserHelp" class="form-text text-muted"><? print(lang('USERNAME_HELP','network3g')) ?></small>
            </div>  
            <div class="form-group" ng-show='enabled' ng-cloak>
                <label for="password3g"><? print(lang('PASSWORD','network3g')) ?></label>
                <input type="text" class="form-control" id="password3g" ng-model="password3g" aria-describedby="userHelp" placeholder="<? print(lang('PASSWORD_HELP','network3g')) ?>">
                <small id="sntpHelp" class="form-text text-muted"><? print(lang('PASSWORD_HELP','network3g')) ?></small>
            </div>
		    <div class="form-group" ng-show='enabled' ng-cloak>
                <label for="mtu"><? print(lang('MTU','network3g')) ?></label>
                <input type="text" class="form-control" id="mtu" size='4' integer minval="100" maxval="1200" ng-model="mtu" aria-describedby="buserHelp" placeholder="<? print(lang('MTU_HELP','network3g')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.mtu.$invalid"><strong><? print(lang('MTU_INVALID','network')) ?></strong></div>
                <small id="buserHelp" class="form-text text-muted"><? print(lang('MTU_HELP','network3g')) ?></small>
            </div>        
            <div class="form-group" ng-show='enabled' ng-cloak>
                <label for="mtu"><? print(lang('INTERVAL','network3g')) ?></label>
                <input type="text" class="form-control" id="packet_interval" size='4' integer minval="0" maxval="1200" ng-model="packet_interval" aria-describedby="buserHelp" placeholder="<? print(lang('INTERVAL_HELP','network3g')) ?>">
                <div ng-cloak class='small text-danger' ng-show="form.packet_interval.$invalid"><strong><? print(lang('INTERVAL_INVALID','network')) ?></strong></div>
                <small id="buserHelp" class="form-text text-muted"><? print(lang('INTERVAL_HELP','network3g')) ?></small>
            </div>      
		</p>
	</div>
</div>
 
</form>
<script type='text/javascript'>
var app = angular.module('myApp', []);

/**
* Network controller object used by Angular.JS
* @param $scope Application scope
* @param $http  HTTP object used for ajax requests
*/
function NetworkCtrl($scope,$http) {
    var self = this;
    $scope.infomsg="";
<?    
    if ($_GET['reboot']) {
      ?> $scope.infomsg="USB Device has been restarted.  Please wait while it reconnects.";<?  
    } 
    ?>
       $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
    
 $scope.isChecked=function(invert) {
    if (!invert) {
        if (Number($scope.enabled)) return 'checked';
        return 'unchecked';
   } else {
       if (!Number($scope.enabled)) return 'checked';
        return 'unchecked';
   }
   }
    /**
    * Posts settings to networksave.cgi and processes the response
    */
    $scope.saveSettings=function () {
        $scope.successmsg="";
        $scope.errormsg="";
        $scope.infomsg="";
        $http.post('/app/configsave.cgi?config=3g.ini&section=3g',"enabled="+$scope.enabled+"&dial="+$scope.dial+"&apn="+$scope.apn+"&mode="+$scope.mode+"&username="+$scope.username3g+"&password="+$scope.password3g+"&mtu="+$scope.mtu+"&packet_interval="+$scope.packet_interval)
        .then(function (response) {
          var data = response.data;      
          $scope.successmsg=(data.status==1)?"Saved Settings":"";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });

    }
}
</script>
<? include("/app/footer.inc"); ?>      


