<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : roleedit.cgi
 * 
 *  Description: Role edit page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013-14 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       18/12/13    v1.0
 *			03/11/14    v1.1 - added role type 'global var'
 *			23/01/15	added role type 'watts'
 *			28/01/16	updated to solve out of memory error for larger device lists
 *          21/06/18    WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="RoleEditCtrl"; 
$title=lang('CONFIGURE_ROLES','roleedit');
include("/app/header.inc");
?>
<?
  
  $role_id=$_GET['role_idx'];
  if (!$role_id) $role_id=-1;
  
  $info_ini="/dev/dev"+$arr['device_type_id']+".ini";
  $info_section="config";
  $role_ini="/config/roles.ini";
  $role_section="roles";
  
  $num_logs=ini_get("/config/datalog.ini","data",'num_groups',0);
  $logged_roles=array();
  $role_logs=array();
  for ($i=0;$i<$num_logs;$i++) {
      $num_items=ini_get("/config/datalog.ini","data",'group'.$i.'numvar',0);
      $role_logs[$i]=ini_get("/config/datalog.ini","data",'group'.$i.'name','');
      for ($item=0;$item<$num_items;$item++) {
         $vartype=ini_get("/config/datalog.ini","data",'group'.$i.'var'.$item.'vartype',0);;
         //print($vartype);
         if ($vartype==2) {
             if ($role_id==ini_get("/config/datalog.ini","data",'group'.$i.'var'.$item.'varval',0)) {
                 $role_logged=1;
                 $logged_roles[]=$i;
                 $role_log_idx=$i;
             };
         }
      }
  }
  if (sizeof($logged_roles))
    $role_log_idx=implode($logged_roles,',');
  else $role_log_idx='';
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/roles.cgi"><? print(lang('ROLES','roleedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('CONFIGURE_ROLES','roleedit')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','roleedit')) ?> <? print(ini_get($role_ini,$role_section,'role'.$role_id,'New Role')); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('CLOSE','roleedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/roles.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','roleedit')) ?></a>
  </li>
  <li ng-hide='settings_locked'  class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','roleedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','roleedit')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','roleedit')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>
<!-- VARIABLES -->

<div ng-init="role_id=<? print($role_id); ?>;"></div>
<div ng-init="role_name='<? print(ini_get($role_ini,$role_section,'role'.$role_id,'Role'+$role_id)); ?>';"></div>
<div ng-init="role_group=<? print(ini_get($role_ini,$role_section,'role'.$role_id+"group",0)); ?>;"></div>
<div ng-init="role_type=<? print(ini_get($role_ini,$role_section,'role'.$role_id+"type",0)); ?>;"></div>
<div ng-init="role_def=<? print(ini_get($role_ini,$role_section,'role'.$role_id+"def",0)); ?>;"></div>
<div ng-init="role_show=<? print(ini_get($role_ini,$role_section,'role'.$role_id+"show",0)); ?>;"></div>
<div ng-init="role_devices='<? print(ini_get($role_ini,$role_section,'role'.$role_id+"ids",0)); ?>';"></div>
            
<div ng-init="role_logged=<? print($role_logged); ?>;"></div>
<div ng-init="role_log_idx='<? print($role_log_idx); ?>';"></div>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ROLE_TITLE','roleedit')) ?></h5>
        <p class="card-text">    
        
            <div class="form-group">
                <label for="role_id"><? print(lang('ROLE_ID','roleedit')) ?></label>
                <input class="form-control" type='number' ng-model="role_id"  class='span12' name='role_id' required integer aria-describedby="rHelp" placeholder="<? print(lang('ROLE_ID','roleedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('ROLE_ID_HELP','roleedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.role_id.$invalid"><? print(lang('ROLE_ID_INVALID','roleedit')) ?></small>
            </div>
	        <div class="form-group">
                <label for="device_name"><? print(lang('ROLE_NAME','roleedit')) ?></label>
                <input type="text" class="form-control" ng-model="role_name"  class='span12' ng-maxlength=30 name='role_name' required aria-describedby="rnHelp" my-directive placeholder="<? print(lang('ROLE_NAME','roleedit')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('ROLE_NAME_HELP','roleedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.role_name.$invalid"><? print(lang('ROLE_NAME_INVALID','roleedit')) ?></small>
            </div>	        
            <div class="form-group">
                <label for="status"><small class='text-muted'><? print(lang('ROLE_SHOW','roleedit')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="role_show" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('NO','roleedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="role_show" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('YES','roleedit')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('ROLE_SHOW_HELP','roleedit')) ?></small>
            </div>            
            <div class="form-group">
                <label for="role_group"><? print(lang('GROUP_ID','roleedit')) ?></label>
                <select ng-model="role_group" name='role_group' class="form-control" ng-options='c.id as c.name for c in groups'></select>
                <small id="dgHelp" class="form-text text-muted"><? print(lang('GROUP_ID_HELP','roleedit')) ?></small>
            </div>   
            <div class="form-group">
                <label for="bus"><? print(lang('ROLE_TYPE','roleedit')) ?></label>
                <select ng-model="role_type" name='role_type' class="form-control">
			                <option value='0'>Modbus: <? print(lang('DIGITAL_OUTPUT','roleedit')) ?></option>
                            <option value='1'>Modbus: <? print(lang('DIGITAL_INPUT','roleedit')) ?></option>
                            <option value='2'>Modbus: <? print(lang('READ_ONLY','roleedit')) ?></option>
                            <option value='3'>Modbus: <? print(lang('READ_WRITE','roleedit')) ?></option>
                            <option value='4'>1-Wire: <? print(lang('ONEWIRE','roleedit')) ?></option>
                            <option value='5'><? print(lang('GLOBAL','roleedit')) ?></option>
                </select>
                <small class="form-text text-muted"><? print(lang('ROLE_TYPE_HELP','roleedit')) ?></small>
	        </div>
	        <div class="form-group" ng-show='role_type==3 || role_type==2 || role_type==5' ng-cloak>
                <label for="role_def"><? print(lang('ROLE_DEF','roleedit')) ?></label>
                <select ng-model="role_def" name='role_def' class="form-control">
	                <option value='0'>Value</option>
                    <option value='1'>Current</option>
                    <option value='2'>Voltage</option>
                    <option value='3'>Temperature</option>
                    <option value='4'>Pressure</option>
                    <option value='5'>Flow Rate</option>
                    <option value='6'>Wind Speed</option>
                    <option value='7'>Watts</option>
                    <option value='8'>Kilowatts</option>
                </select>
                <small class="form-text text-muted"><? print(lang('ROLE_DEF_HELP','roleedit')) ?></small>
	        </div>
            <div class="form-group" ng-show='role_type==0' ng-cloak>
                <label for="role_def"><? print(lang('ROLE_DEF','roleedit')) ?></label>
                <select ng-model="role_def" name='role_def' class="form-control">
	                <option value='0'>Value</option>
                    <option value='1'>Control output</option>
                </select>
                <small class="form-text text-muted"><? print(lang('ROLE_DEF_HELP','roleedit')) ?></small>
	        </div>
	        <div class="form-group" ng-show='role_id>0' ng-cloak>
                <label for="role_logged"><small class='text-muted'><? print(lang('ROLE_LOGGED','roleedit')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="role_logged" id="exampleRadios3" value="0">
                  <label class="form-check-label" for="exampleRadios3">
                    &nbsp;<? print(lang('NO','roleedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="role_logged" id="exampleRadios4" value="1">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;<? print(lang('YES','roleedit')) ?>
                  </label>
                </div>  
                <small class="form-text text-muted"><? print(lang('ROLE_LOGGED_HELP','roleedit')) ?></small>
            </div> 
            <div class="form-group" ng-show='role_logged==1' ng-cloak>
                <label for="role_log_idx"><? print(lang('ROLE_LOG_IDX','roleedit')) ?></label>
                <select ng-model="role_log_idx"  class='form-control' name='role_log_idx' multiple>
			                <? for ($i=0;$i<sizeof($role_logs);$i++) {
			                    print("<option value='".$i."'>".$role_logs[$i]."</option>");
			                } ?>
                </select>
                <small class="form-text text-muted"><? print(lang('ROLE_LOG_IDX_HELP','roleedit')) ?></small>
	        </div>
        </p>
    </div>
</div>
<br/>
<div class="card" ng-show='role_type<4' ng-cloak>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ROLE_DEVICES','roleedit')) ?></h5>
        <h6 class="card-subtitle mb-2 text-muted"><? print(lang('ROLE_DEVICES_SUBTITLE','roleedit')) ?></h6>
        <p class="card-text">    
            <div style='float:right'><a name='addact'></a><button class="btn btn-large" ng-click="devices.push({edit:1})"><? print(lang('ADD','roleedit')) ?></button></div>
 
            <table class='table table-striped' summary="Actions">
            <tr>
            <th scope="col"></th>
            <th scope="col">ID</th>
            <th scope="col">Device</th>
            <th scope="col">Options</th>
            </tr>
            <tr ng-repeat="item in devices">
                <td><a name='dev{{$index}}'></a></td>
                <td><span class="badge badge-inverse">{{$index+1}}</span></td>
                <td><strong>{{makeDevice(item)}}</strong><div ng-show='item.edit==1'>
                    <select class='span12' ng-model="item.device_id" ng-options='c.id as c.name for c in dev_names'>>
                    
                </select>
                    </div></td>            
                <td>
                    <div class="pull-right btn-group">
                        <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">Action <span class="caret"></span></a>
                        <ul class="dropdown-menu dropdown-menu-right">
                            <!-- dropdown menu links -->
                            <li class="dropdown-item" ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#act{{$index}}'><i class="icon-pencil"></i> <? print(lang('EDIT','roleedit')) ?></a></li>
                            <li class="dropdown-item" ng-show='item.edit==1'><a ng-click='stopEdit($index)' href='#act{{$index}}'><i class="icon-pencil"></i> <? print(lang('STOP_EDIT','roleedit')) ?></a></li>
                            <li class="dropdown-item" ng-show='$index>0'><a ng-click='moveUp(actions,$index)' href='#act{{$index}}'><i class="icon-up"></i> <? print(lang('MOVE_UP','roleedit')) ?></a></li>
                            <li class="dropdown-item" ng-show='$index<actions.length-1'><a ng-click='moveDown(actions,$index)' href='#act{{$index}}'><i class="icon-down"></i> <? print(lang('MOVE_DOWN','roleedit')) ?></a></li>
                            <li class="dropdown-item" ><a ng-click='deleteDevice($index)' href='#addact'><i class="icon-remove"></i> <? print(lang('DELETE','roleedit')) ?></a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            </table>
        </p>
    </div>
</div>
 </form>
<script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/role_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});

app.directive('myDirective', function() {
  return {
    require: 'ngModel',
    link: function(scope, element, attr, mCtrl) {
      function myValidation(value) {
        console.log(value);
        
        var regex = /^[0-9a-zA-Z\_\-\ ]+$/;
        if(regex.test(value) == false){
            mCtrl.$setValidity('charE', false);
          
        } else {
            mCtrl.$setValidity('charE', true);
        }
        return value;
      }
      mCtrl.$parsers.push(myValidation);
    }
  };
});

function RoleEditCtrl(dataService,$scope, $timeout,$http) {
  var self = this;
  $scope.infomsg="";
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
  
  $scope.dev_names=[<?
 $curdir=getcwd();
 chdir("/dev/");  
 $arr=findfirst("*.ini",255-8);
 $dev_arr=array();
 while ($arr) {
    $devname=ini_get('/dev/'.$arr['filename'],'config','name');
    $devtype=ini_get('/dev/'.$arr['filename'],'config','device_type_id');
    if ($devtype>0) {
        //print("<option value='".$devtype."'>".$devname." (".$devtype.")</option>\r\n");
        print("{id:".$devtype.',name:"'. $devname . " (" . $devtype . ")\"},");

        //$da=array($devtype,$devname);
        //$dev_arr[]=$da;
   }
    $arr=findnext();
}


  ?>];
  $scope.devices=[<?
   $st=ini_get($role_ini,$role_section,'role'.$role_id+"ids","0");
   if ($st!="0") {
    $arr=explode($st,",");
   //print_r($arr);
    for ($i=0;$i<sizeof($arr);$i++) {
        print("{id:".$i.',device_id:'.$arr[$i]."},");
        //if ($i<sizeof($arr)-1) print(",");
    }
   }
    ?>];
    $scope.groups=[<?
   $ng=ini_get("/config/groups.ini","groups","num_groups",0);
   //print_r($arr);
   
   for ($i=0;$i<$ng;$i++) {
        print("{id:".$i.',name:"'.ini_get("/config/groups.ini","groups","group".$i,"undefined")."\"},");
        //if ($i<sizeof($arr)-1) print(",");
   }
    ?>];
   $scope.getClass=function() {
    if ($scope.form.$invalid) return "disabled";
    return "";
  }
   function swapElement(array, indexA, indexB) {
     var tmp = array[indexA];
    array[indexA] = array[indexB];
    array[indexB] = tmp;
  }
  $scope.moveUp=function(arr,idx) {
     if (idx>0)
        swapElement(arr,idx-1,idx);
  }
  $scope.moveDown=function(arr,idx) {
     if (idx<arr.length-1)
        swapElement(arr,idx,idx+1);
  } 
  $scope.stopEdit = function ( idx ) {
    devid=$scope.devices[idx].device_id;
    for (ai=0;ai<$scope.devices.length;ai++) {
       if (idx!=ai && ($scope.devices[ai].device_id==devid)) {
         alert("This device is already in the list!");
         return 0;
       } 
    }
    $scope.devices[idx].edit=0;
    return 1;
  }
  $scope.deleteDevice = function ( idx ) {
      var person_to_delete = $scope.devices[idx];

    //API.DeleteAction({ id: person_to_delete.id }, function (success) {
        $scope.devices.splice(idx, 1);
    //});
  };
    $scope.makeDevice=function(item) {
        for (i=0;i<$scope.dev_names.length;i++)
          if ($scope.dev_names[i].id==item.device_id)
            return $scope.dev_names[i].name;
        return item.device_id;
    }
  $scope.saveAsNew=function () {
    $scope.role_id=-1;
    $scope.saveSettings();
  }
  $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      $scope.loading=1;
      $scope.role_devices="";
      if ($scope.form.$invalid) return;
      for (i=0;i<$scope.devices.length;i++) {
         if ($scope.devices[i].edit) 
            if (!$scope.stopEdit(i)) {
                return;
            }
        $scope.role_devices+=$scope.devices[i].device_id;
        if (i<$scope.devices.length-1)  $scope.role_devices+=",";
      }
      if (($scope.role_id>=0) && ($scope.role_log_idx.length) && ($scope.role_logged==0)) {
        alert("You cannot remove a role from the csv log from here.  This will not be modified.  To remove the role go to Control Panel > Data Collection");
      }
      //alert($scope.role_log_idx);
      role_url='/app/role_ajax.cgi?action=save&role_id='+$scope.role_id;
      role_params="role_name="+$scope.role_name+"&role_def="+$scope.role_def+"&role_type="+$scope.role_type+"&role_show="+$scope.role_show+"&role_group="+$scope.role_group+"&role_devices="+$scope.role_devices;
      role_params+="&role_logged="+$scope.role_logged+"&role_log_idx="+$scope.role_log_idx;
      //alert(role_params);
      //return;
      $http.post(role_url,role_params)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          $scope.loading=0;
          if (data.status)
            $scope.successmsg="Settings saved. You will need to reboot for changes to take effect";
            if ($scope.role_id==-1)
                document.location='/app/roles.cgi';
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            $scope.loading=0;
            //alert('Failed: ' + reason);
           
        });
   }

}


</script>
<? include("/app/footer.inc"); ?>      

