<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : snmp.cgi
 * 
 *  Description: User settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013-2020 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       22/10/20    v1.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="SNMPCtrl"; 
$title=lang('SNMP_SETTINGS','snmp');
include("/app/header.inc");
print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('SNMP_SETTINGS','snmp')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> <? print(lang('SNMP_SETTINGS','snmp')) ?></h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked'  ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <h4><? print(lang('SNMP_TITLE','snmp')) ?></h4><? print(lang('SNMP_DESC','snmp')) ?><br>
<? print(lang('SNMP_DESC2','snmp')); ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<!-- VARIABLES -->
<? 
  // Variabe Initialization
  $enabled=ini_get("/config/snmp.ini","config","enabled",0);
  $read_community=ini_get("/config/snmp.ini","config","read_community","public");
  $write_community=ini_get("/config/snmp.ini","config","write_community","private");
  
  $trap_enabled=ini_get("/config/snmp.ini","config","trap_enabled",0);
  $trap_community=ini_get("/config/snmp.ini","config","trap_community","private");
  $trap_ip=ini_get("/config/snmp.ini","config","trap_ip","0.0.0.0");
  $iparr=explode($trap_ip,".");
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print(lang('NEED_REBOOT')); ?>';"></div>
<div ng-init="read_community='<? print($read_community); ?>';"></div><div ng-init="write_community='<? print($write_community); ?>';"></div><div ng-init="trap_community='<? print($trap_community); ?>';"></div>
<div ng-init="enabled=<? print($enabled); ?>;"></div>
<div ng-init="trap_enabled=<? print($trap_enabled); ?>;"></div>
<div ng-init="ip1=<? print($iparr[0]); ?>;"></div><div ng-init="ip2=<? print($iparr[1]); ?>;"></div><div ng-init="ip3=<? print($iparr[2]); ?>;"></div><div ng-init="ip4=<? print($iparr[3]); ?>;"></div>

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('SNMP_TITLE','snmp')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
            <label for="enabled"><? print(lang('SNMP_STATUS','snmp')) ?></label>
            <select ng-model="enabled" name='enabled' class="custom-select custom-select-sm">
                <option value='0'><? print(lang('SNMP_DISABLED','snmp')) ?></option>
                <option value='1'><? print(lang('SNMP_ENABLED','snmp')) ?></option>
            </select>
            <small id="langH" class="form-text text-muted"><? print(lang('SNMP_STATUS_HELP','snmp')) ?></small>
          </div>
  
          <div class="form-group">
            <label for="read_community"><? print(lang('SNMP_READ','snmp')) ?></label>
            <input type="text" class="form-control" id="read_community" ng-model="read_community" aria-describedby="userHelp" placeholder="Read Community">
            <small id="userHelp" class="form-text text-muted"><? print(lang('SNMP_READ_HELP','snmp')) ?></small>
          </div>
          <div class="form-group">
            <label for="write_community"><? print(lang('SNMP_WRITE','snmp')) ?></label>
            <input type="text" class="form-control" ng_model="write_community" id="write_community" placeholder="Write Community">
            <small id="userHelp" class="form-text text-muted"><? print(lang('SNMP_WRITE_HELP','snmp')) ?></small>
          </div>
        </p>
    </div>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('SNMP_TRAP_TITLE','snmp')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
            <label for="trap_enabled"><? print(lang('SNMP_TRAP_STATUS','snmp')) ?></label>
            <select ng-model="trap_enabled" name='trap_enabled' class="custom-select custom-select-sm">
                <option value='0'><? print(lang('SNMP_DISABLED','snmp')) ?></option>
                <option value='1'><? print(lang('SNMP_ENABLED','snmp')) ?></option>
            </select>
            <small id="langH" class="form-text text-muted"><? print(lang('SNMP_TRAP_STATUS_HELP','snmp')) ?></small>
          </div>
  
          <div class="form-group">
            <label for="read_community"><? print(lang('SNMP_TRAP','snmp')) ?></label>
            <input type="text" class="form-control" id="trap_community" ng-model="trap_community" aria-describedby="userHelp" placeholder="Trap Community">
            <small id="userHelp" class="form-text text-muted"><? print(lang('SNMP_TRAP_HELP','snmp')) ?></small>
          </div>
          <div class="form-group">
                <label for="user_name"><? print(lang('SNMP_TRAP_IP','snmp')) ?></label>
                <div class="form-row" style='line-height:40px'>
                    <div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip1" name='ip1' min="1" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip2" name='ip2' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip3" name='ip3' min="0" max="254" integer required>
                    </div>.<div class="col-1">
                      <input class="form-control"size="3" type='number' ng-model="ip4" name='ip4' min="1" max="254" integer required>
                      
                    </div>
                    
              </div>
               <div ng-cloak class='small text-danger' ng-show="form.ip1.$invalid || form.ip2.$invalid || form.ip3.$invalid || form.ip4.$invalid"><strong><? print(lang('ERROR_TRAP_IP','snmp')) ?></strong></div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('SNMP_TRAP_IP_HELP','snmp')) ?></small>
          </div>
        </p>
    </div>
</div>


</form>
     <script>
     var app = angular.module('myApp', []);
     function SNMPCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   <? if ($_GLOBALS['VERMINOR']<1175) { ?>
   $scope.errormsg="This firmware version does not support SNMP";
   <? } ?>
       $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
       if (!$scope.read_community.length) {
            $scope.errormsg="<? print(lang('ERROR_READ_COMMUNITY','snmp')) ?>";
            return;
       }
       if (!$scope.write_community.length) {
            $scope.errormsg="<? print(lang('ERROR_WRITE_COMMUNITY','snmp')) ?>";
            return;
       }
       $scope.trap_ip=$scope.ip1+"."+$scope.ip2+"."+$scope.ip3+"."+$scope.ip4;
       if ($scope.trap_enabled) {
           if (!$scope.trap_community.length) {
                $scope.errormsg="<? print(lang('ERROR_TRAP_COMMUNITY','snmp')) ?>";
                return;
           }
           
       }
       
       $http.post('/app/configsave.cgi?config=snmp.ini&section=config',"trap_enabled="+$scope.trap_enabled+"&enabled="+$scope.enabled+"&read_community="+$scope.read_community+"&write_community="+$scope.write_community+"&trap_community="+$scope.trap_community+"&trap_ip="+$scope.trap_ip)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"<? print(lang('MSG_SAVED','user')) ?>":"<? print(lang('ERROR_SAVING','user')) ?>";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="<? print(lang('ERROR_SAVING','user')) ?>";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>



