<?

// registers
define('REG_FIFO',0x00);
define('REG_OP_MODE',              0x01);
define('REG_FRF_MSB',              0x06);
define('REG_FRF_MID',              0x07);
define('REG_FRF_LSB',              0x08);
define('REG_PA_CONFIG',            0x09);
define('REG_LNA',                  0x0c);
define('REG_FIFO_ADDR_PTR',        0x0d);
define('REG_FIFO_TX_BASE_ADDR',    0x0e);
define('REG_FIFO_RX_BASE_ADDR',    0x0f);
define('REG_FIFO_RX_CURRENT_ADDR', 0x10);
define('REG_IRQ_FLAGS',            0x12);
define('REG_RX_NB_BYTES',          0x13);
define('REG_PKT_RSSI_VALUE',       0x1a);
define('REG_PKT_SNR_VALUE',        0x1b);
define('REG_MODEM_CONFIG_1',       0x1d);
define('REG_MODEM_CONFIG_2',       0x1e);
define('REG_PREAMBLE_MSB',         0x20);
define('REG_PREAMBLE_LSB',        0x21);
define('REG_PAYLOAD_LENGTH',       0x22);
define('REG_MODEM_CONFIG_3',       0x26);
define('REG_RSSI_WIDEBAND',        0x2c);
define('REG_DETECTION_OPTIMIZE',   0x31);
define('REG_DETECTION_THRESHOLD',  0x37);
define('REG_SYNC_WORD',            0x39);
define('REG_DIO_MAPPING_1',        0x40);
define('REG_VERSION',              0x42);

// modes
define('MODE_LONG_RANGE_MODE',     0x80);
define('MODE_SLEEP',               0x00);
define('MODE_STDBY',               0x01);
define('MODE_TX',                  0x03);
define('MODE_RX_CONTINUOUS',       0x05);
define('MODE_RX_SINGLE',           0x06);

// PA config
define('PA_BOOST',                 0x80);
define('PA_OUTPUT_RFO_PIN',      0);
define('PA_OUTPUT_PA_BOOST_PIN',1);

// IRQ masks
define('IRQ_TX_DONE_MASK',           0x08);
define('IRQ_PAYLOAD_CRC_ERROR_MASK', 0x20);
define('IRQ_RX_DONE_MASK',           0x40);

define('MAX_PKT_LENGTH',           255);



function begin($frequency)
{
  spi_setcs(1);
  spi_clearcs(1);
/*  // perform reset
  digitalWrite(_reset, LOW);
  delay(10);
  digitalWrite(_reset, HIGH);
  delay(10);
*/
  // set SS high
  //setcs();

  // check version
  $version = readRegister(REG_VERSION);
  
  if ($version != 0x12) {
    print("nothing detected");
    return 0;
  }
  printf("Lora module detected: %X\r\n ".$version);
  // put in sleep mode
  lora_sleep();

  // set frequency
  setFrequency($frequency);

  // set base addresses
  writeRegister(REG_FIFO_TX_BASE_ADDR, 0);
  writeRegister(REG_FIFO_RX_BASE_ADDR, 0);

  // set LNA boost
  writeRegister(REG_LNA, readRegister(REG_LNA) | 0x03);

  // set auto AGC
  writeRegister(REG_MODEM_CONFIG_3, 0x04);

  // set output power to 17 dBm
  setTxPower(17);

  // put in standby mode
  idle();

  return 1;
}

function end()
{
  // put in sleep mode
  lora_sleep();

  // stop SPI
  //SPI.end();
}

function beginPacket($implicitHeader)
{
  // put in standby mode
  idle();

  if ($implicitHeader) {
    implicitHeaderMode();
  } else {
    explicitHeaderMode();
  }

  // reset FIFO address and paload length
  writeRegister(REG_FIFO_ADDR_PTR, 0);
  writeRegister(REG_PAYLOAD_LENGTH, 0);

  return 1;
}

function endPacket()
{
  // put in TX mode
  writeRegister(REG_OP_MODE, MODE_LONG_RANGE_MODE | MODE_TX);

  // wait for TX done
  while((readRegister(REG_IRQ_FLAGS) & IRQ_TX_DONE_MASK) == 0);

  // clear IRQ's
  writeRegister(REG_IRQ_FLAGS, IRQ_TX_DONE_MASK);

  return 1;
}

function parsePacket($size)
{
  global $_implicitHeaderMode;
  global $_packetIndex;
  //global $irqFlags;
  $packetLength = 0;
  $irqFlags = readRegister(REG_IRQ_FLAGS);

  if ($size > 0) {
    implicitHeaderMode();

    writeRegister(REG_PAYLOAD_LENGTH, $size & 0xff);
  } else {
    explicitHeaderMode();
  }

  // clear IRQ's
  writeRegister(REG_IRQ_FLAGS, $irqFlags);

  if ( ($irqFlags & 0x08) &&  // IRQ_RX_DONE_MASK
    ($irqFlags & 0x20 == 0)) { //IRQ_PAYLOAD_CRC_ERROR_MASK
    // received a packet
    $_packetIndex = 0;

    // read packet length
    if ($_implicitHeaderMode) {
      $packetLength = readRegister(REG_PAYLOAD_LENGTH);
    } else {
      $packetLength = readRegister(REG_RX_NB_BYTES);
    }

    // set FIFO address to current RX address
    writeRegister(REG_FIFO_ADDR_PTR, readRegister(REG_FIFO_RX_CURRENT_ADDR));

    // put in standby mode
    idle();
  } else if (readRegister(REG_OP_MODE) != (MODE_LONG_RANGE_MODE | MODE_RX_SINGLE)) {
    // not currently in RX mode

    // reset FIFO address
    writeRegister(REG_FIFO_ADDR_PTR, 0);

    // put in single RX mode
    writeRegister(REG_OP_MODE, MODE_LONG_RANGE_MODE | MODE_RX_SINGLE);
  }

  return $packetLength;
}

function packetRssi()
{
  global $_frequency;
  return (readRegister(REG_PKT_RSSI_VALUE) - ($_frequency < 868000000 ? 164 : 157));
}

function  packetSnr()
{
  return (readRegister(REG_PKT_SNR_VALUE)) * 0.25;
}

function write($byte)
{
  print($byte);
  return 1;
}

function lora_write($buffer, $size)
{
  $currentLength = readRegister(REG_PAYLOAD_LENGTH);

  // check size
  if (($currentLength + $size) > MAX_PKT_LENGTH) {
    $size = MAX_PKT_LENGTH - $currentLength;
  }

  // write data
  for ($i = 0; $i < $size; $i++) {
    writeRegister(REG_FIFO, $buffer[$i]);
  }

  // update length
  writeRegister(REG_PAYLOAD_LENGTH, $currentLength + $size);

  return $size;
}

function available()
{
 global $_packetIndex;
  return (readRegister(REG_RX_NB_BYTES) - $_packetIndex);
}

function lora_read()
{
  global $_packetIndex;
  if (!available()) {
    return -1;
  }

  $_packetIndex++;

  return readRegister(REG_FIFO);
}

function peek()
{
  if (!available()) {
    return -1;
  }

  // store current FIFO address
  $currentAddress = readRegister(REG_FIFO_ADDR_PTR);

  // read
  $b = readRegister(REG_FIFO);

  // restore FIFO address
  writeRegister(REG_FIFO_ADDR_PTR, $currentAddress);

  return $b;
}


function receive($size)
{
  if ($size > 0) {
    implicitHeaderMode();

    writeRegister(REG_PAYLOAD_LENGTH, $size & 0xff);
  } else {
    explicitHeaderMode();
  }

  writeRegister(REG_OP_MODE, MODE_LONG_RANGE_MODE | MODE_RX_CONTINUOUS);
}

function idle()
{
  writeRegister(REG_OP_MODE, MODE_LONG_RANGE_MODE | MODE_STDBY);
}

function lora_sleep()
{
  writeRegister(REG_OP_MODE, MODE_LONG_RANGE_MODE | MODE_SLEEP);
}

function setTxPower($level, $outputPin)
{
  if (PA_OUTPUT_RFO_PIN == $outputPin) {
    // RFO
    if ($level < 0) {
      $level = 0;
    } else if ($level > 14) {
      $level = 14;
    }

    writeRegister(REG_PA_CONFIG, 0x70 | $level);
  } else {
    // PA BOOST
    if ($level < 2) {
      $level = 2;
    } else if ($level > 17) {
      $level = 17;
    }

    writeRegister(REG_PA_CONFIG, PA_BOOST | ($level - 2));
  }
}

function setFrequency($frequency)
{
  global $_frequency;
  $_frequency = $frequency;

  $frf = ($frequency << 19) / 32000000;

  writeRegister(REG_FRF_MSB, ($frf >> 16) & 0xFF);
  writeRegister(REG_FRF_MID, ($frf >> 8) & 0xFF);
  writeRegister(REG_FRF_LSB, ($frf >> 0) & 0xFF);
}

function setSpreadingFactor($sf)
{
  if ($sf < 6) {
    $sf = 6;
  } else if ($sf > 12) {
    $sf = 12;
  }

  if ($sf == 6) {
    writeRegister(REG_DETECTION_OPTIMIZE, 0xc5);
    writeRegister(REG_DETECTION_THRESHOLD, 0x0c);
  } else {
    writeRegister(REG_DETECTION_OPTIMIZE, 0xc3);
    writeRegister(REG_DETECTION_THRESHOLD, 0x0a);
  }

  writeRegister(REG_MODEM_CONFIG_2, (readRegister(REG_MODEM_CONFIG_2) & 0x0f) | (($sf << 4) & 0xf0));
}

function setSignalBandwidth($sbw)
{
  $bw=0;

  if ($sbw <= 7800) {
    $bw = 0;
  } else if (sbw <= 10400) {
    $bw = 1;
  } else if (sbw <= 15600) {
    $bw = 2;
  } else if (sbw <= 20800) {
    $bw = 3;
  } else if (sbw <= 31250) {
    $bw = 4;
  } else if (sbw <= 41700) {
    $bw = 5;
  } else if (sbw <= 62500) {
    $bw = 6;
  } else if (sbw <= 125000) {
    $bw = 7;
  } else if (sbw <= 250000) {
    $bw = 8;
  } else /*if (sbw <= 250E3)*/ {
    $bw = 9;
  }

  writeRegister(REG_MODEM_CONFIG_1, (readRegister(REG_MODEM_CONFIG_1) & 0x0f) | ($bw << 4));
}

function setCodingRate4($denominator)
{
  if ($denominator < 5) {
    $denominator = 5;
  } else if ($denominator > 8) {
    $denominator = 8;
  }

  $cr = $denominator - 4;

  writeRegister(REG_MODEM_CONFIG_1, (readRegister(REG_MODEM_CONFIG_1) & 0xf1) | ($cr << 1));
}

function setPreambleLength($length)
{
  writeRegister(REG_PREAMBLE_MSB, ($length >> 8) & 0xFF);
  writeRegister(REG_PREAMBLE_LSB, ($length >> 0) & 0xff);
}

function setSyncWord($sw)
{
  writeRegister(REG_SYNC_WORD, $sw);
}

function crc()
{
  writeRegister(REG_MODEM_CONFIG_2, readRegister(REG_MODEM_CONFIG_2) | 0x04);
}

function noCrc()
{
  writeRegister(REG_MODEM_CONFIG_2, readRegister(REG_MODEM_CONFIG_2) & 0xfb);
}

function random()
{
  return readRegister(REG_RSSI_WIDEBAND);
}


function dumpRegisters()
{
  for ($i = 0; $i < 128; $i++) {
    printf("%X",$i);
    print(": ");
    printf("%X\r\n",readRegister($i));
  }
}

function explicitHeaderMode()
{
  global $_implicitHeaderMode;
  $_implicitHeaderMode = 0;

  writeRegister(REG_MODEM_CONFIG_1, readRegister(REG_MODEM_CONFIG_1) & 0xfe);
}

function implicitHeaderMode()
{
  global _implicitHeaderMode;
  $_implicitHeaderMode = 1;

  writeRegister(REG_MODEM_CONFIG_1, readRegister(REG_MODEM_CONFIG_1) | 0x01);
}

/*void LoRaClass::handleDio0Rise()
{
  global $irqFlags;
  global $_packetIndex;
  global $_implicitHeaderMode;
  $irqFlags = readRegister(REG_IRQ_FLAGS);

  // clear IRQ's
  writeRegister(REG_IRQ_FLAGS, $irqFlags);

  if (($irqFlags & IRQ_PAYLOAD_CRC_ERROR_MASK) == 0) {
    // received a packet
    $_packetIndex = 0;

    // read packet length
    $packetLength = $_implicitHeaderMode ? readRegister(REG_PAYLOAD_LENGTH) : readRegister(REG_RX_NB_BYTES);

    // set FIFO address to current RX address
    writeRegister(REG_FIFO_ADDR_PTR, readRegister(REG_FIFO_RX_CURRENT_ADDR));


    // reset FIFO address
    writeRegister(REG_FIFO_ADDR_PTR, 0);
  }
}*/

function readRegister($address)
{
  return singleTransfer($address & 0x7f, 0x00);
}

function writeRegister($address, $value)
{
  singleTransfer($address | 0x80, $value);
}

function singleTransfer($address, $value)
{
  $response=0;

//print("Singe Transfer ".$address." ".$value);
  spi_setcs(0);
  sleep(5);
  spi_write($address);
  $response=spi_read($value);
 
  spi_clearcs(1);
  return $response;
}

?>
