<pre><?
/*************************************************************************
*
*  TCP VARIABLE UPDATER
*
*  Usage:  Call this from crontab at an interval required
*  "	*   *   *   *   /examples/tcp/tcp_vars.cgi"
*  
* This will receive variables from the remote master over HTTP and update the $_GLOBALS
* 
* Protocol is <key=value><key2=value2> etc
* Author:  		Akash Heimlich
* Date: 		06/02/2018
* Revision:		1.0
*
*************************************************************************/

$debug = 1; // if you want debug messages in the log file set this to 1, else 0

// change this URL to where you wish to get the data

$url="http://wattmon.com/live/avlibrary.php";

$update_globals = 0;
$update_ini = 1;
$ini_file = "/config/schedule.ini";
$ini_category = 'schedule';

if (strtolower(substr($url,0,7))=='http://')
    $url=substr($url,7);
$p=strpos($url,'/');
$host=substr($url,0,$p);
$path=substr($url,$p);
if (strpos($host,':')) {
    $port=substr($host,strpos($host,':')+1,5);
    $host=substr($host,0,strpos($host,':'));
} else $port=80;
print($host." port ".$port);

$f=fsockopen($host,intval($port),10);

if ($f) {
    if ($debug) {
        log("[tcp_vars] Opened connected");
    }
    $mac=getmac();
    $out = "GET ".$path."?mac="+$mac+" HTTP/1.0\r\n"; 
    $out = $out."Host: ".$host." \r\n";
    $out = $out."Connection: Keep-Alive\r\n\r\n"; // Keep-Alive
    
    if ($debug) {
        print($out);
    }
    fwrite($f, $out);
    
    $done=0;
    $start=microtime();
    $done=0;
    $header_ok = 0;
    while (!$done) {
        $str=fgets($f);
        print("IN2: ".$str+"\r\n");
        if (strpos($str,"OK")>=0) {
            $header_ok=1;
       }
       if (strlen($str)==0) $done=1;
    }
    $len=filesize($f);
    print("Buf size=".$len);
    $in_key=0;
    $in_val=0;
    while ($len) {
    	$c=fread($f,1);
    	print($c);
    	$len--;
    	if (!$len) $len=filesize($f); // reload hopefully
    	if ($c=='<') {		// start of key/val pair
    		$in_key=1;
    		$in_val=0;
    		$key='';
    		$val='';
    	} else {
    
    		if ($c=='=') {		// start of key/val pair
    			$in_key=0;
    			$in_val=1;
    		} else {
    
    			if ($c=='>') {		// end of key/val pair
    				if (strlen($key) && $in_val) {
    				    if ($update_globals) {
        				    if (is_numeric($val)) {
        				        if (is_int($val)) {
        				            $_GLOBALS[$key]=intval($val);
        				        } else $_GLOBALS[$key]=floatval($val);
        				    } else {
        					    $_GLOBALS[$key]=$val;
        				    }
    				    } 
    				    if ($update_ini) {
    				        ini_set($ini_file,$ini_category,$key,$val);
    				    }
    					if ($debug) {
    						print("[debug] Add ".$key."=".$val."\r\n");
    						if ($debug) {
                               log("[tcp_vars] Add ".$key."=".$val);
                            }
    					}
    				}
    				$in_key=0;
    				$in_val=0;
    				$key='';
    				$val='';
    			} else {	// just a regular character
    				if ($in_key) $key.=$c;
    				if ($in_val) $val.=$c;
    			}
    		}
    	}
    } 
    
    
    fwrite($f,$st);
    fclose($f);
} else {
    if ($debug) {
        log("[tcp_vars] Failed to connect");
    }
}
?>

