<?
/**
 * @file http.inc
 * @author Akash Heimlich
 * @version 1.0
 * @date 24/04/2019
 * @description Common uPHP functions for HTTP and URL handling
 */
 
/**
  * URL encode a string
  *
  * Since uPHP does not have a urlencode() function, this function does the same and takes any string of characters
  * and returns a URL-encoded version of the string
  *
  * @param string $s String to encode
  *
  * @return string URL-Encoded version of the string
  */ 
function urlencode($s)
{
    $slen=strlen($s);
    $res='';
	for ($i=0; $i<$slen; $i++) {
	    $x=charat($s,$i); //"-", ".", "_", "~")
	    $c=chr($x);
	    if ((($c>='0') && ($c<='9')) || (($c>='A') && ($c<='Z')) || (($c>='a') && ($c<='z')) || ($c == '~') ||($c == '-') || ($c == '.') || ($c == '_')) {  
	        $res.=$c;
	    } else {
	        if ($c==' ') {
	            $res.="+";
	        } else {
	            $res.=sprintf("%%%02X",$x);
	        }
	    }
	}
	return $res;
}

/**
  * URL deccode a string
  *
  * Since uPHP does not have a urldecode() function, this function does the same and takes any string of characters
  * and returns a URL-decoded version of the string
  *
  * @param string $s String to decode
  *
  * @return string URL-Decoded version of the string
  */ 

function url_decode($input)
{
	$input_length = strlen($input);

	$output_length = ($input_length + 1) ;
	$working = '';
	$output = '';//working;
	
	$idx=0;
	while($idx<$input_length)
	{
	    $input_char=charat($input,$idx);
		if(chr($input_char) == '%')
		{
			$c1=charat($input,$idx+1);
			$c2=charat($input,$idx+2);
			$c1_chr=chr($c1);
			$c2_chr=chr($c2);
			$v = 0;
			if (($c1_chr>='0') && ($c1_chr<='9')) {
			    $v+= ($c1-ord('0')) * 16;
			}
			if (($c1_chr>='a') && ($c1_chr<='z')) {
			    $v+= ($c1-ord('a')+10) * 16;
			}
			if (($c1_chr>='A') && ($c1_chr<='Z')) {
			    $v+= ($c1-ord('A')+10) * 16;
			}
			if (($c2_chr>='0') && ($c2_chr<='9')) {
			    $v+= ($c2-ord('0')) ;
			}
			if (($c2_chr>='a') && ($c2_chr<='z')) {
			    $v+= ($c2-ord('a')+10) ;
			}
			if (($c2_chr>='A') && ($c2_chr<='Z')) {
			    $v+= ($c2-ord('A')+10) ;
			}
			
			$working.=chr($v); 
			$idx += 3;
		}
		else
		{
			$working.=chr($input_char);
			$idx++;
		}
	}

	
	return $working;
}

/**
  * Get HTTP headers for a socket connection
  *
  * This function will take care of the processing of HTTP headers and return type
  * for an open socket.  If the response code is not 200 (OK) then it will return a number
  * containing the response code. Otherwise, it will return an array with key-value pairs.
  *
  * @param socket $f An existing socket connection to a host, either over http or https
  *
  * @return number - status code on error
  *         array - key-value array of http headers
  */ 
function get_headers($f) {
    $headers=array();
    $done=0;
    $result_code=0;
    $cur_line='';
    $got_data=0;
    while (!$done) {
	    $str=fgets($f);
	    if ($str) {
	        $got_data=1;
	        // first line?
	        if (!sizeof($headers) && !$result_code) {
	            //HTTP/1.1 200 OK
	            
	            $result_code=intval(substr($str,9,3));  // get the HTTP Status code
	            if ($result_code!=200) 
	                return $result_code;
	        } else {
	            $cur_line.=$str;                        // add the line to the current line - some headers such as Accept will be longer than 254 characters which is the sting max
	            if (strlen($str)<254) {
	                $key = substr($cur_line,0,strpos($cur_line,':'));
	                $val = substr($cur_line,strpos($cur_line,':')+2);
	                $headers[$key]=$val;               // add this header line.
	                $cur_line='';
	            }
	        }
	    }
	    /*if ($str==-1) {
	        print("no more headers");
	        return -1;
	    }*/
	    if ($got_data && strlen($str)==0) $done=1;
    }
    return $headers;
}

/**
  * Get content of a specified length from a socket
  *
  * This can be used to return part or all of the content of an HTTP page.  It requires
  * an open socket.  It will return a string containing the data of $len
  *
  * @param socket $f An existing socket connection to a host, either over http or https
  * @param number $len Length of content to read
  *
  * @return string - Contents of stream data of $len bytes
  */ 
  
function get_content($f,$len) {

    $remaining = intval($len);
    $content='';
    $done=0;
    $unknown_len=0;
    if (!$len) {
        $unknown_len=1;
        debug_print("No content header found, reading till the end of the stream","content","red");
    }
    while (!filesize($f)) {
        print(".");
    }
    
    while (!$done) {
        if ($unknown_len || ($remaining>1024)) {
            $buf_size=1024; 
        } else {
            $buf_size=$remaining;
        }
        $timeout=microtime();
        while (!filesize($f)) {
            if (microtime()-$timeout>1000) break;
        }
        
        $data=fread($f,$buf_size);
        $data_len = strlen($data);
        if ($data_len>0) {     // some data received
            //debug_print($data,"content","green");
            debug_print("Len=".$data_len,"host","blue");
            if (is_string($data))
                $content.=$data;
            $data='';
            if (!$unknown_len) {
                $remaining -= $data_len;
            }
        } else {
            if ($unknown_len) {
                if (!filesize($f)) {
                    $done=1;
                     debug_print("Returning, EOF","content","red");
                }
            }
        }
        if (!$unknown_len && $remaining<=0) $done=1;
    }
    //print("---".$content."--\r\n");
    return $content;
}


function get_json($url,$headers) {
    
    debug_start();
    if (strtolower(substr($url, 0, 7)) == 'http://')
        $url = substr($url, 7);
    if (strtolower(substr($url, 0, 8)) == 'https://') {
        $url = substr($url, 8,strlen($url));
        $secure=1;
    }
    $p    = strpos($url, '/');
    $host = substr($url, 0, $p);
    $path = substr($url, $p);
    if (strpos($host, ':')) {
        $port = substr($host, strpos($host, ':') + 1, 5);
        $host = substr($host, 0, strpos($host, ':'));
    } else {
        if ($secure) $port=443;
        else $port = 80;
    }
    
    $f = fsockopen($host, intval($port), 10);
    debug_print($host,"host","green");
    if ($f) {
        
        $out = "GET " . $path . " HTTP/1.0\r\n"; 
        $out = $out . "Host: " . $host . " \r\n";
        $out = $out . "Connection: Keep-Alive\r\n"; // Keep-Alive
        if (is_array($headers)) {
            for ($i=0;$i<sizeof($headers);$i++) {
                $k = array_key($headers,$i);
                $out.=$k.": ".$headers[$k]."\r\n";
            }
        }
        $out.="\r\n";
        debug_print($out,"request","blue");
        fwrite($f, $out);
        
        $response_headers=get_headers($f);
        //print_r($response_headers);
        if (is_array($response_headers)) {
            $data=get_content($f,intval($response_headers['Content-Length']));
            fclose($f);
            //debug_print($data,"response","green");
            return json_decode($data);
            //print($data);
        } else {
            fclose($f);
            return $response_headers;
        }

    } else return 0;
}

function http_post_file($url,$fn) {
    $dir='/';
    if (strrpos($fn,'/')>0) {
        $dir=substr($fn,0,strrpos($fn,'/')+1);
        $fn=substr($fn,strrpos($fn,'/')+1);
        debug_print("dir=".$dir." fn=".$fn);
    }
    
    
    if (strtolower(substr($url, 0, 7)) == 'http://')
        $url = substr($url, 7);
    if (strtolower(substr($url, 0, 8)) == 'https://') {
        $url = substr($url, 8,strlen($url));
        $secure=1;
    }
    debug_print("url=".$url);    
    $p    = strpos($url, '/');
    debug_print($p);
    $host = substr($url, 0, $p);
    $path = substr($url, $p);
    if (strpos($host, ':')) {
        $port = substr($host, strpos($host, ':') + 1, 5);
        $host = substr($host, 0, strpos($host, ':'));
    } else {
        if ($secure) $port=443;
        else $port = 80;
    }
    debug_print($host . " port " . $port);
    debug_print("path = ".$path);
    debug_print("dir.fn = ".$dir.$fn);        
    $content1="--a30637183627211514542440074414\r\n"+"Content-Disposition: form-data; name=\"file\"; filename=\"".$fn."\"\r\n"+
            "Content-Type: application/octet-stream\r\n"+
            "Content-Transfer-Encoding: binary\r\n\r\n";


    $data_len=filesize($dir.$fn);

    $content2="\r\n\r\n--a30637183627211514542440074414--\r\n";

    $str="POST ".$path." HTTP/1.1\r\nHost: ".$host."\r\nConnection: keep-alive\r\nContent-Length: ".($data_len+strlen($content1)+strlen($content2));
    $str.="\r\nCache-Control: max-age=0\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8\r\n"+
        "Content-Type: multipart/form-data; boundary=a30637183627211514542440074414\r\n"+
        "Accept-Language: en,en-US;q=0.8,tr;q=0.6\r\n\r\n";

    $f = fsockopen($host, intval($port), 10);
    
    if ($f) {
        fwrite($f,$str);
        fwrite($f,$content1);
        $d=fopen($dir.$fn,"r");
        while (!feof($d)) {
            $old_pos=ftell($d);
            $data=fread($d,512);
            $size=ftell($d)-$old_pos;
            fwrite($f,&$data,$size);
            print(".");
        }
        fwrite($f,$content2);
        
        $res = get_headers($f);
        
        if (!is_array($res)) 
            return $res;
            
        $res=get_content($f,$res['Content-Length']);
        
        fclose($f);
        return $res;
    } else return 0;
}

?>
