<?
/**
 * @file system.inc
 * @author Akash Heimlich
 * @version 1.0
 * @date 07/04/2021
 * @description System integration functions
 */
 
/**
  * Add a role
  *
  * Add a role to the system roles, or modify an existing role based on it's role ID.
  *
  * @param int $id Role ID to edit or -1 to add a new role
  * @param string $role_name Role name
  * @param int $role_group Option group id for the role or 0 if not required
  * @param int $role_type Type of the role
  *             Role Type  | Description
  *             -----------------------
  *             0           Digital Output
  *             1           Digital Input
  *             2           Read Only Register (Modbus)
  *             3           Read Write Register (Modbus)
  *             4           OneWire Sensor role
  *             5           Global Variable (name of the role is the variable name)
  *
  * @param int $role_show - Show (1) or Hide (0) the role where appropriate
  * @param int $role_def - Role definition if appropriate
  *             Role Def    |   Description
  *             0               Value (no processing)
  *             1               Current
  *             2               Voltage
  *             3               Temperature
  *             4               Pressure
  *             5               Flow Rate
  *             6               Wind Speed
  *             7               Watts
  *             8               Kilowatts
  * @param string $role_devices - comma separated list of device type IDs that this role can be linked to
  * @return none
  */ 
function add_role($id, $role_name, $role_group, $role_type, $role_show, $role_def, $role_devices) {
    if ($id==-1)  {
        $num_r=ini_get("/config/roles.ini","roles","num_roles",0);
        for ($j=0;$j<$num_r;$j++) { 
            if ($role_name==ini_get("/config/roles.ini","roles","role"+$j,'')) {
                break;
            }
        }
        $id=$j;
        if ($id==$num_r)  {
            ini_set("/config/roles.ini","roles","num_roles",$id+1);
            $f=fopen("/config/roles.ini",'a+');
            $st="role"+$id+"=".$role_name."\r\n".
                "role"+$id+"group=".$role_group."\r\n".
                "role"+$id+"type=".$role_type."\r\n".
                "role"+$id+"ids=".$role_devices."\r\n".
                "role"+$id+"def=".$role_def."\r\n".
                "role"+$id+"show=".$role_show."\r\n";
            fwrite($f,$st);
            fclose($f);
        }
            
    } else {
        if (ini_get("/config/roles.ini","roles","role"+$id)!=$role_name)
                    ini_set("/config/roles.ini","roles","role"+$id,$role_name);
        if (ini_get("/config/roles.ini","roles","role"+$id+"group")!=$role_group)                    
                    ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
        if (ini_get("/config/roles.ini","roles","role"+$id+"type")!=$role_type)                                        
                    ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
        if (ini_get("/config/roles.ini","roles","role"+$id+"ids")!=$role_devices)                                            
                    ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
        if (ini_get("/config/roles.ini","roles","role"+$id+"def")!=$role_def)                                        
                    ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
        if (ini_get("/config/roles.ini","roles","role"+$id+"show",0)!=$role_show)                                        
                    ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);
    }
}

/**
  * Add CRON script
  *
  * Add a script to be executed by the CRON scheduler
  *
  * @param string $fn - full path with filename to be added
  * @param string $interval - CRON-compatible interval using the following format
  *             second  minute   hour    dow
  *             
  *             Field       Description
  *             second      execution second, can be * (every second), * /x (i.e. * /5 for every 5 seconds), or any number between 0 and 59
  *             minute      execution minute, can be * (every minute), * /x (i.e. * /15 for every 15 minutes), or any number between 0 and 59
  *             hour        execution hour, can be * (every hour), * /x (i.e. * /2 for every 2 hours), or any number between 0 and 23
  *             dow         execution day of the week, can be * (every day), or a value 0-6 (sunday to monday)
  *             For example: "*  0   *   *"  would execute the script once an hour
  * @return int - 1 if the script was added to the schedule or 0 if it was not added (i.e. already there)
  */

function add_cron($fn, $interval) {
    $f=fopen("/config/crontab.txt","r");
    $found=0;
    while (!feof($f)) {
        $st=fgets($f);
        if (strpos($st,$fn)) {
            $found=1;
        }
    }
    fclose($f);
    if (!$found) {
        $f=fopen("/config/crontab.txt","a");
		fseek($f,0);
		$fpos=0;
		while (fgets($f)) {
			$fpos=ftell($f);
		}
		fseek($f,$fpos);
        fwrite($f,$interval." ".$fn."\r\n");
        fclose($f);
        log("Added ".$fn." to crontab");
        return 1;
    }
    return 0;
}

/**
  * Remove CRON script
  *
  * Remove a script from the CRON scheduler
  *
  * @param string $fn - full path with filename to be added
  * @return int - 0 if $fn was not found in the crontab, or 1 if it was removed
  **/
function remove_cron($fn) {
    $f=fopen("/config/crontab.txt","r");
    $f_out=fopen("/config/crontab.tmp","w+");
    $found=0;
    while (!feof($f)) {
        $st=fgets($f);
        
        if (strpos($st,$fn)<0) {
            fwrite($f_out,$st."\r\n");
        } else $found=1;
    }
    fclose($f_out);
    fclose($f);
    
    if ($found) {
        unlink("/config/crontab.txt");
        rename("/config/crontab.tmp","/config/crontab.txt");
        log("Removed ".$fn." from crontab");
        return 1;
    }
    //unlink("/config/crontab.tmp");
    return 0;
}

?>

