<?
/**
 * @package Devices
 * @author Akash Heimlich
 * @description This shows inverters, power meters and other sensors in an easy-to-understand interface
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Devices_install($val) {
        Devices_enable();
        return 1;
    }
     
    function Devices_uninstall() {
        setPackageStatus("Devices",0);
        return 1;
    }
    
    function Devices_enable() {
        setPackageStatus("Devices",2);
        addWidget("/package/Devices.inc","Devices",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function Devices_disable() {
        setPackageStatus("Devices",3);
        addWidget("/package/Devices.inc","Devices",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function Devices_init() {
        
        // generate ajax data for front end processing
        if (file_exists('/package/DevicesAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/DevicesAjax.inc';

        // runs this file once a second
        if (file_exists('/package/DevicesSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/DevicesSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/DevicesMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/DevicesMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/DevicesDay.inc')) 
            $_GLOBALS['hooks']['day'][]='/package/DevicesDay.inc';            
            
        $num_devices=mb_num_devices();    
        $_GLOBALS['d_inverter']=array();
        $_GLOBALS['d_meter']=array();
        $_GLOBALS['d_sensor']=array();
        print("<pre>");
        for ($i=0;$i < $num_devices;$i++) {
            $dev=mb_get_dev_by_index($i);
            // if this is not a wattmon device (pro, mini, mega, etc)
            $rec=array();
            $rec['index']=$i;
            
            if ($dev['device_type_id']>1000) {
                $arr=ini_get_array('/dev/dev'.$dev['device_type_id'].".ini",'config');
                $rec['name']=$arr['name'];
               // print_r($arr);
                if ($dev['category']==0) {      // inverters
                    for ($r=0;$r<$dev['num_roles'];$r++) {
                        
                        $rv=strval($arr['role_var_'.$r]);
                       // print("checking role .".$rv."\r\n");
                        if ($rv=='Status_Code') 
                            $rec['Status_Code'] = $r;
                        if ($rv=='Event_Code') 
                            $rec['Event_Code'] = $r;    
                        if ($rv=='AC_Active_Power') 
                            $rec['AC_Active_Power'] = $r;
                        if ($rv=='kWh_Total_Active') 
                            $rec['kWh_Total_Active'] = $r;        
                    }
                    $_GLOBALS['d_inverter'][]=$rec;
                };
                if ($dev['category']==1) {      // energy meters
                    for ($r=0;$r<$dev['num_roles'];$r++) {
                        
                        $rv=strval($arr['role_var_'.$r]);
                        if ($rv=='AC_Active_Power') 
                            $rec['AC_Active_Power'] = $r;
                        if ($rv=='AC_Reactive_Power') 
                            $rec['AC_Reactive_Power'] = $r;
                        if ($rv=='kWh_Total_Active') 
                            $rec['kWh_Total_Active'] = $r;        
                        if ($rv=='kWh_Total_Export') 
                            $rec['kWh_Total_Export'] = $r;        
                        if ($rv=='kWh_Total_Import') 
                            $rec['kWh_Total_Import'] = $r;        
                        if ($rv=='AC_PF') 
                            $rec['AC_PF'] = $r;    
                        if ($rv=='AC_Current_A') 
                            $rec['AC_Current_A'] = $r;    
                        if ($rv=='AC_Current_B') 
                            $rec['AC_Current_B'] = $r;    
                        if ($rv=='AC_Current_C') 
                            $rec['AC_Current_C'] = $r;    
                        if ($rv=='AC_Power_A') 
                            $rec['AC_Power_A'] = $r;    
                        if ($rv=='AC_Power_B') 
                            $rec['AC_Power_B'] = $r;    
                        if ($rv=='AC_Power_C') 
                            $rec['AC_Power_C'] = $r;    
                            
                            
                    }
                    $_GLOBALS['d_meter'][]=$rec;
                };
               
                $arr=0;
            }
        }
        return 1;
    }
    
    function Devices_configure() {
        
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>





