<?
/**
 * @package 
 * @author Akash Heimlich
 * @description EZDisplay
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function EZDisplay_install($val) {
        EZDisplay_enable();
        return 1;
    }
     
    function EZDisplay_uninstall() {
        setPackageStatus("EZDisplay",0);
        return 1;
    }
    
    function EZDisplay_enable() {
        setPackageStatus("EZDisplay",2);
        addWidget("/package/EZDisplay.inc","EZDisplay",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function EZDisplay_disable() {
        setPackageStatus("EZDisplay",3);
        addWidget("/package/EZDisplay.inc","EZDisplay",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function EZDisplay_init() {
        
        // load the test Value into the globals
        //$_GLOBALS['testValue']=ini_get("/config/EZDisplay.ini","config","test","");
        $_GLOBALS['ez']=array();
        $inv_count=ini_get("/config/EZConfig.ini","config","inv_count",0);
        $pm_count=ini_get("/config/EZConfig.ini","config","pm_count",0);
        $_GLOBALS['ez']['sim']=ini_get("/config/EZConfig.ini","config","sim",0);
            
        $_GLOBALS['ez']['inv']=array();
        for ($i=0;$i<$inv_count;$i++) {
            $_GLOBALS['ez']['inv'][$i]=array();
            $_GLOBALS['ez']['inv'][$i]['device_type_id']=ini_get("/config/EZConfig.ini","config","inv".$i."_device_type_id",0);
            $_GLOBALS['ez']['inv'][$i]['bus']=ini_get("/config/EZConfig.ini","config","inv".$i."_bus",0);
            $_GLOBALS['ez']['inv'][$i]['id']=ini_get("/config/EZConfig.ini","config","inv".$i."_id",0);
            $_GLOBALS['ez']['inv'][$i]['rating']=ini_get("/config/EZConfig.ini","config","inv".$i."_rating",0);
            $_GLOBALS['ez']['inv'][$i]['device_name']=ini_get("/config/EZConfig.ini","config","inv".$i."_device_name","");
        }
        $_GLOBALS['ez']['pm']=array();
        for ($i=0;$i<$pm_count;$i++) {
            $_GLOBALS['ez']['pm'][$i]=array();
            $_GLOBALS['ez']['pm'][$i]['device_type_id']=ini_get("/config/EZConfig.ini","config","pm".$i."_device_type_id",0);
            $_GLOBALS['ez']['pm'][$i]['bus']=ini_get("/config/EZConfig.ini","config","pm".$i."_bus",0);
            $_GLOBALS['ez']['pm'][$i]['type']=ini_get("/config/EZConfig.ini","config","pm".$i."_type",0);
            $_GLOBALS['ez']['pm'][$i]['id']=ini_get("/config/EZConfig.ini","config","pm".$i."_id",0);
            $_GLOBALS['ez']['pm'][$i]['device_name']=ini_get("/config/EZConfig.ini","config","pm".$i."_device_name","");
        }
        
        // if power control is active, add the additional data for this so the dashboard can properly update
        $pc_enabled=ini_get("/config/packages.ini","packages","PC",0);
        if ($pc_enabled==2) {
            $active=ini_get('/config/PC.ini','config','active',0);
            if ($active) {
                $_GLOBALS['ez']['pc']=1;
                $pm=ini_get_array("/config/PC.ini","config");
                for ($i=0;$i<intval($pm['pm_count']);$i++) {
                    $dev=mb_get_dev_by_index($pm["pm".$i."_device_idx"]);    
                    for ($m=0;$m<$pm_count;$m++) {
                        if ($_GLOBALS['ez']['pm'][$m]['id']==$dev['slave_id'])  {
                            $_GLOBALS['ez']['pm'][$m]['type']=$pm["pm".$i."_type"];
                            $_GLOBALS['ez']['pm'][$m]['pc']=1;
                            $_GLOBALS['ez']['pm'][$m]['min']=$pm["pm".$i."_min"];
                            $_GLOBALS['ez']['pm'][$m]['max']=$pm["pm".$i."_max"];
                        }
                    }
                }
                for ($i=0;$i<intval($pm['inv_count']);$i++) {
                    $dev=mb_get_dev_by_index($pm["inv".$i."_device_idx"]);    
                    for ($m=0;$m<$inv_count;$m++) {
                        if ($_GLOBALS['ez']['inv'][$m]['id']==$dev['slave_id'])  {
                            $_GLOBALS['ez']['inv'][$m]['pc']=1;
                        }
                    }
                }
            }
        }
        /**
         * Install the widget in the control panel using this
         **/
        /*$arr=array();
        $arr['script']='/package/EZDisplay.cgi?action=configure';
        $arr['title']='EZDisplay';
        $arr['icon']='icon-hdd';
        $arr['desc']='Display Visualisation';
        
        $_GLOBALS['hooks']['cpanel'][]=$arr;*/
        
        // generate ajax data for front end processing
        if (file_exists('/package/EZDisplayAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/EZDisplayAjax.inc';

        // runs this file once a second
        if (file_exists('/package/EZDisplaySec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/EZDisplaySec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/EZDisplayMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/EZDisplayMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/EZDisplayDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/EZDisplayDay.inc';            
        return 1;
    }
    
    function EZDisplay_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="EZDisplay"; 
        $title='Configure Package EZDisplay';
        $config_file="EZDisplay.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Test Widget</li>
        </ul>
                
        <div class="page-header">
          <h1><i class="icon-suitcase icon-2x"></i> Test Widget Configuration</h1>
        </div>
        <div id="nav-wrapper">
            <div id="nav">
                <div class="navbar well">
                    <div class='container'>
                        <div id='navcontent'><div class='navtext'>Configure widget here.</div>
                
                            <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                            <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                            <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                            <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                        </div>
                
                        
                    </div> <!-- container -->
        <div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
        This widget is a test widget.  Put your text here. <br>
        </div>            
        <div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
        <div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
                </div> <!-- navbar-inner -->
            </div> <!-- navbar -->
        </div>     
        <div class="row-fluid">
        	<div class="box span12">
        		<div class="box-header well">
        			<h2><i class="icon-pencil"></i> Widget Settings</h2>
        			<div class="box-icon">
        				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
        			</div>
        		</div>
        		<div class="box-content">
        		<div ng-init="widget_test='<? print(ini_get("/config/".$config_file,$config_section,"test","")); ?>';">
        		 <fieldset>
        			    <div class="control-group">
        		            <label class="control-label" for='widget_test'>Test Value</label>
        		            <div class="controls">
        			            <input type='text' ng-model="widget_test"  name='widget_test' title="Enter a value to be saved to a config file for re-use later" data-rel="tooltip"> 
        			        </div>
        		        </div>
        		</fieldset>
        		<div class="clearfix"></div>
        					</div>
        				</div>
        			</div>  		        
        </form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function EZDisplay($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="test="+$scope.widget_test;
       post_config="EZDisplay.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>


