<pre><? 
/* message logging in alerts based on inverter type */
$num_dev=mb_num_devices();//intval(sizeof($_GLOBALS['ez']['inv']));
$log_level=intval($_GLOBALS['inv_log_level']);
/* LOG LEVEL
0=all
1=warning
2=warning + power cuts
3=errors
4=critical
5=none
*/
$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA
    $prefix=intval($_GLOBALS['log_drive']).':';    

if (!is_array($_GLOBALS['inv_error'])) {
    $_GLOBALS['inv_error']=array();
    for ($ni=0;$ni<$num_dev;$ni++) {
        $_GLOBALS['inv_error'][$ni]=array();
        $_GLOBALS['inv_error'][$ni]['error']='';
        $_GLOBALS['inv_error'][$ni]['status']='';
        $_GLOBALS['inv_error'][$ni]['offline']=0;
    }
}
$t=time();
for ($ni=0;$ni<$num_dev;$ni++) {
    $alert_text='';
    $status_text='';
    $dev=mb_get_dev_by_index($ni);//mb_get_dev_by_id($_GLOBALS['ez']['inv'][$ni]['id'],$_GLOBALS['ez']['inv'][$ni]['bus']);
        
    if ($dev['status']==1) {
        if ($_GLOBALS['inv_log_offline']>0) {
            if (($t-$dev['last_response'])>($_GLOBALS['inv_log_offline']*60)) { // if offline more than interval
                $_GLOBALS['inv_error'][$ni]['offline']++;
            } else $_GLOBALS['inv_error'][$ni]['offline']=0;
            
            if ($_GLOBALS['inv_error'][$ni]['offline']==1) {
                $alert_text.="Device ".($ni+1)." communication error.";
            }
        }
        
    }
            
    print_r($dev);
    
    // make sure the file exists in $dev['device_type_id]
    
    if (file_exists('/package/inverror/err'.$dev['device_type_id'].'.inc')) {
        include('/package/inverror/err'.$dev['device_type_id'].'.inc');
    }
    

	if ($_GLOBALS['inv_error'][$ni]['error'] != $alert_text) {
	    $_GLOBALS['inv_error'][$ni]['error']=$alert_text;
	    
	    if ($alert_text) {
	        $alert_text="ERROR|".$_GLOBALS['ez']['inv'][$ni]['device_name']." error: ".$alert_text;
	        print($alert_text);
	        log($alert_text,$prefix."/logs/alert.txt");
	    } else  {
	        if ($log_level<4) {
    	        $alert_text="INFO|".$_GLOBALS['ez']['inv'][$ni]['device_name']." error cleared.";
    	        print($alert_text);
    	        log($alert_text,$prefix."/logs/alert.txt");
	        }
	    }
	    
	}
	print("\r\nni=".$ni." and status=".$status_text);
	if (strlen($status_text) && ($_GLOBALS['inv_error'][$ni]['status'] != $status_text)) {
	    $_GLOBALS['inv_error'][$ni]['status']=$status_text;
	    
        $status_text="INFO|".$_GLOBALS['ez']['inv'][$ni]['device_name']." status: ".$status_text;
        print($status_text);
        //log($status_text,"/logs/alert.txt");

	}
}

function mb_get_register3($id, $reg, $cnt)
{
	$base_addr = $reg;
	$num_bytes = 2;
	$msg = array(
		$id,
		3
	);
	$msg[] = $base_addr >> 8;
	$msg[] = $base_addr & 0xFF;
	$msg[] = 0;
	$msg[] = $cnt;
	$done=0;
	$dcnt=0;
	while (!$done) {
	    $dcnt++;
	    $res = mb_send_command($msg);
	    if ($res[1]==3) $done=1;
	    if ($dcnt>3) $done=1;
	}
	$val=0;
	if ($res) {
	    print("read of register ".$reg);
	    print_r($res);
	    $val=$res[3]<<8+$res[4];
	}
	return $val;
}
?>



