<h3>Checking File System</h3><?

include("/lib/uphp/debug.inc");

$_GLOBALS['need_md5_check']=0;
if (function_exists('set_buffering')) {
    set_buffering(0); // disable buffering
}
debug_start();

debug_print("Scanning - please wait as this can take some time","init","green");

max_execution_time(600);

$auto_restore= ini_get("/config/uphp.ini","debug","md5_auto_restore",0);

$backupfile="/md5files.txt";
$f=fopen($backupfile,"r");
if (!$f) {
    debug_print("Error opening md5files.txt file - ensure scan has been run already","error","red");
}
$start_time=time();
$errors=0;
$restored=0;
while (!feof($f)) {
    $line=fgets($f);
    $files=explode($line,"\t");
    
    if (file_exists($files[1])) {
        $md5sum=md5_file($files[1]);
        if ($md5sum!=$files[0]) {
            debug_print("MD5 mismatch on file ".$files[1]." ".$files[0]." ".$md5sum,"error","red");
            log("[md5_sync] MD5 mismatch on file ".$files[1],"/logs/md5log.txt");
            $package=ini_get("/config/repository.ini","package",$files[1],"");
            if ($package!="") {
                debug_print("Package: ".($package!=""?$package:"No source package found"),"file","gray");
                if ($auto_restore) {
                    debug_print("Restoring file ".$files[1]." from package ".$package,"auto_restore","green");
                    log("[md5_sync] Restoring file ".$files[1]." from package ".$package,"/logs/md5log.txt");
                    $dir=getcwd();
                    chdir("/");
                    untar($package,0,substr($files[1],1));
                    chdir($dir);
                    $restored++;
                } else {
                    log("[md5_sync] File ".$files[1]." could be restored from package ".$package." but auto restore is disabled","/logs/md5log.txt");
                }
            } else {
                debug_print("Package: ".($package!=""?$package:"No source package found"),"file","red");
                log("[md5_sync] No source repository package found for ".$files[1],"/logs/md5log.txt");
            }
            
            $errors++;
        }
    }
}

//tar_finish($f);
fclose($f);
debug_print("Completed - ".$errors." files changed - runtime=".(time()-$start_time)." seconds.","terminate","green");
log("[md5_sync] Disk Check Completed - ".$errors." files changed  and ".$restored." files automatically restored - runtime=".(time()-$start_time)." seconds.");
$_GLOBALS['md5_check_errors']=$errors-$restored;
ini_set("/logs/md5.ini",'config','md5_check_errors',$errors-$restored);
?></pre>
<? if ($errors) { ?>
Your filesystem appears to be out of sync.  If you have chosen to auto restore files in the Control Panel > uPHP settings, the OS would have attempted
to automatically restore your packages.  If you have made changes to the file system manually and wish to keep those, run a resync manually now.<br>
<a class="btn btn-secondary" href="/app/pacman.cgi?action=md5_check" class="btn">Scan Again</a> <a class="btn btn-secondary" href="/app/pacman.cgi?action=resync" class="btn">Re-Sync Now</a>
<?
} ?>




