<h3>Resync Filesystem</h3><?

include("/lib/uphp/debug.inc");

debug_start();
if (function_exists('set_buffering')) {
    set_buffering(1); // disable buffering
}
debug_print("Initializing","init","green");

max_execution_time(600);

function searchdir($dir,$dirarr) {
    chdir($dir);
    $arr=findfirst("*.*",16);
    $count=0;
    while ($arr) {
        if ($arr['attributes'] & 16) {
            if ((substr($arr['filename'],0,1)!=".") && ($arr['filename']!="cache") && ($arr['filename']!="backup")) {
                debug_print("Found directory ".$dir.$arr['filename']." - ".$arr['attributes'],"scan","green");
                flush();
                $dirarr[]=$dir.$arr['filename']."/";     
                $count++;
            }
        
        }
        $arr=findnext();
    }

}
$backupfile="/md5files.txt";
$f=fopen($backupfile,"w+");

$dirs=array("/");

$dir=$dirs[0];
$start=1;

searchdir($dir,&$dirs);

$num=sizeof(&$dirs);
while ($start<$num) {
    for ($i=$start;$i<$num;$i++) {
        searchdir($dirs[$i],&$dirs);
        $start++;
    }
    $num=sizeof(&$dirs);
}
$start_time=time();
$count=0;
for ($i=0;$i<$num;$i++) {
    $dir=$dirs[$i];
    chdir($dir);
    $arr=findfirst("*.*",255-24);  // no directories
    
    
    while ($arr) {
        
        // skip directories
        if ((($dir.$arr['filename']) !=$backupfile) && ((strpos($arr['filename'],".cgi")>0) ||(strpos($arr['filename'],".inc")>0) ||(strpos($arr['filename'],".enc")>0))) {
            debug_print("Adding ".$dir.$arr['filename']." -  ".$arr['filesize']." bytes",'file','blue');
            flush();
            $md5sum=md5_file($dir.$arr['filename']);
            fwrite($f,$md5sum."\t".$dir.$arr['filename']."\r\n");
            $count++;
        } else {
            //print("Skipping file ".$dir.$arr['filename']."\r\n");
        }
        $arr=findnext();
    }
}

//tar_finish($f);
fclose($f);
ini_set("/logs/ota.ini","config","need_resync",0);
debug_print("Added ".$count." files to the md5 checklist - runtime=".(time()-$start_time)." seconds.",'terminate','green');
log("[md5_resync] Added ".$count." files to the md5 checklist - runtime=".(time()-$start_time)." seconds");
$_GLOBALS['md5_sync_changed']=0;
$_GLOBALS['md5_check_errors']=0;
ini_set("/logs/md5.ini",'config','md5_sync_changed',0);
ini_set("/logs/md5.ini",'config','md5_check_errors',0);
?></pre>
