<pre><?
/**
 *  Real to Virtual Meter mapping script
 * 
 * Usage:  Add this to crontab.txt at the interval desired, we recommed once every 2 or 3 seconds
 * When running ezconfig, add multiple virtual meters on different IDs from the actual meter.  Make sure
 * they are on the Virtual Bus.  In the example below, the actual meter is on ID 15 while the virtual ones are on 16, 17, 18
 * Do not define a location for the real meter and do not connect it to power control.
 * Instead, add the virtual meters in EZConfig at the correct locations - i.e. zero export, DG, etc
 * In power control, set the thresholds for the virtual meters ONLY
 * 
 * When a digital input is active in option 1, the virtual meter will show active
 * In option 2, one of two virtual meters will be active at all times - the ID 16 when the DI is on, and the ID 17 when the DI is off.
 * 
 * Please comment out the section that is not used.
 * 
 * For further clarity on how this works, reach us at support@wattmon.com
 */

  // get the master device
  $dev=mb_get_dev_by_id(0);
  
  // optional debug output - use this to determine the name of the di1 variable - could be di1 or divar1 depending on the driver
  print_r($dev);
  
  // get the physical meter
  $meter=mb_get_dev_by_id(15);
  
  
  // option 1:  Determine which virtual meter is active with digital inputs, only when they are ON
  // TODO : ensure virtual meters are created on with IDs 16 and 17 and 18, of the same make & model as the real meter
  
  // multiple dis can be used if you wish to update virtual meters  
  if ($dev['di1']) {
      
    // copy over all roles to the virtual meter
    // TODO:  Ensure the ID of the virtual meter below - in this example it's 16
    
    for ($i=0; $i<$meter['num_roles']; $i++) {
	    mb_set_dev_var(16,'roleval'.$i,$meter['roleval'.$i]);
    }
    
  } else if ($dev['di2']) {
    // copy over all roles to the virtual meter
    // TODO:  Ensure the ID of the virtual meter below - in this example it's 17
    
    for ($i=0; $i<$meter['num_roles']; $i++) {
	    mb_set_dev_var(17,'roleval'.$i,$meter['roleval'.$i]);
    }

  }  else if ($dev['di3']) {
    // copy over all roles to the virtual meter
    // TODO:  Ensure the ID of the virtual meter below - in this example it's 18
    
    for ($i=0; $i<$meter['num_roles']; $i++) {
	    mb_set_dev_var(18,'roleval'.$i,$meter['roleval'.$i]);
    }

  }
  
  
  // option 2:  Toggle between two virtual meters based on the status of DI1
  // TODO : ensure 2 virtual meters are created on with IDs 16 and 17, of the same make & model as the real meter
  
  if ($dev['di1']) {
      
    // copy over all roles to the virtual meter
    for ($i=0; $i<$meter['num_roles']; $i++) {
	    mb_set_dev_var(16,'roleval'.$i,$meter['roleval'.$i]);
    }
    
  } else {
    for ($i=0; $i<$meter['num_roles']; $i++) {
	    mb_set_dev_var(17,'roleval'.$i,$meter['roleval'.$i]);
    }
      
  }
?></pre>

