<div ng-controller='BatteryWidgetCtrl'>
<img class='pull-right' ng-src="{{battery_icon}}">
<div class='row-fluid'>
    <div class='span3'>Voltage</div>
    <div class='span5'><strong>{{livedata.voltage}} V</strong></div>
</div>    
<div class='row-fluid row-odd'>
    <div class='span3'>Battery</div>
    <div class='span7'><span class='span10'><div class="progress progress-success myprogress"><div class="bar" style="width: {{livedata.battery_percent}}&#37;"></div></div></span>&nbsp;<strong>{{livedata.battery_percent}}&nbsp;&#37;</strong></div>
</div>    
<div class='row-fluid'>
    <div class='span3'>Status</div>
    <div class='span9'>{{livedata.battery_status}}</div>
</div>    

</div>
<script>function BatteryWidgetCtrl($scope) {
    $scope.battery_icon="img/battery_discharging_100.png";
    function padTo3(number) {
      if (number<=999) { number = ("00"+number).slice(-3); }
      return number;
    }
    $scope.$watch('livedata', function(liveData) {
        rnd=padTo3(Math.round(liveData.battery_percent/20)*20);
        $scope.battery_icon="img/battery_discharging_"+rnd+".png";
        //alert(rnd);
    });
}
</script>