<?
/**
 * @package DeltaRPI
 * @author Akash Heimlich
 * @description This package interfaces with the Delta RPI series of grid tie inverters
 * @version 1.12
 * @date 21-JUL-16
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function DeltaRPI_install($val) {
        DeltaRPI_enable();
        return 1;
    }
     
    function DeltaRPI_uninstall() {
        setPackageStatus("DeltaRPI",0);
        return 1;
    }
    
    function DeltaRPI_enable() {
        setPackageStatus("DeltaRPI",2);
        addWidget("/package/DeltaRPI.inc","Delta RPI",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function DeltaRPI_disable() {
        setPackageStatus("DeltaRPI",3);
        addWidget("/package/DeltaRPI.inc","Delta RPI",4,"icon-play",1,1); // disable
        return 1;
    }
    
    function DeltaRPI_ajax() {
        $_GLOBALS['studer_custom_id']=$_GET['device_id'];
        $_GLOBALS['studer_custom_prop']=$_GET['prop'];
        $_GLOBALS['studer_custom_object']=$_GET['object_id'];
        $_GLOBALS['studer_custom_get']=1;
        
        // wait for second script to finish off 
        while ($_GLOBALS['studer_custom_get']) {
            sleep(100);
        }
        print('{"status":1,"val":"'.$_GLOBALS['studer_custom_response']['val'].'","prop":"'.$_GLOBALS['studer_custom_response']['prop'].'"}');
    }
    
function mb_set_register($id,$reg,$cmd) {
  $base_addr=$reg;
  $num_bytes=2;
  $msg=array($id,6);
  $msg[]=$base_addr >> 8;
  $msg[]=$base_addr & 0xFF;
  $msg[]=$cmd >> 8;
  $msg[]=$cmd & 0xFF;
  print("Set Register Send:\r\n");
  print_r($msg);
  $res=mb_send_command($msg);
  return $res;
}
    function add_role($id,$role_name,$role_group,$role_type,$role_show,$role_def,$role_devices) {
        if ($id==-1)  {
            $num_r=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($j=0;$j<$num_r;$j++) { 
                if ($role_name==ini_get("/config/roles.ini","roles","role"+$j,'')) {
                    break;
                }
            }
            $id=$j;
            print("found role at ".$id."\r\n");
            if ($id==$num_r)  {
                ini_set("/config/roles.ini","roles","num_roles",$id+1);
                $f=fopen("/config/roles.ini",'a+');
                $st="role"+$id+"=".$role_name."\r\n".
                    "role"+$id+"group=".$role_group."\r\n".
                    "role"+$id+"type=".$role_type."\r\n".
                    "role"+$id+"ids=".$role_devices."\r\n".
                    "role"+$id+"def=".$role_def."\r\n".
                    "role"+$id+"show=".$role_show."\r\n";
                fwrite($f,$st);
                fclose($f);
                
            /*    ini_set("/config/roles.ini","roles","role"+$id,$role_name);
                ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
                ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
                ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
                ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
                ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);*/
            }
            
        } else {
            if (ini_get("/config/roles.ini","roles","role"+$id)!=$role_name)
                        ini_set("/config/roles.ini","roles","role"+$id,$role_name);
            if (ini_get("/config/roles.ini","roles","role"+$id+"group")!=$role_group)                    
                        ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
            if (ini_get("/config/roles.ini","roles","role"+$id+"type")!=$role_type)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
            if (ini_get("/config/roles.ini","roles","role"+$id+"ids")!=$role_devices)                                            
                        ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
            if (ini_get("/config/roles.ini","roles","role"+$id+"def")!=$role_def)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
            if (ini_get("/config/roles.ini","roles","role"+$id+"show",0)!=$role_show)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);
        }
    }
    
 function mb_set_register2($id,$reg,$cmd) {
  $base_addr=$reg;
  $num_bytes=2;
  $msg=array($id,6);
  $msg[]=$base_addr >> 8;
  $msg[]=$base_addr & 0xFF;
  $msg[]=$cmd >> 8;
  $msg[]=$cmd & 0xFF;
  print("Set Register Send:\r\n");
  print_r($msg);
  $res=mb_send_command($msg);
  return $res;
}
    /* this is called at system boot */
    function DeltaRPI_init() {
        $_GLOBALS['delta']=array();
        $_GLOBALS['delta_count']=0;
        $_GLOBALS['delta_init']=1;
		$_GLOBALS['delta_count_installed']=ini_get("/config/DeltaRPI.ini","config","delta_count_installed",1);
        max_execution_time(45);
        for ($i=1;$i<=$_GLOBALS['delta_count_installed'];$i++) {
            $addr=$i;
			$dev=mb_get_dev_by_id($addr);
			if (!$dev) {
				mb_add_dev($addr,4580,"delta".($i-1),3000,1);
			} else {
				if ((time()-$dev['last_response'])<180) {
				    $res=mb_send_command(array($addr,4,0x04,0x07,0,1));
				    if (is_array($res)) {
				        $_GLOBALS['delta'.$_GLOBALS['delta_count'].'id']=$i;
				        $res=mb_send_command(array($addr,4,0x04,0x19,0,1));
				        $_GLOBALS['delta'.$_GLOBALS['delta_count'].'rated_power']=intval(($res[3]*0x100+$res[4])*100);
				        $_GLOBALS['power_control']=ini_get("/config/DeltaRPI.ini","config","power_control",0);
				        if ($_GLOBALS['power_control']) {
				            $_GLOBALS['powermeter_role']=ini_get("/config/DeltaRPI.ini","config","powermeter_role",0);
				            $_GLOBALS['power_min']=ini_get("/config/DeltaRPI.ini","config","power_min",2);
				            $_GLOBALS['power_max']=ini_get("/config/DeltaRPI.ini","config","power_max",4);
				        }
				        log('Found Delta RPI Inverter ('. ($_GLOBALS['delta'.$_GLOBALS['delta_count'].'rated_power']/1000).' kW) at address '.$i);
						// disable power control
						$res=mb_set_register(intval($addr),797,0);
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'v_ac1',2,5,1,2,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'v_ac2',2,5,1,2,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'v_ac3',2,5,1,2,'3058');  // watts
				        add_role(-1,'delta'.$_GLOBALS['delta_count'].'w_ac',2,5,1,7,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'w_ac1',0,5,1,7,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'w_ac2',0,5,1,7,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'w_ac3',0,5,1,7,'3058');  // watts
				        add_role(-1,'delta'.$_GLOBALS['delta_count'].'w_dc',3,5,1,7,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'w_dc1',0,5,1,7,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'w_dc2',0,5,1,7,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'v_dc1',0,5,1,2,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'v_dc2',0,5,1,2,'3058');  // watts
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'f_ac1',2,5,1,0,'3058');  // freq
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'f_ac2',2,5,1,0,'3058');  // freq
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'f_ac3',2,5,1,0,'3058');  // freq
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'kw_total',0,5,1,7,'3058');  // freq
		//                add_role(-1,'delta'.$_GLOBALS['delta_count'].'event',0,5,1,7,'3058');  // freq
				        $_GLOBALS['delta'.$_GLOBALS['delta_count']."_kwh_offset"]=ini_get("/config/DeltaRPI.ini","config",'delta'.$_GLOBALS['delta_count']."_kwh_offset",0);

		// disable power control if enabled.
				        $res=mb_set_register2(intval($addr),797,0);
					}
		            $_GLOBALS['delta_count']++;

		        } else print("No inverter found at ".$i);
			}  else print("Inverter unreachable at ".$i);
        }
        $_GLOBALS['delta_init']=0;
        
        /**
         * Install the widget in the control panel using this
         **/
		$found=0;
		for ($i=0;$i<sizeof($_GLOBALS['hooks']['cpanel']);$i++) {
			if ($_GLOBALS['hooks']['cpanel'][$i]['title']=='Delta RPI') 
				$found=1;
		}
		if (!$found) {
		    $arr=array();
		    $arr['script']='/package/DeltaRPI.cgi?action=configure';
		    $arr['title']='Delta RPI';
		    $arr['icon']='icon-hdd';
		    $arr['desc']='Delta RPI settings';
		    $_GLOBALS['hooks']['cpanel'][]=$arr;
		    
		    
		    // generate ajax data for front end processing
		    if (file_exists('/package/DeltaRPIAjax.inc')) 
		        $_GLOBALS['hooks']['ajax'][]='/package/DeltaRPIAjax.inc';

		    // runs this file once a second
		    if (file_exists('/package/DeltaRPISec.inc')) 
		        $_GLOBALS['hooks']['sec'][]='/package/DeltaRPISec.inc';
	   
		    if (file_exists('/package/DeltaRPIDay.inc')) 
		       $_GLOBALS['hooks']['day'][]='/package/DeltaRPIDay.inc';
	   

		    // create any roles that are required
		    // save the delta count
		     ini_set("/config/DeltaRPI.ini","config","delta_count",$_GLOBALS['delta_count']);
		     $_GLOBALS['delta_count_installed']=ini_get("/config/DeltaRPI.ini","config","delta_count_installed",0);
		     /*if ($_GLOBALS['delta_count_installed']<$_GLOBALS['delta_count']) {
		         ini_set("/config/DeltaRPI.ini","config","delta_count_installed",$_GLOBALS['delta_count']);
		         $_GLOBALS['delta_count_installed']=$_GLOBALS['delta_count'];
		     }*/
		     $num_r=ini_get("/config/roles.ini","roles","num_roles",0);//intval($arr['num_graphs']);
		     for ($i=1;$i<$num_r;$i++) {
		        ini_get("/config/roles.ini","roles",'role'+$i,"");
		     }
		}
        return 1;
    }
    
    function DeltaRPI_configure() {
          include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="TestWidget"; 
        $title='Configure Package DeltaRPI';
        $config_file="DeltaRPI.ini";
        $config_section="config";
        $num_inverters= ini_get("/config/".$config_file,$config_section,"delta_count_installed",1);
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Delta RPI</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> DeltaRPI Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
Delta RPI inverters are automatically detected at boot up. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="email='<? print(ini_get("/config/".$config_file,$config_section,"email","")); ?>';">
		<div ng-init="email_enabled=<? print(ini_get("/config/".$config_file,$config_section,"email_enabled",0)); ?>;">
		<div ng-init="delta_count_installed=<? print(ini_get("/config/".$config_file,$config_section,"delta_count_installed",1)); ?>;">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='delta_count_installed'>Num Installed Inverters</label>
		            <div class="controls">
			            <input type='number' ng-model="delta_count_installed"  name='delta_count_installed' title="Enter the number of inverters installed" data-rel="tooltip"> 
			        </div>
		        </div>
			     <div class="control-group">
					<label class="control-label">Daily Alert Enabled</label>
					<div class="controls">
						<select class="input-xlarge" type='text' ng-model="email_enabled"  class='span12' name='email_enabled' required title="Send daily alerts" data-rel="tooltip">
							<option value='0'>Do not send daily alert</option>
							<option value='1'>Send daily alert with production of previous day</option>
							
						</select>
					</div>
				</div>
<!--			    <div class="control-group">
		            <label class="control-label" for='email'>Email address</label>
		            <div class="controls">
			            <input type='number' ng-model="email"  name='email' title="Enter single email address" data-rel="tooltip"> 
			        </div>
		        </div>-->

		</fieldset>
		<? for ($i=0;$i<$num_inverters;$i++) { ?>
		<div ng-init="delta<? print ($i); ?>_kwh_offset=<? print(ini_get("/config/".$config_file,$config_section,"delta"+$i+"_kwh_offset",0)); ?>;">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='delta<? print ($i); ?>_kwh_offset'><? print("Inverter ".($i+1)." kWh Offset"); ?></label>
		            <div class="controls">
			            <input type='number' ng-model="delta<? print ($i); ?>_kwh_offset"  name='delta<? print ($i); ?>_kwh_offset' title="Enter a kwh reading offset if required" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<? } ?>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function TestWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data=<?
		if ($num_inverters) {
		    for ($i=0;$i<$num_inverters;$i++) {
		        if ($i) print("+");
		        print('"delta'.$i.'_kwh_offset="+$scope.delta'+$i+'_kwh_offset+"&"');
		        
		    }
		} else print('test=0');
        ?>;
        post_data+="delta_count_installed="+$scope.delta_count_installed;
        post_data+="&email_enabled="+$scope.email_enabled;
        post_data+="&email="+$scope.email;
       post_config="DeltaRPI.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
</div>   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>






