<?
/**
 * @package DeltaRPI2
 * @author Akash Heimlich
 * @description This file is called every second.  This has been modified to work with power control.
 * @date 05/03/2018
 */

$num=$_GLOBALS['delta_count'];
    $a_dc=0;
    $w_dc=0;
    $w_ac=0;


if (!$_GLOBALS['delta_init']) {
    if (!$_GLOBALS['delta_count'] || ($num<$_GLOBALS['delta_count_installed'])) {
        $_GLOBALS['delta_error']++;
        if ($_GLOBALS['delta_error']>=120) {
            log("Searching for Delta Inverters...");
            if (file_exists("/package/DeltaRPI2.cgi")) {
                    include("/package/DeltaRPI2.cgi");
                    if (function_exists("DeltaRPI_init")) {
                        call_user_func("DeltaRPI_init");
                    }
                }
            $_GLOBALS['delta_error']=0;    
            $num=$_GLOBALS['delta_count'];
        }
    }
	$total_gen=0;
	$cur_inverter=intval($_GLOBALS['cur_inverter']);
	$cur_step=intval($_GLOBALS['cur_step']);

	$i=$cur_inverter;
	if ($_GLOBALS['delta'.$i.'id']>0)
	{
		$dev=mb_get_dev_by_id($_GLOBALS['delta'.$i.'id']);
		if ((time()-$dev['last_response'])<180) {
		    $w_ac=0;
		    $w_dc=0;
		    for ($chan=0;$chan<3;$chan++) {
		        $addr=$_GLOBALS['delta'.$i.'id'];
		        $res=mb_send_command(array($addr,6,0x03,0x1F,0,$chan));
				if (!$res) return;
		        $res=mb_send_command(array($addr,4,0x04,0x1F,0,5));
				if (!$res) return;

				if ($chan==0) $c='A';
				if ($chan==1) $c='B';
				if ($chan==2) $c='C';

		        $_GLOBALS['inverter'.$addr.'_AC_Voltage_'.$c.'N']=($res[5]*0x100+$res[6])/10;
		        $_GLOBALS['inverter'.$addr.'_AC_Current_'.$c]=($res[7]*0x100+$res[8])/100;
		        $_GLOBALS['inverter'.$addr.'_AC_Active_Power_'.$c]=($res[9]*0x100+$res[10]);
		        $_GLOBALS['inverter'.$addr.'_AC_Frequency_'.$c]=($res[11]*0x100+$res[12])/100;
		        $w_ac = $w_ac + ($res[9]*0x100+$res[10]);
		    }
		    for ($chan=0;$chan<2;$chan++) {
		        $addr=$_GLOBALS['delta'.$i.'id'];

		        $res=mb_send_command(array($addr,6,0x03,0x1F,0,$chan+0x30));
				if (!$res) return;
		        $res=mb_send_command(array($addr,4,0x04,0x1F,0,4));
				if (!$res) return;
		        $_GLOBALS['inverter'.$addr.'_DC_Voltage_'.($chan+1)]=($res[5]*0x100+$res[6])/10;
		        $_GLOBALS['inverter'.$addr.'_DC_Current_'.($chan+1)]=($res[7]*0x100+$res[8])/100;
		        $_GLOBALS['inverter'.$addr.'_DC_Power_'.($chan+1)]=($res[9]*0x100+$res[10]);
		        $w_dc += ($res[9]*0x100+$res[10]);
		        $a_dc += ($res[7]*0x100+$res[8])/100;
		    }
		    
		    $_GLOBALS['inverter'.$addr.'_AC_Active_Power']=$w_ac;
		    $_GLOBALS['inverter'.$addr.'_DC_Power']=$w_dc;
		    $_GLOBALS['inverter'.$addr.'_DC_Current']=$a_dc;
		    
		  
		    
		    if (!$_GLOBALS['delta'.$addr.'cntr']) $_GLOBALS['delta'.$addr.'cntr']=30;
		    $_GLOBALS['delta'.$addr.'cntr']=$_GLOBALS['delta'.$addr.'cntr']+1;
		    
		    if ($_GLOBALS['delta'.$addr.'cntr']>=30) {
		        $res=mb_send_command(array($addr,4,0x04,0x33,0,2));
				if (!$res) return;
		        $v=($res[5]*0x100+$res[6])*0x10000;

		        $v+=($res[3]*0x100+$res[4]);
				if ( ($v/100+intval($_GLOBALS['inverter'.$addr.'_kWh_Offset'])) < 2000000000) {
		        	$_GLOBALS['inverter'.$addr.'_kWh_Total_Active']=$v/100+intval($_GLOBALS['inverter'.$addr.'_kWh_Offset']);
				}

		        // get today kwh
		        $res=mb_send_command(array($addr,4,0x04,0x2f,0,2));
		        $v=($res[5]*0x100+$res[6])*0x10000;
		        $v+=($res[3]*0x100+$res[4]);        
				if ($v*10 < 2000000000)
					$_GLOBALS['inverter'.$addr.'_kWh_Day_Active']=$v*10;
	// for old packages, use wd_in    

		        $_GLOBALS['delta'.$addr.'cntr']=1;

				$res=mb_send_command(array($addr,4,0x04,0x40,0,1));
				if (!$res) return;
		        $_GLOBALS['inverter'.$addr.'_Event_Code']=($res[3]*0x100+$res[4]);
		        $res=mb_send_command(array($addr,4,0x04,0x17,0,1));
				if (!$res) return;
		        $_GLOBALS['inverter'.$addr.'_Status_Code']=($res[3]*0x100+$res[4]);

		    }
     	}       
    }

	$_GLOBALS['cur_inverter']=$_GLOBALS['cur_inverter']+1;
	if ($_GLOBALS['cur_inverter']>=$_GLOBALS['delta_count']) {
		$_GLOBALS['cur_inverter']=0;
		$kwhtotal=0;

	    for ($inv=0;$inv<$_GLOBALS['delta_count'];$inv++) {
			$addr=$_GLOBALS['delta'.$i.'id'];
	        $kwhtotal+=$_GLOBALS['inverter'.$addr.'kWh_Day'];
	    }
			
		if (is_array($_GLOBALS['grp'][2]['vals'])) {
			$_GLOBALS['grp'][2]['vals'][4]=$kwhtotal;
		} else {
		    $_GLOBALS['grp'][2]['wd_in']=$kwhtotal;
		}
		$_GLOBALS['delta_total']=0;
	}
	

} else {
     $_GLOBALS['delta_error']++;
     if ($_GLOBALS['delta_error']>=120) {
         $_GLOBALS['delta_init']=0;
         $_GLOBALS['delta_count_installed']=ini_get("/config/DeltaRPI.ini","config","delta_count_installed",0);
     }
}

function mb_set_register($id,$reg,$cmd) {
  $base_addr=$reg;
  $num_bytes=2;
  $msg=array($id,6);
  $msg[]=$base_addr >> 8;
  $msg[]=$base_addr & 0xFF;
  $msg[]=$cmd >> 8;
  $msg[]=$cmd & 0xFF;
  print("Set Register Send:\r\n");
  print_r($msg);
  $res=mb_send_command($msg);
  return $res;
}

function mb_get_register($id,$reg,$cnt) {
  $base_addr=$reg;
  $num_bytes=2;
  $msg=array($id,3);
  $msg[]=$base_addr >> 8;
  $msg[]=$base_addr & 0xFF;
  $msg[]=0;
  $msg[]=$cnt;
  $res=mb_send_command($msg);
  return $res;
}

?>



