<pre><?
/**
 * @package DeltaRPI
 * @author Akash Heimlich
 * @description This file is called every second
 * @date 02-JAN-16 - optional email
 */
$logfile = "/logs/"."daily_kwh.csv";
$fcsv=fopen($logfile,'r');
$year=intval(strftime("%Y",time()));
$month=intval(strftime("%m",time()));
$month_start=mktime(0,0,0,intval($month)-1,1,$year);
$dow=intval(strftime("%w",time()));
$week_start=time()-(86400*$dow);
$day_start=intval(time()-86400*1.9);
//print("Day of week=".$dow."\r\n");

while (!feof($fscv)) {
    $st=fgets($fcsv);
    if (!$st) break;
    $arr=explode($st,',');
    //print_r($arr);
    if (intval($arr[0])>=$month_start) {
        $month_total+=floatval($arr[6]);
    }
    if (intval($arr[0])>=$week_start) {
        $week_total+=floatval($arr[6]);
    }
    if (intval($arr[0])>=$day_start) {
        $day_total+=floatval($arr[6]);
    }
}
fclose($fcsv);
$title="Delta Production Statistics for ".ini_get("/config/user.ini","user","device","Wattmon");
$text="INFO|Production statistics as on ".strftime("%c",time())."|";
$text.="This month: ".$month_total." kWh|";
$text.="This week: ".$week_total." kWh|";
$text.="Yesterday: ".$day_total." kWh";
//print($title);
//print("\r\n");
print($text);
$email=ini_get("/config/DeltaRPI.ini","config","email","");
$email_enabled=ini_get("/config/DeltaRPI.ini","config","email_enabled",0);
if ($email_enabled) {
    log($text,'/logs/alert.txt');
}
else {
    print("Alerts are not enabled.");
}
/*if ($email_enabled && $email) {
    max_execution_time(60);
    mail($email,$title,$text);
}
*/

?>



