<?
/**
 * @package DeltaRPI
 * @author Akash Heimlich
 * @description This file is called every second
 * @date 28-DEC-15 - fixed bug to research for inverters
 * @modified 18-07-16 - fixed a bug for multiple inverters
 */
/*$fmb=f485open(19200,1);
while (filesize($fmb)) {
    $st=fread($fmb,filesize($fmb));
}*/

$num=$_GLOBALS['delta_count'];
    $a_dc=0;
    $w_dc=0;
    $w_ac=0;
function makeUnsigned($org) {    
    if ($org<0) {
        $val=-$org;
        $val=$val ^ 0xFFFF;
        $val+=1;
    } else $val=$org;
    return ($val);
}
if ($_GLOBALS['power_control']) {
    if (!$_GLOBALS['pwr_percent']) {
			$_GLOBALS['pwr_percent']=array();
			$num = $_GLOBALS['delta_count'];
			for ($i=0; $i < $num; $i++) {
			    $_GLOBALS['pwr_percent'][$i]=100;
			}
		}
    $_GLOBALS['power_cnt']++;
    if ($_GLOBALS['power_cnt']>30) {
        $_GLOBALS['power_cnt']=0;
        $_GLOBALS['active_power']=mb_get_val_by_role($_GLOBALS['powermeter_role']);
        if ($_GLOBALS['active_power'] < $_GLOBALS['power_min']) {
				// this is the number of kw to reduce from the current power
				$_GLOBALS['limit_power'] = (($_GLOBALS['active_power']-$_GLOBALS['power_min'])/$_GLOBALS['delta_count']); 
			} else {
				if ($_GLOBALS['active_power'] > $_GLOBALS['power_max']) {
					$_GLOBALS['limit_power'] = (($_GLOBALS['active_power']-$_GLOBALS['power_min'])/$_GLOBALS['delta_count']); 
				} else {
				    //$_GLOBALS['limit_power']=0;
				    $_GLOBALS['limit_power'] = (($_GLOBALS['active_power']-$_GLOBALS['power_min'])/$_GLOBALS['delta_count']); 
				}
			}
    }
}
if (!$_GLOBALS['delta_init']) {
    if (!$_GLOBALS['delta_count'] || ($num<$_GLOBALS['delta_count_installed'])) {
        $_GLOBALS['delta_error']++;
        if ($_GLOBALS['delta_error']>=120) {
            log("Searching for Delta Inverters...");
            if (file_exists("/package/DeltaRPI.cgi")) {
                    include("/package/DeltaRPI.cgi");
                    if (function_exists("DeltaRPI_init")) {
                        call_user_func("DeltaRPI_init");
                    }
                }
            $_GLOBALS['delta_error']=0;    
            $num=$_GLOBALS['delta_count'];
        }
    }
	$total_gen=0;
	$cur_inverter=intval($_GLOBALS['cur_inverter']);
	$cur_step=intval($_GLOBALS['cur_step']);

	$i=$cur_inverter;
	if ($_GLOBALS['delta'.$i.'id']>0)
	{
		$dev=mb_get_dev_by_id($_GLOBALS['delta'.$i.'id']);
		if ((time()-$dev['last_response'])<180) {
		    $w_ac=0;
		    $w_dc=0;
		    for ($chan=0;$chan<3;$chan++) {
		        $addr=$_GLOBALS['delta'.$i.'id'];
		        $res=mb_send_command(array($addr,6,0x03,0x1F,0,$chan));
				if (!$res) return;
		        $res=mb_send_command(array($addr,4,0x04,0x1F,0,5));
				if (!$res) return;
		        $_GLOBALS['delta'.$i.'v_ac'.($chan+1)]=($res[5]*0x100+$res[6])/10;
		        $_GLOBALS['delta'.$i.'a_ac'.($chan+1)]=($res[7]*0x100+$res[8])/100;
		        $_GLOBALS['delta'.$i.'w_ac'.($chan+1)]=($res[9]*0x100+$res[10]);
		        $_GLOBALS['delta'.$i.'f_ac'.($chan+1)]=($res[11]*0x100+$res[12])/100;
		        $w_ac = $w_ac + ($res[9]*0x100+$res[10]);
		    }
		    for ($chan=0;$chan<2;$chan++) {
		        $addr=$_GLOBALS['delta'.$i.'id'];

		        $res=mb_send_command(array($addr,6,0x03,0x1F,0,$chan+0x30));
				if (!$res) return;
		        $res=mb_send_command(array($addr,4,0x04,0x1F,0,4));
				if (!$res) return;
		        $_GLOBALS['delta'.$i.'v_dc'.($chan+1)]=($res[5]*0x100+$res[6])/10;
		        $_GLOBALS['delta'.$i.'a_dc'.($chan+1)]=($res[7]*0x100+$res[8])/100;
		        $_GLOBALS['delta'.$i.'w_dc'.($chan+1)]=($res[9]*0x100+$res[10]);
		        $w_dc += ($res[9]*0x100+$res[10]);
		        $a_dc += ($res[7]*0x100+$res[8])/100;
		    }
		    
		    $_GLOBALS['delta'.$i.'w_ac']=$w_ac;
		    $_GLOBALS['delta'.$i.'w_dc']=$w_dc;
		    $_GLOBALS['delta'.$i.'a_dc']=$a_dc;
		    
		  
		    
		    if (!$_GLOBALS['delta'.$i.'cntr']) $_GLOBALS['delta'.$i.'cntr']=30;
		    $_GLOBALS['delta'.$i.'cntr']=$_GLOBALS['delta'.$i.'cntr']+1;
		    
		    if ($_GLOBALS['delta'.$i.'cntr']>=30) {
		        $res=mb_send_command(array($addr,4,0x04,0x33,0,2));
				if (!$res) return;
		        //$_GLOBALS['delta'.$i.'kw_res']=$res;
		        $v=makeUnsigned($res[5]*0x100+$res[6])*0x10000;

		        $v+=makeUnsigned($res[3]*0x100+$res[4]);
				if ( ($v/100+intval($_GLOBALS['delta'.$i.'_kwh_offset'])) < 2000000000) {
		        	$_GLOBALS['delta'.$i.'kw_total']=$v/100+intval($_GLOBALS['delta'.$i.'_kwh_offset']);
				}

		        // get today kwh
		        $res=mb_send_command(array($addr,4,0x04,0x2f,0,2));
		        $v=($res[5]*0x100+$res[6])*0x10000;
		        $v+=($res[3]*0x100+$res[4]);        
				if ($v*10 < 2000000000)
					$_GLOBALS['delta'.$i.'kw_today']=$v*10;
	// for old packages, use wd_in    

		        $_GLOBALS['delta'.$i.'cntr']=1;

				$res=mb_send_command(array($addr,4,0x04,0x40,0,1));
				if (!$res) return;
		        $_GLOBALS['delta'.$i.'event']=($res[3]*0x100+$res[4]);
		        $res=mb_send_command(array($addr,4,0x04,0x17,0,1));
				if (!$res) return;
		        $_GLOBALS['delta'.$i.'status']=($res[3]*0x100+$res[4]);
		        
		        if ($_GLOBALS['power_control']) {
		        	$_GLOBALS['pwr_limit'][$i]=($w_ac/1000)+$_GLOBALS['limit_power'];
					if ($_GLOBALS['pwr_limit'][$i]<0) $_GLOBALS['pwr_limit'][$i]=0;
					 
								// set new output power
					$_GLOBALS['pwr_percent'][$i]=$_GLOBALS['pwr_limit'][$i]*100/($_GLOBALS['delta'.$i.'rated_power']/1000);
					if ($_GLOBALS['pwr_percent'][$i]>100) $_GLOBALS['pwr_percent'][$i]=100;
					if ($_GLOBALS['pwr_percent'][$i]<0) $_GLOBALS['pwr_percent'][$i]=0;
					$_GLOBALS['delta'.$i."_limit_percent"]=$_GLOBALS['pwr_percent'][$i];
					if ($_GLOBALS['pwr_percent'][$i]==100) {
							$res=mb_set_register(intval($addr),797,0);
					} else {
							$res=mb_set_register(intval($addr),797,1);
							print("Response: \r\n");
							print_r($res);
							$res=mb_set_register(intval($addr),798,$_GLOBALS['pwr_percent'][$i]);
							print("Response: \r\n");
							print_r($res);
					}
		        } else $res=mb_set_register(intval($addr),797,0);
		    }
     	}       
    }

	$_GLOBALS['cur_inverter']=$_GLOBALS['cur_inverter']+1;
	if ($_GLOBALS['cur_inverter']>=$_GLOBALS['delta_count']) {
		$_GLOBALS['cur_inverter']=0;
		$kwhtotal=0;
	    for ($inv=0;$inv<$_GLOBALS['delta_count'];$inv++) {
	        $kwhtotal+=$_GLOBALS['delta'.$inv.'kw_today'];
	    }
			
		if (is_array($_GLOBALS['grp'][2]['vals'])) {
			$_GLOBALS['grp'][2]['vals'][4]=$kwhtotal;
//			$_GLOBALS['grp'][2]['wd_in']=0;
		} else {
		    $_GLOBALS['grp'][2]['wd_in']=$kwhtotal;
		}
		$_GLOBALS['delta_total']=0;
	}
	

} else {
     $_GLOBALS['delta_error']++;
     if ($_GLOBALS['delta_error']>=120) {
         $_GLOBALS['delta_init']=0;
         $_GLOBALS['delta_count_installed']=ini_get("/config/DeltaRPI.ini","config","delta_count_installed",0);
     }
}

function mb_set_register($id,$reg,$cmd) {
  $base_addr=$reg;
  $num_bytes=2;
  $msg=array($id,6);
  $msg[]=$base_addr >> 8;
  $msg[]=$base_addr & 0xFF;
  $msg[]=$cmd >> 8;
  $msg[]=$cmd & 0xFF;
  print("Set Register Send:\r\n");
  print_r($msg);
  $res=mb_send_command($msg);
  return $res;
}

function mb_get_register($id,$reg,$cnt) {
  $base_addr=$reg;
  $num_bytes=2;
  $msg=array($id,3);
  $msg[]=$base_addr >> 8;
  $msg[]=$base_addr & 0xFF;
  $msg[]=0;
  $msg[]=$cnt;
//  $msg[]=2;
//  $msg[]=$cmd >> 8;
//  $msg[]=$cmd & 0xFF;
 // print_r($msg);
  $res=mb_send_command($msg);
  return $res;
}

?>


