<?
/**
 * @package Discovergy Widget
 * @author Akash Heimlich
 * @description This widget communicates with Discovergy meters
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    
    function install_cron($fn, $interval) {
        $f=fopen("/config/crontab.txt","r");
        $f2=fopen("/config/crontab.txt~","w");
        while (!feof($f)) {
            $st=fgets($f);
            print($st."\r\n");
            if (strpos($st,$fn)) {
                $found=1;
            }
            //15   */1 *   *   /scripts/ip.cgi
            if (strlen($st))
                fwrite($f2,$st."\r\n");
        };
        if (!$found) {
            fwrite($f2,$interval." ".$fn."\r\n");
        }
        fclose($f);
        fclose($f2);
        unlink('/config/crontab.txt');
        rename('/config/crontab.txt~','/config/crontab.txt');
    }
    
    function uninstall_cron($fn) {
        $f=fopen("/config/crontab.txt","r");
        $f2=fopen("/config/crontab.txt~","w");
        while (!feof($f)) {
            $st=fgets($f);
            print($st."\r\n");
            if (strpos($st,$fn)<=0) {
                fwrite($f2,$st."\r\n");
            }
        };
        fclose($f);
        fclose($f2);
        unlink('/config/crontab.txt');
        rename('/config/crontab.txt~','/config/crontab.txt');
    }
    //install_cron("/package/DiscovergyCRON.cgi","0 * * *");
    //die();
    include("/app/package.inc"); 
    function Discovergy_install($val) {
        Discovergy_enable();
        return 1;
    }
     
    function Discovergy_uninstall() {
        setPackageStatus("Discovergy",0);
        return 1;
    }
    
    function Discovergy_enable() {
        setPackageStatus("Discovergy",2);
        //addWidget("/package/Discovergy.inc","Discovergy",4,"icon-play",1,0); // enable
        install_cron("/package/DiscovergyCRON.cgi","0 * * *");
        return 1;
    }
    
    function Discovergy_disable() {
         uninstall_cron("/package/DiscovergyCRON.cgi");
        //addWidget("/package/Discovergy.inc","Discovergy",4,"icon-play",1,1); // disable
        return 1;
    }
    


    function Discovergy_ajax() {
    }
    
    $s=0;

    /* this is called at system boot */
    function Discovergy_init() {
        global $s;
        $config_file='discovergy.ini';
        $config_section='config';
        
        max_execution_time(120);
    
        $_GLOBALS['discovergy_installed_count']=ini_get("/config/".$config_file,$config_section,"discovergy_installed_count",1);
        $discovergy_installed_count=$_GLOBALS['discovergy_installed_count'];

        
     
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/Discovergy.cgi?action=configure';
        $arr['title']='Discovergy';
        $arr['icon']='icon-hdd';
        $arr['desc']='Discovergy settings';
/*        $_GLOBALS['vars'][]='meter_frequency';
        $_GLOBALS['vars'][]='meter_voltage';
        $_GLOBALS['vars'][]='meter_current1';
        $_GLOBALS['vars'][]='meter_current2';
        $_GLOBALS['vars'][]='meter_current3';
        */
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        
        // generate ajax data for front end processing
        if (file_exists('/package/DiscovergyAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/DiscovergyAjax.inc';

        // runs this file once a second
        if (file_exists('/package/DiscovergySec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/DiscovergySec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/DiscovergyMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/DiscovergyMin.inc';
            
        // runs this file once a day
//        if (file_exists('/package/EnergyMeterWidgetDay.inc')) 
//            $_GLOBALS['hooks']['sec'][]='/package/EnergyMeterWidgetDay.inc';            
        return 1;
    }
    
    function Discovergy_configure() {
          include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="TestWidget"; 
        $title='Configure Package Discovergy';
        $config_file="discovergy.ini";
        $config_section="config";
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Discovergy</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Discovergy Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
Discovergy meters are automatically added as they become available. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="email='<? print(ini_get("/config/discovergy.ini","config","email","")); ?>';">
		<div ng-init="password='<? print(ini_get("/config/discovergy.ini","config","password","")); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='email'>User Email</label>
		            <div class="controls">
			            <input type='text' ng-model="email"  name='email' title="Discovergy Username" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		<fieldset>
			    <div class="control-group">
		            <label class="control-label" for='password'>Password</label>
		            <div class="controls">
			            <input type='password' ng-model="password"  name='password' title="Discovergy Password" data-rel="tooltip"> 
			        </div>
		        </div>
		</fieldset>
		
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function TestWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="email="+$scope.email+
            "&password="+$scope.password;
       post_config="discovergy.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
</div>   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>






