<?
/**
 * @package PowerControl Manager
 * @author Akash Heimlich
 * @description This package will control inverter power based on a power meter and set points.
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
function in_array($arr, $val) {
    for ($i=0;$i<sizeof($arr);$i++) {
        if ($arr[$i]==$val) return 1;
    }
    return 0;
}
    
    function EZConfig_install($val) {
        EZConfig_enable();
        return 1;
    }
     
    function EZConfig_uninstall() {
        setPackageStatus("EZConfig",0);
        return 1;
    }
    
    function EZConfig_enable() {
        setPackageStatus("EZConfig",2);
//        addWidget("/package/EZConfig.inc","PowerControl",12,"icon-play",1,0); // enable
        return 1;
    }
    
    function EZConfig_disable() {
        setPackageStatus("EZConfig",3);
  //      addWidget("/package/EZConfig.inc","PowerControl",12,"icon-play",1,1); // disable
        return 1;
    }
    
    function EZConfig_ajax() {
//        $_GLOBALS['studer_custom_id']=$_GET['device_id'];
        
    }
    
   
    
    /* this is called at system boot */
    function EZConfig_init() {
        // power meters
        
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/EZConfig.cgi?action=configure';
        $arr['title']='EZ Config';
        
        $arr['icon']='icon-hdd';
        $arr['desc']='Inverter and Power Meter Configurator';
        //print_r($arr);
        //log("in EZConfig init");
         $found=0;
        for ($ai=0;$ai<sizeof($_GLOBALS['hooks']['cpanel']);$ai++) {
            if ($_GLOBALS['hooks']['cpanel'][$ai]['script']=='/package/EZConfig.cgi?action=configure') $found=1;
        }
        if (!$found) $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        
   
        return 1;
    }
    
    function EZConfig_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="EZConfigWidget"; 
        $title='Configure Package Power Control';
        $config_file="EZConfig.ini";
        $config_section="config";
        $num_inverters=$_GLOBALS['inverter_count']?$_GLOBALS['inverter_count']:1;
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        
        if ($_GET['stage']<=1) {
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">EZConfig</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> EZConfig Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveAndNext()" ng-disabled="form.$invalid"><i class="icon-check"></i> Save and Next</button>
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
The EZConfig package helps you set up your system quickly.<br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
        <? 
            $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
            $ez_arr = ini_get_array("/config/EZConfig.ini","config");
            // load power meter values
            for ($i=0;$i<$pm_cnt;$i++) {
                print('<div ng-init="pm.push({device_idx:'+
                    $ez_arr['pm'+$i+'_device_idx']+',bus:\''+
                    $ez_arr['pm'+$i+'_bus']+'\',id:\''+
                    $ez_arr['pm'+$i+'_id']+'\',device_name:\''+$ez_arr['pm'+$i+'_device_name'] + '\'})"></div>'
                    );
            } 
            
            // load inverter values
            for ($i=0;$i<$inv_cnt;$i++) {
                print('<div ng-init="inv.push({device_idx:'+
                    $ez_arr['inv'+$i+'_device_idx']+',bus:\''+
                    $ez_arr['inv'+$i+'_bus']+'\',id:\''+
                    $ez_arr['inv'+$i+'_id']+'\',device_name:\''+$ez_arr['inv'+$i+'_device_name'] + '\'})"></div>'
                    );
            } 
        ?>            
		<div ng-init="inv_count=<? print($inv_cnt); ?>;">
        <div ng-init="pm_count=<? print($pm_cnt); ?>;">
        
        
        <div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-key"></i> Power Meters</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content"> 
		 Number of Power Meters: <strong>{{pm_count}}</strong>
					
 <div >
<a name='addpm'></a>
<div class='pull-right'><ng-button ng-disabled='power_meters.length==0' class="btn btn-primary" ng-click="addPM()"><i class="icon-plus"></i> Add</ng-button></div>
<table class='table table-striped' summary="Meters" >
<tr>
<td scope="col"></td>
<td scope="col">Device</td>
<td scope="col">Address</td>
<td scope="col">Bus</td>
<td scope="col">Name</td>
<td scope="col">Options</td>
</tr>
<tr ng-repeat="item in pm">
    <td><a name='pm{{$index}}'></a><span class="badge badge-inverse">{{$index+1}}</span></td>
    <td><strong>{{power_meters[item.device_idx].name}}</strong><div ng-show='item.edit==1'>
        <select ng-options="vitem.device_idx as vitem.name for vitem in power_meters" ng-model="item.device_idx" class='span12'>
		      <option value="{{vitem.device_idx}}">{{vitem.name}}</option>       
		 </select>
        </div>
    </td>            
    <td>{{item.id}}<div ng-show='item.edit==1'>
         <input type='text' class='span12' ng-model='item.id'>
        </div></td>

    <td>{{makeBus(item.bus)}}<div ng-show='item.edit==1'>
          <select ng-options="vbus.idx as vbus.name for vbus in bus" ng-model="item.bus" class='span12'>
		      <option value="{{vbus.idx}}">{{vbus.name}}</option>       
		 </select>
        </div></td>
    <td>{{item.device_name}}<div ng-show='item.edit==1'>
         <input type='text' class='span12' ng-model='item.device_name'>
        </div></td>
    <td>
        <div class="pull-right btn-group">
        <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
        Action
        <span class="caret"></span>
        </a>
    <ul class="dropdown-menu">
    <!-- dropdown menu links -->
    <li ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#pm{{$index}}'><i class="icon-pencil"></i> Edit</a></li>
    <li ng-show='item.edit==1'><a ng-click='item.edit=0' href='#pm{{$index}}'><i class="icon-pencil"></i> Stop Edit</a></li>
     <li><a ng-click='delPM($index)' href='#addpm'><i class="icon-remove"></i> Delete</a></li>
    </ul>
    </div></td>
</tr>
</table> 
</div>
  <div class="clearfix"></div>
					</div>
				</div>
			</div> 
            
     <div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-key"></i> Inverters</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content"> 
		 Number of Inverters: <strong>{{inv_count}}</strong>
					
 <div >
<a name='addinv'></a>
<div class='pull-right'><ng-button ng-disabled='inverters.length==0' class="btn btn-primary" ng-click="addInv()"><i class="icon-plus"></i> Add</ng-button></div>
<table class='table table-striped' summary="Inverters" >
<tr>
<td scope="col"></td>
<td scope="col">Device</td>
<td scope="col">Address</td>
<td scope="col">Bus</td>
<td scope="col">Name</td>
<td scope="col">Options</td>
</tr>
<tr ng-repeat="item in inv">
    <td><a name='inv{{$index}}'></a><span class="badge badge-inverse">{{$index+1}}</span></td>
    <td><strong>{{inverters[item.device_idx].name}}</strong><div ng-show='item.edit==1'>
        <select ng-options="vitem.device_idx as vitem.name for vitem in inverters" ng-model="item.device_idx" class='span12'>
		      <option value="{{vitem.device_idx}}">{{vitem.name}}</option>       
		 </select>
        </div>
    </td>            
    <td>{{item.id}}<div ng-show='item.edit==1'>
         <input type='text' class='span12' ng-model='item.id'>
        </div></td>

    <td>{{makeBus(item.bus)}}<div ng-show='item.edit==1'>
          <select ng-options="vbus.idx as vbus.name for vbus in bus" ng-model="item.bus" class='span12'>
		      <option value="{{vbus.idx}}">{{vbus.name}}</option>       
		 </select>
        </div></td>
    <td>{{item.device_name}}<div ng-show='item.edit==1'>
         <input type='text' class='span12' ng-model='item.device_name'>
        </div></td>
    <td>
        <div class="pull-right btn-group">
        <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
        Action
        <span class="caret"></span>
        </a>
    <ul class="dropdown-menu">
    <!-- dropdown menu links -->
    <li ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#inv{{$index}}'><i class="icon-pencil"></i> Edit</a></li>
    <li ng-show='item.edit==1'><a ng-click='item.edit=0' href='#inv{{$index}}'><i class="icon-pencil"></i> Stop Edit</a></li>
     <li><a ng-click='delInv($index)' href='#addinv'><i class="icon-remove"></i> Delete</a></li>
    </ul>
    </div></td>
</tr>
</table> 
</div>
  <div class="clearfix"></div>
					</div>
				</div>
			</div>         
			        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
   $scope.power_meter_types=[<? $pm_types=ini_get('/config/EZConfig.ini','config','pm_types','');
   print($pm_types); ?>]; 
   //2900,2901,4580,4134,4133,3360,4789,4790
   $scope.inverter_types=[<? $inv_types=ini_get('/config/EZConfig.ini','config','inv_types','');
   print($inv_types); ?>];
   $scope.pm=[<?
       $num_pm=ini_get('/config/EZConfig.ini','config','num_pm',0);
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","pm".$d,"address",0);
            $bus=ini_get("/config/EZConfig.ini","pm".$d,"bus",0);
            $name=ini_get("/config/EZConfig.ini","pm".$d,"name","");
            $idx=ini_get("/config/EZConfig.ini","pm".$d,"idx",0);

            $st="{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"},";
            print($st);
            
       }
   ?>];
    $scope.inv=[<?
       $num_pm=ini_get('/config/EZConfig.ini','config','num_inv',0);
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","inv".$d,"address",0);
            $bus=ini_get("/config/EZConfig.ini","inv".$d,"bus",0);
            $name=ini_get("/config/EZConfig.ini","inv".$d,"name","");
            $idx=ini_get("/config/EZConfig.ini","inv".$d,"idx",0);

            $st="{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"},";
            print($st);
            
       }
   ?>];

   $scope.power_meters=[<?
        $pm_arr=explode($pm_types,',');
        
       
       for ($d=0;$d<sizeof($pm_arr);$d++) {
        
            $st="{device_type_id:".$pm_arr[$d].",";
            $st.="device_idx:".$d.",";
            $st.="name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","name","")." (".$pm_arr[$d].")\"},";
            print($st);
            
       }
   ?>];
   $scope.inverters=[<?
        $inv_arr=explode($inv_types,',');
        
       
       for ($d=0;$d<sizeof($inv_arr);$d++) {

            $st="{device_type_id:".$inv_arr[$d].",";
            $st.="device_idx:".$d.",";
            $st.="name:\"".ini_get("/dev/dev".$inv_arr[$d].".ini","config","name","")."\"},";
            print($st);
            
       }
   ?>];

   $scope.bus=[{idx:0,name:"Modbus RTU (RS-485)"},
        {idx:2,name:"Modbus TCP Channel 1"},
        {idx:3,name:"Modbus TCP Channel 2"},
        {idx:4,name:"Modbus TCP Channel 3"},
        {idx:5,name:"Modbus TCP Channel 4"},
        {idx:6,name:"Modbus TCP Channel 5"},
        {idx:7,name:"Modbus TCP Channel 6"},
        {idx:8,name:"Modbus TCP Channel 7"},
        {idx:9,name:"Modbus TCP Channel 8"},
    ];
   $scope.pm_count_installed=0;
   $scope.loading=0;
   $gscope=$scope;
   if ($scope.power_meters.length==0) {
        $scope.errormsg="There are currently no power meters defined that support power control.  Please add a Secure 400 or Schneider EM6400 meter.";
   }
   if ($scope.inverters.length==0) {
        if ($scope.errormsg.length>0) $scope.errormsg+="\r\n";
        $scope.errormsg+="There are currently no inverters defined that support power control.  Please add a supported inverter or contact us.";
   }
   
   $scope.makeBus=function(idx) {
     for (i=0;i<$scope.bus.length;i++) {
        if ($scope.bus[i].idx==idx) 
            return $scope.bus[i].name;
     }
     return "";
   }
   $scope.addPM=function() {
    if ($scope.power_meters.length==0) {
        alert("No supported power meters found.  Add the power meter in your devices list first.");
    } else {
        // guess the next meter id
        meter_id=1;
        dbus=0;
        ddevice_idx=0;
        name='meter'+($scope.pm_count+1);
        if ($scope.pm.length) {
            meter_id=Number($scope.pm[$scope.pm.length-1].id)+1;
            ddevice_idx=Number($scope.pm[$scope.pm.length-1].device_idx);
            dbus=Number($scope.pm[$scope.pm.length-1].bus);
            for (i=0;i<$scope.pm.length;i++) {
                if ($scope.pm[i].device_name==name) {
                    name=name+"dup";
                }
            }
        }
        $scope.pm.push({edit:1,id:meter_id,device_idx:ddevice_idx,bus:dbus,device_name:name});
        $scope.pm_count++;
    }
   }
   $scope.delPM=function(idx) {
        $scope.pm.splice(idx,1);
        $scope.pm_count--;
   }
   
    $scope.addInv=function() {
    if ($scope.inverters.length==0) {
        alert("No supported Inverters found.  Add the Inverter in your devices list first.");
    } else {
        // guess the next meter id
        inv_id=1;
        dbus=0;
        ddevice_idx=0;
        name='inverter'+($scope.inv_count+1);
        if ($scope.inv.length) {
            inv_id=Number($scope.inv[$scope.inv.length-1].id)+1;
            ddevice_idx=Number($scope.inv[$scope.inv.length-1].device_idx);
            dbus=Number($scope.inv[$scope.inv.length-1].bus);
            for (i=0;i<$scope.inv.length;i++) {
                if ($scope.inv[i].device_name==name) {
                    name=name+"dup";
                }
            }
        }
        $scope.inv.push({edit:1,id:inv_id,device_idx:ddevice_idx,bus:dbus,device_name:name});
        $scope.inv_count++;
    
    }
   }
   $scope.delInv=function(idx) {
        $scope.inv.splice(idx,1);
        $scope.inv_count--;
   }

    $scope.makeRole=function(itemid) {
        str='';
        switch (Number(itemid)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
      } 

      return str;

  }

   $scope.saveSettings=function() {
       post_data="pm_count="+$scope.pm_count+"&inv_count="+$scope.inv_count;
        
        for (i=0;i<$scope.pm.length;i++) {
            post_data+="&pm"+i+"_device_idx="+$scope.pm[i].device_idx;     
            post_data+="&pm"+i+"_device_type_id="+$scope.power_meters[$scope.pm[i].device_idx].device_type_id;     
            post_data+="&pm"+i+"_id="+$scope.pm[i].id;     
            post_data+="&pm"+i+"_bus="+$scope.pm[i].bus;     
            post_data+="&pm"+i+"_device_name="+$scope.pm[i].device_name;     
        }
        for (i=0;i<$scope.inv.length;i++) {
            post_data+="&inv"+i+"_device_idx="+$scope.inv[i].device_idx;     
            post_data+="&inv"+i+"_device_type_id="+$scope.inverters[$scope.inv[i].device_idx].device_type_id;     
            post_data+="&inv"+i+"_id="+$scope.inv[i].id;     
            post_data+="&inv"+i+"_bus="+$scope.inv[i].bus;     
            post_data+="&inv"+i+"_device_name="+$scope.inv[i].device_name;     
        }
       post_config="EZConfig.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
   
   $scope.saveAndNext=function() {
       post_data="pm_count="+$scope.pm_count+"&inv_count="+$scope.inv_count;
        
        for (i=0;i<$scope.pm.length;i++) {
            post_data+="&pm"+i+"_device_idx="+$scope.pm[i].device_idx;     
            post_data+="&pm"+i+"_device_type_id="+$scope.power_meters[$scope.pm[i].device_idx].device_type_id;     
            post_data+="&pm"+i+"_id="+$scope.pm[i].id;     
            post_data+="&pm"+i+"_bus="+$scope.pm[i].bus;     
            post_data+="&pm"+i+"_device_name="+$scope.pm[i].device_name;     
        }
        for (i=0;i<$scope.inv.length;i++) {
            post_data+="&inv"+i+"_device_idx="+$scope.inv[i].device_idx;     
            post_data+="&inv"+i+"_device_type_id="+$scope.inverters[$scope.inv[i].device_idx].device_type_id;     
            post_data+="&inv"+i+"_id="+$scope.inv[i].id;     
            post_data+="&inv"+i+"_bus="+$scope.inv[i].bus;     
            post_data+="&inv"+i+"_device_name="+$scope.inv[i].device_name;     
        }
       post_config="EZConfig.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          document.location='/package/EZConfig.cgi?action=configure&stage=2';
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
</div>   
        <? }
        
/********************************************************************************************************* STAGE 2 */        
        if ($_GET['stage']==2) {
            ?>
               <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">EZConfig</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> EZConfig Configuration Stage 2 - Logged Data Points</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings(1)" ng-disabled="form.$invalid"><i class="icon-check"></i> Save and Next</button>
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings(0)" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" ng-click="prev()"><i class="icon-back"></i> Previous</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
The EZConfig package helps you set up your system quickly.<br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
        <? 
            $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
            $ez_arr = ini_get_array("/config/EZConfig.ini","config");
//            $=ini_get("/config/EZConfig.ini","config",'pm_count',0);       
        ?>            
		<div ng-init="inv_count=<? print($inv_cnt); ?>;">
        <div ng-init="pm_count=<? print($pm_cnt); ?>;">
        
        
        <div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-key"></i> Power Meters</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content"> 

                     <div >
                    <table class='table table-striped' summary="Meters" >
                    <tr>
                    <td scope="col"></td>
                    <td scope="col">Roles</td>
                    </tr>
                    <tr ng-repeat="item in power_meters">
                        <td><a name='pm{{$index}}'></a><span class="badge badge-inverse">{{$index+1}}</span></td>
                        <td><strong>{{item.name}}</strong>
                        <table class='table table-striped' summary="Roles" >
                            <tr>
                            <td scope="col"></td>
                            <td scope="col">ID</td>
                            <td scope="col">Variable</td>
                            <td scope="col">Description</td>
                            </tr>
                            <tr ng-repeat="role in item.roles">
                                <td><input type='checkbox' class='span12' ng-model='role.selected'></td>
                                <td>{{role.role_idx}}</td><td>
                                <td>{{role.role_name}}</td><td>
                                <td>{{role.role_desc}}</td><td>
                            </tr>
                        </table>
                        
                        
                        </td>            
                    </tr>
                    </table> 
                    </div>
  <div class="clearfix"></div>
					</div>
				</div>
			</div> 
            
     <div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-key"></i> Inverters</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content"> 
                    <table class='table table-striped' summary="Inverters" >
                    <tr>
                    <td scope="col"></td>
                    <td scope="col">Roles</td>
                    </tr>
                    <tr ng-repeat="item in inverters">
                        <td><a name='pm{{$index}}'></a><span class="badge badge-inverse">{{$index+1}}</span></td>
                        <td><strong>{{item.name}}</strong>
                        <table class='table table-striped' summary="Roles" >
                            <tr>
                            <td scope="col"></td>
                            <td scope="col">ID</td>
                            <td scope="col">Variable</td>
                            <td scope="col">Description</td>
                            </tr>
                            <tr ng-repeat="role in item.roles">
                                <td><input type='checkbox' class='span12' ng-model='role.selected'></td>
                                <td>{{role.role_idx}}</td><td>
                                <td>{{role.role_name}}</td><td>
                                <td>{{role.role_desc}}</td><td>
                            </tr>
                        </table>
                        
                        
                        </td>            
                    </tr>
                    </table> 
                    </div>
  <div class="clearfix"></div>
					</div>
				</div>
			</div>         
			        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
<?

?>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
   $scope.power_meter_types=[<? $pm_types=ini_get('/config/EZConfig.ini','config','pm_types','');
   print($pm_types); ?>]; 
   //2900,2901,4580,4134,4133,3360,4789,4790
   $scope.inverter_types=[<? $inv_types=ini_get('/config/EZConfig.ini','config','inv_types','');
   print($inv_types); ?>];
   $scope.pm=[<?
       $num_pm=ini_get('/config/EZConfig.ini','config','pm_count',0);
     //  $pm_used=array();
        $pm_arr=explode($pm_types,',');
        
       $pm_used=indexed_array(1,sizeof($pm_arr));
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","pm".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","pm".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","pm".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","pm".$d."_device_idx",0);
            
            $pm_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';
            print($st);
            
       }
   ?>];
   <?
   //print_r($pm_used); 
   ?>
    $scope.inv=[<?
       $num_pm=ini_get('/config/EZConfig.ini','config','inv_count',0);
      $inv_arr=explode($inv_types,',');
       $inv_used=indexed_array(1,sizeof($inv_arr));
       
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","inv".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","inv".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","inv".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","inv".$d."_device_idx",0);
            $inv_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';

            print($st);
            
       }
   ?>];

   $scope.power_meters=[<?
        $pm_arr=explode($pm_types,',');
        
       $prefix2="";
       for ($d=0;$d<sizeof($pm_arr);$d++) {
            if ($pm_used[$d]==1) {
                $pm_roles_str=ini_get("/config/EZConfig.ini","config","dev".$pm_arr[$d]."_roles","");
                if ($pm_roles_str) {
                    $pm_roles=explode($pm_roles_str,',');
                } else $pm_roles=array();
                
                $st=$prefix2."{device_type_id:".$pm_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","name","")." (".$pm_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$pm_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                 $prefix="";
                for ($r=0;$r<$num_roles;$r++) {
                    // role_var_0=
                    $rt=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    $role_desc=ini_get("/dev/dev".$pm_arr[$d].".ini","config",$var,"");
                    if (in_array($pm_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $st.=$prefix."{role_idx:".$r.",role_name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".$role_desc."\",\"selected\":".$sel."}"; //
                    $prefix=",";
                }
                 
                $st.="] }";
                $prefix2=",";
                print($st);
            }
            
       }
   ?>];
   
   $scope.inverters=[<?
        $inv_arr=explode($inv_types,',');
        
      $prefix2="";
       for ($d=0;$d<sizeof($inv_arr);$d++) {
            if ($inv_used[$d]) {
                $inv_roles_str=ini_get("/config/EZConfig.ini","config","dev".$inv_arr[$d]."_roles","");
                if ($inv_roles_str) {
                    $inv_roles=explode($inv_roles_str,',');
                } else $inv_roles=array();
            
                $st=$prefix2."{device_type_id:".$inv_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$inv_arr[$d].".ini","config","name","")." (".$inv_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$inv_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                $prefix="";
                if ($inv_arr[$d]==4580) {       // Delta Inverter - Special Case
                    $st.=$prefix."{role_idx:0,role_name:\"v_ac1\",\"role_desc\":\"Volts Phase 1\",\"selected\":".(in_array($inv_roles,0)?"true":"false")."},";
                    $st.=$prefix."{role_idx:1,role_name:\"v_ac2\",\"role_desc\":\"Volts Phase 2\",\"selected\":".(in_array($inv_roles,1)?"true":"false")."},";
                    $st.=$prefix."{role_idx:2,role_name:\"v_ac3\",\"role_desc\":\"Volts Phase 3\",\"selected\":".(in_array($inv_roles,2)?"true":"false")."},";
                    $st.=$prefix."{role_idx:3,role_name:\"a_ac1\",\"role_desc\":\"Amps Phase 1\",\"selected\":".(in_array($inv_roles,3)?"true":"false")."},";
                    $st.=$prefix."{role_idx:4,role_name:\"a_ac2\",\"role_desc\":\"Amps Phase 2\",\"selected\":".(in_array($inv_roles,4)?"true":"false")."},";
                    $st.=$prefix."{role_idx:5,role_name:\"a_ac3\",\"role_desc\":\"Amps Phase 3\",\"selected\":".(in_array($inv_roles,5)?"true":"false")."},";
                    $st.=$prefix."{role_idx:6,role_name:\"w_ac1\",\"role_desc\":\"Watts Phase 1\",\"selected\":".(in_array($inv_roles,6)?"true":"false")."},";
                    $st.=$prefix."{role_idx:7,role_name:\"w_ac2\",\"role_desc\":\"Watts Phase 2\",\"selected\":".(in_array($inv_roles,7)?"true":"false")."},";
                    $st.=$prefix."{role_idx:8,role_name:\"w_ac3\",\"role_desc\":\"Watts Phase 3\",\"selected\":".(in_array($inv_roles,8)?"true":"false")."},";
                    $st.=$prefix."{role_idx:9,role_name:\"f_ac1\",\"role_desc\":\"Frequency Phase 1\",\"selected\":".(in_array($inv_roles,9)?"true":"false")."},";
                    $st.=$prefix."{role_idx:10,role_name:\"f_ac2\",\"role_desc\":\"Frequency Phase 2\",\"selected\":".(in_array($inv_roles,10)?"true":"false")."},";
                    $st.=$prefix."{role_idx:11,role_name:\"f_ac3\",\"role_desc\":\"Frequency Phase 3\",\"selected\":".(in_array($inv_roles,11)?"true":"false")."},";
                    print($st);
                    $st="";
                    $st.=$prefix."{role_idx:12,role_name:\"w_ac\",\"role_desc\":\"AC Watts\",\"selected\":".(in_array($inv_roles,12)?"true":"false")."},";
                    $st.=$prefix."{role_idx:13,role_name:\"w_dc\",\"role_desc\":\"DC Watts\",\"selected\":".(in_array($inv_roles,13)?"true":"false")."},";
                    $st.=$prefix."{role_idx:14,role_name:\"a_dc\",\"role_desc\":\"DC Amps\",\"selected\":".(in_array($inv_roles,14)?"true":"false")."},";
                    
                    $st.=$prefix."{role_idx:15,role_name:\"kw_total\",\"role_desc\":\"kWh Lifetime\",\"selected\":".(in_array($inv_roles,15)?"true":"false")."},";
                    $st.=$prefix."{role_idx:16,role_name:\"kw_today\",\"role_desc\":\"kWh Today\",\"selected\":".(in_array($inv_roles,16)?"true":"false")."},";
                    $st.=$prefix."{role_idx:17,role_name:\"status\",\"role_desc\":\"Inverter Status\",\"selected\":".(in_array($inv_roles,17)?"true":"false")."},";
                
                    $st.=$prefix."{role_idx:18,role_name:\"event\",\"role_desc\":\"Event Code\",\"selected\":".(in_array($inv_roles,18)?"true":"false")."},";
                    $st.=$prefix."{role_idx:19,role_name:\"limit_percent\",\"role_desc\":\"Power Limit Percent\",\"selected\":".(in_array($inv_roles,19)?"true":"false")."}";
                } else {
                    for ($r=0;$r<$num_roles;$r++) {
                        // role_var_0=
                    $rt=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    if (in_array($pm_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $role_desc=ini_get("/dev/dev".$inv_arr[$d].".ini","config",$var,"");                        
                        $st.=$prefix."{role_idx:".$r.",role_name:\"".
                            ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".
                            $role_desc."\",\"selected\":".$sel."}"; /**/
                        $prefix=",";
                    }
                }
                
                $st.="] }";
                $prefix2=",";
                print($st);
            }
            
       } ?>
   ];

   $scope.loading=0;
   $gscope=$scope;



    $scope.makeRole=function(itemid) {
        str='';
        switch (Number(itemid)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
      } 

      return str;

  }

   $scope.prev=function() {
        document.location='/package/EZConfig.cgi?action=configure&stage=1';
   }

   $scope.saveSettings=function(moveNext) {
       post_data="";
        //alert('save ');
        for (i=0;i<$scope.power_meters.length;i++) {
            //alert($scope.power_meters[i].roles.length);
            roles="";
            prefix="";
            for (r=0;r<$scope.power_meters[i].roles.length;r++) {
                //alert($scope.power_meters[i].roles[r].selected);
                if ($scope.power_meters[i].roles[r].selected) {
                    //alert("selected "+r);
                    roles=roles+prefix+r;
                    prefix=",";
                }
            }
            if (post_data.length) post_data=post_data+"&";
            post_data+="dev"+$scope.power_meters[i].device_type_id+"_roles="+roles;

        }
        for (i=0;i<$scope.inverters.length;i++) {
            roles="";
            prefix="";
            for (r=0;r<$scope.inverters[i].roles.length;r++) {
                //alert($scope.power_meters[i].roles[r].selected);
                if ($scope.inverters[i].roles[r].selected) {
                    //alert("selected "+r);
                     roles=roles+prefix+r;
                    prefix=",";
                }
            }
            if (post_data.length) post_data=post_data+"&";
            post_data+="dev"+$scope.inverters[i].device_type_id+"_roles="+roles;
        }
       post_config="EZConfig.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          if (moveNext) {
            document.location='/package/EZConfig.cgi?action=configure&stage=3';
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
</div> 
<? } // stage=2

/********************************************************************************************************* STAGE 3 */        
        if ($_GET['stage']==3) {
            ?>
               <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">EZConfig</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> EZConfig Configuration Stage 3 - Confirmation</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="generate()" ng-disabled="form.$invalid"><i class="icon-check"></i> Generate Config</button>
                    <button class="btn btn-large pull-right" ng-click="prev()"><i class="icon-back"></i> Previous</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
The EZConfig package helps you set up your system quickly.<br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
        <? 
            $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
            $ez_arr = ini_get_array("/config/EZConfig.ini","config");
            
//            $=ini_get("/config/EZConfig.ini","config",'pm_count',0);       
        ?>            
		<div ng-init="inv_count=<? print($inv_cnt); ?>;">
        <div ng-init="pm_count=<? print($pm_cnt); ?>;">
        
        <h1>Review</h1>
        Please go through the following table and verify that you have chosen the right options for your new configuration.
        <div class='alert alert-warn'><i class="icon-suitcase icon-2x"></i>
        All existing roles and device configuration data will be lost!  If you would like to make a backup of the existing setup do so now:<br>
        <button class="btn btn-primary btn-large " ng-click="makeBackup()"><i class="icon-check"></i> Backup Now</button></div>
        <div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-key"></i> Power Meters</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content"> 

                     <div >
                     The following parameters will be created and logged:
                     <table class='table table-striped' summary="Inverters" >
                    <tr>
                    <td scope="col"></td>
                    <td scope="col">Roles</td>
                    </tr>
                    <tr ng-repeat="item in pm">
                        <td><a name='pm{{$index}}'></a><span class="badge badge-inverse">{{item.id}}</span></td>
                        <td><strong>{{item.name}}</strong>
                        <td><strong>{{power_meters[item.device_idx].name}}</strong>
                        <table class='table table-striped' summary="Roles" >
                            <tr>
                            <td scope="col">Variable</td>
                            <td scope="col">Description</td>
                            </tr>
                            <tr ng-repeat="role in power_meters[item.device_idx].roles" ng-show='role.selected==true'>
                                <td><strong>{{item.name}}_{{role.role_name}}</strong></td>
                                <td><i>{{role.role_desc}}</i></td>
                            </tr>
                        </table>
                        
                        
                        </td>            
                    </tr>
                    </table> 
            
                    </div>
  <div class="clearfix"></div>
					</div>
				</div>
			</div> 
            
     <div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-key"></i> Inverters</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content"> 
                     <div >
                     The following parameters will be created and logged:
                     <table class='table table-striped' summary="Inverters" >
                    <tr>
                    <td scope="col"></td>
                    <td scope="col">Roles</td>
                    </tr>
                    <tr ng-repeat="item in inv">
                        <td><a name='inv{{$index}}'></a><span class="badge badge-inverse">{{item.id}}</span></td>
                        <td><strong>{{item.name}}</strong>
                        <td><strong>{{inverters[item.device_idx].name}}</strong>
                        <table class='table table-striped' summary="Roles" >
                            <tr>
                            <td scope="col">Variable</td>
                            <td scope="col">Description</td>
                            </tr>
                            <tr ng-repeat="role in inverters[item.device_idx].roles" ng-show='role.selected==true'>
                                <td><strong>{{item.name}}_{{role.role_name}}</strong></td>
                                <td><i>{{role.role_desc}}</i></td>
                            </tr>
                        </table>
                        
                        
                        </td>            
                    </tr>
                    </table> 
            
                    </div>
  <div class="clearfix"></div>
					</div>
				</div>
			</div>         
			        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
   $scope.power_meter_types=[<? $pm_types=ini_get('/config/EZConfig.ini','config','pm_types','');
   print($pm_types); ?>]; 
   //2900,2901,4580,4134,4133,3360,4789,4790
   $scope.inverter_types=[<? $inv_types=ini_get('/config/EZConfig.ini','config','inv_types','');
   print($inv_types); ?>];
   $scope.pm=[<?
       $num_pm=ini_get('/config/EZConfig.ini','config','pm_count',0);
     //  $pm_used=array();
        $pm_arr=explode($pm_types,',');
        
       $pm_used=indexed_array(1,sizeof($pm_arr));
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","pm".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","pm".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","pm".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","pm".$d."_device_idx",0);
            
            $pm_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';
            print($st);
            
       }
   ?>];
   <?
   //print_r($pm_used); 
   ?>
    $scope.inv=[<?
       $num_pm=ini_get('/config/EZConfig.ini','config','inv_count',0);
      $inv_arr=explode($inv_types,',');
       $inv_used=indexed_array(1,sizeof($inv_arr));
       
       $prefix='';
       for ($d=0;$d<$num_pm;$d++) {
            $addr=ini_get("/config/EZConfig.ini","config","inv".$d."_id",0);
            $bus=ini_get("/config/EZConfig.ini","config","inv".$d."_bus",0);
            $name=ini_get("/config/EZConfig.ini","config","inv".$d."_device_name","");
            $idx=ini_get("/config/EZConfig.ini","config","inv".$d."_device_idx",0);
            $inv_used[$idx]=1;
            $st=$prefix."{id:".$addr.",";
            $st.="device_idx:".$idx.",";
            $st.="bus:".$bus.",";
            $st.="name:\"".$name."\"}";
            $prefix=',';

            print($st);
            
       }
   ?>];

   $scope.power_meters=[<?
        $pm_arr=explode($pm_types,',');
        
       $prefix2="";
       for ($d=0;$d<sizeof($pm_arr);$d++) {
            if ($pm_used[$d]==1) {
                $pm_roles_str=ini_get("/config/EZConfig.ini","config","dev".$pm_arr[$d]."_roles","");
                if ($pm_roles_str) {
                    $pm_roles=explode($pm_roles_str,',');
                } else $pm_roles=array();
                
                $st=$prefix2."{device_type_id:".$pm_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","name","")." (".$pm_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$pm_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                 $prefix="";
                for ($r=0;$r<$num_roles;$r++) {
                    // role_var_0=
                    $rt=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    $role_desc=ini_get("/dev/dev".$pm_arr[$d].".ini","config",$var,"");
                    if (in_array($pm_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $st.=$prefix."{role_idx:".$r.",role_name:\"".ini_get("/dev/dev".$pm_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".$role_desc."\",\"selected\":".$sel."}"; //
                    $prefix=",";
                }
                 
                $st.="] }\r\n";
                $prefix2=",";
                print($st);
            }  else {
                $st=$prefix2."{device_type_id:".$pm_arr[$d]."}\r\n";
                $prefix2=",";
                print($st); 
            }
            
       }
   ?>];
   
   $scope.inverters=[<?
        $inv_arr=explode($inv_types,',');
        
      $prefix2="";
       for ($d=0;$d<sizeof($inv_arr);$d++) {
            if ($inv_used[$d]) {
                $inv_roles_str=ini_get("/config/EZConfig.ini","config","dev".$inv_arr[$d]."_roles","");
                if ($inv_roles_str) {
                    $inv_roles=explode($inv_roles_str,',');
                } else $inv_roles=array();
            
                $st=$prefix2."{device_type_id:".$inv_arr[$d].",";
                $st.="device_idx:".$d.",";
                $st.="name:\"".ini_get("/dev/dev".$inv_arr[$d].".ini","config","name","")." (".$inv_arr[$d].")\"";
                $num_roles=ini_get("/dev/dev".$inv_arr[$d].".ini","config","num_roles",0);
                $st.=",roles:[";
                $prefix="";
                if ($inv_arr[$d]==4580) {       // Delta Inverter - Special Case
                    $st.=$prefix."{role_idx:0,role_name:\"v_ac1\",\"role_desc\":\"Volts Phase 1\",\"selected\":".(in_array($inv_roles,0)?"true":"false")."},";
                    $st.=$prefix."{role_idx:1,role_name:\"v_ac2\",\"role_desc\":\"Volts Phase 2\",\"selected\":".(in_array($inv_roles,1)?"true":"false")."},";
                    $st.=$prefix."{role_idx:2,role_name:\"v_ac3\",\"role_desc\":\"Volts Phase 3\",\"selected\":".(in_array($inv_roles,2)?"true":"false")."},";
                    $st.=$prefix."{role_idx:3,role_name:\"a_ac1\",\"role_desc\":\"Amps Phase 1\",\"selected\":".(in_array($inv_roles,3)?"true":"false")."},";
                    $st.=$prefix."{role_idx:4,role_name:\"a_ac2\",\"role_desc\":\"Amps Phase 2\",\"selected\":".(in_array($inv_roles,4)?"true":"false")."},";
                    $st.=$prefix."{role_idx:5,role_name:\"a_ac3\",\"role_desc\":\"Amps Phase 3\",\"selected\":".(in_array($inv_roles,5)?"true":"false")."},";
                    $st.=$prefix."{role_idx:6,role_name:\"w_ac1\",\"role_desc\":\"Watts Phase 1\",\"selected\":".(in_array($inv_roles,6)?"true":"false")."},";
                    $st.=$prefix."{role_idx:7,role_name:\"w_ac2\",\"role_desc\":\"Watts Phase 2\",\"selected\":".(in_array($inv_roles,7)?"true":"false")."},";
                    $st.=$prefix."{role_idx:8,role_name:\"w_ac3\",\"role_desc\":\"Watts Phase 3\",\"selected\":".(in_array($inv_roles,8)?"true":"false")."},";
                    $st.=$prefix."{role_idx:9,role_name:\"f_ac1\",\"role_desc\":\"Frequency Phase 1\",\"selected\":".(in_array($inv_roles,9)?"true":"false")."},";
                    $st.=$prefix."{role_idx:10,role_name:\"f_ac2\",\"role_desc\":\"Frequency Phase 2\",\"selected\":".(in_array($inv_roles,10)?"true":"false")."},";
                    $st.=$prefix."{role_idx:11,role_name:\"f_ac3\",\"role_desc\":\"Frequency Phase 3\",\"selected\":".(in_array($inv_roles,11)?"true":"false")."},";
                    print($st);
                    $st="";
                    $st.=$prefix."{role_idx:12,role_name:\"w_ac\",\"role_desc\":\"AC Watts\",\"selected\":".(in_array($inv_roles,12)?"true":"false")."},";
                    $st.=$prefix."{role_idx:13,role_name:\"w_dc\",\"role_desc\":\"DC Watts\",\"selected\":".(in_array($inv_roles,13)?"true":"false")."},";
                    $st.=$prefix."{role_idx:14,role_name:\"a_dc\",\"role_desc\":\"DC Amps\",\"selected\":".(in_array($inv_roles,14)?"true":"false")."},";
                    
                    $st.=$prefix."{role_idx:15,role_name:\"kw_total\",\"role_desc\":\"kWh Lifetime\",\"selected\":".(in_array($inv_roles,15)?"true":"false")."},";
                    $st.=$prefix."{role_idx:16,role_name:\"kw_today\",\"role_desc\":\"kWh Today\",\"selected\":".(in_array($inv_roles,16)?"true":"false")."},";
                    $st.=$prefix."{role_idx:17,role_name:\"status\",\"role_desc\":\"Inverter Status\",\"selected\":".(in_array($inv_roles,17)?"true":"false")."},";
                
                    $st.=$prefix."{role_idx:18,role_name:\"event\",\"role_desc\":\"Event Code\",\"selected\":".(in_array($inv_roles,18)?"true":"false")."},";
                    $st.=$prefix."{role_idx:19,role_name:\"limit_percent\",\"role_desc\":\"Power Limit Percent\",\"selected\":".(in_array($inv_roles,19)?"true":"false")."}";
                } else {
                    for ($r=0;$r<$num_roles;$r++) {
                        // role_var_0=
                    $rt=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_type_".$r,0);
                    $ri=ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_idx_".$r,0);
                    
                    if ($rt==0) $var="do_desc_".$ri;
                    if ($rt==1) $var="di_desc_".$ri;
                    if ($rt==2) $var="ro_desc_".$ri;
                    if ($rt==3) $var="rw_desc_".$ri;
                    if ($rt==22) $var="ro_desc_".$ri;
                    if ($rt==23) $var="rw_desc_".$ri;
                    if (($rt>=24) && ($rt<=28)) $var="ro_desc_".$ri;
                    if ($rt==29) $var="rw_desc_".$ri;
                    if ($rt==30) $var="rw_desc_".$ri;
                    //print("r=".$r."\r\nrt=".$rt."\r\nri=".$ri."\r\nvar=".$var);
                    if (in_array($inv_roles, $r)) 
                        $sel="true";
                    else $sel="false";
                    $role_desc=ini_get("/dev/dev".$inv_arr[$d].".ini","config",$var,"");                        
                        $st.=$prefix."{role_idx:".$r.",role_name:\"".
                            ini_get("/dev/dev".$inv_arr[$d].".ini","config","role_var_".$r,"")."\",\"role_desc\":\"".
                            $role_desc."\",\"selected\":".$sel."}"; /**/
                        $prefix=",";
                    }
                }
                
                $st.="] }";
                $prefix2=",";
                print($st);
            }  else {
                $st=$prefix2."{device_type_id:".$inv_arr[$d]."}\r\n";
                $prefix2=",";
                print($st); 
            }
            
       } ?>
   ];

   $scope.loading=0;
   $gscope=$scope;



    $scope.makeRole=function(itemid) {
        str='';
        switch (Number(itemid)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
      } 

      return str;

  }
  
  $scope.makeBackup=function() {
     window.open("/app/backuprun.cgi?folder=/config/","_blank","scrollbars=yes");
     return true;
  }

   $scope.prev=function() {
        document.location='/package/EZConfig.cgi?action=configure&stage=2';
   }

   $scope.generate=function() {
     document.location='/package/EZConfig.cgi?action=configure&stage=4';
   }
}
   </script>
</div> 
<? } // stage=3


/********************************************************************************************************* STAGE 4 */        
        if ($_GET['stage']==4) {
            ?>
               <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">EZConfig</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> EZConfig Configuration Stage 4 - Implementation</h1>
</div>
<div id="nav-wrapper">
    <div id="nav" style='max-width:100%'>
        <div class="navbar well" style='max-width:100%'>
            <div class='container' style='max-width:100%'>
                <div id='navcontent' style='max-width:100%'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="reboot()" ng-disabled="form.$invalid"><i class="icon-check"></i> Reboot</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
The EZConfig package helps you set up your system quickly.<br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
        <? 
            $inv_cnt=ini_get("/config/EZConfig.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/EZConfig.ini","config",'pm_count',0);
            $ez_arr = ini_get_array("/config/EZConfig.ini","config");
            if (!$ez_arr['poll']) $ez_arr['poll']=1000;
            $role_array=array();
            $role_types=array();
            $role_ids=array();
            $role_array[]='Undefined';
            $role_types[]=0;
            $role_ids[]="";
            $st_devices="[general]
num_devices=".($inv_cnt+$pm_cnt)+"
delay=10
tcp_delay=100
retry=1000
tcp_retry=1000
max_retries=5
short_timeout=30
tcp_max_retries=1
tcp_delay=100
parity=0
baud=9600
timeout=300
tcp_timeout=300
modbus_tcp_enabled=1
enabled=1
tcp_auto_close=0
";
// stage 1 - generate the devices map
            $cur_device_id=0;
            for ($i=0;$i<$inv_cnt;$i++) {
                //print("inverter ".$i);
                $st_devices.='[Device'.$cur_device_id."]\r\n";
                $st_devices.='name='.$ez_arr['inv'.$i.'_device_name']."\r\n";
                $st_devices.='address='.$ez_arr['inv'.$i.'_id']."\r\n";
                $st_devices.='params='.$ez_arr['inv'.$i.'_bus']."\r\n";
                $st_devices.='poll_interval='.$ez_arr['poll']."\r\n";
                $st_devices.="status=1\r\n";
                $st_devices.='device_type_id='.$ez_arr['inv'.$i.'_device_type_id']."\r\n";
                
                if ($ez_arr['inv'.$i.'_device_type_id']!=4580) {        // delta gets special privileges
                    $roles=explode($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"],",");
                    if (!sizeof($roles)) 
                        $roles=array(intval($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]));
                    //print("roles: ".$ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]);
                    //print_r($roles);
                    
                    for ($r=0;$r<sizeof($roles);$r++) {
                        // get the role name.
                        $rn=intval($roles[$r]);
                        $role_name=$ez_arr['inv'.$i.'_device_name']."_".ini_get("/dev/dev".$ez_arr['inv'.$i.'_device_type_id'].".ini","config","role_var_".$rn,"");
                        $rt=ini_get("/dev/dev".$ez_arr['inv'.$i.'_device_type_id'].".ini","config","role_type_".$rn,0);
                        if ($rt==0) $role_type=0;
                        if ($rt==1) $role_type=1;
                        if ($rt==2) $role_type=2;
                        if ($rt==3) $role_type=3;
                        if ($rt==22) $role_type=2;
                        if ($rt==23) $role_type=3;
                        if (($rt>=24) && ($rt<=28)) $role_type=2;
                        if ($rt==29) $role_type=3;
                        if ($rt==30) $role_type=3;

                        $st_devices.="role".$rn."_id=".sizeof($role_array)."\r\n";
                        $role_array[]=$role_name;
                        $role_types[]=$role_type;
                        $role_ids[]=$ez_arr['inv'.$i.'_device_type_id'];
                    
                    } 
                } else {
                    $roles=explode($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"],",");
                    if (!sizeof($roles)) 
                        $roles=array(intval($ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]));
//                    print("roles: ".$ez_arr['dev'.$ez_arr['inv'.$i.'_device_type_id']."_roles"]);
  //                  print_r($roles);
                    
                    for ($r=0;$r<sizeof($roles);$r++) {
                        // get the role name.
                        $rn=intval($roles[$r]);
                        if ($rn==0) $role_name="v_ac1";
                        if ($rn==1) $role_name="v_ac2";
                        if ($rn==2) $role_name="v_ac3";
                        if ($rn==3) $role_name="a_ac1";
                        if ($rn==4) $role_name="a_ac2";
                        if ($rn==5) $role_name="a_ac3";
                        if ($rn==6) $role_name="w_ac1";
                        if ($rn==7) $role_name="w_ac2";
                        if ($rn==8) $role_name="w_ac3";
                        if ($rn==9) $role_name="f_ac1";
                        if ($rn==10) $role_name="f_ac2";
                        if ($rn==11) $role_name="f_ac3";
                        if ($rn==12) $role_name="w_ac";
                        if ($rn==13) $role_name="w_dc";
                        if ($rn==14) $role_name="a_dc";
                        if ($rn==15) $role_name="kw_total";
                        if ($rn==16) $role_name="kw_today";
                        if ($rn==17) $role_name="status";
                        if ($rn==18) $role_name="event";
                        if ($rn==19) $role_name="limit_percent";
                        $role_name=$ez_arr['inv'.$i.'_device_name']."_".$role_name;
                        $role_type=5;
                        //$role_ids=4580;
                        $role_array[]=$role_name;
                        $role_types[]=$role_type;
                        $role_ids[]=$ez_arr['inv'.$i.'_device_type_id'];

                }
            }
            $cur_device_id++;
        }
            
            for ($i=0;$i<$pm_cnt;$i++) {
                //print("inverter ".$i);
                $st_devices.='[Device'.$cur_device_id."]\r\n";
                $st_devices.='name='.$ez_arr['pm'.$i.'_device_name']."\r\n";
                $st_devices.='address='.$ez_arr['pm'.$i.'_id']."\r\n";
                $st_devices.='params='.$ez_arr['pm'.$i.'_bus']."\r\n";
                $st_devices.='poll_interval='.$ez_arr['poll']."\r\n";
                $st_devices.="status=1\r\n";
                $st_devices.='device_type_id='.$ez_arr['pm'.$i.'_device_type_id']."\r\n";
                
                $roles=explode($ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_roles"],",");
                if (!sizeof($roles)) 
                    $roles=array(intval($ez_arr['dev'.$ez_arr['pm'.$i.'_device_type_id']."_roles"]));

                for ($r=0;$r<sizeof($roles);$r++) {
                    // get the role name.
                    $rn=intval($roles[$r]);
                    $role_name=$ez_arr['pm'.$i.'_device_name']."_".ini_get("/dev/dev".$ez_arr['pm'.$i.'_device_type_id'].".ini","config","role_var_".$rn,"");
                    $rt=ini_get("/dev/dev".$ez_arr['pm'.$i.'_device_type_id'].".ini","config","role_type_".$rn,0);
                    if ($rt==0) $role_type=0;
                    if ($rt==1) $role_type=1;
                    if ($rt==2) $role_type=2;
                    if ($rt==3) $role_type=3;
                    if ($rt==22) $role_type=2;
                    if ($rt==23) $role_type=3;
                    if (($rt>=24) && ($rt<=28)) $role_type=2;
                    if ($rt==29) $role_type=3;
                    if ($rt==30) $role_type=3;

                    $st_devices.="role".$rn."_id=".sizeof($role_array)."\r\n";
                    $role_array[]=$role_name;
                    $role_types[]=$role_type;
                    $role_ids[]=$ez_arr['pm'.$i.'_device_type_id'];
                
                } 
           
            
            $cur_device_id++;
        }
            $datalog_st="[data]\r\nnum_groups=1\r\ngroup0name=Datalog\r\ngroup0type=0\r\ngroup0status=1\r\ngroup0numvar=".(sizeof($role_array)-1)."\r\n";
            
            $role_st="[roles]
num_roles=".sizeof($role_array)."\r\n";
            for ($r=0;$r<sizeof($role_array);$r++) {
                $role_st.="role".$r."=".$role_array[$r]."\r\n";
                $role_st.="role".$r."ids=".$role_ids[$r]."\r\n";
                $role_st.="role".$r."type=".$role_types[$r]."\r\n";
                $role_st.="role".$r."show=1\r\n";
                if ($r) {
                    $datalog_st.="group0var".($r-1)."vartype=2\r\ngroup0var".($r-1)."varval=".$r."\r\ngroup0var".($r-1)."varscale=1\r\n";
                }
            }

            /*print("<pre>");
            print($st_devices);
            //print_r($role_array);
            print($datalog_st);
            print($role_st);
            
            print("</pre>");*/
            $f_device=fopen("/config/device.ini","w");
            fwrite($f_device,$st_devices);
            fclose($f_device);
            $f_roles=fopen("/config/roles.ini","w");
            fwrite($f_roles,$role_st);
            fclose($f_roles);
            $f_datalog=fopen("/config/datalog.ini","w");
            fwrite($f_datalog,$datalog_st);
            fclose($f_datalog);
            
            
        ?>
        <h1>Success!</h1>
        Your configuration has been successfully built!  Please click the reboot button for it to take effect.
        <br>
        <strong><? print(($cur_device_id)); ?> Devices</strong> were created.<p>
        <strong><? print(sizeof($role_array)); ?> Roles</strong> were created.<p>
        
        </div>
			        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

function EZConfigWidget($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   //4028,4099,4098,4024,4023
   

   $scope.loading=0;
   $gscope=$scope;


   $scope.reboot=function() {
     document.location='/app/task.cgi?action=reboot';
   }
}
   </script>
</div> 
<? } // stage=4
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    
    
    execute(); // process the package and run the correct function    
?>






