<?
/**
 * @package PowerOne
 * @author Akash Heimlich
 * @description This file is called every second
 * @date 28-DEC-15 - fixed bug to research for inverters
 */


$num=intval($_GLOBALS['inverter_count']);

function send_message($id,$arr) {
    global $s;
    $msg=array();
    $chksum=0;
    $msg[]=0xAA;
    $msg[]=0xAA;
    $msg[]=$id;
    for ($i=0;$i<sizeof($arr);$i++) {
        $msg[]=$arr[$i];
    }
    for ($i=0;$i<sizeof($msg);$i++) {
        $chksum+=$msg[$i];
    }
    $msg[]=$chksum >> 8;
    $msg[]=$chksum & 0xFF;
    $msg[]=0x0A;
    $msg[]=0x0D;
    fwrite($s,$msg);
}

if ($_GLOBALS['powerone_init']==0) {
    if ($num<$_GLOBALS['powerone_installed_count']) {
        $_GLOBALS['powerone_error']++;
        if ($_GLOBALS['powerone_error']>=120) {
            log("Searching for PowerOne Inverters...");
            if (file_exists("/package/PowerOne.cgi")) {
                    include("/package/PowerOne.cgi");
                    if (function_exists("PowerOne_init")) {
                        call_user_func("PowerOne_init");
                    }
                }
            $_GLOBALS['powerone_error']=0;    
            $num=$_GLOBALS['inverter_count'];
        }
    }
    
    for ($i=0; $i < $_GLOBALS['inverter_count']; $i++) {
        if ($_GLOBALS['inverter'][$i]['make']=='PowerOne') {
            // enquire system work
            $_GLOBALS['pwrcntr']++;
            if ($_GLOBALS['pwrcntr']>=5) {
                $_GLOBALS['pwrcntr']=0;
                $s=f485open(9600,0);
                while (1) {
            		  $b=fread($s,1);
            		  if (!filesize($s)) break;
            	}
                
                for ($i=0;$i<sizeof($_GLOBALS['inverter']);$i++) {
                    
                    $msg=array(0,0,0,0);
                    send_message(intval($_GLOBALS['inverter'][$i]['id']),$msg);
                    $res=indexed_array(1,128);
                    $idx=0;
                    
                    while (1) {
                        $b=fread($s,1);
                        $res[$idx++]=charat($b,0);
                        if (!filesize($s)) break;
                    }
                    
                    if (($res[0]!=0xAA) || ($res[1]!=0xAA) || ($res[2]!=intval($_GLOBALS['inverter'][$i]['id']))) {
                        log("Read error on PowerOne inverter");
                        break;
                    }
                    $len=($res[5]<<8 + $res[6]);
                    
                    $chksum=0;
                    for ($c=0;$c<($idx-4);$c++) {
                        $chksum+=$res[$c];
                    }
                    $reschecksum=($res[$idx-4]<<8 + $res[$idx-3]);
                    //print("Calc checksum=".$chksum." and checksum is ".$reschecksum);
                    if ($reschecksum!=$chksum) {
                        log("Checksum error PowerOne expected checksum=".$chksum." and checksum is ".$reschecksum);
                        break;
                    }
                    $pv1_voltage=($res[7]<<8 + $res[8])/10;
                    $pv2_voltage=($res[9]<<8 + $res[10])/10;
                    $pv3_voltage=($res[11]<<8 + $res[12])/10;
                    $pv1_current=($res[13]<<8 + $res[14])/100;
                    $pv2_current=($res[15]<<8 + $res[16])/100;
                    $pv3_current=($res[17]<<8 + $res[18])/100;
                    $pv1_power=($res[19]<<24 + $res[20]<<16 + $res[21] << 8 + $res[22]);
                    $pv2_power=($res[23]<<24 + $res[24]<<16 + $res[25] << 8 + $res[26]);
                    $pv3_power=($res[27]<<24 + $res[28]<<16 + $res[29] << 8 + $res[30]);
                    $v_r=($res[35]<<8 + $res[36])/10;
                    $v_y=($res[37]<<8 + $res[38])/10;
                    $v_b=($res[39]<<8 + $res[40])/10;
                    $freq=($res[41]<<8 + $res[42])/100;
                    $a_r=($res[47]<<8 + $res[48])/100;
                    $a_y=($res[49]<<8 + $res[50])/100;
                    $a_b=($res[51]<<8 + $res[52])/100;
        //print_r($res);
                    $_GLOBALS['inverter'.$i.'v_dc1']=$pv1_voltage;
                    $_GLOBALS['inverter'.$i.'a_dc1']=$pv1_current;
                    $_GLOBALS['inverter'.$i.'w_dc1']=$pv1_power;
                    $_GLOBALS['inverter'.$i.'v_dc2']=$pv2_voltage;
                    $_GLOBALS['inverter'.$i.'a_dc2']=$pv2_current;
                    $_GLOBALS['inverter'.$i.'w_dc2']=$pv2_power;
                    $_GLOBALS['inverter'.$i.'v_dc3']=$pv3_voltage;
                    $_GLOBALS['inverter'.$i.'a_dc3']=$pv3_current;
                    $_GLOBALS['inverter'.$i.'w_dc3']=$pv3_power;
                                    
                    $_GLOBALS['inverter'.$i.'v_ac1']=$v_r;
                    $_GLOBALS['inverter'.$i.'v_ac2']=$v_y;
                    $_GLOBALS['inverter'.$i.'v_ac3']=$v_b;
                    $_GLOBALS['inverter'.$i.'a_ac1']=$a_r;
                    $_GLOBALS['inverter'.$i.'a_ac2']=$a_y;
                    $_GLOBALS['inverter'.$i.'a_ac3']=$a_b;
                    $_GLOBALS['inverter'.$i.'w_ac1']=floatval($a_r)*floatval($v_r);
                    $_GLOBALS['inverter'.$i.'w_ac2']=floatval($a_y)*floatval($v_y);
                    $_GLOBALS['inverter'.$i.'w_ac3']=floatval($a_b)*floatval($v_b);
                    $_GLOBALS['inverter'.$i.'f_ac1']=($res[45] << 8 + $res[46])/100;
                    
                    $total=$_GLOBALS['inverter'.$i.'w_ac1']+$_GLOBALS['inverter'.$i.'w_ac2']+$_GLOBALS['inverter'.$i.'w_ac3'];//($res[75]<<24 + $res[76]<<16 + $res[77] << 8 + $res[78])/10;
                    $_GLOBALS['inverter'.$i.'w_ac']=$total;
                    $_GLOBALS['inverter'.$i.'w_dc']=$pv1_power+$pv2_power+$pv3_power;
                    $_GLOBALS['inverter'.$i.'a_dc']=$pv1_current+$pv2_current;
            
        
                    if ($_GLOBALS['powerone'.$i.'cntr']) 
                        $_GLOBALS['powerone'.$i.'cntr']=30;
                    $_GLOBALS['powerone'.$i.'cntr']++;
                    
                    if ($_GLOBALS['powerone'.$i.'cntr']>=30) {
                        $msg=array(0,0x0C,0,0);
                        send_message(1,$msg);
                        $cnt=0;
                        $res=indexed_array(1,128);
                        $idx=0;
                        
                        $str="      ";
                        sleep(100);
                        while (1) {
                            $b=fread($s,1);
                            $res[$idx++]=charat($b,0);;
                            $cnt++;
                            if ($cnt>6)
                                $str=$str.$b;
                            if (!filesize($s)) 
                                break;
                        }
                        $chksum=0;
                        for ($c=0;$c<($idx-4);$c++) {
                            $chksum+=$res[$c];
                        }
                        $reschecksum=($res[$idx-4]<<8 + $res[$idx-3]);
                        //print("Calc checksum=".$chksum." and checksum is ".$reschecksum);
                        if ($reschecksum!=$chksum) {
                            log("Checksum error PowerOne Stats expected checksum=".$chksum." and checksum is ".$reschecksum);
                            break;
                        }
                        if (strlen($str)>48) {
                            $_GLOBALS['inverter'.$i.'kwh_total']=floatval(substr($str,25,7));
                            $_GLOBALS['inverter'.$i.'kwh_today']=floatval(substr($str,45,4));
                            $_GLOBALS['powerone'.$i.'cntr']=1;
                        } else {
                            log("Error reading PowerOne Stats, received ".strlen($str)." chars");
                        }
                        
                    }
                
                }  // for
            }  // cnt > 5
        } // if make is powerone
    } // for inverter
} else {
     $_GLOBALS['powerone_error']++;
     if ($_GLOBALS['powerone_error']>=120) {
         $_GLOBALS['powerone_init']=0;
         $_GLOBALS['powerone_count_installed']=ini_get("/config/DeltaRPI.ini","config","powerone_count_installed",1);
     }
}



?>






