<?
/**
 * @package PushData
 * @author Akash Heimlich
 * @description This widget will collect certain parameters at regular intervals for transfer to a server
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function PushData_install($val) {
        PushData_enable();
        return 1;
    }
     
    function PushData_uninstall() {
        setPackageStatus("PushData",0);
        return 1;
    }
    
    function PushData_enable() {
        setPackageStatus("PushData",2);
        addWidget("/package/PushData.inc","PushData",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function PushData_disable() {
        setPackageStatus("PushData",3);
        addWidget("/package/PushData.inc","PushData",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function PushData_init() {
        
        // load the test Value into the globals
        $_GLOBALS['pd_roles']=ini_get("/config/PushData.ini","config","roles","");
        $roles=explode($_GLOBALS['pd_roles'],',');
        $buffer_size=ini_get("/config/PushData.ini","config","buffer_size",60);
        $_GLOBALS['pd_int']=ini_get("/config/PushData.ini","config","interval",60);
        
        $num_roles=sizeof($roles);
        $_GLOBALS['pd_rolesize']=$num_roles;
        // index into the buffer
        $_GLOBALS['pd_bufidx']=0;
        // timestamp for next buffer item
        $_GLOBALS['pd_ts']=time();
        // create the data buffer
        $_GLOBALS['pd_buf']=array();
        for ($i=0;$i<$num_roles;$i++) {
            $_GLOBALS['pd_buf'][$i]=indexed_array(4,$buffer_size);
        }
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/PushData.cgi?action=configure';
        $arr['title']='PushData Collection';
        $arr['icon']='icon-hdd';
        $arr['desc']='PushData settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/PushDataAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/PushDataAjax.inc';

        // runs this file once a second
        if (file_exists('/package/PushDataSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/PushDataSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/PushDataMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/PushDataMin.inc';
            
        // runs this file once a day
        if (file_exists('/package/PushDataDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/PushDataDay.inc';            
        return 1;
    }
    
    function PushData_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="PushData"; 
        $title='Configure Package PushData';
        $config_file="PushData.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">PushData Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> PushData Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget is a test widget.  Put your text here. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="roles='<? print(ini_get("/config/".$config_file,$config_section,"roles","")); ?>';">
		<div ng-init="buffer_size='<? print(ini_get("/config/".$config_file,$config_section,"buffer_size",10)); ?>';">
		<div ng-init="export=<? print(ini_get("/config/".$config_file,$config_section,"export",0)); ?>;">
		<div ng-init="interval='<? print(ini_get("/config/".$config_file,$config_section,"interval",60)); ?>';">
		<div ng-init="host='<? print(ini_get("/config/".$config_file,$config_section,"host",'')); ?>';">
		<div ng-init="key='<? print(ini_get("/config/".$config_file,$config_section,"key",getmac())); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='roles'>Roles</label>
		            <div class="controls">
			            <input type='text' ng-model="roles"  name='roles' title="Enter a comma separated list of roles to log" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='buffer_size'>Buffer Size</label>
		            <div class="controls">
			            <input type='text' ng-model="buffer_size"  name='buffer_size' title="Enter number of seconds to buffer" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='interval'>Interval in S</label>
		            <div class="controls">
			            <input type='text' ng-model="interval"  name='interval' title="Enter interval to collect data at" data-rel="tooltip"> 
			        </div>
		        </div>
		         <div class="control-group">
		            <label class="control-label" for='export'>Export</label>
		            <div class="controls">
			            <input type='number' ng-model="export"  name='export' title="Select 1 to export data or 0 to just log data" data-rel="tooltip"> 
			        </div>
		        </div>
		         <div class="control-group">
		            <label class="control-label" for='key'>Key</label>
		            <div class="controls">
			            <input type='text' ng-model="key"  name='key' title="Enter a unique key for this device" data-rel="tooltip"> 
			        </div>
		        </div>
                <div class="control-group">
		            <label class="control-label" for='host'>Push URL</label>
		            <div class="controls">
			            <input type='text' ng-model="host"  name='host' title="Enter full script to path that will handle the data" data-rel="tooltip"> 
			        </div>
		        </div>		        
		        
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function PushData($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="roles="+$scope.roles+
        "&buffer_size="+$scope.buffer_size+
        "&export="+$scope.export+
        "&host="+encodeURI($scope.host)+        
        "&key="+encodeURI($scope.key)+        
        "&interval="+$scope.interval;
       post_config="PushData.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>


