<?
/**
 * @package SchedulerWidget
 * @author Akash Heimlich
 * @description The scheduler lets you control output based on times of the day, week, month and year
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Scheduler_install($val) {
        Scheduler_enable();
        return 1;
    }
     
    function Scheduler_uninstall() {
        setPackageStatus("Scheduler",0);
        return 1;
    }
    
    function Scheduler_enable() {
        setPackageStatus("Scheduler",2);
        addWidget("/package/Scheduler.inc","Scheduler",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function Scheduler_disable() {
        setPackageStatus("Scheduler",3);
        addWidget("/package/Scheduler.inc","Scheduler",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function Scheduler_init() {
        
        // load the test Value into the globals
        $_GLOBALS['testValue']=ini_get("/config/scheduler.ini","config","test","");
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/Scheduler.cgi?action=configure';
        $arr['title']='Scheduler';
        $arr['icon']='icon-time';
        $arr['desc']='Scheduler settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
/*        if (file_exists('/package/SchedulerAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/SchedulerAjax.inc';
*/

        // runs this file once a minute
        if (file_exists('/package/SchedulerMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/SchedulerMin.inc';
            
        return 1;
    }
    
    function Scheduler_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="Scheduler"; 
        $title='Configure Scheduler';
        $config_file="scheduler.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Scheduler</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Scheduler Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="addSchedule();" ><i class="icon-plus"></i> Add Schedule</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget is a test widget.  Put your text here. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-pencil"></i> Schedule List</h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content">


<table class='table table-striped' summary="Schedule List">
<tr>
<th scope="col"><a href="" ng-click="predicate = ''; reverse=!reverse">ID</a></th>
<th scope="col"><a href="" ng-click="predicate = 'name'; reverse=!reverse">Schedule Name</a></th></th>
<th scope="col"><a href="" ng-click="predicate = 'status'; reverse=!reverse">Enabled</a></th>
<th scope="col">Options</th>
</tr>
<tr ng-repeat="item in schedules | orderBy:predicate:reverse" ng-show='item.status<10'>
<td ><span class="badge badge-inverse">{{item.id}}</span></td><td><strong>{{item.name}}</strong></td><td><div ng-show='item.status>0' class="label label-success">{{isActive(item)}}</div><div ng-show='item.status==0' class="label label-failure">{{isActive(item)}}</div></td><td><div ng-hide="refresh" class="pull-right btn-group">
    <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
    Action
    <span class="caret"></span>
    </a>
    <ul class="dropdown-menu">
    <!-- dropdown menu links -->
    <li><a ng-click='edit(item.id)' href='#'><i class="icon-pencil"></i> Edit</a></li>
     <li class="divider"></li>
     <li><a ng-click='dis(item.id)' href='#'><i class="icon-remove"></i> Disable</a></li>
     <li><a ng-click='del(item.id)' href='#'><i class="icon-remove"></i> Delete</a></li>
    </ul>
    </div></td>
</tr>
</table>
<div class="clearfix"></div>    <!-- actionlist-->
					</div>
				</div>
			</div>  
			
        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function Scheduler($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.schedules=[<?
    $num_schedules=intval(nvram_get('schedule_count','0'));
    for ($i=0;$i<$num_schedules;$i++) {
        print("{id:".$i);
        print(",name:\"".nvram_get('sch'.$i.'name','')."\"");
        print(",status:".intval(nvram_get('sch'.$i.'status','0')));
        $schedule='';
        //print(",schedule:\"".$schedule."\"");
        print("}");
        if ($i<($num_schedules-1)) print(",");
    }
   
   ?>];
   $scope.loading=0;
   $gscope=$scope;
    $scope.isActive=function(item) {
      if (item.status==0) 
        return "Disabled";
      if (item.status==1) 
      return "Enabled";
    }
   $scope.addSchedule=function() {
       document.location='/package/Scheduler.cgi?action=edit&new=1';
   }
   $scope.edit=function(item) {
       document.location='/package/Scheduler.cgi?action=edit&schedule_idx='+item;
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    /**
     * Edit the schedule
     **/
    function Scheduler_edit() {
        include("/app/config.inc");
        max_execution_time(30);
        $angular_controller="ScheduleEditCtrl"; 
        $title='Schedule Settings';
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>
      <div class="row-fluid">
        <div class='span12' >    
        <?
  
  //$actions=ini_get_array("/config/actions.ini","actions");
  
 // $roles=ini_get_array("/config/roles.ini","roles");
    $schedule=array();
  $schedule_count=intval(nvram_get('schedule_count','0'));
  if ($_GET['new']==1) {
    $_GET['schedule_idx']=intval(nvram_get('schedule_count','0'));
    $schedule_count++;
    for ($i=0;$i<$_GET['schedule_idx'];$i++) {
        if (intval(nvram_get('sch'.$i.'enabled','0'))==2) {  // deleted
            $_GET['schedule_idx']=$i;
            break;
        }
    }
    $idx=$_GET['schedule_idx'];
    $schedule['sch'+$idx+'name']='New Schedule';
    $schedule['sch'+$idx+'h']='0';
    $schedule['sch'+$idx+'m']='';
    $schedule['sch'+$idx+'min']='0';
    $schedule['sch'+$idx+'status']=1;
    $schedule['sch'+$idx+'d']='';
    $schedule['sch'+$idx+'wd']='';
    $schedule['sch'+$idx+'type']=0;
    $schedule['sch'+$idx+'val']=0;
    $schedule['sch'+$idx+'stval']='';
  } else {
    $idx=$_GET['schedule_idx'];
    $schedule['sch'+$idx+'name']=nvram_get('sch'.$idx.'name','');
    $schedule['sch'+$idx+'h']=intval(nvram_get('sch'.$idx.'h','0'));
    $schedule['sch'+$idx+'m']=nvram_get('sch'.$idx.'m','');
    $schedule['sch'+$idx+'min']=intval(nvram_get('sch'.$idx.'min','0'));
    $schedule['sch'+$idx+'status']=intval(nvram_get('sch'.$idx.'status','0'));
    $schedule['sch'+$idx+'d']=nvram_get('sch'.$idx.'d','');
    $schedule['sch'+$idx+'wd']=nvram_get('sch'.$idx.'wd','');
    $schedule['sch'+$idx+'type']=intval(nvram_get('sch'.$idx.'type','0'));
    $schedule['sch'+$idx+'val']=intval(nvram_get('sch'.$idx.'val','0'));
    $schedule['sch'+$idx+'stval']=(nvram_get('sch'.$idx.'stval',''));
  }
  //$idx=$_GET['schedule_idx'];
  
  //print_r($schedule);die();
?>

        <ul class="breadcrumb">
  <li><a href="/">Home</a> <span class="divider">/</span></li>
  <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
  <li><a href="/package/Scheduler.cgi?action=configure">Scheduler</a> <span class="divider">/</span></li>
  <li class="active">Configure Schedule</li>
</ul>
<form name="form" class="css-form" novalidate>
<div class="page-header">
  <h1><i class="icon-wrench"></i> Configure Schedule <small> <? print($schedule['sch'+$idx+'name']); ?></small></h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'>
                    <button class="btn btn-primary btn-large pull-right" ng-click="form.$pristine=true;saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/package/Scheduler.cgi?action=configure';"><i class="icon-remove"></i> Close</button>
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                    
                    
                    
                </div>
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'><h4>Configuring a schedule</h4>Configure your schedule here in order for it to be usable by WattMon.<br>
Schedules let you plan actions at particular times and dates. <br><br>
<h4>Months</h4>If you want to restrict a schedule to a particular month or range of months, select the months in the list.  Otherwise, select all or none to activate the
schedule for every month.
<h4>Weekdays</h4>
If you wish to only activate the schedule on particular days of the week, select them in this area, otherwise just leave it fully checked to enable the action on every day of the week.
<h4>Days</h4>
If you wish to only execute the action on particular days of the month, select the days here.  This will override the weekdays option, so if you only select
for example the 1st and 5th of a month, and you check all the weekdays, it will still only work on those two days.  However, if you select for example the 1st and 5th
and in the weekdays only select Monday and Wednesday, it will only activate the action when the 1st or 5th falls on a Monday or Wednesday.
<h4>Time</h4>
You can only active a scheduled action at a fixed time, enter the hours (0-23) and minutes (0-59) here.
<h4>Action</h4>
The action to be executed must be configured in the Actions manager and must be set to 'Manually Triggered' as the type.</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg && form.$pristine"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

                
            
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>


<div ng-init="schedule_index=<? print($_GET['schedule_idx']); ?>;"></div>
<div ng-init="schedule_id=<? print($idx); ?>;"></div>
<div ng-init="schedule_name='<? print($schedule['sch'+$idx+'name']); ?>';"></div>
<div ng-init="schedule_status=<? $stat=$schedule['sch'+$idx+'status'];print($stat); ?>;"></div>
<div ng-init="schedule_m='<? print($schedule['sch'+$idx+'m']); ?>';"></div>
<? 
$m=strval($schedule['sch'+$idx+'m']);
if (strlen($m)) {
    $m_arr=explode($m,',');
} else $m_arr=array(1,2,3,4,5,6,7,8,9,10,11,12);
//print_r($m_arr);
$k_arr=array_keys($m_arr);
$numact=sizeof($m_arr);
for ($i=0;$i<$numact;$i++) {
    print('\r\n<div ng-init="user.m_arr.push('.$m_arr[$k_arr[$i]].')"></div>');
} 
?>
<div ng-init="schedule_d='<? print($schedule['sch'+$idx+'d']); ?>';"></div>
<? 
$m=strval($schedule['sch'+$idx+'d']);
if (strlen($m)) {
    $m_arr=explode($m,',');
} else {
    
    $m_arr=array();
    for ($i=1;$i<32;$i++) $m_arr[$i]=$i;
}
//print_r($m_arr);
$k_arr=array_keys($m_arr);
$numact=sizeof($m_arr);
for ($i=0;$i<$numact;$i++) {
    print('\r\n<div ng-init="user.d_arr.push('.$m_arr[$k_arr[$i]].')"></div>');
} 
?>
<div ng-init="schedule_wd='<? print($schedule['sch'+$idx+'wd']); ?>';"></div>
<? 
$m=strval($schedule['sch'+$idx+'wd']);
if (strlen($m)) {
    $m_arr=explode($m,',');
} else $m_arr=array(1,2,3,4,5,6,7);
//print_r($m_arr);
$k_arr=array_keys($m_arr);
$numact=sizeof($m_arr);
for ($i=0;$i<$numact;$i++) {
    print('\r\n<div ng-init="user.dow_arr.push('.$m_arr[$k_arr[$i]].')"></div>');
} 
?>
<div ng-init="schedule_h=<? print($schedule['sch'+$idx+'h']); ?>;"></div>
<div ng-init="schedule_min=<? print($schedule['sch'+$idx+'min']); ?>;"></div>
<div ng-init="schedule_type=<? print($schedule['sch'+$idx+'type']); ?>;"></div>
<div ng-init="schedule_val=<? print($schedule['sch'+$idx+'val']); ?>;"></div>
<div ng-init="schedule_stval='<? print($schedule['sch'+$idx+'stval']); ?>';"></div>
<? 
$numact=ini_get("/config/actions.ini","actions",'num_actions',0);
for ($i=0;$i<$numact;$i++) {
    $atype=ini_get("/config/actions.ini","actions",'a'.$i.'status',0);
    if ($atype==5) { // manually triggered
        print('\r\n<div ng-init="actions.push({id:'+$i+',name:\''.htmlspecialchars(ini_get("/config/actions.ini","actions",'a'.$i.'name',''))+'\'})"></div>');
    }
}  
//die();
?>

<div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-pencil"></i> <? print($title); ?> </h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
						</div>
					</div>
					<div class="box-content">
					
 <div class="row-fluid">
        <div class='span2' >
            Schedule Name</div>
        <div class='span6'><input class="span12" type='text' ng-model="schedule_name" name='schedule_name' ng-maxlength="32" required></div>
        <div  class='span3'> <div ng-cloak class='alert alert-block' ng-show="form.schedule_name.$invalid">This name is invalid, either too short or too long (max 32 chars)</div></div>
 </div>
 <div class="row-fluid">
        <div class='span2' >
            Status</div>
        <div class='span6'><input type="radio" ng-model="schedule_status" value="0">  Disabled <br/> <input type="radio" ng-model="schedule_status" value="1">  Enabled <br/></div>
        <div  class='span3'> </div>
 </div>
 <h4>Schedule Month</h4>
  <div class="row-fluid" ng-cloak>
        <div class='span2' >        
            When</div>
            <div class='span6'>
               <label ng-repeat="month in months">
                  <input type="checkbox" checklist-model="user.m_arr" checklist-value="month.id"> {{month.text}}
                </label>
                <button ng-click="mcheckAll()" style="margin-right: 10px">Check all</button>
                <button ng-click="muncheckAll()" style="margin-right: 10px">Uncheck all</button>
                <button ng-click="mcheckFirst()">Check first</button>
            </div>
<div  class='span3'></div>
 </div>
 
  <h4>Schedule Weekday</h4>
  <div class="row-fluid" ng-cloak>
        <div class='span2' >        
            Days</div>
            <div class='span6'>
               <label ng-repeat="dow in weekdays">
                  <input type="checkbox" checklist-model="user.dow_arr" checklist-value="dow.id"> {{dow.text}}
                </label>
                <button ng-click="dowcheckAll()" style="margin-right: 10px">Check all</button>
                <button ng-click="dowuncheckAll()" style="margin-right: 10px">Uncheck all</button>
                <button ng-click="dowcheckFirst()">Check first</button>
            </div>
<div  class='span3'></div>
 </div>

<h4>Schedule Days</h4>
  <div class="row-fluid" ng-cloak>
        <div class='span2' >        
            Month days</div>
            <div class='span6'>
               <div class='row'>
                  <div class='span2' style='margin-left:0px;' ng-repeat="day in days">
                   <input type="checkbox" checklist-model="user.d_arr" checklist-value="day.id"> {{day.text}}
                  </div>
                 </div>
                <button ng-click="dcheckAll()" style="margin-right: 10px">Check all</button>
                <button ng-click="duncheckAll()" style="margin-right: 10px">Uncheck all</button>
                <button ng-click="dcheckFirst()">Check first</button>
            </div>
<div  class='span3'></div>
 </div>
 <h4>Schedule Time</h4>
 <div class="row-fluid" ng-cloak>
        <div class='span2' >
            At time</div>
        <div class='span6'><span style='display:inline;clear:none!important'><input class='input-xsmall' style='width:100px' size=4 type='number' min=0 max=23 ng-model="schedule_h"  name='schedule_h' required></span>:
        <span style='display:inline;clear:none!important'><input class='input-xsmall' size=4 type='number'  style='width:100px'  min=0 max=59 ng-model="schedule_min"  name='schedule_min' required></span></div>
        <div class='span1'>(HH:MM)</div>
        <div  class='span3'> <div ng-cloak class='alert alert-block' ng-show="form.schedule_h.$invalid">Enter a valid hour</div></div>
 </div>
 <h4>Action Type</h4>
 <div class="row-fluid">
        <div class='span2' >
            Scheduled Action</div>
        <div class='span6'><input type="radio" ng-model="schedule_type" value="0">  Execute an Action <br/> <input type="radio" ng-model="schedule_type" value="1">  Run a script <br/></div>
        <div  class='span3'> </div>
 </div>
 <div ng-cloak ng-show='schedule_type==0'>
 <h4>Action to Execute</h4>
 <div class="row-fluid" ng-cloak>
        <div class='span2' >
            Action</div>
        <div class='span7'>
        <select ng-model="schedule_val" ng-options="act.id as act.name for act in actions">
        </select>
        </div>
        <div  class='span3'></div>
 </div>
 </div>
 <div ng-cloak ng-show='schedule_type==1'>
 <h4>Script to Execute</h4>
 <div class="row-fluid" ng-cloak>
        <div class='span2' >
            Script</div>
        <div class='span7'>
        <div class="input-group">
                    
                    
                    <input type="text" class="form-control" ng-model="schedule_stval">
                      <div class="pull-right btn-group"><a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
    Select Script
    <span class="caret"></span>
    </a>
    <ul class="dropdown-menu">
    <li ng-repeat="script in scripts" class="input-lg"><a href="#" ng-click="changeScript(script)">{{script.desc}}</a></li>
    </ul></div>
    
                </div>
        </div>
        <div  class='span3'></div>
 </div>
 </div>
 <div class="clearfix"></div>
					</div>
				</div>
			</div>  
   
			
  </select>
<!--<div class="alert alert-success" ng-cloak ng-show="successmsg && form.$pristine"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{successmsg}}</div><div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<br>
<button class="btn btn-primary btn-large" ng-click="form.$pristine=true;saveSettings()"
ng-disabled="form.$invalid">Update Settings</button>  <button class="btn btn-large" onclick="document.location='/app/actions.cgi';" >Close</button>  -->
</form>

        </div><!--/span-->
      </div><!--/row-->


    <script>
    var gItems,gHttp;
var count=0;

/**
 * Checklist-model
 * AngularJS directive for list of checkboxes
 */

angular.module('checklist-model', [])
.directive('checklistModel', ['$parse', '$compile', function($parse, $compile) {
  // contains
  function contains(arr, item) {
    if (angular.isArray(arr)) {
      for (var i = 0; i < arr.length; i++) {
        if (angular.equals(arr[i], item)) {
          return true;
        }
      }
    }
    return false;
  }

  // add
  function add(arr, item) {
    arr = angular.isArray(arr) ? arr : [];
    for (var i = 0; i < arr.length; i++) {
      if (angular.equals(arr[i], item)) {
        return arr;
      }
    }    
    arr.push(item);
    return arr;
  }  

  // remove
  function remove(arr, item) {
    if (angular.isArray(arr)) {
      for (var i = 0; i < arr.length; i++) {
        if (angular.equals(arr[i], item)) {
          arr.splice(i, 1);
          break;
        }
      }
    }
    return arr;
  }

  // http://stackoverflow.com/a/19228302/1458162
  function postLinkFn(scope, elem, attrs) {
    // compile with `ng-model` pointing to `checked`
    $compile(elem)(scope);

    // getter / setter for original model
    var getter = $parse(attrs.checklistModel);
    var setter = getter.assign;

    // value added to list
    var value = $parse(attrs.checklistValue)(scope.$parent);

    // watch UI checked change
    scope.$watch('checked', function(newValue, oldValue) {
      if (newValue === oldValue) { 
        return;
      } 
      var current = getter(scope.$parent);
      if (newValue === true) {
        setter(scope.$parent, add(current, value));
      } else {
        setter(scope.$parent, remove(current, value));
      }
    });

    // watch original model change
    scope.$parent.$watch(attrs.checklistModel, function(newArr, oldArr) {
      scope.checked = contains(newArr, value);
    }, true);
  }

  return {
    restrict: 'A',
    priority: 1000,
    terminal: true,
    scope: true,
    compile: function(tElement, tAttrs) {
      if (tElement[0].tagName !== 'INPUT' || !tElement.attr('type', 'checkbox')) {
        throw 'checklist-model should be applied to `input[type="checkbox"]`.';
      }

      if (!tAttrs.checklistValue) {
        throw 'You should provide `checklist-value`.';
      }

      // exclude recursion
      tElement.removeAttr('checklist-model');
      
      // local scope var storing individual checkbox model
      tElement.attr('ng-model', 'checked');

      return postLinkFn;
    }
  };
}]);

var app = angular.module('myApp', ["checklist-model"]);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/dev_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});



function ScheduleEditCtrl(dataService,$scope, $timeout,$http ) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  $scope.conditions = [];
  $scope.actions = [{id:-1,name:"Select action"}];
  $scope.infomsg="";
  function swapElement(array, indexA, indexB) {
     var tmp = array[indexA];
    array[indexA] = array[indexB];
    array[indexB] = tmp;
  }
  
  $scope.days=[];
  for (i=1;i<32;i++) { 
    $scope.days.push({id:i,text:i}); 
    }
  $scope.months = [
    {id: 1, text: 'Jan'},
    {id: 2, text: 'Feb'},
    {id: 3, text: 'Mar'},
    {id: 4, text: 'Apr'},
    {id: 5, text: 'May'},
    {id: 6, text: 'Jun'},
    {id: 7, text: 'Jul'},
    {id: 8, text: 'Aug'},
    {id: 9, text: 'Sep'},
    {id: 10, text: 'Oct'},
    {id: 11, text: 'Nov'},
    {id: 12, text: 'Dec'}
  ];
  $scope.weekdays = [
    {id: 1, text: 'Sun'},
    {id: 2, text: 'Mon'},
    {id: 3, text: 'Tue'},
    {id: 4, text: 'Wed'},
    {id: 5, text: 'Thu'},
    {id: 6, text: 'Fri'},
    {id: 7, text: 'Sat'}
    ];
  $scope.user= {m_arr : [], dow_arr:[], d_arr:[]};
  
  $scope.scripts=[<?
  if (!chdir('/scripts/user')) {
    $arr=findfirst("*.cgi",255-8);
    
    while ($arr) {
        $blank=1;    
        if (!($arr['attributes'] & 16)) {  // not a directory
            if (strpos($arr['filename'],'.cgi')) {
                print("{");
                print('name:"');
                print('/scripts/user'."/".$arr['filename']);
                $desc=$arr['filename'];
                $ini="/scripts/user/".(substr($arr['filename'],0,strrpos($arr['filename'],'.'))).".ini";
                //print($ini);
                if (file_exists($ini)) {
                    //print("File exists");
                    $desc=ini_get($ini,"script","description",$arr['filename']);
                }
                print('",desc:"'.$desc.'"}');
                $blank=0;
            }
        }
        $arr=findnext();
        if (!$blank)
            if ($arr) print(",");
    }
  } 
  ?>];
  
  $scope.changeScript=function(scriptName) {
    $scope.schedule_stval=scriptName.name;
  }
  $scope.mcheckAll = function() {
    $scope.user.m_arr = $scope.months.map(function(item) { return item.id; });
  };
  $scope.muncheckAll = function() {
    $scope.user.m_arr = [];
  };
  $scope.mcheckFirst = function() {
    $scope.user.m_arr.splice(0, $scope.user.m_arr.length); 
    $scope.user.m_arr.push(1);
  };

  $scope.dcheckAll = function() {
    $scope.user.d_arr = $scope.days.map(function(item) { return item.id; });
  };
  $scope.duncheckAll = function() {
    $scope.user.d_arr = [];
  };
  $scope.dcheckFirst = function() {
    $scope.user.d_arr.splice(0, $scope.user.d_arr.length); 
    $scope.user.d_arr.push(1);
  };
  
  $scope.dowcheckAll = function() {
    $scope.user.dow_arr = $scope.weekdays.map(function(item) { return item.id; });
  };
  $scope.dowuncheckAll = function() {
    $scope.user.dow_arr = [];
  };
  $scope.dowcheckFirst = function() {
    $scope.user.dow_arr.splice(0, $scope.user.dow_arr.length); 
    $scope.user.dow_arr.push(1);
  };
  
 
 
   $scope.saveSettings=function () {
      if ($scope.schedule_val==-1) {
         
         $scope.errormsg="Select an action.  If no actions are available, you first need to create a manually triggered action for this schedule";
         return;
         
      }
      
      $scope.successmsg="";
      $scope.errormsg="";  $scope.infomsg="";
      
      m='';
      for (i=0;i<$scope.user.m_arr.length;i++) {
        m=m+$scope.user.m_arr[i];
        if (i<$scope.user.m_arr.length-1) m=m+","
      }
        d='';
      for (i=0;i<$scope.user.d_arr.length;i++) {
        d=d+$scope.user.d_arr[i];
        if (i<$scope.user.d_arr.length-1) d=d+","
      }
        
        wd='';
      for (i=0;i<$scope.user.dow_arr.length;i++) {
        wd=wd+$scope.user.dow_arr[i];
        if (i<$scope.user.dow_arr.length-1) wd=wd+","
      }

//      astr="&sch<? print($idx); ?>type=0";
      astr="schedule_count="+<? print($schedule_count); ?>;
      astr+="&sch<? print($idx); ?>name="+encodeURIComponent($scope.schedule_name);
      astr+="&sch<? print($idx); ?>stval="+encodeURIComponent($scope.schedule_stval);
      astr+="&sch<? print($idx); ?>type="+$scope.schedule_type;
      astr+="&sch<? print($idx); ?>val="+$scope.schedule_val;
      astr+="&sch<? print($idx); ?>h="+($scope.schedule_h);
      astr+="&sch<? print($idx); ?>min="+($scope.schedule_min);
      astr+="&sch<? print($idx); ?>wd="+wd;
      astr+="&sch<? print($idx); ?>d="+d;
      astr+="&sch<? print($idx); ?>m="+m;
      astr+="&sch<? print($idx); ?>status="+$scope.schedule_status;

      //alert(astr);
      //return;
      $http.post("/app/configsavenv.cgi",astr)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          if (data.status)
            $scope.successmsg="Settings saved.";
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}
//);
//app.ItemListCtrl.$inject=['$defer'];

</script>
<? include("/app/footer.inc"); ?>
<script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    
    execute(); // process the package and run the correct function
     
?>

