<?
/**
 * @package SiteInfo
 * @author Akash Heimlich
 * @description This dummy widget shows the basic functionality of widgets and can be used as a starting point
 * for further development
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function SiteInfo_install($val) {
        SiteInfo_enable();
        return 1;
    }
     
    function SiteInfo_uninstall() {
        setPackageStatus("SiteInfo",0);
        return 1;
    }
    
    function SiteInfo_enable() {
        setPackageStatus("SiteInfo",2);
        addWidget("/package/SiteInfo.inc","SiteInfo",12,"none",1,0); // enable
        return 1;
    }
    
    function SiteInfo_disable() {
        setPackageStatus("SiteInfo",3);
        addWidget("/package/SiteInfo.inc","SiteInfo",12,"none",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function SiteInfo_init() {
        
        // load the test Value into the globals
        //$_GLOBALS['testValue']=ini_get("/config/TestWidget.ini","config","test","");
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/SiteInfo.cgi?action=configure';
        $arr['title']='Site Information';
        $arr['icon']='icon-hdd';
        $arr['desc']='Site Info settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        //if (file_exists('/package/TestWidgetAjax.inc')) 
         //   $_GLOBALS['hooks']['ajax'][]='/package/TestWidgetAjax.inc';

        // runs this file once a second
        //if (file_exists('/package/TestWidgetSec.inc')) 
            //$_GLOBALS['hooks']['sec'][]='/package/TestWidgetSec.inc';
            
        // runs this file once a minute
        //if (file_exists('/package/TestWidgetMin.inc')) 
            //$_GLOBALS['hooks']['min'][]='/package/TestWidgetMin.inc';
            
        // runs this file once a day
        //if (file_exists('/package/TestWidgetDay.inc')) 
            //$_GLOBALS['hooks']['sec'][]='/package/TestWidgetDay.inc';            
        return 1;
    }
    
    function SiteInfo_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="SiteInfo"; 
        $title='Site Information';
        $config_file="SiteInfo.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">Site Information</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> Site Info Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure Site Info here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This lets you configure your site parameters such as serial number, kW installed, etc <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Site Information</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="site_name='<? print(ini_get("/config/".$config_file,$config_section,"site_name","")); ?>';">
		<div ng-init="serial_number='<? print(ini_get("/config/".$config_file,$config_section,"serial_number","")); ?>';">
		<div ng-init="date_installed='<? print(ini_get("/config/".$config_file,$config_section,"date_installed","")); ?>';">
		<div ng-init="location='<? print(ini_get("/config/".$config_file,$config_section,"location","")); ?>';">
		<div ng-init="kw_solar='<? print(ini_get("/config/".$config_file,$config_section,"kw_solar","")); ?>';">
		<div ng-init="kw_inverter='<? print(ini_get("/config/".$config_file,$config_section,"kw_inverter","")); ?>';">
		<div ng-init="comments='<? print(ini_get("/config/".$config_file,$config_section,"comments","")); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='site_name'>Site Name</label>
		            <div class="controls">
			            <input type='text' ng-model="site_name"  name='site_name' title="Enter a name for the site" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='serial_number'>Serial Number</label>
		            <div class="controls">
			            <input type='text' ng-model="serial_number"  name='serial_number' title="Enter a serial number for the site" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='date_installed'>Date Installed</label>
		            <div class="controls">
			            <input type='text' ng-model="date_installed"  name='date_installed' title="Enter the date of installation" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='location'>Location</label>
		            <div class="controls">
			            <input type='text' ng-model="location"  name='location' title="Enter a location for the site" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='kw_solar'>Installed kW Solar</label>
		            <div class="controls">
			            <input type='text' ng-model="kw_solar"  name='kw_solar' title="Enter the solar installed capacity" data-rel="tooltip"> 
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='kw_inverter'>Installed Inverter kW</label>
		            <div class="controls">
			            <input type='text' ng-model="kw_inverter"  name='kw_inverter' title="Enter the inverter rating in kW" data-rel="tooltip"> 
			        </div>
		        </div>
		        <div class="control-group">
		            <label class="control-label" for='comments'>Comments</label>
		            <div class="controls">
			            <input type='text' ng-model="comments"  name='comments' title="Enter any comments" data-rel="tooltip"> 
			        </div>
		        </div>
		        
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
      </div>
      </div>
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function SiteInfo($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="comments="+$scope.comments+
            "&kw_inverter="+$scope.kw_inverter+
            "&kw_solar="+$scope.kw_solar+
            "&location="+$scope.location+
            "&date_installed="+$scope.date_installed+
            "&serial_number="+$scope.serial_number+
            "&site_name="+$scope.site_name;            
       post_config="SiteInfo.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>



