<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : firmware.cgi
 * 
 *  Description: Firmware upload page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      20/06/18    v2.0    WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
if ($_GET['exec']=='1') {
    if ($_GET['action']=='firmwareupdate') {
        
        nvram_backup($prefix."/nvram.dat");
        firmwareupdate();
    }
}

$angular_controller="FirmwareCtrl"; 
$title='Firmware Update';
$bodyid="rootscope";
include("/app/header.inc");
if ($_SERVER['HW_PLATFORM']<11) { 
    $prefix='';
} else $prefix='0:';

?>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','firmware')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-suitcase"></i> <? print(lang('PAGE_TITLE','firmware')) ?></h4>
<ul class="nav justify-content-end">
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i></div>
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','firmware')) ?><br>
    <? print(lang('HELP2','firmware')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-success" ng-cloak ng-show="infomsg"> <button type="button" class="close" ng-click='infomsg=""'>&times;</button>{{infomsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="scanning"> Scanning: <div class="progress"><div class="progress-bar" style="width: {{scanpercent}}%;"></div></div></div>

<!-- VARIABLES -->

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('UPDATE_TITLE','firmware')) ?></h5>
        <p class="card-text">    
The firmware updater tool takes a .HEX file from your local file system and uploads it to the Wattmon device.  To obtain the latest firmware, go to <a href='http://www.wattmon.com/downloads/' target='_blank'>Wattmon.com</a> and download the link in the Firmware section.
    <br>Next, unzip this onto your local machine and then select the file in the area below.  <br>Please wait while the file uploads, this could take up to a minute or more depending on the bandwidth.  Once the file is uploaded the wattmon device
    will reboot and the new firmware will be installed.
<div ng-show='loading==0'><div id='fileadd' ng-non-bindable >
Select HEX File: <input ng-non-bindable type="file" id="files" name="files"/></div><br></div>

<div ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i> Uploading, please wait...</div>

<br>
Do you want to download a file from wattmon.com instead?  <a title='Open download manager' class='btn btn-outline' href='/app/firmwareman.cgi'>Firmware Manager</a><br>
<script>
  var thePath="<? print($_GET['dir']); ?>";
  $gscope=0;
  function handleFileSelect(evt) {
    var f= evt.target.files[0]; // FileList object
    typest=(f.type.length>0)?f.type:f.name;
    
    if (!typest.match(/hex/gi)) {
        alert('Please select a hex file. '+typest);
        return 0;
      }
      var reader = new FileReader();
      scope = angular.element(document.getElementById('rootscope')).scope();
      scope.$apply(function() {
            scope.setLoading(1);
      }); 
      // Closure to capture the file information.
      reader.onload = (function(theFile) {
        return function(e) {
              $.ajax({
                type: "PUT",
<?  if ($_SERVER['HW_PLATFORM']<8) { ?>                
                url: "/image.hex",
<? } else { 
    if ($_SERVER['HW_PLATFORM']==11) {?>
                url: "<? print($prefix); ?>/image2.hex",
<? } else if ($_SERVER['HW_PLATFORM']>=20) {?>
                url: "../<? print($prefix); ?>/imageu.hex",
<? } else { ?>
                url: "<? print($prefix); ?>/imagez.hex",
<? }
}
?>
                data: e.target.result,
                dataType: "html"
                }).done(function( msg ) {
                    scope.$apply(function() {
                        scope.setLoading(0);
                    });
                    if (msg=="OK") {
                        alert("Upload of file successful!  Click OK to reboot the device.");
                        document.location="/app/task.cgi?action=firmware&exec=1";
                    } else alert("File upload failed.  Error returned: "+msg);
                });
        };
      })(f);

      // Read in the image file as a data URL.
      reader.readAsDataURL(f);
    
  }

  document.getElementById('files').addEventListener('change', handleFileSelect, false);
</script>
            </p>
          </div><!--/span-->
      </div><!--/row-->
  <script>
var app = angular.module('myApp', []);
 function FirmwareCtrl($scope,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.setLoading=function(val) {
    $scope.loading=val;
   }
 }
</script>
<? include("/app/footer.inc"); ?>






