<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : firmwareman.cgi
 * 
 *  Description: Firmware manager page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, coay, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * 						18/04/16    added version number
 *                      25/04/16    added md5 checking
 *                      15/03/17    added Mega support
 *                      20/06/18    WattmonOS 3
 *                      06/03/19    M2 Support
 ********************************************************************/
include("/app/config.inc");


$bodyid="rootscope";
$angular_controller="FirmwareCtrl"; 
$title='Firmware Updater';
include("/app/header.inc");
$cat=$_GET['cat'];

$ota_enabled=ini_get("/config/ota.ini","config","ota_enabled",0);

if (!$cat) $cat=4;
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','firmwareman')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-suitcase"></i> <? print(lang('PAGE_TITLE','firmwareman')) ?> - HTTP Mode</h4>
<ul class="nav justify-content-end">
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i></div>
  <li class="nav-item">
    <a class="btn btn-primary" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>

  </li>
<? if (!$_GET['beta']) { ?>
  <li class="nav-item">
    <a class="btn btn-primary" href="/app/firmwareman.cgi?beta=1" role="button" aria-expanded="false" aria-controls="collapseExample">
    Beta Channel
  </a>
  </li>
</ul>
<? } else { ?>
  <li class="nav-item">
    <a class="btn btn-primary" href="/app/firmwareman.cgi" role="button" aria-expanded="false" aria-controls="collapseExample">
    Release Channel
  </a>
  </li>
</ul>

<? } ?>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','firmwareman')) ?><br>
    <? print(lang('HELP2','firmwareman')) ?><br>
    <? print(lang('HELP3','firmwareman')) ?><br>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-success" ng-cloak ng-show="infomsg"> <button type="button" class="close" ng-click='infomsg=""'>&times;</button>{{infomsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="scanning"> Scanning: <div class="progress"><div class="progress-bar" style="width: {{scanpercent}}%;"></div></div></div>
<? if ($_GET['action']=='untar') { print("<div ng-init='infomsg=\"Untarring the file, please wait...\";'></div><div ng-init='loading=1;'></div><div ng-init='msg=\"Untarring file "+$_GET['filename']+"\";'></div>"); } 
if ($_GET['action']=='error') { print("<div ng-init='infomsg=\"".$_GLOBALS['errormsg']."\";'></div>"); } 
?>  
<div ng-cloak ng-show='loading==1'><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i> {{msg}} <progress min="0" max="100" value="0">0% complete</progress></div>
<? if ($_GET['action']=='untar') { 
    print("<div><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i> The firmware image is being uncompressed now.  ");
    print("The device will reboot automatically in about 30 seconds. </div>");
    flush();
} ?>

<!-- VARIABLES -->
<script>
  var thePath="<? print($_GET['dir']); ?>";
</script>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('UPDATE_TITLE','firmwareman')) ?></h5>
        <p class="card-text">    
            <div class="alert alert-info">Your current firmware version is <? print($_GLOBALS['VERMAJOR'].".".$_GLOBALS['VERMINOR']); ?>.  <a href='/changelog.txt' target='_blank'>View the change log.</a></div>

            <table ng-cloak class='table table-striped' summary="File List">
            <tr>
            <th scope="col"></th>
            <th scope="col"><a href="" ng-click="predicate = 'id'; reverse=!reverse">ID</a></th></th>
            <th scope="col"><a href="" ng-click="predicate = 'title'; reverse=!reverse">Name</a></th>
            <th scope="col"><a href="" ng-click="predicate = 'version'; reverse=!reverse">Version</a></th>
            <th scope="col"><a href="" ng-click="predicate = 'filesize'; reverse=!reverse">Size</a></th>
            <th scope="col"><a href="" ng-click="predicate = 'date'; reverse=!reverse">Date</a></th>
            <th scope="col">Options</th>
            </tr>
            <tr ng-repeat="item in files | orderBy:predicate:reverse">
            <td></td><td><span class="badge badge-pill badge-dark">{{item.id}}</span></td><td><strong>{{item.title}}</strong><br><div ng-bind-html-unsafe="item.description"></div>MD5: {{item.md5}}</td><td>{{item.version}}</td><td>{{item.filesize}}</td><td>{{item.date}}</td>
                <td><a class="btn btn-small btn-outline" ng-show='loading==0' ng-click="confirmInstall(item);" href="#">Install</a><? if ($ota_enabled) { ?> <a class="btn btn-small btn-outline" ng-show='loading==0' ng-click="confirmOTA(item);" href="#">Schedule Install</a><? } ?></td>
            </tr>
            </tr>
            </table>
Do you want to upload a file from your computer instead?  <a title='Upload a hex file from your computer' class='btn btn-outline' href='/app/firmware.cgi'>Upload File</a><br>
        </p>
    </div>
</div>
    

     

    
    
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>{{question}}</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">Continue</button>
      </div>
    </div>
  </div>
</div>

  <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function FirmwareCtrl($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.setLoading=function(val) {
    $scope.loading=val;
   }
$scope.reverse=1;
$scope.predicate='id';
$scope.files=[];
$scope.pkgVersion="<? print($_GLOBALS['VERMAJOR']+"."+$_GLOBALS["VERMINOR"]); ?>";

 $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  
  $scope.doModal=function() {
      if ($scope.action==1) {
        $('#myModal').modal('hide');
          $scope.startUpdate($scope.filename);
      }
      if ($scope.action==2) {
        $('#myModal').modal('hide');
          document.location="/app/ota.cgi?action=force&filename="+$scope.filename+"&version="+$scope.version+"&filesize="+$scope.filesize+"&md5="+$scope.md5;
      } 
  }
  
    $scope.confirmInstall=function(item) {
        $scope.filename=item.filename;
        $scope.action=1;
        if (Number($scope.pkgVersion)>Number(item.version)) {
                $scope.question="You have chosen to install an older version of the current firmware.  Are you sure you want to downgrade the firmware? ";
        } else if ($scope.pkgVersion==item.version) {
                $scope.question="Your already installed this version of the firmware ("+$scope.pkgVersion+").  Are you sure you want to re-install this firmware? ";
        } else {
                $scope.question="You are about to upgrade system firmware from version "+$scope.pkgVersion+" to version "+item.version+".  Are you sure you want to continue? ";
        }
        $('#myModal').modal('show');
    }
    
    $scope.confirmOTA=function(item) {
        $scope.filename=item.filename;
        $scope.md5=item.md5;
        $scope.filesize=item.filesize;
        $scope.version=item.version;
        $scope.action=2;
        if (Number($scope.pkgVersion)>Number(item.version)) {
                $scope.question="You have chosen to install an older version of the current firmware.  Are you sure you want to downgrade the firmware?  This will happen in the background. ";
        } else if ($scope.pkgVersion==item.version) {
                $scope.question="Your already installed this version of the firmware ("+$scope.pkgVersion+").  Are you sure you want to schedule a re-install this firmware? ";
        } else {
                $scope.question="You are about to schedule an upgrade of system firmware from version "+$scope.pkgVersion+" to version "+item.version+".  Are you sure you want to continue? ";
        }
        $('#myModal').modal('show');
    }
    
    
  function poll(){
  
   var x = new XMLHttpRequest();
<? if ($_SERVER['HW_PLATFORM']<8) { ?>
        x.open('GET', 'http://www.wattmon.com/live/updater.php?action=list&cat=1', true);
<? } else { 
    if ((($_SERVER['HW_PLATFORM']>=8) && ($_SERVER['HW_PLATFORM']<=10)) || 
        ($_SERVER['HW_PLATFORM']==12)) { ?>
        <? if ($_GET['beta'])  { ?>
            x.open('GET', 'http://www.wattmon.com/live/updater.php?action=list&cat=14', true);
        <? } else { ?>
            x.open('GET', 'http://www.wattmon.com/live/updater.php?action=list&cat=8', true);
        <? } ?>
<?   } else if ($_SERVER['HW_PLATFORM']==20 || $_SERVER['HW_PLATFORM']==21 || $_SERVER['HW_PLATFORM']==22) { ?> 
        x.open('GET', 'http://www.wattmon.com/live/updater.php?action=list&cat=13', true);
<?   } else { ?>
        x.open('GET', 'http://www.wattmon.com/live/updater.php?action=list&cat=9', true);
<?  }

 } 
 ?>
        x.onload=function() {
            var jsonlist = eval("(" + x.response + ")");
            //alert(jsonlist.files.length);
            $scope.$apply(function() {
                $scope.files=jsonlist.files;
            });
        }
        x.send();
      //$scope.asyncData = dataService.async();
     
    };
   poll();
   $scope.startUpdate=function(aFile) {
<? if (($_SERVER['HW_PLATFORM']==WM_M2) ||($_SERVER['HW_PLATFORM']>=WM_ULTRA)) {
            $cur_drive=get_drive();
            //print('if (1) { alert("'.disk_free_space($cur_drive).' Unable to update package.  Please make sure an SD card is inserted for this to happen."); return 0; }');
                if (disk_status(0)!=0) {
                    print('if (1) { alert("Unable to update firmware.  Please make sure an SD card is inserted for this."); return 0; }');
                }
        }
   ?>   
    $scope.msg="Downloading firmware file...";
        var x = new XMLHttpRequest();
                $scope.setLoading(1);
      var progressBar = document.querySelector('progress');
      x.open('GET', 'http://www.wattmon.com/live/updater.php?action=download&filename='+aFile, true);
      x.responseType = "blob";
      x.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = (e.loaded / e.total) * 100;
                    progressBar.textContent = progressBar.value; // Fallback for unsupported browsers.
                }
            };
      x.onload=function() {
            $scope.$apply(function() {
                $scope.msg="Uploading firmware file...";
            });
            var xmlhttp;
            if (window.XMLHttpRequest)  {// code for IE7+, Firefox, Chrome, Opera, Safari
    		    xmlhttp=new XMLHttpRequest();
    		}
    		else {// code for IE6, IE5
    		    xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
    		}
    		xmlhttp.onreadystatechange=function() {
    		    if (xmlhttp.readyState==4 && xmlhttp.status==201) {
    	    	    document.location="/app/firmwareman.cgi?action=untar";
    		    }
    		}
    		<? if ($_SERVER['HW_PLATFORM']<WM_MINI3) { ?>
    		    xmlhttp.open("PUT","/firmware.tar",true);
            <? } else { 
                $prefix='';
                if (($_SERVER['HW_PLATFORM']==WM_M2) || ($_SERVER['HW_PLATFORM']>=WM_ULTRA)) $prefix='0:';
                ?>
                xmlhttp.open("PUT","<? print($prefix); ?>/firmwarez.tar",true);
            <? } ?>
            var progressBar = document.querySelector('progress');
            xmlhttp.upload.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = (e.loaded / e.total) * 100;
                    progressBar.textContent = progressBar.value; // Fallback for unsupported browsers.
                }
            };
		    xmlhttp.setRequestHeader("Content-Length",x.response.length);
	  	    xmlhttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
		    xmlhttp.send(x.response);
      }
      x.send();
      $gscope=0;
   }
 }
 
 
 

</script>
</div>
<? 
    $prefix='';
    if (($_SERVER['HW_PLATFORM']==WM_M2) || ($_SERVER['HW_PLATFORM']>=WM_ULTRA)) {
        $prefix='0:';
    }

if ($_GET['action']=='untar') {
    max_execution_time(500);
    chdir($prefix."/");
    // delete the md5 file if it is there
    unlink('/md5.txt');
    print("<div class='alert alert-info'><pre>");
    if ($_SERVER['HW_PLATFORM']<WM_MINI3) {
      untar('/firmware.tar');
    } else {
       untar($prefix.'/firmwarez.tar');
    }
    print("</pre></div>");
    $ok=1;
    if (file_exists($prefix.'\md5.txt')) {
        if (function_exists('md5_file')) {
            $f=fopen($prefix."\md5.txt","r");
            $md5=fread($f,32);
            print("Calculating MD5 checksum");
            flush();
            if ($_SERVER['HW_PLATFORM']<8) {
                $fn="/image.hex";
                $md5sum=strtolower(md5_file('/image.hex'));
            } else {
                if (($_SERVER['HW_PLATFORM']!=WM_M2)) {
                    if (($_SERVER['HW_PLATFORM']!=WM_ULTRA) && ($_SERVER['HW_PLATFORM']!=21) && ($_SERVER['HW_PLATFORM']!=22)) {
                        $fn=$prefix."/imagez.hex";
                    } else
                        $fn=$prefix."\imageu.hex";
                    $md5sum=strtolower(md5_file($fn));
                } else {
                    $fn=$prefix."/image2.hex";
                    $md5sum=strtolower(md5_file($fn));
                }
            }
            //print($md5sum."<br>".$md5); die();        
            if ($md5sum!=$md5) {
                $_GLOBALS['errormsg']='There was an error uploading the firmware - the MD5 checksum does not match - '.$md5sum." and ".$md5;
                print("<script>document.location='/app/firmwareman.cgi?action=error';</script>");
                 //include("/app/footer.inc"); 
                $ok=0;
            } 
        } 
    } else {
            print($prefix."\md5.txt was not found..");die();
        }
    if ($ok) {
        if (($_GLOBALS['VERMAJOR']==1) && ($_GLOBALS["VERMINOR"]<51)) {
            print("<script>alert('Firmware update started.  Click OK to reboot in a few seconds.');");
                    print("document.location='/index.cgi';</script></body></html>");
                    flush();
                    sleep(500);
            log("Firmware update initiated");
	        nvram_backup("/nvram.dat");
			include("/app/footer.inc");
			flush();
            firmwareupdate();
        }
        if ($ok && filesize($fn)>0) {
            $_GLOBALS['sysmsg']='Firmware Update In Progress.';
            print("<script>alert('The device is rebooting now.  Click OK to reload in a few seconds.');");
                    print("document.location='/index.cgi';</script></body></html>");
                    flush();
                     sleep(1000);
                     log("Firmware update initiated");
		        nvram_backup($prefix."/nvram.dat");
                firmwareupdate();
        } else {
            $_GLOBALS['errormsg']='There was an error uploading the firmware. '.$fn;
            print("<script>document.location='/app/firmwareman.cgi?action=error';</script>");
        }
    }
}
?>
<? include("/app/footer.inc"); ?>

















