<?
/**
 * @package pyranometer
 * @author Akash Heimlich
 * @description This file is called every day
 */

log("[pyra] Resetting day kwh fron ".$_GLOBALS['pyra_day']." to 0");
$_GLOBALS['kWh_Potential_Day']=0;
$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA
    $prefix=intval($_GLOBALS['log_drive']).':';    
    
mb_set_dev_var($_GLOBALS['pyra_id'],'kWh_Day_Potential',$_GLOBALS['kWh_Potential_Day']);
$month_irradiance = ini_get($prefix."/logs/Pyranometer.ini","config","kWh_Month_Irradiance",0)+$_GLOBALS['pyra_day'];
$life_irradiance = ini_get($prefix."/logs/Pyranometer.ini","config","kWh_Lifetime_Irradiance",0)+$_GLOBALS['pyra_day'];
$d=strftime("%d",time());
if ($d==1) {
    $month_irradiance=0;
    log("Resetting monthly irradiance");
}
ini_set($prefix."/logs/Pyranometer.ini","config","kWh_Month_Irradiance",$month_irradiance);
ini_set($prefix."/logs/Pyranometer.ini","config","kWh_Lifetime_Irradiance",$life_irradiance);
$_GLOBALS['kWh_Month_Irradiance']=$month_irradiance/1000;
$_GLOBALS['pyra_day']=0;
mb_set_dev_var($_GLOBALS['pyra_id'],'kWh_Day_Irradiance',$_GLOBALS['pyra_day']);
ini_set($prefix."/logs/Pyranometer.ini","config","kWh_Day_Irradiance",$_GLOBALS['pyra_day']);
if ($_GLOBALS['track_curtailment']) {
    ini_set($prefix."/logs/PC.ini","config","kWh_Curtailment_DG_Day",0);
    ini_set($prefix."/logs/PC.ini","config","kWh_Curtailment_Grid_Day",0);
    ini_set($prefix."/logs/PC.ini","config","kWh_Curtailment_Day",0);
}
$_GLOBALS['kWh_Curtailment_Day']=0;
$_GLOBALS['kWh_Curtailment_DG_Day']=0;
$_GLOBALS['kWh_Curtailment_Grid_Day']=0;

// set the daily inverter values  
if ($_GLOBALS['ez']['inv']) {
    if (!is_array($_GLOBALS['inv_kwh_midnight']))
        $_GLOBALS['inv_kwh_midnight']=array();
    for ($i=0;$i<sizeof($_GLOBALS['ez']['inv']);$i++) {
        $dev=mb_get_dev_by_id($_GLOBALS['ez']['inv'][$i]['id'],$_GLOBALS['ez']['inv'][$i]['bus']);
        
        $_GLOBALS['inv_kwh_midnight'][$i]=$dev['roleval3']; // assume kWh is register 3
        $_GLOBALS['inv_kwh_today'][$i]=0;
        
        if ($_GLOBALS['inv_kwh_midnight'][$i]) 
            ini_set($prefix."/logs/Pyranometer.ini","config","inv".$i,$_GLOBALS['inv_kwh_midnight'][$i]);
    }
}

?>





