<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : deviceedit.cgi
 * 
 *  Description: Device edit page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       03/12/13    v1.1 - optimised memory usage
 * Akash Heimlich       23/04/18    v2.0
 *                      02/10/18    v3.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceEditCtrl"; 
$title='Edit Device Settings';
include("/app/header.inc");
 
print('<script src="'.$url_prefix.'/js/deveditctrl.js"></script>'); 
max_execution_time(60);
?>


<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/devices.cgi"><? print(lang('MODBUS_DEVICES','deviceedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('DEVICE_CONFIGURE','deviceedit')) ?></li>
  </ol>
</nav>


<!-- VARIABLES -->
<?
  
  $arr = mb_get_dev_by_index($_GET['device_idx']);
  $info_ini="/dev/dev"+$arr['device_type_id']+".ini";
  
  $info_section="config";
  $role_ini="/config/roles.ini";
  $role_section="roles";
  
  $mb_tcp_connected=0;
  $mb_tcp_enabled=0;
  $has_dual_rs485 = ($_SERVER['HW_PLATFORM']==20 || $_SERVER['HW_PLATFORM']==21 || $_SERVER['HW_PLATFORM']==22 || $_SERVER['HW_PLATFORM']==11);
  $rs232_enabled=ini_get("/config/device.ini","general","rs232_enabled",0);
if (function_exists("getmbstat")) {
    $sarr=getmbstat();
    $mb_tcp_enabled=$sarr['TCP_ENABLED'];
}
//print_r($sarr);
  //$info=ini_get_array("/dev/dev"+$arr['device_type_id']+".ini","config");
  //$roles=ini_get_array("/config/roles.ini","roles");
  //print_r($arr);
?>
<div ng-init="device_index=<? print($_GET['device_idx']); ?>;"></div>
<div ng-init="device_id=<? print($arr['slave_id']); ?>;"></div>
<div ng-init="device_name='<? print($arr['name']); ?>';"></div>
<div ng-init="device_type_id=<? print($arr['device_type_id']); ?>;"></div>
<div ng-init="role_id=<? print($arr['role_id']); ?>;"></div>
<div ng-init="bus=<? print($arr['params']); ?>;"></div>
<div ng-init="status=<? print($arr['status']); ?>;"></div>
<div ng-init="poll_interval=<? print($arr['poll_interval']); ?>;"></div>
<!-- NAVBAR -->
<h4 ><i class="icon-cog"></i><? print(lang('CONFIGURE_TITLE','deviceedit')) ?>&nbsp;<? if ($arr['model']) print($arr['model']); ?><small> <? print(ini_get($info_ini,$info_section,'description')." (".$arr['device_type_id'].")"); 
  if ($arr['serial']) print(" S/N:".$arr['serial']); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/devices.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/devicecalib.cgi?device_idx=<? print($_GET['device_idx']); ?>'"><i class="icon-wrench"></i> <? print(lang('CALIBRATE','deviceedit')) ?></a>
  </li>
 
  <li ng-hide='settings_locked' class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','deviceedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','deviceedit')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','deviceedit')) ?></div>
<form id="form" name="form" class="css-form">

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('CONFIGURE_TITLE','deviceedit')) ?></h5>
        <p class="card-text">    
<?  if ($rs232_enabled || $mb_tcp_enabled || $has_dual_rs485) { ?>
            <div class="form-group">
                <label for="bus"><? print(lang('DEVICE_BUS','deviceedit')) ?></label>
                <select ng-model="bus"  required name='bus' class="form-control">
	                <option value='0'>Modbus RTU (RS-485)</option>
<? if ($rs232_enabled) { ?>
	                <option value='1'>Modbus RTU (RS-232)</option>
<? } else { ?>	                
                    <option value='1'>Modbus RTU 2 (RS-485)</option>
<? } ?>                    
	                <option value='100'>Virtual Device</option>
<? 			        
      $is_mega = ($_SERVER['HW_PLATFORM']>=8);
     
      $modbus_tcp_port=array();
      $modbus_tcp_ip_address=array();
      // single modbus TCP for non-mega
      if (!$is_mega) {
            $max_tcp=1;
            $modbus_tcp_port[0]=ini_get("/config/device.ini","general","modbus_tcp_port",502);
            $modbus_tcp_ip_address[0]=ini_get("/config/device.ini","general","modbus_tcp_ip_address","0.0.0.0");
      } else {
            $max_tcp = intval($sarr['TCP_COUNT']);
            for ($i=0;$i<$max_tcp;$i++) {
                $modbus_tcp_port[$i]=ini_get("/config/device.ini","general","modbus_tcp_port".$i,502);
                $modbus_tcp_ip_address[$i]=ini_get("/config/device.ini","general","modbus_tcp_ip_address".$i,"0.0.0.0");
            }
          
      }
     // print("max_tcp=".$max_tcp);
      //print_r($sarr);
      for ($i=0;$i<$max_tcp;$i++) {
          print("<option value='"+(2+$i)+"'>TCP Channel "+(1+$i)." - ".$modbus_tcp_ip_address[$i].":".$modbus_tcp_port[$i].($arr['TCP_STATE'.$i]==2?" - CONNECTED":"")."</option>");
          //if ($mb_tcp_connected) print("- CONNECTED"); ?>);
      }
?>
       
                </select>
                <small id="chanHelp" class="form-text text-muted"><? print(lang('DEVICE_BUS_HELP','deviceedit')) ?></small>
            </div>

<? } ?>
            <div class="form-group">
                <label for="device_id"><? print(lang('DEVICE_ID','deviceedit')) ?></label>
                <input class="form-control" type='number' ng-model="device_id"  class='span12' name='device_id' required size='3' min="0" max="254" integer aria-describedby="diHelp" placeholder="<? print(lang('DEVICE_ID','deviceedit')) ?>">
                <small id="diHelp" class="form-text text-muted"><? print(lang('DEVICE_ID_HELP','deviceedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.device_id.$invalid"><? print(lang('DEVICE_ID_INVALID','deviceedit')) ?></small>
            </div>
            
        	<div class="form-group">
                <label for="device_name"><? print(lang('DEVICE_NAME','deviceedit')) ?></label>
                <input type="text" class="form-control" ng-model="device_name"  class='span12' name='device_name' requiredaria-describedby="dnHelp" my-directive placeholder="<? print(lang('DEVICE_NAME','deviceedit')) ?>">
                <small id="dnHelp" class="form-text text-muted"><? print(lang('DEVICE_NAME_HELP','deviceedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.device_name.$invalid"><? print(lang('DEVICE_NAME_INVALID','deviceedit')) ?></small>
            </div>	        
            
		    <div class="form-group">
                <label for="guest_user_name"><? print(lang('POLL_INTERVAL','deviceadd')) ?></label>
                <div class="input-group">
                    <input class="form-control" aria-label="<? print(lang('POLL_INTERVAL','deviceedit')) ?>" ng-model="poll_interval" type="number" size='3' min="0" max="60000" integer required>
                    <div class="input-group-append">
                        <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><? print(lang('POLL_CHOOSE','deviceedit')) ?></button>
                        <ul class="dropdown-menu dropdown-menu-right">
                            <li class="dropdown-item"><a ng-click='poll_interval=0' href='#'>No polling</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=1000' href='#'>Every Second</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=2000' href='#'>Every 2 Seconds</a></li>
                            <li class="dropdown-item"><a ng-click='poll_interval=60000' href='#'>Every Minute</a></li>
                        </ul>
                    </div>
                </div>
                <small id="pHelp" class="form-text text-muted"><? print(lang('POLL_INTERVAL_HELP','deviceedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.poll_interval.$invalid"><? print(lang('POLL_INTERVAL_INVALID','deviceedit')) ?></small>
            </div>  
            
		    <div class="form-group">
                <label for="status"><small class='text-muted'><? print(lang('STATUS','deviceadd')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="status" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;Disabled
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="status" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;Enabled
                  </label>
                </div>  
                <small id="dnHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','deviceadd')) ?></small>
            </div>
        </p>
    </div>
</div>
<br/>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('CONFIGURE_ROLES','deviceedit')) ?></h5>
        <p class="card-text">    

<?
 print('<div ng-init="numroles='+$arr['num_roles']+';"></div>');
  $role_cnt=ini_get($role_ini,$role_section,'num_roles',0);
  $devid=strval($arr['device_type_id']);
  // Create the role arrays for the different device types
  $rolearr=array();
  $rolearr[0]=array();
  $rolearr[1]=array();
  $rolearr[2]=array();
  $rolearr[3]=array();
  $rolearr[0][]=0;
  $rolearr[1][]=0;
  $rolearr[2][]=0;
  $rolearr[3][]=0;
  if (freemem() < 512000) {  // PIC32MZ2048
  
     // $log_array=ini_get_array("/logs/datalog.ini");
      $num_logs=ini_get("/config/datalog.ini","data",'num_groups',0);
      $logged_roles=array();
      for ($i=0;$i<$num_logs;$i++) {
          $num_items=ini_get("/config/datalog.ini","data",'group'.$i.'numvar',0);
          
          for ($item=0;$item<$num_items;$item++) {
             $vartype=ini_get("/config/datalog.ini","data",'group'.$i.'var'.$item.'vartype',0);;
             //print($vartype);
             if ($vartype==2) {
                 $logged_roles[ini_get("/config/datalog.ini","data",'group'.$i.'var'.$item.'varval',0)]=1;
             }
          }
      }
    //  print_r($logged_roles);
      
      //print($devid."<br>");
      for ($i=1;$i<$role_cnt;$i++) {
          $st=strval(ini_get($role_ini,$role_section,'role'.$i.'ids',''));
          //print($st."<br>");
          if (strpos($st,$devid)>=0) {
              $x=intval(ini_get($role_ini,$role_section,'role'.$i.'type',0));
              //print("Match found! - ".$x."=".$i."<br>");
              $rolearr[$x][]=$i;
          }
      }
     // print_r($rolearr);
      for ($r=0;$r<$arr['num_roles'];$r++)  {
            $rt=intval(ini_get($info_ini,$info_section,'role_type_'+$r,0));
            $ri=intval(ini_get($info_ini,$info_section,'role_idx_'+$r,0));
            //print($rt."-");
            //strval()
            $num_roles=0;//sizeof($rolearr[$rt]);
      //      while ($rolearr[$rt][$num_roles]>0) $num_roles++;
        //    print($num_roles);
            $st='';
            if ($rt==1) {
                $st='Digital Input';
                $prefix='di';
            }
            if ($rt==0) {
                $st='Digital Output';
                $prefix='do';
            }
            if ($rt==2) {
                $st='Read Only Register';
                $prefix='ro';
            }
             if ($rt==31) {
                $st='Read Only Unsigned Register';
                $prefix='ro';
            }
            if ($rt==22) {
                $st='Read Only Float Register';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==24) {
                $st='Read Only Unsigned INT32 (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==25) {
                $st='Read Only Unsigned INT32 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==39) {
                $st='Read Only Unsigned INT64 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            
            if ($rt==26) {
                $st='Read Only Signed INT32 (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==27) {
                $st='Read Only Signed INT32 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==28) {
                $st='Read Only Float Register (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            
            if ($rt==3) {
                $st='Read/Write Register';
                $prefix='rw';
                $rt=3;
            }
            if ($rt==32) {
                $st='Read/Write Unsigned Register';
                $prefix='rw';
                $rt=3;
            }
            if ($rt==23) {
    
                $st='Read/Write Float Register (Big Endian)';
                $prefix='rw';
                $rt=3;
            }
            if ($rt==29) {
    
                $st='Read/Write Float Register (Little Endian)';
                $prefix='rw';
                $rt=3;
            }
            
            if ($rt==30) {
    
                $st='Read/Write Holding Register - UINT32 Big Endian';
                $prefix='rw';
                $rt=3;
            }        
            if ($rt==35) {
    
                $st='Read/Write Holding Register - INT32 Small Endian';
                $prefix='rw';
                $rt=3;
            }        
            if ($rt==34) {
    
                $st='Read/Write Holding Register - INT32 Big Endian';
                $prefix='rw';
                $rt=3;
            }        
            if ($rt==42) {
                $st='Read Only Signed INT64 (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==43) {
                $st='Read Only Signed INT64 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==44) {
                $st='Read Only Signed INT64 (Swapped Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==45) {
                $st='Read Only Signed INT64 (Swapped Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            
            
            print($st);
        print('<div ng-init="role'+$r+'='+$arr['role'+$r]+';"></div>');
        ?>
                <div class="form-group form-inline">
               
                    <label><strong><? print(ini_get($info_ini,$info_section,$prefix.'_desc_'+$ri)); ?></strong></label>
        <?              print('<select ng-model="role'+$r+'" class="form-control" >');
                        $rt2=ini_get($info_ini,$info_section,'role_type_'+$r);
                        if ($rt2==22) $rt2=2;
                        if ($rt2==23) $rt2=3;
                        if ($rt2==24) $rt2=2;
                        if ($rt2==25) $rt2=2;
                        if ($rt2==39) $rt2=2;
                        if ($rt2==26) $rt2=2;
                        if ($rt2==27) $rt2=2;
                        if ($rt2==28) $rt2=2;
                        if ($rt2==29) $rt2=3;
                        if ($rt2==30) $rt2=3;
                        if ($rt2==31) $rt2=2;
                        if ($rt2==32) $rt2=3;
                        if ($rt2==33) $rt2=3;
                        if ($rt2==34) $rt2=3;
                        if ($rt2==35) $rt2=3;
                        if ($rt2==42) $rt2=2;
                        if ($rt2==43) $rt2=2;
                        if ($rt2==44) $rt2=2;
                        if ($rt2==45) $rt2=2;
                        
                        $num_roles=sizeof($rolearr[$rt2]);
                        
                       
                        for ($i=0;$i<$num_roles;$i++) {
                            print('<option value="'+$rolearr[$rt2][$i]+'">'+ini_get($role_ini,$role_section,'role'+$rolearr[$rt2][$i]));
                            if ($rolearr[$rt2][$i] && $logged_roles[$rolearr[$rt2][$i]]==1) print(" [logged]");
                            print('</option>');                 
                        }
                        print("<option value='-2'>Create New Logged Role</option>");
                        print("<option value='-1'>Create New Role</option>");
                        print('</select>'); 
                    ?>
                   
                   <div class='input-append' style='margin-right:20px;margin-left:20px;'>Scale:<? print(ini_get($info_ini,$info_section,'role_scale_'+$r,1)); 
                    print('</div><div class="input-append">'.$st."</div>");
                    ?>
                    <div class='input-append' ng-show='role<? print($r); ?>>0'><button class='btn btn-secondary' ng-click='editRole(role<? print($r); ?>)'>Edit Role</button></div>
                </div>
           
    <?
            
      }
  } else {  // ULTRA, MEGA2
      $log_array=ini_get_array("/logs/datalog.ini");
      $datalog_array=ini_get_array("/config/datalog.ini");
      $role_array=ini_get_array("/config/roles.ini");
      $info_array=ini_get_array($info_ini);
      $num_logs = $datalog_array['data']['num_groups'];//ini_get("/config/datalog.ini","data",'num_groups',0);
      $logged_roles=array();
      
      for ($i=0;$i<$num_logs;$i++) {
          $num_items = $datalog_array['data']['group'.$i.'numvar'];
          
          for ($item=0;$item<$num_items;$item++) {
             $vartype=$datalog_array['data']['group'.$i.'var'.$item.'vartype'];//,0);;
             //print($vartype);
             if ($vartype==2) {
                 $logged_roles[$datalog_array['data']['group'.$i.'var'.$item.'varval']]=1;
             }
          }
      }
    //  print_r($logged_roles);
      
      //print($devid."<br>");
      for ($i=1;$i<$role_cnt;$i++) {
          $st=strval($role_array[$role_section]['role'.$i.'ids']);
          //print($st."<br>");
          if (strpos($st,$devid)>=0) {
              $x=intval($role_array[$role_section]['role'.$i.'type']);
              //print("Match found! - ".$x."=".$i."<br>");
              $rolearr[$x][]=$i;
          }
      }
     // print_r($rolearr);
      for ($r=0;$r<$arr['num_roles'];$r++)  {
            $rt=intval($info_array[$info_section]['role_type_'+$r]);
            $ri=intval($info_array[$info_section]['role_idx_'+$r]);
            //print($rt."-");
            //strval()
            $num_roles=0;//sizeof($rolearr[$rt]);
      //      while ($rolearr[$rt][$num_roles]>0) $num_roles++;
        //    print($num_roles);
            $st='';
            if ($rt==1) {
                $st='Digital Input';
                $prefix='di';
            }
            if ($rt==0) {
                $st='Digital Output';
                $prefix='do';
            }
            if ($rt==2) {
                $st='Read Only Register';
                $prefix='ro';
            }
             if ($rt==31) {
                $st='Read Only Unsigned Register';
                $prefix='ro';
            }
            if ($rt==22) {
                $st='Read Only Float Register';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==24) {
                $st='Read Only Unsigned INT32 (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==25) {
                $st='Read Only Unsigned INT32 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==39) {
                $st='Read Only Unsigned INT64 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            
            if ($rt==26) {
                $st='Read Only Signed INT32 (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==27) {
                $st='Read Only Signed INT32 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==28) {
                $st='Read Only Float Register (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            
            if ($rt==3) {
                $st='Read/Write Register';
                $prefix='rw';
                $rt=3;
            }
            if ($rt==32) {
                $st='Read/Write Unsigned Register';
                $prefix='rw';
                $rt=3;
            }
            if ($rt==23) {
    
                $st='Read/Write Float Register (Big Endian)';
                $prefix='rw';
                $rt=3;
            }
            if ($rt==29) {
    
                $st='Read/Write Float Register (Little Endian)';
                $prefix='rw';
                $rt=3;
            }
            
            if ($rt==30) {
    
                $st='Read/Write Holding Register - UINT32 Big Endian';
                $prefix='rw';
                $rt=3;
            }        
            if ($rt==35) {
    
                $st='Read/Write Holding Register - INT32 Small Endian';
                $prefix='rw';
                $rt=3;
            }        
            if ($rt==34) {
    
                $st='Read/Write Holding Register - INT32 Big Endian';
                $prefix='rw';
                $rt=3;
            }        
            if ($rt==42) {
                $st='Read Only Signed INT64 (Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==43) {
                $st='Read Only Signed INT64 (Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==44) {
                $st='Read Only Signed INT64 (Swapped Little Endian)';
                $prefix='ro';
                $rt=2;
            }
            if ($rt==45) {
                $st='Read Only Signed INT64 (Swapped Big Endian)';
                $prefix='ro';
                $rt=2;
            }
            
            print($st);
        print('<div ng-init="role'+$r+'='+$arr['role'+$r]+';"></div>');
        ?>
                <div class="form-group form-inline">
               
                    <label><strong><? print($info_array[$info_section][$prefix.'_desc_'+$ri]); ?></strong></label>
        <?              print('<select ng-model="role'+$r+'" class="form-control" >');
                        $rt2=$info_array[$info_section]['role_type_'+$r];
                        if ($rt2==22) $rt2=2;
                        if ($rt2==23) $rt2=3;
                        if ($rt2==24) $rt2=2;
                        if ($rt2==25) $rt2=2;
                        if ($rt2==39) $rt2=2;
                        if ($rt2==26) $rt2=2;
                        if ($rt2==27) $rt2=2;
                        if ($rt2==28) $rt2=2;
                        if ($rt2==29) $rt2=3;
                        if ($rt2==30) $rt2=3;
                        if ($rt2==31) $rt2=2;
                        if ($rt2==32) $rt2=3;
                        if ($rt2==33) $rt2=3;
                        if ($rt2==34) $rt2=3;
                        if ($rt2==35) $rt2=3;
                        if ($rt2==42) $rt2=2;
                        if ($rt2==43) $rt2=2;
                        if ($rt2==44) $rt2=2;
                        if ($rt2==45) $rt2=2;
                        
                        $num_roles=sizeof($rolearr[$rt2]);
                        
                       
                        for ($i=0;$i<$num_roles;$i++) {
                            print('<option value="'+$rolearr[$rt2][$i]+'">'+$role_array[$role_section]['role'+$rolearr[$rt2][$i]]);
                            if ($rolearr[$rt2][$i] && $logged_roles[$rolearr[$rt2][$i]]==1) print(" [logged]");
                            print('</option>');                 
                        }
                        print("<option value='-2'>Create New Logged Role</option>");
                        print("<option value='-1'>Create New Role</option>");
                        print('</select>'); 
                    ?>
                   
                   <div class='input-append' style='margin-right:20px;margin-left:20px;'>Scale:<? print($info_array[$info_section]['role_scale_'+$r]); 
                    print('</div><div class="input-append">'.$st."</div>");
                    ?>
                    <div class='input-append' ng-show='role<? print($r); ?>>0'><button class='btn btn-secondary' ng-click='editRole(role<? print($r); ?>)'>Edit Role</button></div>
                </div>
           
    <?
            
      }
  }
 ?>
        </p>
    </div>
</div>
</form>


<? include("/app/footer.inc"); ?>





