<pre><?

/**
*  @version 3.03
*  @date 03/12/18
*  added an option RELAXED_REPLY which will just check the header for a 200 to ensure the transmission completed
*  added a buffer_interval in seconds to dataexport.ini which will allow for quicker buffering.
*  added auto restart device after 5 dongle attempts
*  added MD5 exporting
*  added alert exporting

**/
include("/lib/uphp/debug.inc");

debug_start();

$ini = ini_get_array("/config/dataexport.ini","export");
max_execution_time(45);
define("EXPORT_LINES",15);

function str_replace($str,$c1,$c2) {
    $p1=strpos($str,$c1);
    if ($p1) {
        $str1=substr($str,0,$p1);
        $str2=substr($str,$p1+strlen($c1));
        $str=$str1.$c2.$str2;
    }
    return $str;
}

$ini['custom_lines']=intval($ini['custom_lines']);
if (!$ini['export_lines']) 
		$ini['export_lines']=EXPORT_LINES;
// create the config folder if it does not exist
$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20) {  // ULTRA
        $prefix=intval($_GLOBALS['log_drive']).':';
}

mkdir($prefix."/ini");

define("RELAXED_REPLY",0);
$buffer_interval=intval($ini['buffer_interval'])*1000;
if (intval($ini['export_wattmon'])==1) {
    // if we just rebooted, then immediately export the IP
    if ($_GLOBALS['exportint']==0)
        $_GLOBALS['exportint']=$ini['interval']+1;
	// force reboot false as we exported
	$force_boot=ini_get($prefix."/logs/reset.ini","config","force_reboot",0);
	if ($force_boot) 
		ini_set($prefix."/logs/reset.ini","config","force_reboot",0);
        
    $_GLOBALS['exportint']++;
    if ($_GLOBALS['exportint']>$ini['interval']) 
    {
        $dns_ip=ini_get("/config/dns.ini","dns","www.wattmon.com","www.wattmon.com");
    	$f=fsockopen($dns_ip,80,10);
    	if ($f) {
    	    $local_port=ini_get("/config/uphp.ini","http","server_port",80);
    	    
    	    $mac=getmac();
    	    $arr=getethstat();
    	    $net=get3gstat();
    	    $port=$ini['port'];
    	    if ($net['enabled'] && $net['connected']) {
    	        $port=$local_port;
    	  
    	    }
    	    //    $ip=$net['ip_address'];
    	    $ip=$arr['ip_address'];
    	    if ($ini['devicekey']==0) {
    	        $ini['devicekey']=$mac;
    	        //ini_set($prefix."/config/dataexport.ini","export","devicekey",$mac);
    	    }
    	    $out = "GET /live/getip.php?dev="+$ini['devicename']+"&key="+$ini['devicekey']+"&v="+$_GLOBALS['battery_voltage']+"&pc="+$_GLOBALS['battery_percent']+"&mac=".$mac."&lp=".$local_port."&rp=".$port."&ip=".$ip." HTTP/1.0\r\n";
            $out = $out."Host: www.wattmon.com\r\n";
    	    $out = $out."Connection: Keep-Alive\r\n\r\n";
    	    fwrite($f, $out);
			fread($f,1);
    	    print($out);
    	    // get header
    	    $done=0;
    	    fclose($f);
    	     $_GLOBALS['error3g']=0;
    	     $_GLOBALS['restarts']=0;
    	    //rint("finished executing getip.cgi");
    	    $_GLOBALS['exportint']=1; // restore for the next time
    	} else {
            $stat=get3gstat(); 
            if ($stat['enabled']) {
                if ($stat['connected']) {
                    if ($stat['ip_address']!='0.0.0.0') {
                        $_GLOBALS['error3g']++;
                        if ($_GLOBALS['error3g']>=5) {
							 $_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
                                    if ($_GLOBALS['restarts']>3) {
									  ini_set($prefix."/logs/reset.ini","config","force_reboot",1);
                                      log("Restarting due to link issues.") ;
                                      reset();
                                    };
                            log("Cellular link seems to have died, restarting USB power");
                            setusbpower(0);
                            sleep(500);
                            setusbpower(1);
                            $_GLOBALS['error3g']=0;
                        }
                        
                    }
                } else {  // enable this on devices that have an issue rebooting and are using a dongle
                	if (intval($ini['force_reboot'])) {
						$_GLOBALS['error3g']++;
                        if ($_GLOBALS['error3g']>=5) {
							 $_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
                                    if ($_GLOBALS['restarts']>3) {
                                      log("Restarting due to link issues.") ;
									  ini_set($prefix."/logs/reset.ini","config","force_reboot",1);
                                      reset();
                                    };
                            log("Cellular link seems to have died, restarting USB power");
                            setusbpower(0);
                            sleep(500);
                            setusbpower(1);
                            $_GLOBALS['error3g']=0;
                        }
                	}
				} 
            }
    	    $_GLOBALS['exportint']=$ini['interval']+1; // retry next minute...
    	    print("unable to connect to host");
    	}
    	
    }
} 

/* if exporting to portal, upload general device info */
if ($ini['export_portal']==1 ||  $_GET['debug']) {
    $_GLOBALS['config_data']++;
    //print("Debug=1");
    // 5 minutes after boot, connection should be active
    if (($_GLOBALS['config_data']==5) || $_GET['debug']) {  
            max_execution_time(180); // 3 minutes, if filesize is large..
            $export_json='{"platform":'.$_SERVER['HW_PLATFORM'].',"fw":"'.$_GLOBALS['VERMAJOR'].".".$_GLOBALS["VERMINOR"].'","os":"'.$_GLOBALS['PKG_VERSION'].'",';
    	    
    	    $net=get3gstat();
            $export_json.='"cellular":"'.$net['enabled'].'",';
            $export_json.='"cellular_connected":"'.$net['connected'].'",';
            $num_dev=mb_num_devices();
            $export_json.=('"count":'+$num_dev+",\n");

            /**
            * load all roles into the $roles array
            */
            //$roles=ini_get_array("/config/roles.ini","roles");

            //if ($_SERVER['HW_PLATFORM']!=10) {
                $f_config=fopen($prefix."/logs/config.txt","w");
                fwrite($f_config,$export_json);
                $export_json='';
            //}
			if (is_array($_GLOBALS['ez']))
	            $export_json.=json_encode($_GLOBALS['ez']).",";

			if (is_array($_GLOBALS['pc_pm']))
	            $export_json.=json_encode($_GLOBALS['pc_pm']).",";
			if (is_array($_GLOBALS['pc_inv']))
            	$export_json.=json_encode($_GLOBALS['pc_inv']).",";
            
            
            //print($export_json);
//            if ($_SERVER['HW_PLATFORM']!=10) {
/*                $f_config=fopen("/logs/config.txt","w");
                fwrite($f_config,$export_json);
                $export_json='';*/
//            }
          $export_json.=('"devices": [');
            

            /**
            * iterate through all devices and output json encoded device information
            */            
            for ($i=0;$i<$num_dev;$i++) {
                $export_json.=('{');
                $dev=0;
                /**
                * Load device variables into array $dev
                * The mb_get_dev_by_index() function takes an integer index parameter and returns an array
                */                
                $dev=mb_get_dev_by_index($i);
                //print("<pre>");print_r($dev);
                /**
                * load device config file into array $info
                */
                $info=0;
                $dev_ini="/dev/dev"+$dev['device_type_id']+".ini";
                //$info=ini_get_array("/dev/dev"+$dev['device_type_id']+".ini","config");
                
                /**
                * id of modbus or wireless device
                */
                $export_json.=('"id": "'+$dev['slave_id']+'",\n');
                /**
                * type id of modbus or wireless device
                */
                $export_json.=('"type_id": "'+$dev['device_type_id']+'",\n');
                /**
                * device name
                */
                $export_json.=('"name": "'+$dev['name']+'",\n');
                /**
                * description of device
                */
                $dev_name=ini_get($dev_ini,"config","name");
                if (strpos($dev_name,"&")) {
                    $dev_name=substr($dev_name,0,strpos($dev_name,"&"));
                }
                $export_json.=('"description": "'+$dev_name+'",\n');
                /**
                * last response time (milliseconds since successful communication occured)
                */
                $export_json.=('"last_response": "'+(time()-intval($dev['last_response']))+'",\n');
                /**
                * status of device (1=active, 0= disables)
                */
                $export_json.=('"status": "'+$dev['status']+'",\n');
                /**
                * extra parameter to indicate which bus the device is on (0=wired bus, 1=wireless bus)
                */
                $export_json.=('"params": "'+$dev['params']+'",\n');                    

                /**
                * user parameters
                */
                if ($dev['serial']) {
                    if (is_ok($dev['serial'])) 
                        $export_json.=('"serial": "'+$dev['serial']+'",\n');
                }
                if ($dev['model'])
                    $export_json.=('"model": "'+$dev['model']+'",\n');
				
				if (1) { //($_SERVER['HW_PLATFORM']!=10) || (freemem()<100000)
                    
	                $nroles=intval(ini_get($dev_ini,"config","num_roles",0));
	                $export_json.=('"num_roles": '+$nroles+',\n');
	                $export_json.=('"roles":[');
	                /**
	                * iterate through the different roles this device handles
	                */            
	                $rc1=0;
	              //  print("nroles=".$nroles."\r\n");
	                for ($c=0;$c<$nroles;$c++) {
	                    //print("role=".$c."=".$dev["role"+$c]."\r\n");
	                    if ($dev["role"+$c]) {
	                        if ($rc1) $export_json.=(", ");
	                        $rc1++;
		                    $export_json.=('{"var":"'+ini_get($dev_ini,"config",'role_var_'+$c)+'", "idx": '+ini_get($dev_ini,"config",'role_idx_'+$c)+',"type":'+ini_get($dev_ini,"config",'role_type_'+$c)+', "assign": "'+ini_get($dev_ini,"config",'role_assign_'+$c)+'"');
		                    
		                    $export_json.=(',"role_id":'+$dev["role"+$c]);
		                    /**
		                    * output description for digital output role (role type 0)
		                    */
		                    $cidx=ini_get($dev_ini,"config",'role_idx_'+$c);
		                    $ctype=ini_get($dev_ini,"config",'role_type_'+$c);
		                    //print(',"cidx":'+$cidx+" "+$ctype);                        
		                    $desc='';
		                    if ($ctype==0) {
		                        $desc=(',"desc":"'+ini_get($dev_ini,"config","do_desc_"+$cidx)+'",');    
		                    } else {
		                        /**
		                        * output description for digital input role (role type 1)
		                        */
		                        if ($ctype==1) {
		                            $desc=(',"desc":"'+ini_get($dev_ini,"config","di_desc_"+$cidx)+'",');    
		                        } else {
		                            /**
		                            * output description for read only register role (role type 2)
		                            */
		                            if (($ctype==2) || ($ctype==22)  || (($ctype>=24) && ($ctype<=28))) {
		                                $desc=(',"desc":"'+ini_get($dev_ini,"config","ro_desc_"+$cidx)+'",');    
		                            } else {
		                                /**
		                                * output description for read/write role (role type 3)
		                                */
		                                if (($ctype==3) || ($ctype==23) || ($ctype==29) || ($ctype==30)) {
		                                    $desc.=(',"desc":"'+ini_get($dev_ini,"config","rw_desc_"+$cidx)+'",');    
		                                } else $desc.=(",");
		                            }
		                        }
		                    }
		                    if ($desc) {
		                        if (strpos($desc,"&")) {
                                    $desc=str_replace($desc,"&","-");
                                }
		                        $export_json.=$desc;
		                    }
		          
		                    $export_json.=('"role": "'+ini_get("/config/roles.ini","roles",'role'+intval($dev["role"+$c]))+'"}\n');
		                    //print($export_json."\r\n");
		                    //if ($c<($nroles-1)) print(", ");
		                    //print("free=".freemem());
	                    }
	                }
				} else {
					$dev_array=0;
					$dev_array=ini_get_array($dev_ini,"config");
					//print_r($dev_array);
					if (!$role_arr) 
						$role_arr=ini_get_array("/config/roles.ini","roles");
				//	print_r($role_arr);
					$nroles=intval($dev_array["num_roles"]);
	                $export_json.=('"num_roles": '+$nroles+',\n');
	                $export_json.=('"roles":[');
	                /**
	                * iterate through the different roles this device handles
	                */            
	    
	                for ($c=0;$c<$nroles;$c++) {
                        if ($dev["role"+$c]>0) {
	    	                    
    	                    $export_json.=('{"var":"'+$dev_array['role_var_'+$c]+'", "idx": '+$dev_array['role_idx_'+$c]+',"type":'+$dev_array['role_type_'+$c]+', "assign": "'+$dev_array['role_assign_'+$c]+'"');
    	                    
    	                    $export_json.=(',"role_id":'+$dev["role"+$c]);
    	                    /**
    	                    * output description for digital output role (role type 0)
    	                    */
    	                    $cidx=$dev["role"+$c];//$dev_array['role_idx_'+$c];
    	                    $ctype=$dev_array['role_type_'+$c];
    	                    //print(',"cidx":'+$cidx+" "+$ctype);                        
    	                    if ($ctype==0) {
    	                        $export_json.=(',"desc":"'+$dev_array["do_desc_"+$cidx]+'",');    
    	                    } else {
    	                        /**
    	                        * output description for digital input role (role type 1)
    	                        */
    	                        if ($ctype==1) {
    	                            $export_json.=(',"desc":"'+$dev_array["di_desc_"+$cidx]+'",');    
    	                        } else {
    	                            /**
    	                            * output description for read only register role (role type 2)
    	                            */
    	                            if (($ctype==2) || ($ctype==22)  || (($ctype>=24) && ($ctype<=28))) {
    	                                $export_json.=(',"desc":"'+$dev_array["ro_desc_"+$cidx]+'",');    
    	                            } else {
    	                                /**
    	                                * output description for read/write role (role type 3)
    	                                */
    	                                if (($ctype==3) || ($ctype==23) || ($ctype==29) || ($ctype==30)) {
    	                                    $export_json.=(',"desc":"'+$dev_array["rw_desc_"+$cidx]+'",');    
    	                                } else $export_json.=(",");
    	                            }
    	                        }
    	                    }
    	                    
    	                    $export_json.=('"role": "'+$role_arr['role'+$cidx]+'"}\n');
    	                    if ($c<($nroles-1)) $export_json.=(", ");
                        }
	                }
				}
				
                $export_json.=("]");
            
                $export_json.=('}');
                if ($i<($num_dev-1)) $export_json.=(",");
                
               // if ($_SERVER['HW_PLATFORM']!=10) {          
                    fwrite($f_config,$export_json);
                    $export_json='';
              //  }
                
            }
            $export_json.=(']}');
          //  if ($_SERVER['HW_PLATFORM']!=10) {          
                    //$export_json=htmlspecialchars($export_json);
                    fwrite($f_config,$export_json);
                    $export_json='';
                   fclose($f_config);
         //   }
         //   print($export_json);
            $host=$ini['portal'];
			if (!$host) $host='ems.wattmon.com';

                    if (($host=='mycloud.wattmon.com') || ($host=='ems.wattmon.com') || ($host=='beta.wattmon.com')) {
                        $dns_ip="104.199.148.202";
                    } else {
                        $dns_ip=ini_get("/config/dns.ini","dns",$host,$host);
                    }
//            $dns_ip=ini_get("/config/dns.ini","dns",$host,$host);
            if ($ini['secure']) {
                print("Connecting to https://".$dns_ip);
        	    $f=fsockopen($dns_ip,443,30);
            } else {
                print("Connecting to ".$dns_ip);
        	    $f=fsockopen($dns_ip,80,30);
            }
        	
        	if ($f) {
        	    print("connected...");
            	    $mac=getmac();
            	    $out = "POST /data/setconfig?key=".$mac." HTTP/1.0\r\n"; //="+$ini['devicename']+"&key="+$ini['devicekey']+"&v="+$_GLOBALS['battery_voltage']+"&pc="+$_GLOBALS['battery_percent']+"
            	    //$out = "POST /wattmononline/data/setdatacsv HTTP/1.0\r\n";
                    $out = $out."Host: ".$host."\r\n";
                    $out = $out."Content-Type: application/x-www-form-urlencoded\r\n";
            	    $out = $out."Connection: Keep-Alive\r\n"; // Keep-Alive
//                if ($_SERVER['HW_PLATFORM']!=10) {                   	    
                    $out.="Content-Length: ".(filesize($prefix."/logs/config.txt")+5)."\r\n\r\n";
                    
        	        fwrite($f, $out);
        	        fwrite($f,"data=");
        	        print($out);
        	        print("data=");
        	        $f_config=fopen($prefix."/logs/config.txt","r");
        	        while (!feof($f_config)) {
        	            $export_json=fread($f_config,1024);   
        	            print($export_json);
        	            fwrite($f,$export_json);
        	        }
  /*              } else {
                    //print($export_json);
                    print("sending data");
                    $out.="Content-Length: ".(strlen($export_json)+5)."\r\n\r\n";
        	        fwrite($f, $out);
        	        fwrite($f,"data=");
        	        fwrite($f,&$export_json);
        	        print($out);
                    
                }*/
    	    
			$out=fread($f,512);
//			$out=fread($f,2048);
    	    print($out);
    	    // get header
    	    $done=0;
    	    log("[ip] Exported latest config to server");
    	   
    	    fclose($f);
    	     $_GLOBALS['error3g']=0;
    	    //rint("finished executing getip.cgi");
    	    $_GLOBALS['exportint']=1; // restore for the next time
    	} else {
    	    print("no connection");
            $stat=get3gstat(); 
            if ($stat['enabled']) {
                if ($stat['connected']) {
                    if ($stat['ip_address']!='0.0.0.0') {
                        $_GLOBALS['error3g']++;
                        if ($_GLOBALS['error3g']>=5) {
							 $_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
                                    if ($_GLOBALS['restarts']>3) {
                                      log("Restarting due to link issues.") ;
                                      reset();
                                    };
                            log("Cellular link seems to have died, restarting USB power");
                            setusbpower(0);
                            sleep(500);
                            setusbpower(1);
                            $_GLOBALS['error3g']=0;
                        }
                        
                    }
                } else {  // enable this on devices that have an issue rebooting and are using a dongle
                	if (intval($ini['force_reboot'])) {
						$_GLOBALS['error3g']++;
                        if ($_GLOBALS['error3g']>=5) {
							 $_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
                                    if ($_GLOBALS['restarts']>3) {
                                      log("Restarting due to link issues.") ;
                                      reset();
                                    };
                            log("Cellular link seems to have died, restarting USB power");
                            setusbpower(0);
                            sleep(500);
                            setusbpower(1);
                            $_GLOBALS['error3g']=0;
                        }
                	}
				} 
            }
    	    $_GLOBALS['exportint']=$ini['interval']+1; // retry next minute...
    	    print("unable to connect to host");
    	}
    	
    
    }

}

if ($ini['export_portal']==1) 
{
    
    if ($_GET['lognow']) {
        $_GLOBALS['log0interval']=1; // ensure it logs
        if ($_GLOBALS['firmware_logging']) {
            if (function_exists("sys_set")) {
                sys_set("force_log",1);
                print("Forcing a firmware log line now\r\n");
                sleep(1000);
            } else {
                print("Forcing a line using firmware logging requires firmare x.1273 or above\r\n");
            }
        }
        
        print("including cronmin.");
        log("Forcing generation of a log entry for testing");
        
        include("/scripts/cronmin.cgi");
        
        $_GLOBALS['exportportalint'] = $ini['intervalportal'];
    }

    $_GLOBALS['exportportalint']++;
    debug_print("Checking... cnt=".$_GLOBALS['exportportalint'],'ip export','blue');    
    $export_only=intval($ini['export_only']);
    if ($_GLOBALS['exportportalint']>=intval($ini['intervalportal'])) 
    {
        
        $num_groups = ini_get("/config/datalog.ini","data","num_groups",0);
		$static_header = intval($ini['static_header']);
        if ($static_header && file_exists("/config/csv_headers.txt")) {
            debug_print('Found static csv_headers','headers');
            $data='';
            $fh=fopen("/config/csv_headers.txt","r");
            while (!feof($fh)) {
                $data.=fread($fh,512);
            }
            fclose($fh);
        } else {
            $data='"ts",';
            for ($i=0;$i<$num_groups;$i++) {
                $s=ini_get("/config/datalog.ini","data",'group'+$i+'status',0);
                
                if ($s==1) {
        
                    $logfile2 = $prefix."/logs/log_"+$i+".ini";
                    //$arr=ini_get_array($logfile2);
                    
                    
                    $grpnvar=ini_get("/config/datalog.ini","data",'group'+$i+"numvar",0);
                    for ($j=0;$j<$grpnvar;$j++) {
                        $vt=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'vartype',0);
                        $vfn=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varfn',0);
                        $vval=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varval',0);
                        if ($vt==1) {  // system
                            $varst=ini_get("/config/sysvars.ini","sysvars","sysvar".$vval."name","");
                            $varr=explode($varst,';');
                            if ($varr[0]=='V') {
                                $varst=$varr[1];
                            } else {
                                if ($varr[0]=='G') {
                                    $varst=$varr[2].$varr[1];
                                }
                            }
                        } else {
                            if ($vt==2) {  // device
                                $varst=ini_get("/config/roles.ini","roles","role".$vval,"");
                            }
                            if ($vt==3) {  // global
                                //$varst=$vval;
                                 $varst=ini_get("/config/datalog.ini","data",'group'+$i+'var'+$j+'varval','');
                            }                
                        }
                        //$data.="\"".$varst."\":\"".$arr['data']['p'.$j]."\"";
                        $data.='"'.$varst.'"';
                        if ($j<($grpnvar-1)) $data.=",";
                    }
                    $group_number=$i;
                    break;
        
                }
            }
			if ($static_header) {
                if ($_GLOBALS['boot_drive']==1) {
                    log("Unlocking flash to write static csv headers");
                    sys_set("FLASH_WP",0);
                }
			    
				$fh=fopen("/config/csv_headers.txt","w");
	            if ($fh) {
	                fwrite($fh,&$data);
            		fclose($fh);
				}
                if ($_GLOBALS['boot_drive']==1) {
                    log("Locking flash after writing static csv headers");
                    sys_set("FLASH_WP",1);
                }
				
			}
        }
        
        $last_export_time=ini_get($prefix."/ini/datalog_status.ini","status","last_export",0);
        $last_export_file=ini_get($prefix."/ini/datalog_status.ini","status","file","");
        
        if ($export_only) {
            $last_export_filepos=ini_get($prefix."/ini/datalog_status.ini","status","filepos",filesize($prefix.'/logs/log_'.$group_number.'.csv'));
        } else
            $last_export_filepos=ini_get($prefix."/ini/datalog_status.ini","status","filepos",0);
        debug_print("1. last_export_file=" . $last_export_file,'file','blue');

        $export_alerts=ini_get("/config/dataexport.ini","export","alerts",0);
	    $alerts_filepos=ini_get($prefix."/ini/datalog_status.ini","status","alert_filepos",filesize($prefix.'/logs/alert.txt'));

        $export_events=ini_get("/config/dataexport.ini","export","events",0);
	    $events_filepos=ini_get($prefix."/ini/datalog_status.ini","status","event_filepos",filesize($prefix.'/logs/event.txt'));
	    
	    if ($export_only) {
	        $logdir=$prefix."/logs/";
	    } else 
            $logdir=$prefix."/logs/"+strftime("%Y",time())."/".strftime("%m",time())."/";

// month change bug
	    // if this is new, just start from now
        if (!$last_export_file) {
            $last_export_time=time();
            $m=strftime("%M",time());
            $h=strftime("%H",time());
            if ($export_only) {
                $last_export_file = "log_".$group_number.".csv";
            } else $last_export_file = strftime("%Y%m%d",time())."_0.csv";
            $last_export_filepos=filesize($logdir.$last_export_file);
            ini_set($prefix."/ini/datalog_status.ini","status","filepos",$last_export_filepos);
            ini_set($prefix."/ini/datalog_status.ini","status","last_export",time());
            ini_set($prefix."/ini/datalog_status.ini","status","file",$last_export_file);
            	                    
        } else {
			$y=substr($last_export_file,0,4);
			$m=substr($last_export_file,4,2);
			$cury=strftime("%Y",time());
			if ($y<$cury-1) {
				print("Year wrong, resetting log file (cury=".$cur." and year=".$y);
				unlink($prefix."/ini/datalog_status.ini");
				die();
			}
            if ($export_only) {
                $logdir=$prefix."/logs/";
            } else
	            $logdir=$prefix."/logs/"+$y."/".$m."/";
		}
        debug_print("2. last_export_file=" . $last_export_file,'file');
        debug_print($last_size . " " . $last_export_filepos);
        $last_size=filesize($logdir.$last_export_file);
        debug_print("Comparison : last_size (".$last_size.") <= last_export_filepos (".$last_export_filepos.") + 10 = ".($last_size <= $last_export_filepos + 10),'file','blue');
//		print($last_size." ".$last_export_filepos);
        if (($last_size<=$last_export_filepos+2) && (file_exists($logdir.$last_export_file))) {  // added 2 bytes if the last line is CR+LF

			$y=substr($last_export_file,0,4);
			$m=substr($last_export_file,4,2);
			$d=substr($last_export_file,6,2);
			debug_print("fn=" . $y . " " . $m . " " . $d,'file','green');
			$t=mktime(0,0,0,intval($m)-1,intval($d),intval($y))+86400;

            $m=strftime("%m",$t);
            $d=strftime("%d",$t);
			$y=strftime("%Y",$t);
			if ($export_only) {
			    $logdir=$prefix."/logs/";
			    $new_export_file = "log_".$group_number.".csv";
			} else {
	            $logdir=$prefix."/logs/"+$y."/".$m."/";
	            $new_export_file = strftime("%Y%m%d",$t)."_0.csv";
			}
	        debug_print("ts=".$t . " " . $logdir,"file","green");
            
            debug_print("Check for new file " . $new_export_file);
			if (!file_exists($logdir.$new_export_file)) {
			    if (!$export_only) {
    			    if (($t<(time()-86400*30)) || ($t>time())) {
        		        $logdir=$prefix."/logs/"+strftime("%Y",time())."/".strftime("%m",time())."/";
                    	$new_export_file = strftime("%Y%m%d",time())."_0.csv";
        		        // if we have switched days
        		        if ($new_export_file!=$last_export_file) {
        		            if ((time()-$last_export_time)>(intval($ini['intervalportal'])*6)) {
        		                $last_export_file=$new_export_file;
        		                $last_export_filepos=0;
        		                
        		            }
        		        }
    			    } else {
    			        ini_set($prefix."/ini/datalog_status.ini","status","filepos",0);
                        ini_set($prefix."/ini/datalog_status.ini","status","last_export",time());
                        ini_set($prefix."/ini/datalog_status.ini","status","file",$new_export_file);
                        debug_print("switching to file " . $new_export_file);
                        die();
    			    }
			    }
			} else {
			    if (!$export_only) {
                    $last_export_file=$new_export_file;
                    $last_export_filepos=0;
			    }
			}

        }
        
function is_ok($str) {
    $res=1;
    if (function_exists('ereg')) {
        $res=ereg("^[a-zA-Z0-9_.,-]*$",&$str);
        //print($res);
    } else {
        for ($x=0;$x<strlen($str);$x++) {
            $o=charat($str,$x);
            if ((($o >= 65) && ($o < 91)) || (($o >= 97) && ($o <= 122)) || (($o >= 48) && ($o <=57 )) || ($o==32) || (($o>=44)  && ($o<=46))) {
                $ok=1;
            } else {
                $res=0;
            }
        }
    }
    return $res;
}
    debug_print("3. last_export_file=" . $last_export_file,"file","green");
        $f_log=fopen($logdir.$last_export_file,"r");
        $lines=array();
        $export_size=0;
        $csv_size=0;
        if ($export_only) {
            $mem_lines=intval($_GLOBALS['log'.$group_number.'lines']);
        } else $mem_lines=0;
        
        if ($f_log) {
            // navigate to the last saved pos
            print("Seeking to ".$last_export_filepos."\r\n");
            fseek($f_log,$last_export_filepos,0);
            print("<pre>");
            for ($l=$mem_lines;$l<$ini['export_lines'];$l++) {
                $st=fgets($f_log);
				if (!strlen($st) && !feof($f_log)) {
					$st=fgets($f_log);
				}
                //print("Len: ".strlen($st)."\r\n");
                if (strlen($st)==254) {
                    $st2=$st;
                    while (strlen($st2)==254) {
                        $st2=fgets($f_log);
                        $st.=$st2;//$st2='';
                    }
                    //$st2=fgets($f_log);
                    //$st.=$st2;$st2='';
                }
                if (!is_string($st) && !$st) {
                    break;
                }
                //$a=explode($st,',');
                $dt=intval(substr($st,0,strpos($st,',')));
                $dt=intval(strftime("%Y",$dt));
                debug_print("Line: " . $st." ".ftell($f_log)." - fs=".filesize($f_log) ,"csv","green" );
                //print($dt."\r\n");
                //print_r($a);
                if (is_ok($st) && ($dt >= 2015)) {
            /*        for ($ch=0;$ch<strlen($st);$ch++) {
                        if (charat())
                    }*/
                    debug_print($dt." OK","csv","green");
                    $st.="\r\n";
                    $export_size+=strlen($st);  // add cr+lf
                    $csv_size+=strlen($st);
                    $lines[$l]=$st;$st="";
                } else {
                    $l--;
                    $csv_size+=strlen($st);
                    debug_print("Year=" . $a . " skipping CSV line " . $st . " filepos=" . ftell($f_log) . " filesize=" . filesize($f_log),'csv','green');
                    log("[csv] Year=".$a." skipping CSV line ".$st." offset=".ftell($f_log));
                }
                if (feof($f_log)) {
                    $l++;
                    break;
                }
            }
            debug_print("EXPORT_SIZE=".$export_size,'csv');
            print("<pre>Found ".($l-$mem_lines)." lines\r\n");
            print("Export_file =".$last_export_file."\r\n");            
            print("File_size =".filesize($logdir.$last_export_file)."\r\n");
            print("Export_size =".$export_size."\r\n");
            print("CSV _size =".$csv_size."\r\n");
            if (feof($f_log) && $l<=0) {
                debug_print("jumping to next day",'file','green');
                log("Jumping to next day as no data available");
                
                $y1 = substr($last_export_file, 0, 4);
                $m1 = substr($last_export_file, 4, 2);
                $d1 = substr($last_export_file, 6, 2);
                debug_print("fn=" . $y1 . " " . $m1 . " " . $d1,'csv');
                $t = mktime(0, 0, 0, intval($m1) - 1, intval($d1), intval($y1)) + 86400;
                $m2 = strftime("%m", time());
                $d2 = strftime("%d", time());
                $y2 = strftime("%Y", time());
                
                $m = strftime("%m", $t);
                $d = strftime("%d", $t);
                $y = strftime("%Y", $t);
                debug_print ($y1." ".$m1." ".$d1." -- ".$y2." ".$m2." ".$d2,'csv');
                if (($m2==$m1) && ($d2==$d1) && ($y2==$y1)) {
                    debug_print("at end of file in current day, abort",'csv','red');
                    die();
                }
                if ($export_only) {
                    $logdir          = $prefix."/logs/";
                    $new_export_file = "log_" . $group_number . ".csv";
                } else {
                    $logdir          = $prefix."/logs/" + $y . "/" . $m . "/";
                    $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
                }
                
                // if we have switched days
                if ($new_export_file != $last_export_file) {
                    debug_print("New file=" . $new_export_file . " and old file=" . $last_export_file,'csv','green');
                    if ((time() - $last_export_time) > (intval($ini['intervalportal']) * 60)) {
                        debug_print("Updating file to new one",'csv','green');
                        $last_export_file    = $new_export_file;
                        $last_export_filepos = 0;
                        ini_set($prefix."/ini/datalog_status.ini", "status", "filepos", $last_export_filepos);
                        ini_set($prefix."/ini/datalog_status.ini", "status", "last_export", time());
                        ini_set($prefix."/ini/datalog_status.ini", "status", "file", $last_export_file);

                    } else {
                        debug_print((time() - $last_export_time) . ">" . (intval($ini['intervalportal']) * 60),'export','green');
                    }
                }
                die();
                
            }
            	        
          //  print_r($lines);
            fclose($f_log);
        }   
        if ($export_alerts) {
                $f_alert=fopen($prefix.'/logs/alert.txt',"r");
                print("Alerts enabled");
                if ($f_alert) {
                    // navigate to the last saved pos
                    fseek($f_alert,$alerts_filepos,0);
                    $alerts=array();
                    $alert_export_size=0;
                    $alert_csv_size=0;
                    print("<pre>");
                    for ($l=0;$l<5;$l++) {  // max 5 alerts
                        $st=fgets($f_alert);
                        //print("Len: ".strlen($st)."\r\n");
                        if (strlen($st)==254) {
                            $st2=$st;
                            while (strlen($st2)==254) {
                                $st2=fgets($f_alert);
                                $st.=$st2;//$st2='';
                            }
                        }
                        if (!$st) {
                            break;
                        }
                        $st.="\r\n";
                         $alert_csv_size+=strlen($st);
                        $left=strpos($st,': ');
                        $enc=substr($st,$left+1);
                        $st=substr($st,0,$left+1).urlencode($enc);
                        $enc='';
                        $alert_export_size+=strlen($st);  // add cr+lf
                        $alerts[$l]=$st;$st="";
                    }
                    print("<pre>Found ".$l." lines\r\n");
                    print("Export_file =".$alert_export_size."\r\n");            
                    print("File_size =".filesize($prefix.'/logs/alert.txt')."\r\n");
                    print("Export_size =".$alert_export_size."\r\n");
                    print("CSV _size =".$alert_csv_size."\r\n");
                }
        }
        
        if ($export_events) {
                $f_event=fopen($prefix.'/logs/event.txt',"r");
                print("Events enabled");
                if ($f_event) {
                    // navigate to the last saved pos
                    fseek($f_event,$events_filepos,0);
                    $events=array();
                    $event_export_size=0;
                    $event_csv_size=0;
                    print("<pre>");
                    for ($l=0;$l<5;$l++) {  // max 5 alerts
                        $st=fgets($f_event);
                        //print("Len: ".strlen($st)."\r\n");
                        if (strlen($st)==254) {
                            $st2=$st;
                            while (strlen($st2)==254) {
                                $st2=fgets($f_event);
                                $st.=$st2;//$st2='';
                            }
                        }
                        if (!$st) {
                            break;
                        }
                        $st.="\r\n";
                         $event_csv_size+=strlen($st);
                        $left=strpos($st,': ');
                        $enc=substr($st,$left+1);
                        $st=substr($st,0,$left+1).urlencode($enc);
                        $enc='';
                        $event_export_size+=strlen($st);  // add cr+lf
                        $events[$l]=$st;$st="";
                    }
                    print("<pre>Found ".$l." lines\r\n");
                    print("Export_file =".$event_export_size."\r\n");            
                    print("File_size =".filesize($prefix.'/logs/event.txt')."\r\n");
                    print("Export_size =".$event_export_size."\r\n");
                    print("CSV _size =".$event_csv_size."\r\n");
                }
        }
//            die();
            // only export data if something has changed
            if (sizeof($lines) || $mem_lines) {
                $host=$ini['portal'];
				if (!$host) $host='my.wattmon.com';
                if ($host=='my.wattmon.com') {
                    $dns_ip="35.204.188.95";
                } else {
                    if (($host=='mycloud.wattmon.com') || ($host=='ems.wattmon.com') || ($host=='beta.wattmon.com')) {
                        $dns_ip="104.199.148.202";
                    } else {
                        $dns_ip=ini_get("/config/dns.ini","dns",$host,$host);
                    }
                }
                
                if ($ini['secure']) {
                    print("Connecting to https://".$dns_ip);
            	    $f=fsockopen($dns_ip,443,30);
                } else {
                    print("Connecting to ".$dns_ip);
            	    $f=fsockopen($dns_ip,80,30);
                }
            	$log_buf_len=strlen($_GLOBALS['log'.$group_number.'buf']);
            	//$f=fsockopen("192.168.0.7",80,10);
            	if ($f) {
            	    
            	    $out = "POST /data/setdatacsv HTTP/1.0\r\n"; //="+$ini['devicename']+"&key="+$ini['devicekey']+"&v="+$_GLOBALS['battery_voltage']+"&pc="+$_GLOBALS['battery_percent']+"
            	    //$out = "POST /wattmononline/data/setdatacsv HTTP/1.0\r\n";
                    $out = $out."Host: ".$host."\r\n";
                    //$out = $out."Host: 192.168.0.7\r\n";
                    $out = $out."Content-Type: application/x-www-form-urlencoded\r\n";
            	    $out = $out."Connection: Keep-Alive\r\n"; // Keep-Alive
            	    $mac=ini_get("/config/uphp.ini","debug","mac_override",getmac());
            	    if (($ini['md5']==1) && function_exists('md5')) {
            	        
            	        $data.="\r\n";
						for ($l=0;$l<sizeof($lines);$l++)  {
							$data.=$lines[$l];//."\r\n";
							$lines[$l]=0;
		        	    }
		        	    $data.=$_GLOBALS['log'.$group_number.'buf'];
            	        $md5=md5($data);
            	        
            	        $data= "key="+$mac."&md5sum=".strtolower($md5)."&data=".$data;
						$len=strlen($data);//$export_size;
						
						if ($export_alerts) {
                	        $alert_data="";
    						for ($l=0;$l<sizeof($alerts);$l++)  {
    							$alert_data.=$alerts[$l];//."\r\n";
    							$alerts[$l]=0;
    		        	    }
    		        	    //$len+=strlen($alert_data);
    		        	    $data.="&alert=".$alert_data;//."\r\n";
    		        	    $len=strlen($data);//$export_size;
    
                	    }
                	    if ($export_events) {
                	        $event_data="";
    						for ($l=0;$l<sizeof($events);$l++)  {
    							$event_data.=$events[$l];//."\r\n";
    							$events[$l]=0;
    		        	    }
    		        	    //$len+=strlen($alert_data);
    		        	    $data.="&event=".$event_data;//."\r\n";
    		        	    $len=strlen($data);//$export_size;
    
                	    }
            	    } else {
						
            	        
						//$len=strlen($data)+$export_size;
						//print("\r\nLEN = "+strlen($data)+" + "+$export_size);
						$data.="\r\n";
						for ($l=0;$l<sizeof($lines);$l++)  {
							$data.=$lines[$l];//."\r\n";
							$lines[$l]=0;
		        	    }
		        	    $data.=$_GLOBALS['log'.$group_number.'buf'];
		        	    $data= "key="+$mac."&data=".$data;
		        	    $len=strlen($data);//$export_size;
		        	    if ($export_alerts) {
                	        $alert_data="";
    						for ($l=0;$l<sizeof($alerts);$l++)  {
    							$alert_data.=$alerts[$l];//."\r\n";
    							$alerts[$l]=0;
    		        	    }
    		        	    //$len+=strlen($alert_data);
    		        	    $data.="&alert=".$alert_data;//."\r\n";
    		        	    $len=strlen($data);//$export_size;
    
                	    }
                	    if ($export_events) {
                	        $event_data="";
    						for ($l=0;$l<sizeof($events);$l++)  {
    							$event_data.=$events[$l];//."\r\n";
    							$events[$l]=0;
    		        	    }
    		        	    //$len+=strlen($alert_data);
    		        	    $data.="&event=".$event_data;//."\r\n";
    		        	    $len=strlen($data);//$export_size;
    
                	    }
            	    }
            	    
            	    //$len=strlen($data)+strlen($_GLOBALS['log0buf']);
            	    $out = $out."Content-Length: ".$len."\r\n\r\n";
            	    print($out);
            	    fwrite($f, $out);
            	    //print($data);
				//	if (($ini['md5']==1) && function_exists('md5')) {
	            	    $cnt=strlen($data);
						 $send_counter=0;
						while ($cnt) {
						    $oldcnt=$cnt;
							$cnt=fwrite($f,&$data);
							if ($oldcnt==$cnt) {
							    $send_counter++;
							    if ($send_counter>5) {
    							    log("Connection broken");
	    						    die();

							    }
							}
							print($data);
							if ($cnt==-1) {
							    log("Connection broken");
								$stat=get3gstat(); 
		                        
							    die();
							}
							if ($cnt) {
								print($cnt." bytes left in buffer..\r\n");
								$data=substr($data,strlen($data)-$cnt);
								
							}
							
						}
	        	    // get header
            	    $done=0;
            	    $start=microtime();
            	    // if we received anything back, assume the export succeeded
            	    $done=0;
					$error_skip=0;
					$got_data=0;
            	     while (!$done) {
            		    $str=fgets($f);
            		    print("IN2: ".$str+"\r\n");
                      //  print("***:".$str);//+"\r\n");
            		    if ($str) {
            		        $got_data=1;
            		        if (strpos($str,"500 Internal")>0) {
            		            log("[data export] Internal Server Error 500 reported, skipping segment and moving on.");
            		            print("[data export] Internal Server Error 500 reported, skipping segment and moving on.");
            		            $error_skip=1;
            		            $done=1;
            		        }
            		    }
            		    if ($data && ($str==-1)) {
            		        log("Connection broken");
							$stat=get3gstat(); 
							if ($stat['enabled']) {
		                            if ($stat['connected'] || intval($ini['force_reboot'])) {
		                                if (($stat['ip_address']!='0.0.0.0') || intval($ini['force_reboot'])) {
		                                    $_GLOBALS['error3g']++;
		                                    if ($_GLOBALS['error3g']>=5) {
		                                        log("Cellular link seems to have died, restarting USB power");
		                                        setusbpower(0);
		                                        sleep(500);
		                                        setusbpower(1);
		                                        $_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
		                                        $_GLOBALS['error3g']=0;
		                                        if ($_GLOBALS['restarts']>3) {
		                                          log("Restarting due to link issues.") ;
		                                          reset();
		                                        };
		                                    }
		                                    
		                                }
		                            } else {
		                            	
		                            		if ($_GLOBALS['exportportalint'] % 10==9) {
		                            			log("Cellular link seems to have died, restarting USB power");
		                            			setusbpower(0);
		                            			sleep(500);
		                            			setusbpower(1);
		                            			$_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
		                            			$_GLOBALS['error3g']=0;
		                            		}
		                            		
		                            		
		                            }
		                        }
            		        die();
            		    }
            		    if (strlen($str)==0 && $got_data) $done=1;
            	    }
            	    //while (!feof($f)) {
            	    if (!$error_skip) {
            	        $str=fread($f,filesize($f));
            	        print("\r\nBody:".$str);
            	    }
            	    //}
            	        
            	    if ((strpos($str,"OK")>=0) || $error_skip) {
            	        print("Success!");
            	        $_GLOBALS['restarts']=0;
            	        $last_export_filepos+=$csv_size;
            	        ini_set($prefix."/ini/datalog_status.ini","status","filepos",$last_export_filepos);
            	        ini_set($prefix."/ini/datalog_status.ini","status","last_export",time());
            	        ini_set($prefix."/ini/datalog_status.ini","status","file",$last_export_file);
            	        
            	         if ($export_alerts) {
            	             $alerts_filepos+=$alert_csv_size;
            	             ini_set($prefix."/ini/datalog_status.ini","status","alert_filepos",$alerts_filepos);
            	         }
            	         if ($export_events) {
            	             $events_filepos+=$event_csv_size;
            	             ini_set($prefix."/ini/datalog_status.ini","status","event_filepos",$events_filepos);
            	         }
// only wait if there is nothing to buffer
                        if ($export_only) {
                            if (strlen($_GLOBALS['log'.$group_number.'buf'])==$log_buf_len) {
						        $_GLOBALS['log'.$group_number.'buf']='';
                                $_GLOBALS['log'.$group_number.'lines']=0;
						    } else {
						        
						        $_GLOBALS['log'.$group_number.'buf']=substr($_GLOBALS['log'.$group_number.'buf'],$log_buf_len,strlen($_GLOBALS['log'.$group_number.'buf'])-$log_buf_len);
                                $_GLOBALS['log'.$group_number.'lines']=1;
						        
						    }
                        }
						if ($last_export_filepos>=$last_size) {
						    if (!$export_only) {
    						    if ($last_export_file==strftime("%Y%m%d",time())."_0.csv") {
    						        print("Resetting export interval to 0\r\n");
    							    $_GLOBALS['exportportalint']=0; // restore for the next time
    						    }
						    } else $_GLOBALS['exportportalint']=0;
						} else {
						    
						    print("BUFFER INTERVAL=".$buffer_interval);
						    if ($buffer_interval) exec("/scripts/ip.cgi",$buffer_interval);
						}
            		} else {
            		    log("Error exporting: ".$str);
            		    if ($export_only) {
                            $fs=fopen($prefix."/logs/log_".$group_number.".csv","a");
                            if ($fs) {
                                fwrite($fs,&$_GLOBALS['log'.$i.'buf']);
                                fclose($fs);
                            }
                            $_GLOBALS['log'.$i.'buf']='';
                            $_GLOBALS['log'.$i.'lines']=0;
            		    }
            		}
            		if ($_GET['debug']) {
                		$st=fread($f,512);
                		while (strlen($st)) {
                		    print($st);
                		    $st=fread($f,512);
                		}
            		}
            	    fclose($f);
            	    
            	    print("finished executing export.cgi");
            	    
            	    $_GLOBALS['error3g']=0;
            	    $_GLOBALS['restarts']=0;
            	} else {
            	    if ($export_only) {
                        $fs=fopen($prefix."/logs/log_".$group_number.".csv","a");
                        if ($fs) {
                            fwrite($fs,&$_GLOBALS['log'.$i.'buf']);
                            fclose($fs);
                        }
                        $_GLOBALS['log'.$i.'buf']='';
                        $_GLOBALS['log'.$i.'lines']=0;
            		}
                    $stat=get3gstat(); 
                    if ($stat['enabled']) {
                        if ($stat['connected'] || intval($ini['force_reboot'])) {
                            if (($stat['ip_address']!='0.0.0.0') || intval($ini['force_reboot'])) {
                                $_GLOBALS['error3g']++;
                                if ($_GLOBALS['error3g']>=5) {
                                    log("Cellular link seems to have died, restarting USB power");
                                    setusbpower(0);
                                    sleep(500);
                                    setusbpower(1);
                                    $_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
                                    $_GLOBALS['error3g']=0;
                                    if ($_GLOBALS['restarts']>3) {
                                      log("Restarting due to link issues.") ;
                                      reset();
                                    };
                                }
                                
                            }
                        } else {
                        	
                        		if ($_GLOBALS['exportportalint'] % 10==9) {
                        			log("Cellular link seems to have died, restarting USB power");
                        			setusbpower(0);
                        			sleep(500);
                        			setusbpower(1);
                        			$_GLOBALS['restarts']=$_GLOBALS['restarts']+1;
                        			$_GLOBALS['error3g']=0;
                        		}
                        		
                        		
                        }
                    }
            	    $_GLOBALS['exportportalint']=$ini['intervalportal']+1; // retry next minute...
            	    print("unable to connect to host");
            	}
            } else {    // nothing to export
                    if (($l==0) && $csv_size) {
                        $last_export_filepos+=$csv_size;
                        print("reset counter to next valid line");
                        ini_set($prefix."/ini/datalog_status.ini","status","filepos",$last_export_filepos);
                        ini_set($prefix."/ini/datalog_status.ini","status","last_export",time());
                        ini_set($prefix."/ini/datalog_status.ini","status","file",$last_export_file);
                    }
            	    $_GLOBALS['exportportalint']=0; // restore for the next time
            	    $_GLOBALS['error3g']=0;
            }
         // fopen
    	
    }
} 

if ($ini['export_emoncms']==1) {
    $_GLOBALS['exportemon']++;
    if ($_GLOBALS['exportemon']>=$ini['intervalemon']) 
    {  
            $fs=fsockopen("emoncms.org",80,10);
        	if ($fs) {

        	    $out = "GET /input/post.json?apikey=".$ini['emonkey']."&json={".$_GLOBALS['logexp']."} HTTP/1.0\r\n";
        	    $out = $out."Host: emoncms.org\r\nConnection: Close\r\n\r\n";
               // 
        	    print($out);
        	    fwrite($fs, $out);
        	    $done=0;
        	    $str=fgets($fs);
        	    $done=0;
        	    fclose($fs);
        	}
    } else {
    	    print("unable to connect to host");
    	}
    	$_GLOBALS['exportemon']=0; // restore for the next time
    
}    



if ($ini['export_custom']==1) 
{
   include("/scripts/ip_export_custom.cgi");
} 

if ($ini['export_mqtt']==1) 
{
   if (file_exists("/scripts/ip_export_mqtt.cgi"))
     include("/scripts/ip_export_mqtt.cgi");
} 

if ($ini['export_pvoutput']==1) 
{
   if (file_exists("/scripts/pvoutput.cgi"))
    include("/scripts/pvoutput.cgi");
} 

function urlencode($s)
{
    $slen=strlen($s);
    $res='';
	for ($i=0; $i<$slen; $i++) {
	    $x=charat($s,$i); //"-", ".", "_", "~")
	    $c=chr($x);
	    if ((($c>='0') && ($c<='9')) || (($c>='A') && ($c<='Z')) || (($c>='a') && ($c<='z')) || ($c == '~') ||($c == '-') || ($c == '.') || ($c == '_')) {  
	        $res.=$c;
	    } else {
	        if ($c==' ') {
	            $res.="+";
	        } else {
	            $res.=sprintf("%%%02X",$x);
	        }
	    }
	}
	return $res;
}  
?></pre>












