<?
/**
 * @package PowerControl Manager
 * @author Akash Heimlich
 * @description This package will control inverter power based on a power meter and set points.
 * @date_created 06/12/18    WattmonOS 3
 * @date_updated 10/02/23    WattmonOS 3.18
 */
    define("PC_VERSION","20240905");
    
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 

   // power controls script version
   
    $version=1.1; 
    
    function PC_install($val) {
        PC_enable();
        return 1;
    }
     
    function PC_uninstall() {
        setPackageStatus("PC",0);
        return 1;
    }
    
    function PC_enable() {
        setPackageStatus("PC",2);
        //addWidget("/package/PC.inc","PowerControl",12,"icon-play",1,0); // enable
        return 1;
    }
    
    function PC_disable() {
        setPackageStatus("PC",3);
        //addWidget("/package/PC.inc","PowerControl",12,"icon-play",1,1); // disable
        return 1;
    }
    
    function PC_ajax() {
//        $_GLOBALS['studer_custom_id']=$_GET['device_id'];
        $st=1;
    }
    function PC_globals() {
      //  print("in PC_globals");
        return array(
                    array('eb_state','State of EB Input'),
                    array('kWh_Curtailment_Day','kWh Curtailed Today'),
                    array('kWh_Curtailment_Lifetime','Total kWh Curtailed'),
                    array('kWh_Curtailment_DG_Day','Curtailement due to DG'),
                    array('kWh_Curtailment_Grid_Day','Curtailment due to Zero Export')
                );
    }
    function add_role($id,$role_name,$role_group,$role_type,$role_show,$role_def,$role_devices) {
        if ($id==-1)  {
            $num_r=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($j=0;$j<$num_r;$j++) { 
                if ($role_name==ini_get("/config/roles.ini","roles","role"+$j,'')) {
                    break;
                }
            }
            $id=$j;
            print("found role at ".$id."\r\n");
            if ($id==$num_r)  {
                ini_set("/config/roles.ini","roles","num_roles",$id+1);
                $f=fopen("/config/roles.ini",'a+');
                $st="role"+$id+"=".$role_name."\r\n".
                    "role"+$id+"group=".$role_group."\r\n".
                    "role"+$id+"type=".$role_type."\r\n".
                    "role"+$id+"ids=".$role_devices."\r\n".
                    "role"+$id+"def=".$role_def."\r\n".
                    "role"+$id+"show=".$role_show."\r\n";
                fwrite($f,$st);
                fclose($f);
                
            /*    ini_set("/config/roles.ini","roles","role"+$id,$role_name);
                ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
                ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
                ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
                ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
                ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);*/
            }
            
        } else {
            if (ini_get("/config/roles.ini","roles","role"+$id)!=$role_name)
                        ini_set("/config/roles.ini","roles","role"+$id,$role_name);
            if (ini_get("/config/roles.ini","roles","role"+$id+"group")!=$role_group)                    
                        ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
            if (ini_get("/config/roles.ini","roles","role"+$id+"type")!=$role_type)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
            if (ini_get("/config/roles.ini","roles","role"+$id+"ids")!=$role_devices)                                            
                        ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
            if (ini_get("/config/roles.ini","roles","role"+$id+"def")!=$role_def)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
            if (ini_get("/config/roles.ini","roles","role"+$id+"show",0)!=$role_show)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);
        }
    }

    /* this is called at system boot */
    function PC_init() {
        global $version;
        //log('init pc.cgi');
        // power meters
        $_GLOBALS['pc_pm']=array();
        
        // inverters
        $_GLOBALS['pc_inv']=array();
        
        // number of power meters
        $_GLOBALS['pc_pm_cnt']=ini_get("/config/PC.ini","config","pm_count",0);
        
        // number of inverters
        $_GLOBALS['pc_inv_cnt']=ini_get("/config/PC.ini","config","inv_count",0);
        
        // default percentage for inverters when unable to read power values
        $_GLOBALS['pc_default_pc']=ini_get("/config/PC.ini","config","default_pc",0);
        
        // average or phase-wise
        $_GLOBALS['power_mode']=ini_get("/config/PC.ini","config","power_mode",0);
        $_GLOBALS['reactive_power_mode']=ini_get("/config/PC.ini","config","reactive_power_mode",0);

        // track the curtailment losses
        $_GLOBALS['track_curtailment']=ini_get("/config/PC.ini","config","track_curtailment",0);
        
        $_GLOBALS['pf_control']=ini_get("/config/PC.ini","config","pf_control",0);
        
        $_GLOBALS['bus_coupler']=ini_get("/config/PC.ini","config","bus_coupler",0);
        
        $_GLOBALS['pc_ramp_mode']=ini_get("/config/PC.ini","config","ramp_mode",0);
        
        $_GLOBALS['pc_tcp_fail_check'] = ini_get("/config/PC.ini","config","tcp_fail_check",0);
        
        if ($_GLOBALS['pc_tcp_fail_check']) {
            $_GLOBALS['pc_tcp_fail_interval'] = ini_get("/config/PC.ini","config","tcp_fail_interval",60);
            $_GLOBALS['pc_tcp_fail_percent'] = ini_get("/config/PC.ini","config","tcp_fail_percent",100);
        }
        
        // load the power meter info
        for ($i = 0; $i < $_GLOBALS['pc_pm_cnt']; $i++) {
            $pm_arr = array();
            $pm_arr['device_idx'] = ini_get("/config/PC.ini","config","pm".$i."_device_idx",0);
            $dev=mb_get_dev_by_index($pm_arr['device_idx']);
            
            $pm_arr['pf_role']=-1;  // -1 = no PF field found or PF control disabled
            //if ($_GLOBALS['pf_control']) {
                // MINI & PRO have less memory, so iterate through the ini file slowly
                if ($_SERVER['HW_PLATFORM']<2) {
                    $num_roles=ini_get("/dev/dev".$dev['device_type_id'].".ini","config","num_roles",0);
                    
                    for ($r=0;$r<$num_roles;$r++) {
                        $role_name=ini_get("/dev/dev".$dev['device_type_id'].".ini","config","role_var_".$r,"");
                        if ($role_name=="AC_PF") {
                            $pm_arr['pf_role']=$r;
                            break;
                        }
                    }
                } else {
                    $dev_info=ini_get_array("/dev/dev".$dev['device_type_id'].".ini","config");
                    //print_r($dev_info);
                    for ($r=0;$r<$dev_info['num_roles'];$r++) {
                        if (strval($dev_info['role_var_'.$r])=="kWh_Total_Import") {
                            $pm_arr['kwh_import_role']=$r;
                        }
                        if (strval($dev_info['role_var_'.$r])=="AC_PF") {
                            $pm_arr['pf_role']=$r;
                        }
                        if (strval($dev_info['role_var_'.$r])=="AC_Reactive_Power") {
                            $pm_arr['reactive_role']=$r;
                            print("MATCH AC_Reactive_Power role ".$r."\r\n");
                        }
                        if (strval($dev_info['role_var_'.$r])=="AC_Reactive_Power_A") {
                            $pm_arr['reactive_role_a']=$r;
                            print("MATCH AC_Reactive_Power_A role ".$r."\r\n");
                        }
                        if (strval($dev_info['role_var_'.$r])=="AC_Reactive_Power_B") {
                            $pm_arr['reactive_role_b']=$r;
                            print("MATCH AC_Reactive_Power_B role ".$r."\r\n");
                        }

                        if (strval($dev_info['role_var_'.$r])=="AC_Reactive_Power_C") {
                            $pm_arr['reactive_role_c']=$r;
                            print("MATCH AC_Reactive_Power_C role ".$r."\r\n");
                        }
                        
                    }
                    $dev_info=0;
                }
            //}
            $pm_arr['device_id']=$dev['slave_id'];
            $pm_arr['disabled'] = ini_get("/config/PC.ini","config","pm".$i."_disabled",0);
            $pm_arr['max'] = ini_get("/config/PC.ini","config","pm".$i."_max",0);
            $pm_arr['min'] = ini_get("/config/PC.ini","config","pm".$i."_min",0);
            $pm_arr['type'] = ini_get("/config/PC.ini","config","pm".$i."_type",0);
            $pm_arr['pf'] = ini_get("/config/PC.ini","config","pm".$i."_pf",0);
            $pm_arr['reactive_threshold'] = ini_get("/config/PC.ini","config","pm".$i."_reactive_threshold",0.5)*1000;
            $pm_arr['priority'] = ini_get("/config/PC.ini","config","pm".$i."_priority",0);
            $pm_arr['group'] = ini_get("/config/PC.ini","config","pm".$i."_group",0);
            $pm_arr['group_override'] = 0;
            $pm_arr['plant_size'] = ini_get("/config/PC.ini","config","pm".$i."_plant_size",0);
            if (($pm_arr['type']==3)) {
                if (($pm_arr['pf']==0) && ($pm_arr['priority']==0)) {
                    log("Check meter on ID ".$pm_arr['device_id']." will not be used in the power control algorithm.");
                }
            }
            $pm_arr['power_mode'] = $_GLOBALS['power_mode'];
            $pm_arr['reactive_power_mode'] = $_GLOBALS['reactive_power_mode'];
            
            
            if ($_GLOBALS['power_mode']==1) {  // we need to get the indexes of the roles from the power driver
                for ($r=0; $r < $dev['num_roles']; $r++) {
                    $role_name=ini_get("/dev/dev".$dev['device_type_id'].".ini","config","role_var_".$r,"");
                    if ($role_name=="AC_Active_Power_A") {
                        $pm_arr['role_a']=$r;
                    }
                    if ($role_name=="AC_Active_Power_B") {
                        $pm_arr['role_b']=$r;
                    }
                    if ($role_name=="AC_Active_Power_C") {
                        $pm_arr['role_c']=$r;
                    }
                }
                
                // if the right role names are not there, just do average active power control
                //print_r($pm_arr);
                if (!isset($pm_arr['role_a']) ||!isset($pm_arr['role_b']) || !isset($pm_arr['role_c'])) {
                    $pm_arr['power_mode']=0;
                    log("Unable to use phase-wise control as meter ".$dev['name']." does not seem to have the right format");
                }
            }
			$_GLOBALS['pc_pm'][$i]=$pm_arr;           
        }
        
        // load the inverter info
        $total_inverter_kw=0;
        
        // the reactive kw will tell us the inverter capacity that is ready for reactive power control
        $group_total = array();
        $total_reactive_kw=0;
        for ($i = 0; $i < $_GLOBALS['pc_inv_cnt']; $i++) {
            $pm_arr = array();
            $pm_arr['device_idx'] = ini_get("/config/PC.ini","config","inv".$i."_device_idx",0);
            $dev=mb_get_dev_by_index($pm_arr['device_idx']);
            $pm_arr['device_id']=$dev['slave_id'];
            $pm_arr['rating'] = ini_get("/config/PC.ini","config","inv".$i."_rating",0);
            $pm_arr['pf'] = ini_get("/config/PC.ini","config","inv".$i."_pf",0);
            $pm_arr['group'] = intval(ini_get("/config/PC.ini","config","inv".$i."_group",0));
            $total_inverter_kw+=intval($pm_arr['rating']);
            $group_total[$pm_arr['group']]+=intval($pm_arr['rating']);
            if ($pm_arr['pf']) {
                $total_reactive_kw+=intval($pm_arr['rating']);
                $dev_info=ini_get_array("/dev/dev".$dev['device_type_id'].".ini","config");
                   // print_r($dev_info);
                for ($r=0;$r<$dev_info['num_roles'];$r++) {
                    if (strval($dev_info['role_var_'.$r])=="AC_Reactive_Power") {
                        $pm_arr['reactive_role']=$r;
                    }
                }
                if (!$pm_arr['reactive_role']) 
                        $pm_arr['reactive_role']=1; // assume role 1 if not otherwise
                $dev_info=0;
            }
            $pm_arr['default_pc'] = ini_get("/config/PC.ini","config","inv".$i."_default_pc",0);
            $pm_arr['cur_percent'] = -1;
            $pm_arr['plant_size'] = ini_get("/config/PC.ini","config","inv".$i."_plant_size",0);
            $_GLOBALS['pc_inv'][$i]=$pm_arr;           
        }
        
        for ($i=0;$i<sizeof($group_total);$i++) {
            $k=array_key($group_total,$i);
            log("check group ".$k);
            for ($p=0;$p<sizeof($_GLOBALS['pc_pm']);$p++) {
                if (!$_GLOBALS['pc_pm'][$p]['group'] || ($_GLOBALS['pc_pm'][$p]['group'] & intval($k)>0)) {
                //    log($_GLOBALS['pc_pm'][$p]['group']." is port of ".$k);
                    $_GLOBALS['pc_pm'][$p]['group_plant_size']+=$group_total[$k];
                }
            }
        }
        
        /** 
         * This is the total kWh for all the inverters on this device
         * It will be used when calculating power control limits in multi-wattmon setups
         **/
        $_GLOBALS['pc_this_plant_size']=$total_inverter_kw;
        
        /**
         * This value will be used by the dynamic PF correction algorithm
         **/
        $_GLOBALS['pc_total_reactive_kw']=$total_reactive_kw;
        
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/PC.cgi?action=configure';
        $arr['title']='Power Control';
        
        $arr['icon']='icon-hdd';
        $arr['desc']='Power Control Settings';
         $found=0;
        for ($i=0;$i<sizeof($_GLOBALS['hooks']['cpanel']);$i++) {
            if ($_GLOBALS['hooks']['cpanel'][$i]['script']=='/package/PC.cgi?action=configure') $found=1;
        }
        if (!$found) $_GLOBALS['hooks']['cpanel'][]=$arr;
        
       
        
        // generate ajax data for front end processing
        $found=0;
        for ($i=0;$i<sizeof($_GLOBALS['hooks']['ajax']);$i++) {
            if ($_GLOBALS['hooks']['ajax'][$i]=='/package/PCAjax.inc') $found=1;
        }
        //print($found);
       
         if (file_exists('/package/PCAjax.inc')) {
              if (!$found) {
                  print('install ajax');
                $_GLOBALS['hooks']['ajax'][]='/package/PCAjax.inc';
            }
        }
        // runs this file once a second
        $found=0;
        for ($i=0;$i<sizeof($_GLOBALS['hooks']['sec']);$i++) {
            if ($_GLOBALS['hooks']['sec'][$i]=='/package/PCSec.inc') $found=1;
            if ($_GLOBALS['hooks']['sec'][$i]=='/package/PCSec.enc') $found=1;
        }
//        print($found);
        
        if (file_exists('/package/PCSec.enc')) {
            $license_key=ini_get("/config/license.ini","config","key1","");
            
            $license_valid=set_unlock_code($license_key);
            
            if ($license_valid) {
              $_GLOBALS['pc_license']=$license_key;
              $license_type="";
              if ($license_valid==1) {
                  $license_type="Legacy Key - Zero Feed in and DG Sync";
              } else {
                  if ($license_valid & 2) $license_type.="Zero Feed-In";
                  if ($license_valid & 4) $license_type.=(strlen($license_type)?",":"")."DG Protection";
                  if ($license_valid & 8) $license_type.=(strlen($license_type)?",":"")."Dynamic PF Correction";
                  if ($license_valid & 16) $license_type.=(strlen($license_type)?",":"")."Multiple Control Groups";
                     
              }
              if (!$found) {
                 
                log("Power control license key is valid, enabling power control - License type:".$license_type);
                $_GLOBALS['hooks']['sec'][]='/package/PCSec.enc';
                if ($_GLOBALS["VERMINOR"]>1200) {
                    init_watchdog(120,1); // start up watchdog for PC on Watchdog 1 at 60 seconds
                    log("[pc] Initializing software reboot watchdog 1 at 120 seconds");
                }                
              }
            } else log("Enter a valid license for power control and reboot for it to take effect.");
        } else if (file_exists('/package/PCSec.inc')) {
            $license_key=ini_get("/config/license.ini","config","key1","");
            
            $license_valid=set_unlock_code($license_key);
            
            if ($license_valid) {
              $_GLOBALS['pc_license']=$license_key;
              $license_type="";
              if ($license_valid==1) {
                  $license_type="Legacy Key - Zero Feed in and DG Sync";
              } else {
                  if ($license_valid & 2) $license_type.="Zero Feed-In";
                  if ($license_valid & 4) $license_type.=(strlen($license_type)?",":"")."DG Protection";
                  if ($license_valid & 8) $license_type.=(strlen($license_type)?",":"")."Dynamic PF Correction";
                  if ($license_valid & 16) $license_type.=(strlen($license_type)?",":"")."Multiple Control Groups";
              }
              
                 
                log("Power control license key is valid, enabling power control - License type:".$license_type);
                //$_GLOBALS['hooks']['sec'][]='/package/PCSec.enc';
                if ($_GLOBALS["VERMINOR"]>1200) {
                    init_watchdog(300,1); // start up watchdog for PC on Watchdog 1 at 60 seconds
                    log("[pc] Initializing software reboot watchdog 1 at 60 seconds");
                }                
              
            } else log("Enter a valid license for power control and reboot for it to take effect.");
              if (!$found) {
                  print('install sec');
             $_GLOBALS['hooks']['sec'][]='/package/PCSec.inc';
            }
        }
        // runs this file once a second
        $found=0;
        for ($i=0;$i<sizeof($_GLOBALS['hooks']['min']);$i++) {
            if ($_GLOBALS['hooks']['min'][$i]=='/package/PCMin.inc') $found=1;
        }
  //      print($found);
        
            if (file_exists('/package/PCMin.inc')) {
                if (!$found) {
                    print('install min');
             $_GLOBALS['hooks']['min'][]='/package/PCMin.inc';
            }
        }
   $found=0;
        for ($i=0;$i<sizeof($_GLOBALS['hooks']['day']);$i++) {
            if ($_GLOBALS['hooks']['day'][$i]=='/package/PCDay.inc') $found=1;
        }
  //      print($found);
        
            if (file_exists('/package/PCDay.inc')) {
                if (!$found) {
                    print('install day');
             $_GLOBALS['hooks']['day'][]='/package/PCDay.inc';
            }
        }
        return 1;
    }
    function urlencode($s)
    {
    $slen=strlen($s);
    $res='';
	for ($i=0; $i<$slen; $i++) {
	    $x=charat($s,$i); //"-", ".", "_", "~")
	    $c=chr($x);
	    if ((($c>='0') && ($c<='9')) || (($c>='A') && ($c<='Z')) || (($c>='a') && ($c<='z')) || ($c == '~') ||($c == '-') || ($c == '.') || ($c == '_')) {  
	        $res.=$c;
	    } else {
	        if ($c==' ') {
	            $res.="+";
	        } else {
	            $res.=sprintf("%%%02X",$x);
	        }
	    }
	}
	return $res;
}
    function PC_configure() {
        global $version;
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="PCWidget"; 
        $title='Configure Package Power Control';
        $config_file="PC.ini";
        $config_section="config";
        $num_inverters=$_GLOBALS['inverter_count']?$_GLOBALS['inverter_count']:1;
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        $license_key=ini_get("/config/license.ini","config","key1","");
        $accepted_terms=ini_get("/config/license.ini","config","accepted_terms",0);
        $license_valid=set_unlock_code($license_key);
        ?> 
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','PC')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','PC')) ?> <? print(PC_VERSION); ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','PC')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-show='accepted_terms==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','PC')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','PC')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','roleedit')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>
<!-- VARIABLES -->
<? 
            $inv_cnt=ini_get("/config/PC.ini","config",'inv_count',0);
            $pm_cnt=ini_get("/config/PC.ini","config",'pm_count',0);
            $pc_arr = ini_get_array("/config/PC.ini","config");
            // load power meter values
            for ($i=0;$i<$pm_cnt;$i++) {
                //if (!$pc_arr['pm'+$i+'_pf']) $pc_arr['pm'+$i+'_pf']=1;
                print('<div ng-init="pm.push({device_idx:'+
                    $pc_arr['pm'+$i+'_device_idx']+',max:\''+
                    $pc_arr['pm'+$i+'_max']+'\',min:\''+
                    $pc_arr['pm'+$i+'_min']+'\','+
                    'disabled:'+intval($pc_arr['pm'+$i+'_disabled']) + ','+
                    'priority:\''+$pc_arr['pm'+$i+'_priority'] + '\','+
                    'group:\''+intval($pc_arr['pm'+$i+'_group']) + '\','+
                    'pf:'+intval($pc_arr['pm'+$i+'_pf']) + ','+
                    'reactive_threshold:\''+number_format(floatval($pc_arr['pm'+$i+'_reactive_threshold']),2) + '\','+
                    'plant_size:\''+intval($pc_arr['pm'+$i+'_plant_size']) + '\','+
                    'type:'+intval($pc_arr['pm'+$i+'_type']) + '})"></div>'
                    );
            } 
            
            // load inverter values
            for ($i=0;$i<$inv_cnt;$i++) {
                print('<div ng-init="inv.push({device_idx:'+
                    $pc_arr['inv'+$i+'_device_idx']+
                    ',rating:\''+$pc_arr['inv'+$i+'_rating']+'\','+
                    'group:\''+$pc_arr['inv'+$i+'_group']+'\','+
                    'pf:'.(intval($pc_arr['inv'+$i+'_pf'])==0?"false":"true").','.
                    'default_pc:'+$pc_arr['inv'+$i+'_default_pc']+'})"></div>');
                    
            } 
        ?>            
		<div ng-init="inv_count=<? print($inv_cnt); ?>;">
        <div ng-init="pm_count=<? print($pm_cnt); ?>;">
        
        <div ng-init="interval=<? print(ini_get("/config/PC.ini","config",'interval',5)); ?>">
        <div ng-init="active=<? print(ini_get("/config/PC.ini","config",'active',0)); ?>">
        <div ng-init="debug=<? print(ini_get("/config/PC.ini","config",'debug',0)); ?>">
        <div ng-init="debug_log=<? print(ini_get("/config/PC.ini","config",'debug_log',0)); ?>">
        <div ng-init="track_curtailment=<? print(ini_get("/config/PC.ini","config",'track_curtailment',0)); ?>">
        <div ng-init="retries=<? print(ini_get("/config/PC.ini","config",'retries',1)); ?>">
        <div ng-init="meter_timeout=<? print(ini_get("/config/PC.ini","config",'meter_timeout',20)); ?>">
        <div ng-init="meter_scale=<? print(ini_get("/config/PC.ini","config",'meter_scale',1)); ?>">
        <div ng-init="power_mode=<? print(ini_get("/config/PC.ini","config",'power_mode',0)); ?>">
        <div ng-init="reactive_power_mode=<? print(ini_get("/config/PC.ini","config",'reactive_power_mode',0)); ?>">
        <div ng-init="inverter_level_percent=<? print(ini_get("/config/PC.ini","config",'inverter_level_percent',0)); ?>">
        <div ng-init="inverter_timeout=<? print(ini_get("/config/PC.ini","config",'inverter_timeout',60)); ?>">
        <div ng-init="pf_control=<? print(ini_get("/config/PC.ini","config",'pf_control',0)); ?>">
        <div ng-init="bus_coupler=<? print(ini_get("/config/PC.ini","config",'bus_coupler',0)); ?>">
        <div ng-init="reactive_offset=<? print(ini_get("/config/PC.ini","config",'reactive_offset',0)); ?>">
        <div ng-init="ramp_mode=<? print(ini_get("/config/PC.ini","config",'ramp_mode',0)); ?>">
        <div ng-init="eb_on=<? print(ini_get("/config/PC.ini","config",'eb_on',0)); ?>">
        <div ng-init="plant_size=<? print(ini_get("/config/PC.ini","config",'plant_size',0)); ?>">
        <div ng-init="readjust_interval=<? print(ini_get("/config/PC.ini","config",'readjust_interval',5)); ?>">
        <div ng-init="tcp_fail_check=<? print(ini_get("/config/PC.ini","config",'tcp_fail_check',0)); ?>">
        <div ng-init="tcp_fail_percent=<? print(ini_get("/config/PC.ini","config",'tcp_fail_percent',0)); ?>">
        <div ng-init="tcp_fail_interval=<? print(ini_get("/config/PC.ini","config",'tcp_fail_interval',0)); ?>">
        <div ng-init="set_to_100=<? print(ini_get("/config/PC.ini","config",'set_to_100',0)); ?>">
        
        <div ng-init='license_key="<? print(($license_key)); ?>"'>
        <div ng-init='license_limit="<?  $license_type="";
        $has_zero_feed_in = 0;
        $has_dg_protection = 0;
        $has_pf_correction = 0;
        $has_ess=0;
        if ($license_valid==1) {
            $has_zero_feed_in = 1;
            $has_dg_protection = 1;
            $has_pf_correction = 1;
            $has_multiple_groups = 0;
            $has_ess = 1;
        } else {
          if ($license_valid & 2) 
            $has_zero_feed_in = 1;
          if ($license_valid & 4) 
            $has_dg_protection = 1;
          if ($license_valid & 8) 
            $has_pf_correction = 1;
        
          if ($license_valid & 16) 
            $has_multiple_groups = 1;
        if ($license_valid & 32) 
            $has_ess = 1;    
        }
        
              if ($license_valid==1) {
                  $license_type="Zero Feed in and DG Protection (Legacy Mode)";
                  
              } else {
                  if ($license_valid & 2) $license_type.="Zero Feed-In";
                  if ($license_valid & 4) $license_type.=(strlen($license_type)?",":"")."DG Protection";
                  if ($license_valid & 32) $license_type.=(strlen($license_type)?",":"")."ESS";
                  if ($license_valid & 8) $license_type.=(strlen($license_type)?",":"")."Dynamic PF Correction";
                  if ($license_valid & 16) $license_type.=(strlen($license_type)?",":"")."Multiple Control Groups";
              }
              print($license_type);
              ?>"'>
              
        <div ng-init="license_valid=<? print(intval($license_valid)>0); ?>">
        <div ng-init="accepted_terms=<? print(intval($accepted_terms)); ?>">
        
<div ng-cloak class="card" ng-show='accepted_terms==0'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('GENERAL','PC')) ?></h5>
        <p class="card-text">    
            <a class="btn btn-outline-primary" ng-hide='accepted_terms==1' ng-click="terms()" >Read and Accept Terms and Conditions</a>
        </p>
    </div>
</div>
<div ng-cloak class="card" ng-hide='accepted_terms==0'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('GENERAL','PC')) ?></h5>
        <p class="card-text">
            <label for="tc"><small class='text-muted'>Terms and conditions</small></label>
            You have already accepted the terms and conditions.<br>
            <a class="btn btn-outline-primary " ng-hide='accepted_terms==1' ng-click="terms()" >Read and Accept Terms and Conditions</a>
        </p>
        
        <p class="card-text" >    
            <div class="form-group">
                <label for="active"><small class='text-muted'><? print(lang('STATUS','PC')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="active" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('DISABLED','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="active" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('ENABLED','PC')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','PC')) ?></small>
            </div>     
            <div class="form-group">
                <label for="interval"><? print(lang('LICENSE_KEY','PC')) ?></label>
                <div class='row'><div class='col-sm-8'><input class="form-control" type='text' ng-minlength="30" ng-model="license_key"  class='span12' name='license_key' required aria-describedby="rHelp" placeholder="<? print(lang('LICENSE_KEY','PC')) ?>"></div>
                <div class='col-sm-4'><button ng-click='getKey()' value="Get Key">Get Key</button>
                </div>
                </div>
                <small class="form-text text-muted"><? print(lang('LICENSE_KEY_HELP','PC')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.license_key.$invalid"><? print(lang('LICENSE_KEY_INVALID','PC')) ?></small>
                <small ng-cloak class='text-danger' ng-hide="license_valid==1">The license key is not valid for this device.  If you are just entering it now, save the page and refresh to check if it is valid.</small>
                <div ng-cloak class='text-success' ng-show="license_valid==1"><i class='icon icon-check'></i> This license code is valid and will execute code on this Wattmon. This key supports: {{license_limit}}.</div>
            </div>
             <div class="form-group">
                <label for="debug"><small class='text-muted'><? print(lang('DEBUG','PC')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="debug"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="debug" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ENABLED','PC')) ?>
                  </label>
                </div>  
                <small class="form-text text-muted"><? print(lang('DEBUG_HELP','PC')) ?></small>
            </div> 
            <div class="form-group">
                <label for="debug_log"><small class='text-muted'><? print(lang('DEBUG_LOG','PC')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="debug_log"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="debug_log" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ENABLED','PC')) ?>
                  </label>
                </div>  
                <small class="form-text text-muted"><? print(lang('DEBUG_LOG_HELP','PC')) ?></small>
            </div> 
            
            <div class="form-group">
                <label for="interval"><? print(lang('INTERVAL','PC')) ?></label>
                <input class="form-control" type='number' ng-model="interval"  class='span12' name='interval' required integer aria-describedby="rHelp" placeholder="<? print(lang('INTERVAL','PC')) ?>">
                <small class="form-text text-muted"><? print(lang('INTERVAL_HELP','PC')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.interval.$invalid"><? print(lang('INTERVAL_INVALID','PC')) ?></small>
            </div>
        
            <div class="form-group">
                <label for="meter_timeout"><? print(lang('METER_TIMEOUT','PC')) ?></label>
                <input class="form-control" type='number' ng-model="meter_timeout"  class='span12' name='meter_timeout' required integer aria-describedby="rHelp" placeholder="<? print(lang('METER_TIMEOUT','PC')) ?>">
                <small class="form-text text-muted"><? print(lang('METER_TIMEOUT_HELP','PC')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.meter_timeout.$invalid"><? print(lang('METER_TIMEOUT_INVALID','PC')) ?></small>
            </div>
            
           <div class="form-group">
                <label for="inverter_timeout"><? print(lang('INVERTER_TIMEOUT','PC')) ?></label>
                <input class="form-control" type='number' ng-model="inverter_timeout"  class='span12' name='inverter_timeout' required integer aria-describedby="rHelp" placeholder="<? print(lang('INVERTER_TIMEOUT','PC')) ?>">
                <small class="form-text text-muted"><? print(lang('INVERTER_TIMEOUT_HELP','PC')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.inverter_timeout.$invalid"><? print(lang('INVERTER_TIMEOUT_INVALID','PC')) ?></small>
            </div>
           <div class="form-group">
                <label for="retries"><? print(lang('MODBUS_RETRIES','PC')) ?></label>
                <input class="form-control" type='number' ng-model="retries"  class='span12' name='retries' required min=1 max=10 integer aria-describedby="rHelp" placeholder="<? print(lang('MODBUS_RETRIES','PC')) ?>">
                <small class="form-text text-muted"><? print(lang('MODBUS_RETRIES_HELP','PC')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.retries.$invalid"><? print(lang('MODBUS_RETRIES_INVALID','PC')) ?></small>
            </div>
<!--            <div class="form-group">
                <label for="meter_timeout"><? print(lang('METER_SCALE','PC')) ?></label>
                <input class="form-control" type='number' ng-model="meter_scale"  class='span12' name='meter_scale' required integer aria-describedby="rHelp" placeholder="<? print(lang('METER_SCALE','PC')) ?>">
                <small class="form-text text-muted"><? print(lang('METER_SCALE_HELP','PC')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.meter_scale.$invalid"><? print(lang('METER_SCALE_INVALID','PC')) ?></small>
            </div>-->
            <div class="form-group" ng-show="<? if ($has_pf_correction) print("1"); else print("0"); ?>">
                <label for="interval">Reactive Offset (W)</label>
                <input class="form-control" type='number' ng-model="reactive_offset"  class='span12' name='reactive_offset' required integer aria-describedby="rHelp" placeholder="Reactive Offset (W)">
                <small class="form-text text-muted">Optional per-inverter adjustment of reactive power to compensate for losses</small>
                
            </div>
            <div class="form-group">
                <label for="power_mode"><small class='text-muted'><? print(lang('POWER_MODE','PC')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="power_mode" id="exampleRadios5" value="0">
                  <label class="form-check-label" for="exampleRadios5">
                    &nbsp;<? print(lang('AVERAGE','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="power_mode" id="exampleRadios6" value="1">
                  <label class="form-check-label" for="exampleRadios6">
                    &nbsp;<? print(lang('PHASE','PC')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('POWER_MODE_HELP','PC')) ?></small>
            </div> 
             <div class="form-group">
                <label for="power_mode"><small class='text-muted'>Reactive Control Method</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="reactive_power_mode" id="exampleRadios5" value="0">
                  <label class="form-check-label" for="exampleRadios5">
                    &nbsp;<? print(lang('AVERAGE','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="reactive_power_mode" id="exampleRadios6" value="1">
                  <label class="form-check-label" for="exampleRadios6">
                    &nbsp;<? print(lang('PHASE','PC')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('POWER_MODE_HELP','PC')) ?></small>
            </div> 
             <div class="form-group">
                <label for="inverter_level_percent"><small class='text-muted'>Percentage Control method</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="inverter_level_percent" id="exampleRadiosX" value="0">
                  <label class="form-check-label" for="exampleRadiosX">
                    &nbsp;All inverters at the same percent
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="inverter_level_percent" id="exampleRadiosY" value="1">
                  <label class="form-check-label" for="exampleRadiosY">
                    &nbsp;Individual percent calculated per inverter
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted">This can be used to optimize generation in larger plants where inverters may not generate equally always.</small>
            </div> 
            <div class="form-group">
                <label for="set_to_100"><small class='text-muted'>Set percent to 100%</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="set_to_100" id="exampleRadiosdd5" value="0">
                  <label class="form-check-label" for="exampleRadios5">
                    &nbsp;Use calculated percent
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="set_to_100" id="exampleRadiosdd6" value="1">
                  <label class="form-check-label" for="exampleRadios6">
                    &nbsp;Set all inverters to 100% when irradiance is less
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted">Use this option to set all inverters to 100% when calculated potential generation would not exceed power setpoints</small>
            </div> 
        
             <div class="form-group" ng-show='inverter_level_percent==1'>
                <label for="readjust_interval">Readjust all inverters to the same percent interval (minutes)</label>
                <input class="form-control" type='number' ng-model="readjust_interval"  class='span12' name='readjust_interval' required integer aria-describedby="rHelp" placeholder="interval">
                <small class="form-text text-muted">Re-equalize interval in minutes</small>
            </div>
            <div class="form-group" ng-show='inverter_level_percent==0'>
                <label for="ramp_mode"><small class='text-muted'>Ramp Mode</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ramp_mode"value="0">
                  <label class="form-check-label">
                    &nbsp;No Ramp
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="ramp_mode" value="1">
                  <label class="form-check-label">
                    &nbsp;Ramp to set point
                  </label>
                </div>  
                <small class="form-text text-muted">Wait for the inverters to ramp to within 10% of the set point before changing power percent</small>
            </div> 
            
            <div class="form-group">
                <label for="eb_on"><small class='text-muted'>Shared meter for EB/DG</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="eb_on" id="exampleRadiosX1" value="0">
                  <label class="form-check-label" for="exampleRadiosX1">
                    &nbsp;<? print(lang('DISABLED','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="eb_on" id="exampleRadiosY1" value="1">
                  <label class="form-check-label" for="exampleRadiosY1">
                    &nbsp;<? print(lang('ENABLED','PC')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted">Shared energy meter for EB/DG.  Wattmon Mega DI1 is used to indicate grid availability (input on = grid available)</small>
            </div>    
            <div class="form-group">
                <label for="eb_on"><small class='text-muted'>Use Digital Inputs as bus coupler</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="bus_coupler" id="exampleRadiosdX1" value="0">
                  <label class="form-check-label" for="exampleRadiosdX1">
                    &nbsp;<? print(lang('DISABLED','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="bus_coupler" id="exampleRadiosdY1" value="1">
                  <label class="form-check-label" for="exampleRadiosdY1">
                    &nbsp;<? print(lang('ENABLED','PC')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted">Digital inputs will modify the group IDs dynamically in multi cluster mode</small>
            </div>    
            
            <div class="form-group">
                <label for="track_curtailment"><small class='text-muted'><? print(lang('CURTAILMENT','PC')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="track_curtailment"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="track_curtailment" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ENABLED','PC')) ?>
                  </label>
                </div>  
                <small class="form-text text-muted">Track curtailment losses on both Grid and DG sources.  This requires the Pyranometer package to be installed and configured.</small>
            </div> 
            <div class="form-group">
                <label for="tcp_fail_check"><small class='text-muted'>Fallback when TCP meter connection fails</small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="tcp_fail_check"value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','PC')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="tcp_fail_check" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ENABLED','PC')) ?>
                  </label>
                </div>  
                <small class="form-text text-muted">If a remote Modbus TCP energy meter of a higher priority meter fails, you an choose to override the inverter percent until the TCP connection is restored</small>
            </div> 
            <div class="form-group" ng-show='tcp_fail_check==1'>
                <label for="tcp_fail_interval">Duration that TCP link fails before ramping down</label>
                <input class="form-control" type='number' ng-model="tcp_fail_interval"  class='span12' name='tcp_fail_interval'  integer aria-describedby="rHelp" placeholder="Delay in s">
                <small class="form-text text-muted">Delay before ramping down in seconds</small>
            </div>
            <div class="form-group" ng-show='tcp_fail_check==1'>
                <label for="tcp_fail_percent">Inverter override percent</label>
                <input class="form-control" type='number' ng-model="tcp_fail_percent"  class='span12' name='tcp_fail_percent'  integer min='1' max='100' aria-describedby="rHelp" placeholder="Override percent">
                <small class="form-text text-muted">Interval percent to fallback to</small>
            </div>
                    
        </p>
    </div>
</div>
<br/>
<div ng-cloak class="card" ng-hide='accepted_terms==0'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('POWER_METERS','PC')) ?></h5>
        <h6 class="card-subtitle mb-2 text-muted"><? print(lang('NUM_POWER_METERS','PC')) ?>: {{pm_count}}</h6>
        <p class="card-text">    
            <div class="form-group"> 
                <div style='float:right'><a name='addpm'></a><button class="btn btn-large" ng-click="addPM()"><? print(lang('ADD','PC')) ?></button></div>
            
                <table class='table table-striped' summary="Meters" >
                    <tr>
            
                        <td scope="col"></td>
                        <td scope="col"><strong><? print(lang('DEVICE','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('DEVICE_MODEL','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('CONNECTED_TO','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('MIN','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('MAX','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('PRIORITY','PC')) ?></strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="If multiple meters are active, the higher priority (larger number) will be used">?</i></td>
<? if ($has_multiple_groups) { ?>                        
                        <td scope="col"><strong>Group</strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="If multiple meters are active, each group will be part of a separate control loop">?</i></td>
<? } ?>                        
                        <td scope="col"><strong><? print(lang('PF','PC')) ?></strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="When this meter is active, reactive power control will happen on any enabled inverters to bring the PF as close to unity as possible">?</i></td>
                        <td scope="col"><strong>Plant Size</strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="Sum of all inverter ratings connected to this energy meter">?</i></td>
                        <td scope="col"><strong><? print(lang('STATUS','PC')) ?></strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="Set this to enabled to use the meter, or disabled to show it on the ezdisplay but not have it part of power control">?</i></td>
                        <td scope="col"><strong><? print(lang('OPTIONS','PC')) ?></strong></td>
                    </tr>
                    <tr ng-repeat="item in pm">
                        <td><a name='pm{{$index}}'></a><span class="badge badge-warning badge-pill">{{$index+1}}</span></td>
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'><strong>{{devices[item.device_idx].name}} (ID: {{devices[item.device_idx].id}})</strong></span>
                        </td>            
                       <td ng-show='item.edit!=1'>{{devices[item.device_idx].device_type_name}}</td>
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'><strong>{{makeType(item.type)}}</strong></span>
                        </td>               
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'>{{item.min}}</span></td>
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'>{{item.max}}</span></td>
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'>{{item.priority}}</span></td>
<? if ($has_multiple_groups) { ?>                                                
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'>{{item.group}}</span></td>
<? } ?>                        
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'>{{makeMeterPF(item)}}</span></td>
                        <td ng-show='item.edit!=1'><span ng-show='item.edit!=1'>{{item.plant_size}}</span></td>
                        <td ng-show='item.edit!=1'><span ><strong>{{makeDisabled(item.disabled)}}</strong></span>
                        </td>               
                        <td colspan=8 ng-show='item.edit==1'>
                            <div ng-show='item.edit==1' >
                                <strong>Meter</string><br/>
                                <select ng-options="vitem.device_idx as vitem.name for vitem in power_meters" ng-model="item.device_idx" class="form-control">
                        		               <option value="{{vitem.device_idx}}">{{vitem.name}}</option>       
                        		       </select>
                            </div>
                            <div ng-show='item.edit==1'>
                                <strong>Connected To</string><br/>
                                <select ng-model="item.type"  class="form-control">
                        		               <option value="0"><? print(lang('UNDEFINED','PC')) ?></option>
                        		               <? if ($has_dg_protection)  { ?>
                        		               <option value="1"><? print(lang('GENSET','PC')) ?></option>       
                        		               <? }
                        		               if ($has_zero_feed_in)  { ?>
                        		               <option value="2"><? print(lang('ZFI','PC')) ?></option>       
                        		               <? } ?>
                        		               <option value="3"><? print(lang('INVERTER_OUTPUT','PC')) ?></option>       
                        		               <option value="4"><? print(lang('BUILDING_LOAD','PC')) ?></option>       
                        		               <? if ($has_ess)  { ?>
                        		               <option value="5">ESS (Battery)</option>       
                        		               <? } ?>
                        		    </select>
                        		    <small class="form-text text-muted">Select the location and functonality of this meter</small>
                            </div>
                            <div ng-show='item.edit==1' >
                            <strong>Min Power (kW)</string><br/>
                             <input type='text'  ng-model='item.min' class="form-control">
                             <small class="form-text text-muted">Minimum allowed power value</small>
                            </div>
                            <div ng-show='item.edit==1'>
                            <strong>Max Power (kW)</string><br/>
                             <input type='text' ng-model='item.max' class="form-control">
                             <small class="form-text text-muted">Maximum allowed power value</small>
                            </div>
                            <div ng-show='item.edit==1'>
                            <strong>Priority (Higher is more)</string><br/>
                             <input type='text' ng-model='item.priority' class="form-control">
                             <small class="form-text text-muted">Higher value meters will be used when multiple meters are active at the same time</small>
                            </div>
                            <? if ($has_multiple_groups)  { ?>                            
                            <div ng-show='item.edit==1'>
                                <strong>Group</string><br/>
                                <select ng-model="item.group"  class="form-control">
                                    <option value="0">No group</option>
            		                <option value="1">Group 1</option>
            		                <option value="2">Group 2</option>       
                        		    <option value="4">Group 4</option>       
                        		    <option value="8">Group 8</option>       
                        		    <option value="16">Group 16</option>       
                        		    <option value="32">Group 32</option>       
                        		    <option value="64">Group 64</option>       
                        		    
                        		    
                    		    </select>
                    		    <small class="form-text text-muted">Select the group number if you have multiple control loops</small>
                            </div>
                            <? } ?>
                            <div ng-show='item.edit==1'>
                            <strong>PF Control</string><br/>
                            <select ng-model="item.pf"  class="form-control" ng-disabled="<? if (!$has_pf_correction) print("1"); else print("0"); ?>">
                    		               <option value="1">Active</option>
                    		               <option value="0">Disabled</option>       
                    		    </select>
                    		    <small class="form-text text-muted">Perform dynamic reactive power adjustment if the inverters support it. <? if (!$has_pf_correction) print("Your license key does not support this feature."); ?></small>
                            </div>
                            <div ng-show='item.edit==1 && item.pf==1'>
                            <strong>Reactive Threshold</string><br/>
                             <input type='text' ng-model='item.reactive_threshold' class="form-control">
                             <small class="form-text text-muted">Maximum allowed reactive power (kW)</small>
                            </div>
                            <div ng-show='item.edit==1'>
                             <strong>Plant Size (AC kW)</string><br/>
                             <input type='text' required ng-model='item.plant_size' class="form-control">
                             <small class="form-text text-muted">Enter the Solar Plant size controlled by this meter in kW</small>
                            </div>
                            <div ng-show='item.edit==1'>
                            <strong>Status</string><br/>
                            <select ng-model="item.disabled"  class="form-control">
                    		               <option value="0">Active</option>
                    		               <option value="1">Disabled</option>       
                    		    </select>
                    		    <small class="form-text text-muted">Selecting disabled will still show the meter but it will not be used in the power control algorithm</small>
                            </div>
                        </td>    
                        <td>
                            <div class="pull-right btn-group">
                                    <a class="btn dropdown-toggle" data-toggle="dropdown" href="#"><? print(lang('ACTION','PC')) ?><span class="caret"></span></a>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <!-- dropdown menu links -->
                                        <li class="dropdown-item" ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#pm{{$index}}'><i class="icon-pencil"></i> <? print(lang('EDIT','PC')) ?></a></li>
                                        <li class="dropdown-item" ng-show='item.edit==1'><a ng-click='item.edit=0' href='#pm{{$index}}'><i class="icon-pencil"></i> <? print(lang('STOP_EDIT','PC')) ?></a></li>
                                        <li class="dropdown-item" ><a ng-click='delPM($index)' href='#addpm'><i class="icon-remove"></i> <? print(lang('DELETE','PC')) ?></a></li>
                                    </ul>
                                </div>
                        </td>
                    </tr>
                </table>
            </div>
        </p>
    </div>
</div>
<br/>
<div ng-cloak class="card" ng-hide='accepted_terms==0'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('INVERTERS','PC')) ?></h5>
        <h6 class="card-subtitle mb-2 text-muted"><? print(lang('NUM_INVERTERS','PC')) ?>: {{inv_count}}</h6>
        <p class="card-text">    
            <div class="form-group"> 
                <div style='float:right'><a name='addpm'></a><button class="btn btn-large" ng-click="addInv()"><? print(lang('ADD','PC')) ?></button></div>
            
                <table class='table table-striped' summary="Inverters" >
                    <tr>
            
                        <td scope="col"></td>
                        <td scope="col"><strong><? print(lang('DEVICE','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('DEVICE_MODEL','PC')) ?></strong></td>
                        <td scope="col"><strong><? print(lang('RATING','PC')) ?></strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="Inverter size in kW used for power calculation">?</i></td>
                        <td scope="col"><strong><? print(lang('DEFAULT_PERCENT','PC')) ?></strong>  <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="When no meters are active inverters are set to this percent">?</i></td>
                        <? if ($has_multiple_groups)  { ?>                            
                        <td scope="col"><strong>Group</strong> <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="Enter a bitmask of the groups this inverter is part if (i.e 5 would be part of group 1 and 4)">?</i></td>
                        <? } ?>
                        <td scope="col"><strong>PF Control</strong>  <i class='badge badge-pill badge-secondary' data-toggle="tooltip" data-placement="top" title="Perform dynamic PF control if available<? if (!$has_pf_correction) print(" - Your license key does not support this feature."); ?>">?</i></td>
                        <td scope="col"><strong><? print(lang('OPTIONS','PC')) ?></strong></td>
                    </tr>
                    <tr ng-repeat="item in inv">
                        <td><a name='inv{{$index}}'></a><span class="badge badge-success badge-pill">{{$index+1}}</span></td>
                        <td>
                            <strong>{{devices[item.device_idx].name}} (ID: {{devices[item.device_idx].id}})</strong><div ng-show='item.edit==1'>
                            <select ng-options="vitem.device_idx as vitem.name for vitem in inverters" ng-model="item.device_idx" class='form-control'>
		                    <option value="{{vitem.device_idx}}">{{vitem.name}}</option>       
		                    </select>
                            </div>
                        </td>            
                        <td>{{devices[item.device_idx].device_type_name}}</td>
                        <td>{{item.rating}}<div ng-show='item.edit==1'>
                             <input type='text' class='form-control' ng-model='item.rating'>
                            </div></td>
                        <td>{{item.default_pc}}<div ng-show='item.edit==1'>
                             <input type='number' minval=0 maxval=100 class='form-control' ng-model='item.default_pc'>
                            </div>
                        </td>
                            <? if ($has_multiple_groups)  { ?>                            
                        <td>{{item.group}}
                            <div ng-show='item.edit==1'>
                             <input type='text' class='form-control' ng-model='item.group'>
                            </div></td>
                        </td>
                        <? } ?>
                        
                        <td>{{makeYesNo(item.pf)}}<div ng-show='item.edit==1'>
                        <input ng-model="item.pf"  class="form-control"  type="checkbox">
                            <!--<select ng-model="item.pf"  class="form-control" ng-disabled="<? if (!$has_pf_correction) print("1"); else print("0"); ?>">
                               <option value="0">Disabled</option>       
                    		   <option value="1">Active</option>
                    		 </select>-->
                            </div>
                        </td>
                        
                        <td>
                            <div class="pull-right btn-group">
                                    <a class="btn dropdown-toggle" data-toggle="dropdown" href="#"><? print(lang('ACTION','PC')) ?><span class="caret"></span></a>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <!-- dropdown menu links -->
                                        <li class="dropdown-item" ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#inv{{$index}}'><i class="icon-pencil"></i> <? print(lang('EDIT','PC')) ?></a></li>
                                        <li class="dropdown-item" ng-show='item.edit==1'><a ng-click='item.edit=0' href='#inv{{$index}}'><i class="icon-pencil"></i> <? print(lang('STOP_EDIT','PC')) ?></a></li>
                                        <li class="dropdown-item" ><a ng-click='delInv($index)' href='#addinv'><i class="icon-remove"></i> <? print(lang('DELETE','PC')) ?></a></li>
                                    </ul>
                                </div>
                        </td>
                    </tr>
                </table>
            </div>
        </p>
    </div>
</div>        
      
	  
 <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">TERMS AND CONDITIONS FOR WATTMON POWER CONTROL</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>By Using The Licensed Product / Software, You Accept The Following Terms And Conditions:</p>
        <p>A. DISCLAIMER OF WARRANTY</p>
        <p>The Software / Licensed Product is provided on an “AS IS” basis, without warranty of any kind, including without limitation the warranties of merchantability, fitness for a particular purpose and non-infringement. The entire risk as to the quality and performance of the Software is borne by the Buyer (also referred to as the Licensee). Should the Software prove defective, the Licensee and not Cynergy (also referred to as the Licensor) assume the entire cost of any service and repair.</p>
        <p>No Employee, Agent or Representative of Cynergy has the Authority to bind the Licensor to any Oral representation or Warranty concerning the Licensed Material / Software. Any Oral or Written Representation or Warranty not expressly contained herein shall not be enforceable by the Licensee.</p>
        <p>B. LIMITATIONS OF LIABILITY</p>
        <p>CYNERGY IS NOT RESPONSIBLE FOR ANY INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY KIND INCLUDING, WITHOUT LIMITATION, DAMAGES FOR LOSS OF GOODWILL, WORK STOPPAGE, SYSTEMS FAILURE OR MALFUNCTION, OR ANY AND ALL OTHER COMMERCIAL DAMAGES OR LOSSES.</p>
        <p>Licensee agrees to indemnify and hold Licensor harmless from and against all loss, cost, expense or liability (including reasonable attorney’s fees) arising out of a claim by a third party against Licensor based upon Licensee’s use of the LICENSED PRODUCT / SOFTWARE.</p>
        <p>Licensee also agrees to indemnify and hold Licensor harmless from any loss or damages to Licensor related to, or associated with Licensee’s customizations, updates and/or modifications to the Software.</p>
        <p>Licensor shall have no liability to Licensee for any damage sustained by Licensee as a result of Licensee’s use of the LICENSED PRODUCT / SOFTWARE, whether such damages would arise as a result of breach of contract, tort or otherwise. Licensee has tested the LICENSED PRODUCT / SOFTWARE and relies on its own judgment in utilizing it.</p>
        <p></p>
        <p>Proceeding further with the configuration of this Wattmon data logger implies that you have carefully read the Power Control Terms and Conditions as set out above, and accept the same without any exception.</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">DISAGREE</button>
        <button type="button" class="btn btn-primary" ng-click="doModal()">AGREE</button>
      </div>
    </div>
  </div>
</div>		        
</form>
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
<?
include("/app/package.inc");
include("/lib/uphp/array.inc");

$all_inverters = ini_get_array('/config/devicetypes.ini','Inverter');
$all_inverters = quick_sort($all_inverters,1); // sort by value

$all_meters = ini_get_array('/config/devicetypes.ini','Meter');
$all_meters = quick_sort($all_meters,1); // sort by value

?>

function PCWidget($scope, $timeout,$http) {
   var self = this;
   
   //alert('init');
   $scope.power_meter_types=[<? 
   $pm_types=implode(array_keys($all_meters),',');
   print($pm_types);
   ?>];
   $scope.inverter_types=[<?
   $inv_types=implode(array_keys($all_inverters),',');
   print( $inv_types);
   ?>];
   $scope.pm=[];
   $scope.inv=[];
   
   $scope.devices=[<?
   $num_dev=ini_get("/config/device.ini","general","num_devices",0);
   //print($num_dev);
   for ($d=0;$d<$num_dev;$d++) {
        $addr=ini_get("/config/device.ini","Device".$d,"address",0);
        //if ($addr) 
        {
            $st="{id:".$addr.",";
            $st.="device_idx:".$d.",";
            $dt=ini_get("/config/device.ini","Device".$d,"device_type_id",0);
            $st.="device_type_id:".$dt.",";
            $st.="device_type_name:\"".ini_get("/dev/dev".$dt.".ini","config","name","")."\",";
            $st.="bus:".ini_get("/config/device.ini","Device".$d,"params",0).",";
            
            $num_inv=sizeof($all_inverters);
            //print("Num INVERTERS: ".$num_inv);
            $can_add=1;
            for ($i=0;$i<$num_inv;$i++) {
                //print(array_key($all_inverters,$i));
                if (array_key($all_inverters,$i)==$dt) { // this is an inverter
//                    $can_add=0;
                    if (file_exists("/package/pc/pc".$dt.".inc") || file_exists("/package/pc/pc".$dt.".enc")) {
                       $st.="has_pc:1,";
                       break;
                    } else $st.="has_pc:0,";
                }
            }
            $st.="name:\"".ini_get("/config/device.ini","Device".$d,"name","")."\"},";
            if ($can_add) 
                print($st);
        }
   }
   ?>];
   $scope.power_meters=[];
   $scope.inverters=[];
   $scope.inv_count=0;
   $scope.pm_count=0;
   for (i=0;i<$scope.devices.length;i++) {
        for (p=0;p<$scope.power_meter_types.length;p++) {
            if ($scope.devices[i].device_type_id==$scope.power_meter_types[p]) {
                $scope.power_meters.push($scope.devices[i]);
            }
        }
        for (p=0;p<$scope.inverter_types.length;p++) {
            if ($scope.devices[i].device_type_id==$scope.inverter_types[p]) {
                if ($scope.devices[i].has_pc) {
                    console.log($scope.devices[i]);
                    $scope.inverters.push($scope.devices[i]);
                }
            }
        }
   }
   $scope.pm_count_installed=0;
   $scope.loading=0;
   $gscope=$scope;
   $scope.errormsg="";
   if ($scope.power_meters.length==0) {
        $scope.errormsg="There are currently no power meters defined that support power control.  Please add a Secure 400 or Schneider EM6400 meter.\r\n";
   }
//   alert('hello');    
   if ($scope.inverter_types.length==0) {
    $scope.errormsg+="Your configuration is incorrect.  Make sure the /config/EZConfigTypes.ini file is properly installed.\r\n";
   }
   if ($scope.inverters.length==0) {
        $scope.errormsg+="There are currently no inverters defined that support power control.  Please add a supported inverter or contact us.\r\n";
   }
   <? if (floatval($_GLOBALS['PKG_VERSION'])<3.16) { ?>
   $scope.errormsg="Please update your WattmonOS to 3.16 or above to use this version of PC";
   <? } ?>
   /*alert('hello2');*/    
   $scope.makeYesNo=function(yn) {
        if (yn) return "Active";
        return "Disabled";
   }
   $scope.addPM=function() {
    if ($scope.power_meters.length==0) {
        alert("No supported power meters found.  Add the power meter in your devices list first.");
    } else {
        $scope.pm.push({edit:1});
        $scope.pm_count++;
    }
   }
   $scope.makeMeterPF=function(item) {
    if (item.pf!=1) return "No";
    if (item.pf) return "Yes, "+item.reactive_threshold+"kW";
   }

   $scope.delPM=function(idx) {
        $scope.pm.splice(idx,1);
        $scope.pm_count--;
   }
   
   $scope.addInv=function() {
    if ($scope.inverters.length==0) {
        alert("No supported Inverters found.  Add the Inverter in your devices list first.");
    } else {
        $scope.inv.push({edit:1});
        $scope.inv_count++;
    }
   }
   $scope.delInv=function(idx) {
        $scope.inv.splice(idx,1);
        $scope.inv_count--;
    }
    $scope.makeType=function(atype_id) {
        switch (atype_id) {
            case 0:return "Undefined";
            case 1:return "Genset";
            case 2:return "Main Incomer";
            case 3:return "Inverter Output";
            case 4:return "Building Load";
        }
    };
    
    $scope.makeDisabled=function(atype_id) {
        switch (Number(atype_id)) {
            case 0:return "Active";
            case 1:return "Disabled";
        }
        return atype_id;
    };
    
    $scope.makeRole=function(itemid) {
        str='';
        switch (Number(itemid)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
      } 

      return str;

  }

    $scope.isActive=function(invert) {
        if (!invert) {
            if (Number($scope.active)) return 'checked';
            return 'unchecked';
       } else {
           if (!Number($scope.active)) return 'checked';
            return 'unchecked';
       }
   }
   
   $scope.isDebug=function(invert) {
        if (!invert) {
            if (Number($scope.debug)) return 'checked';
            return 'unchecked';
       } else {
           if (!Number($scope.debug)) return 'checked';
            return 'unchecked';
       }
   }
   
   $scope.isDebugLog=function(invert) {
        if (!invert) {
            if (Number($scope.debug_log)) return 'checked';
            return 'unchecked';
       } else {
           if (!Number($scope.debug_log)) return 'checked';
            return 'unchecked';
       }
   }
   $scope.getKey=function() {
      $http.get('http://license.wattmon.com/licenses/get?mac=<? print(getmac()); ?>')
        .then(function (response) {
          var data = response.data; 
          if (!data.found) {
            $scope.errormsg="No license key found";
          } else {
            $scope.errormsg="";
            $scope.successmsg="Found a license key";
            $scope.license_key=data.key;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error getting key";
            $scope.successmsg="";
        });

   };
   $scope.saveSettings=function() {
        if ($scope.license_key.$invalid) {
        alert("Data will be saved but unless a valid license key is entered, power control will not work.  Please obtain the key from the Wattmon team.")
        //return;
        }
       post_data="pm_count="+$scope.pm_count+
            "&inv_count="+$scope.inv_count+
            "&active="+$scope.active+
            "&eb_on="+$scope.eb_on+
            "&pf_control="+$scope.pf_control+
            "&bus_coupler="+$scope.bus_coupler+
            "&ramp_mode="+$scope.ramp_mode+
            "&debug="+$scope.debug+
            "&debug_log="+$scope.debug_log+
            "&track_curtailment="+$scope.track_curtailment+
            "&retries="+$scope.retries+
            "&interval="+$scope.interval+
            "&tcp_fail_check="+$scope.tcp_fail_check+
            "&tcp_fail_interval="+$scope.tcp_fail_interval+
            "&tcp_fail_percent="+$scope.tcp_fail_percent+
            "&meter_timeout="+$scope.meter_timeout+
            "&readjust_interval="+$scope.readjust_interval+
            "&inverter_level_percent="+$scope.inverter_level_percent+
            "&meter_scale="+$scope.meter_scale+
            "&power_mode="+$scope.power_mode+
            "&set_to_100="+$scope.set_to_100+
            "&reactive_power_mode="+$scope.reactive_power_mode+
            "&reactive_offset="+$scope.reactive_offset+
            "&inverter_timeout="+$scope.inverter_timeout;
        
        for (i=0;i<$scope.pm.length;i++) {
        console.log("meter pf="+$scope.pm[i].pf);
            post_data+="&pm"+i+"_device_idx="+$scope.pm[i].device_idx;     
            post_data+="&pm"+i+"_max="+$scope.pm[i].max;     
            post_data+="&pm"+i+"_min="+$scope.pm[i].min;
            post_data+="&pm"+i+"_type="+$scope.pm[i].type;
            post_data+="&pm"+i+"_disabled="+$scope.pm[i].disabled;
            post_data+="&pm"+i+"_pf="+($scope.pm[i].pf);
            post_data+="&pm"+i+"_group="+($scope.pm[i].group);
            post_data+="&pm"+i+"_reactive_threshold="+($scope.pm[i].reactive_threshold);
            post_data+="&pm"+i+"_plant_size="+$scope.pm[i].plant_size;
            post_data+="&pm"+i+"_priority="+$scope.pm[i].priority;
        }
        for (i=0;i<$scope.inv.length;i++) {
        console.log("meter pf="+$scope.inv[i].pf);
            post_data+="&inv"+i+"_device_idx="+$scope.inv[i].device_idx;     
            post_data+="&inv"+i+"_rating="+$scope.inv[i].rating;
            post_data+="&inv"+i+"_group="+$scope.inv[i].group;
            console.log($scope.inv[i].pf);
            post_data+="&inv"+i+"_pf="+($scope.inv[i].pf?"1":"0");
            post_data+="&inv"+i+"_default_pc="+$scope.inv[i].default_pc;     
        }
        console.log(post_data);
/*        post_data+="&inverter_count_installed="+$scope.inverter_count_installed;
        post_data+="&export_interval="+$scope.export_interval;
        post_data+="&custom_url="+encodeURI($scope.custom_url);
        post_data+="&irradiation_enabled="+$scope.irradiation_enabled;
        post_data+="&powermeter_enabled="+$scope.powermeter_enabled;*/
       post_config="PC.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
        //alert($scope.license_key);
        $http.post('/app/configsave.cgi?config=license.ini&section=config','key1='+encodeURIComponent($scope.license_key)+"&accepted_terms="+$scope.accepted_terms)
        .then(function (response) {
          var data = response.data; 
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving license key settings";
            $scope.successmsg="";
        });
        
   }
   
  $scope.hideModal=function() {
    $('#myModal').modal('hide');
  }  
  
  $scope.doModal=function() {
      if ($scope.action==1) {
          $scope.accepted_terms=1;
      } else {
        $scope.accepted_terms=0;
      }
      $('#myModal').modal('hide');
  }
  $scope.terms=function() {
    $('#myModal').modal('hide');
        $scope.action=1;
        $('#myModal').modal('show');
  }
}
   </script>
</div>   
        <?
        include("/app/footer.inc");?>
     <?
        return 1;

        
    }

    
    execute(); // process the package and run the correct function
    
?>




















