<?
/**
 * @package QOS
 * @author Akash Heimlich
 * @description This dummy widget shows the basic functionality of widgets and can be used as a starting point
 * for further development
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 

function sn_is_ok($str) {
    $res=1;
    
    for ($x=0;$x<strlen($str);$x++) {
        $o=charat($str,$x);
        //$o=ord($c);
        if ((($o >= 65) && ($o < 91)) || (($o >= 97) && ($o <= 122)) || (($o >= 40) && ($o <=57 )) || ($o==32) || ($o==45) || ($o==46)) {
            $ok=1;
        } else {
            $res=0;
        }
    }
    if (strlen($str)<3) $res=0;
    if (!$str) $res=0;
    return $res;
}

    function QOS_searchdir($dir,$dirarr) {
		chdir($dir);
		$arr=findfirst("*.*",16);
		$count=0;
		while ($arr) {
		    if ($arr['attributes'] & 16) {
		        if ((substr($arr['filename'],0,1)!=".") && ($arr['filename']!="cache") && ($arr['filename']!="backup")) {
		            print("Found directory ".$dir.$arr['filename']." - ".$arr['attributes']."\r\n");
		            flush();
		            $dirarr[]=$dir.$arr['filename']."/";     
		            $count++;
		        }
		    
		    }
		    $arr=findnext();
		}

	}
    function QOS_install($val) {
        QOS_enable();
        return 1;
    }
     
    function QOS_uninstall() {
        setPackageStatus("QOS",0);
        return 1;
    }
    
    function QOS_enable() {
        setPackageStatus("QOS",2);
        addWidget("/package/QOS.inc","QOS",4,"icon-play",1,0); // enable
		ini_set("/config/uphp.ini","debug","call_depth",25);
		ini_set("/config/uphp.ini","debug","stack_size",5000);
        return 1;
    }
    
    function QOS_disable() {
        setPackageStatus("QOS",3);
        addWidget("/package/QOS.inc","QOS",4,"icon-play",1,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function QOS_init() {
        
        // load the test Value into the globals
        $_GLOBALS['QOS_path']=ini_get("/config/QOS.ini","config","QOS_path","");
        $_GLOBALS['QOS_sitename']=ini_get("/config/QOS.ini","config","QOS_sitename","TEST");
        $_GLOBALS['QOS_url']=ini_get("/config/QOS.ini","config","QOS_url","");
        $_GLOBALS['QOS_log']=ini_get("/config/QOS.ini","config","QOS_log","/logs/QOS");
        $_GLOBALS['QOS_interval']=ini_get("/config/QOS.ini","config","QOS_interval",15);
        $_GLOBALS['QOS_up_interval']=ini_get("/config/QOS.ini","config","QOS_up_interval",15);
        $_GLOBALS['QOS_lines']=ini_get("/config/QOS.ini","config","QOS_lines",5);
	$fs_prefix = '';
        if ($_SERVER['HW_PLATFORM']==11) {
            $fs_prefix='0:';
        }
        if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA
            $fs_prefix=intval($_GLOBALS['log_drive']).':';    
        
        $num_dev=mb_num_devices();
        $_GLOBALS['QOS_sn']=array();
        
        for ($i=0;$i<$num_dev;$i++) {
            $d=mb_get_dev_by_index($i);
            $_GLOBALS['QOS_sn'][$i]=ini_get("/config/QOS.ini","config","QOS_sn".$i,'');
            
        }
    
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/QOS.cgi?action=configure';
        $arr['title']='QOS FTP';
        $arr['icon']='icon-hdd';
        $arr['desc']='QOS FTP Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
/*         $arr=array();
        $arr['script']='/package/ezconfig_qos.cgi';
        $arr['title']='QOS EZConfig';
        $arr['icon']='icon-hdd';
        $arr['desc']='QOS EZConfig';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
  */      
        // generate ajax data for front end processing
        if (file_exists('/package/QOSAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/QOSAjax.inc';

        // runs this file once a second
        if (file_exists('/package/QOSSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/QOSSec.inc';
            
        // runs this file once a minute
        if (file_exists('/package/QOSMin.inc')) 
            $_GLOBALS['hooks']['min'][]='/package/QOSMin.inc';
            
/*        if (file_exists('/package/QOSMinLog.inc')) 
            $_GLOBALS['hooks']['minlog'][]='/package/QOSMinLog.inc';
            */
        // runs this file once a day
        if (file_exists('/package/QOSDay.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/QOSDay.inc';            

		// create a backup at boot of the config folder
		max_execution_time(600);

		mkdir($fs_prefix.$_GLOBALS['QOS_log']);

		$f=fopen($fs_prefix.$_GLOBALS['QOS_log']."/config.json","w+");
		fwrite($f,'{"mac":"'.getmac().'","os":"'.$_GLOBALS['PKG_VERSION'].'","firmware":"'.$_GLOBALS["VERMAJOR"].".".$_GLOBALS["VERMINOR"].'"}');
		fclose($f);
		$backupfile=$fs_prefix.$_GLOBALS['QOS_log']."/config.tar";
		$f=fopen($backupfile,"w+");

		$dirs=array("/config/");
		$dir=$dirs[0];
		$start=1;
		QOS_searchdir($dir,&$dirs);
		$num=sizeof(&$dirs);
		while ($start<$num) {
			for ($i=$start;$i<$num;$i++) {
				QOS_searchdir($dirs[$i],&$dirs);
				$start++;
			}
			$num=sizeof(&$dirs);
		}
		$count=0;
		for ($i=0;$i<$num;$i++) {
			$dir=$dirs[$i];
			chdir($dir);
			$arr=findfirst("*.*",255-24);  // no directories
		
		
			while ($arr) {
				
				// skip directories
				if ((($dir.$arr['filename']) !=$backupfile) && (strpos($arr['filename'],".cgc")<0)) {
				    printf("Adding ".$dir.$arr['filename']." -  ".$arr['filesize']." bytes \r\n");
				    flush();
				    tar_put($f,$dir.$arr['filename'],substr($dir,1).$arr['filename']);     
				    $count++;
				} else {
				    print("Skipping file ".$dir.$arr['filename']."\r\n");
				}
				$arr=findnext();
			}
		}

		tar_finish($f);
		fclose($f);


        return 1;
    }
    
    function QOS_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="QOS"; 
        $title='Configure Package QOS';
        $config_file="QOS.ini";
        $config_section="config";
	$fs_prefix = '';
        if ($_SERVER['HW_PLATFORM']==11) {
            $fs_prefix='0:';
        }
        if ($_SERVER['HW_PLATFORM']>=20)   // ULTRA
            $fs_prefix=intval($_GLOBALS['log_drive']).':';    
        
        if ($_GET['reset_export']) {
            unlink($fs_prefix."/logs/qos_status.ini");
            
        }
        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        
        ?><script> if (typeof settings_locked == 'undefined') settings_locked=0;</script>
<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page">QOS FTP Export</li>
  </ol>
</nav>

<!-- NAVBAR -->
<h2><i class="icon-group"></i> QOS Export <? print(ini_get("/package/QOS.ini","package","version","unknown")); ?></h2>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/package/QOS.cgi?action=configure&reset_export=1';">Reset Export</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" ng-hide='settings_locked' ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> <? print(lang('APPLY','user')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>

<div ng-init="QOS_path='<? print(ini_get("/config/".$config_file,$config_section,"QOS_path","")); ?>';">
<div ng-init="QOS_sitename='<? print(ini_get("/config/".$config_file,$config_section,"QOS_sitename","")); ?>';">
<div ng-init="QOS_username='<? print(ini_get("/config/".$config_file,$config_section,"QOS_username","")); ?>';">
<div ng-init="QOS_password='<? print(ini_get("/config/".$config_file,$config_section,"QOS_password","")); ?>';">
<div ng-init="QOS_url='<? print(ini_get("/config/".$config_file,$config_section,"QOS_url","http://ftp.wattmon.com/QOS.php")); ?>';">
<div ng-init="QOS_log='<? print(ini_get("/config/".$config_file,$config_section,"QOS_log","/logs/QOS")); ?>';">
<div ng-init="QOS_interval=<? print(ini_get("/config/".$config_file,$config_section,"QOS_interval",15)); ?>;">
<div ng-init="QOS_up_interval=<? print(ini_get("/config/".$config_file,$config_section,"QOS_up_interval",15)); ?>;">
<div ng-init="QOS_lines=<? print(ini_get("/config/".$config_file,$config_section,"QOS_lines",15)); ?>;">
<div ng-init="QOS_debug=<? print(ini_get("/config/".$config_file,$config_section,"QOS_debug",0)); ?>;">
<div ng-init="QOS_keep_alive=<? print(ini_get("/config/".$config_file,$config_section,"QOS_keep_alive",0)); ?>;">
<div ng-init="QOS_ignore_response=<? print(ini_get("/config/".$config_file,$config_section,"QOS_ignore_response",0)); ?>;">

<!-- FORM -->
<form name="form" class="css-form form-horizontal" novalidate>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ADMIN_SETTINGS','user')) ?></h5>
        <p class="card-text">    

          <div class="form-group">
            <label for="QOS_path">QOS FTP Server Path</label>
            <input type="text" class="form-control" id="QOS_path" ng-model="QOS_path" aria-describedby="QOS_pathHelp" placeholder="Enter FTP Server Path">
            <small id="QOS_pathHelp" class="form-text text-muted">Enter path on FTP server with / at end</small>
          </div>
          <div class="form-group">
            <label for="QOS_url">QOS FTP Server Hostname</label>
            <input type="text" class="form-control" id="QOS_url" ng-model="QOS_url" aria-describedby="QOS_urlHelp" placeholder="Enter FTP Server Host">
            <small id="QOS_urlHelp" class="form-text text-muted">FTP Server Hostname</small>
          </div>
          <div class="form-group">
            <label for="QOS_username">FTP Username</label>
            <input type="text" class="form-control" id="QOS_username" ng-model="QOS_username" aria-describedby="QOS_usernameHelp" placeholder="Username">
            <small id="QOS_usernameHelp" class="form-text text-muted">FTP Username</small>
          </div>
           <div class="form-group">
            <label for="QOS_password">FTP Password</label>
            <input type="password" class="form-control" id="QOS_password" ng-model="QOS_password" aria-describedby="QOS_passwordHelp" placeholder="Password">
            <small id="QOS_passwordHelp" class="form-text text-muted">FTP Password</small>
          </div>
          <div class="form-group">
            <label for="QOS_path">QOS Site Name</label>
            <input type="text" class="form-control" id="QOS_sitename" ng-model="QOS_sitename" aria-describedby="QOS_pathHelp" placeholder="Site name (for export filename)">
            <small id="QOS_pathHelp" class="form-text text-muted">Enter Site name for this site</small>
          </div>
          <div class="form-group">
            <label for="QOS_url">QOS Log Folder</label>
            <input type="text" class="form-control" id="QOS_log" ng-model="QOS_log" aria-describedby="QOS_urlHelp" placeholder="Enter log folder path without trailing slasht">
            <small id="QOS_urlHelp" class="form-text text-muted">Enter log folder path without trailing /</small>
          </div>
          <div class="form-group">
            <label for="QOS_interval">QOS Interval (between data writes)</label>
            <input type='number' min=1 max=30 ng-model="QOS_interval"  name='QOS_interval' t aria-describedby="QOS_intHelp" placeholder="Enter Interval">
            <small id="QOS_intHelp" class="form-text text-muted">QOS Interval in Minutes (between inverter data) * max=30</small>
          </div>
          <div class="form-group">
            <label for="QOS_interval">QOS Upload Interval (between FTP Push)</label>
            <input type='number' min=1 max=30 ng-model="QOS_up_interval"  name='QOS_up_interval' t aria-describedby="QOS_intHelp" placeholder="Enter Interval">
            <small id="QOS_intHelp" class="form-text text-muted">QOS Interval in Minutes (between inverter data) * max=30</small>
          </div>
          <div class="form-group">
            <label for="QOS_lines">QOS Lines Per Upload</label>
            <input type='number' min=1 max=1000 ng-model="QOS_lines"  name='QOS_lines' t aria-describedby="QOS_lineHelp" placeholder="Enter Lines to upload">
            <small id="QOS_lineHelp" class="form-text text-muted">Lines to upload when pushing historic data</small>
          </div>
          <div class="form-group">
            <label for="QOS_keep_alive">Keep Alive FTP connection</label>
            <select ng-model="QOS_keep_alive" name='QOS_keep_alive' class="custom-select custom-select-sm">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
            </select>
            <small id="langH" class="form-text text-muted">Send FTP Keep Alive requests</small>
          </div>
          <div class="form-group">
            <label for="QOS_ignore_response">FTP Ignore Response</label>
            <select ng-model="QOS_ignore_response" name='QOS_ignore_response' class="custom-select custom-select-sm">
                <option value='0'>Disabled</option>
                <option value='1'>Enabled</option>
            </select>
            <small id="langH" class="form-text text-muted">Ignore FTP responses after upload</small>
          </div>
        </p>
    </div>
</div>
		 
		       
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Device Serial Numbers</h5>
        <p class="card-text">    
            <table class='table table-striped' summary="Inverters" >
                    <tr>
                        <td scope="col">ID</td>
                        <td scope="col">Serial</td>
                    </tr>
                    <tr ng-repeat="item in sn">
                        <td scope="col">S/N for <strong>{{item.device}}</strong> (Modbus ID: {{item.id}})</td>
                        <td scope="col"><input type="text" class="form-control"  ng-model="item.serial" placeholder="Enter Serial Number" required></td>
                    </tr>
                </table>

          </div>

        </p>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <h5 class="card-title">Export Information</h5>
        <p class="card-text">    
            
            <label class="control-label" for='export_lines'>Current Status</label><br>
			            Last Export Time <? print(strftime("%c",ini_get("/logs/qos_status.ini","export","last_export",0))); ?>. <br>
			            <? print(lang('FILE_POSITION','dataexport')) ?>: <? print(ini_get("/logs/qos_status.ini","export","filepos",0)); ?><br>
			            <? print(lang('FILE_DATE','dataexport')) ?>: <? $file=ini_get("/logs/qos_status.ini","export","file","");
			            if ($file)
			                    print(substr($file,6,2)."/".substr($file,4,2)."/".substr($file,0,4)); ?>
			            
        </p>
    </div>
</div>
			    
</form>
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function QOS($scope, $timeout,$http) {
   var self = this;
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

   //alert('init');
   $scope.sn=[<?
   
    $num_dev=mb_num_devices();
    
    $_GLOBALS['QOS_sn']=array();
        
    for ($i=0;$i<$num_dev;$i++) {
        $d=mb_get_dev_by_index($i);
        $_GLOBALS['QOS_sn'][$i]=ini_get("/config/QOS.ini","config","QOS_sn".$i,'');
    }
    
    $first=1;
    for ($i=0;$i<$num_dev;$i++) {
        //print("i=".$i);
        $d=mb_get_dev_by_index($i);
        //print_r($d);
        
        if (!strlen($_GLOBALS['QOS_sn'][$i])) {
            
            $_GLOBALS['QOS_sn'][$i]=strval($d['serial']);
        }
        if ($d['device_type_id']>1000) {
            if (!$first) 
                print(",");
        
            print('{"idx":'.$i.',"id":"'.$d['slave_id'].'","device":"'.$d['name'].'","serial":"'.$_GLOBALS['QOS_sn'][$i].'"}');
            $first=0;
        }
		if (!sn_is_ok($_GLOBALS['QOS_sn'][$i])) 
			$_GLOBALS['QOS_sn'][$i]='';
    }
   
   ?>
   ];
   $scope.loading=0;
   $gscope=$scope;
   <?
    if ($_GET['reset_export']) {
        ?>$scope.successmsg="Cleared the export position, data will start uploading from current time.";
        <?
    }
    ?>
   $scope.saveSettings=function() {
        for (i=0;i<$scope.sn.length;i++) {
            if ($scope.sn[i].serial.length<2) {
                $scope.errormsg="Unable to save as one or more serial numbers are not properly entered.  Please enter them first";
                return;
            }
        }
       post_data="QOS_path="+$scope.QOS_path;
       post_data+="&QOS_sitename="+$scope.QOS_sitename;
       post_data+="&QOS_username="+$scope.QOS_username;
       post_data+="&QOS_password="+encodeURI($scope.QOS_password);
       post_data+="&QOS_interval="+$scope.QOS_interval;
	   post_data+="&QOS_up_interval="+$scope.QOS_up_interval;
	   post_data+="&QOS_keep_alive="+$scope.QOS_keep_alive;
	   post_data+="&QOS_ignore_response="+$scope.QOS_ignore_response;

       post_data+="&QOS_lines="+$scope.QOS_lines;
       post_data+="&QOS_url="+$scope.QOS_url;
       post_data+="&QOS_log="+$scope.QOS_log;
       
       for (i=0;i<$scope.sn.length;i++) {
            post_data+="&QOS_sn"+$scope.sn[i].idx+"="+encodeURI($scope.sn[i].serial);
       }
       
       post_config="QOS.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
      <?
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>









