<?
/**
 * @package QOS
 * @author  Akash Heimlich
 * @data    13 Mar 2023
 * @description Runs once a minute
 * 
 * This version is updated and dynamically generates a CSV file but uses the log data from the main
 * Wattmon CSV file.  This is done to prevent the QOS package from getting stuck when there are heavy
 * uploads and bad connections.
 * 
 * The script will keep pushing the data until the file is successfully uploaded, then populate the next data.
 * 
 */
$DEBUG = ini_get("/config/QOS.ini","config","QOS_debug",1);

$y=strftime("%Y",time());
$day=strftime("%d",time());
$m=strftime("%m",time());
$hour=strftime("%H",time());
$minute=strftime("%M",time());
$second=strftime("%s",time());
$min=intval(strftime("%M",time()));


$prefix='';
if ($_SERVER['HW_PLATFORM']==11) {
    $prefix='0:';
}
if ($_SERVER['HW_PLATFORM']>=20) {  // ULTRA
        $prefix=intval($_GLOBALS['log_drive']).':';
}


// if this is set anywhere, it will jump out of the script
$skip_qos = 0;
$error = 0;

$base_dir=$prefix.$_GLOBALS['QOS_log'];

// check if the upload interval is reached, or if the user is running the script manually (with debugupload=1)

//log ("min = ".$min. " uploadinterval=".$_GLOBALS['QOS_up_interval']." debugupload=".$_GET['debugupload']);
max_execution_time(45);

if (($min % $_GLOBALS['QOS_up_interval']==0) || $_GET['debugupload']) {
    
    $base_dir .= "/";
    
    $log_folder = $base_dir;
    
    $log_file = 'QDATA_' . $_GLOBALS['QOS_sitename'] . '_' . $y . $m . $day . "_" . $hour . $minute . "00.csv";
    
    $log_file2 = $y . $m . $day . "_" . $hour . $minute . "00.csv";

    $folder_path = ini_get("/config/QOS.ini", "config", "QOS_path", "/");

    // get the number of lines to upload
    $qos_lines = ini_get("/config/QOS.ini", "config", "QOS_lines", 15);
    
    $error=0;
    
    // check if already connected to FTP and if not reconnect
    if ($DEBUG) {
            
            print("Check FTP is connected= " . ftp_is_connected()."\r\n");
            log("Check FTP is connected= " . ftp_is_connected()."\r\n");
    }
    
	if (!ftp_is_connected()) {

        $host = ini_get("/config/QOS.ini", "config", "QOS_url", "");
        $user = ini_get("/config/QOS.ini", "config", "QOS_username", "");
        $pass = ini_get("/config/QOS.ini", "config", "QOS_password", "");
        $port = ini_get("/config/QOS.ini", "config", "QOS_port", 21);
        $keep_alive = ini_get("/config/QOS.ini", "config", "QOS_keep_alive", 1);
        $ignore_response = ini_get("/config/QOS.ini", "config", "QOS_ignore_response", 0);
        
        if ($DEBUG) {
            log("[qos] Starting FTP connection to " . $host . " keep_alive=" . $keep_alive . " ignore_response=" . $ignore_response);
            print("[qos] Starting FTP connection to " . $host . " keep_alive=" . $keep_alive . " ignore_response=" . $ignore_response."\r\n");
        }
        
        if (!$host || !$user || !$pass) {
            log("FTP settings not configured");
            print("FTP settings not configured");
            $skip_qos=1;
        }
        
        max_execution_time(60);
        
        // check if the FTP engine is already busy
        if (!$skip_qos) {
            if (ftp_is_busy()) {
                
                $_GLOBALS['ftp_busy']++;
                
                $ftp_status=ftp_status();
                
                if ($DEBUG) {
                    print_r($ftp_status);
                    log("FTP is busy...");
                    print("FTP is busy...");
                }
                
                if ($_GLOBALS['ftp_busy'] > 5) {
                    log("Force close FTP..");
                    ftp_close();
                } else {
                    $skip_qos = 1;
                }
                
            } else $_GLOBALS['ftp_busy']=0;
        }
        
        if (!$skip_qos) {
            
            $ftp = ftp_open($host, $port, $user, $pass, 0, $keep_alive, $ignore_response);
            
            if (!$ftp) {
                
                log("[QOSMin] Error establishing FTP connection");
                print("[QOSMin] Error establishing FTP connection");
                
                if (!ftp_is_busy()) {
                    ftp_close();
                }
                $skip_qos = 1;
            }
            
            if (!$skip_qos) {
                
                // if the new FTP connection could not be established
                // wait for the FTP response containing the error at hand and log it
                // then set error=True which effectively terminates the script
                $error = 0;
                $wait = 0;
                while (!ftp_is_connected()) {
                    sleep(2000);
                    if (ftp_error() > 0) {
                        
                        print("FTP ERROR " + ftp_error());
                        log("FTP ERROR " + ftp_error());
                        $error=1;
                        $skip_qos = 1;
                    }
                    $wait++;
                    if($wait >= 6) {
                        log("[QOSMin] FTP connection unsuccessful. Cancel upload.");
                        die();
                    }
                    
                }
                
                // FTP should be connected now
                // $error=0;
                // $skip_qos = 0;
                
                if (!$error) {
                    $res=ftp_command("mkd " . $folder_path); // make the folder
                    $res=ftp_command("cwd " . $folder_path);
                }
            }
    	}
	}  
	
	// now it should be connected
	
    if (!$skip_qos && ftp_is_connected() && !$error) {

        
		$has_data = file_exists($base_dir . 'QDATA.csv');
		
		if ($DEBUG) {
            print("Check if exists ".$base_dir . 'QDATA.csv - '.$has_data."\r\n");
        }
		// if the file does not exist, populate it from the file pointer in QOS_status.ini
		
		if (!$has_data) {
		    
		    // include the fgets_long function
		    
		    include("/lib/uphp/fileio.inc");
		    
		    if ($DEBUG) {
                include("/lib/uphp/debug.inc");

                debug_start();
		    }
		    
		    // generate the QDATA csv file
		    $f_log=fopen($base_dir . 'QDATA.csv', "w");
            
            
            if (file_exists("/config/qos_header.txt")) {
                
                $f_header = fopen("/config/qos_header.txt","r");
                
                $f_row = fgets_long($f_header);
                fwrite($f_log, $f_row . "\r\n");
                
                $f_row = fgets_long($f_header);
                fwrite($f_log, $f_row . "\r\n");
                
                $f_row = fgets_long($f_header);
                $arr_devices = explode($f_row, ',');
                
                // populate the serial number from the QOS ini file
                
                for ($i = 1; $i < sizeof($arr_devices); $i++) {
                    if (is_numeric($arr_devices[$i])) {     
                        $arr_devices[$i] = strval(ini_get('/config/QOS.ini', 'config', 'QOS_sn' . $arr_devices[$i], 'sn' . $arr_devices[$i]));
                    }
                }
                
                $f_row = implode($arr_devices, ',');
                fwrite($f_log, $f_row . "\r\n");
                
                // free up memory
                $arr_devices = 0;
                
                $f_row = fgets_long($f_header);
                fwrite($f_log, $f_row . "\r\n");
                
                $f_row = fgets_long($f_header);
                fwrite($f_log, $f_row . "\r\n");
                fclose($f_header);
                
            } else {
                if ($DEBUG) {
                    log("[qos] Error - qos_header file not found, re-run ezconfig");
                }
            }
            
            // get last export pointer
            
            $last_export_time    = ini_get($prefix."/logs/qos_status.ini", "export", "last_export", 0);
            $last_export_file    = ini_get($prefix."/logs/qos_status.ini", "export", "file", "");
            $last_export_filepos = ini_get($prefix."/logs/qos_status.ini", "export", "filepos", 0);
            
            //log ("last_export_time = ".$last_export_time. " last_export_file=".$last_export_file." last_export_filepos=".$last_export_filepos);

            if ($DEBUG) {
                debug_print("1. last_export_file=" . $logdir . $last_export_file,'file','blue');
            }
            
            // if this is new, just start from now
            
            if (!$last_export_file) {
                
                $logdir = $prefix."/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
                
                $last_export_time    = time();
                $m                   = strftime("%M", time());
                $h                   = strftime("%H", time());
                $last_export_file    = strftime("%Y%m%d", time()) . "_0.csv";
                $last_export_filepos = filesize($logdir . $last_export_file);
                
                ini_set($prefix."/logs/qos_status.ini", "export", "filepos", $last_export_filepos);
                ini_set($prefix."/logs/qos_status.ini", "export", "last_export", time());
                ini_set($prefix."/logs/qos_status.ini", "export", "file", $last_export_file);
                
            } else {
                
                $y = substr($last_export_file, 0, 4);
                $m = substr($last_export_file, 4, 2);
                
                $logdir = $prefix."/logs/" + $y . "/" . $m . "/";
            }
            
            if ($DEBUG) 
                debug_print("2. last_export_file=" . $logdir.$last_export_file, 'file');
            
            $last_size = filesize($logdir . $last_export_file);
            
            if ($DEBUG) {
                debug_print($last_size . " " . $last_export_filepos);
                debug_print("Comparison : last_size <= last_export_filepos + 10 = ".($last_size <= $last_export_filepos + 10), 'file', 'blue');
            }
            
            // check if end of file is reached
            
            if ($last_size <= $last_export_filepos + 10) {
                $y = substr($last_export_file, 0, 4);
                $m = substr($last_export_file, 4, 2);
                $d = substr($last_export_file, 6, 2);
                
                if ($DEBUG) 
                    debug_print("fn=" . $y . " " . $m . " " . $d, 'file', 'green');
                    
                $found_file=0;
                $date_offset=0;
                $date_offset=86400;
                while (!$found_file) {
                    
                    $t = mktime(0, 0, 0, intval($m) - 1, intval($d), intval($y)) + $date_offset;
                    
                    $m = strftime("%m", $t);
                    $d = strftime("%d", $t);
                    $y = strftime("%Y", $t);
                    
                    $logdir          = $prefix."/logs/" + $y . "/" . $m . "/";
                    $new_export_file = strftime("%Y%m%d", $t) . "_0.csv";
                    
                    if ($DEBUG) {
                        debug_print("ts=".$t . " " . $logdir,"file","green");
                        debug_print("Check for new file " . $new_export_file);
                    }
                    
                    // check if more data is available in a new file (i.e day change)
                    
                    if (!file_exists($logdir . $new_export_file)) {
                        debug_print("File not found for day ".$d."/".$m."/".$y);
                        if (($t < (time() - 86400 * 30)) || ($t > time())) {
                            $logdir          = $prefix . "/logs/" + strftime("%Y", time()) . "/" . strftime("%m", time()) . "/";
                            $new_export_file = strftime("%Y%m%d", time()) . "_0.csv";
                            $found_file = 1;
                            // if we have switched days
                            if ($new_export_file != $last_export_file) {
                                
                                // if we are on a new day for the duration of the QOS_Interval, then force it to that file name
                                if ((time() - $last_export_time) > ($_GLOBALS['QOS_interval']*60)) {
                                    $last_export_file    = $new_export_file;
                                    $last_export_filepos = 0;
                                }
                            }
                        }
                        
                    } else {
                        debug_print("Using file for day ".$d."/".$m."/".$y);
                        $found_file=1;
                        $last_export_file    = $new_export_file;
                        $last_export_filepos = 0;
                    }
                }
            }
            
            debug_print("3. last_export_file=" . $last_export_file,"file","green");
            
            $f_csv_log = fopen($logdir . $last_export_file, "r");
            if ($f_csv_log) {
                fseek($f_csv_log, $last_export_filepos, 0);
                
                // make sure to respect the inverval (skip any lines in-between)
                $csv_interval = 0;
                debug_print("Reading up to " . $qos_lines . " lines ","file","green");
                for ($lines=0;$lines <= $qos_lines;$lines++) {
                    $csv_line = fgets_long($f_csv_log);
                    print($csv_line."\r\n");
                    if (!$csv_line) {
                        if (feof($f_csv_log)) {
                            if ($DEBUG) {
                                print("End of log reached, lines=" . $lines . "\r\n");
                            }
                            break;
                        }
                    }
    
                    $f_arr=explode($csv_line, ',');
                    
                    //log ("intval(f_arr[0]) = ".intval($f_arr[0]). " csv_interval=".$csv_interval. " lines =".$lines);
                    if (is_numeric($f_arr[0]) && (intval($f_arr[0]) - $csv_interval>= $_GLOBALS['QOS_interval']*60) && 
                       (intval(strftime("%M", intval($f_arr[0]))) % $_GLOBALS['QOS_interval'] == 0))  {
                        if ($DEBUG) {
                            print("Adding line. \r\n");
                        }
                        $csv_interval = intval($f_arr[0]);
                        $f_arr[0] = strftime("%d/%m/%Y %H:%M:00", intval($f_arr[0]));
        
                        // fix for PYRA module                
                        if ($_GLOBALS['pyra_id']) {
                            // we need to copy over everything except the last 2 roles
                            $f_arr2=array();
                            for ($t=0;$t<sizeof($f_arr);$t++) {
                                $f_arr2[] = $f_arr[$t];
                            }
                            $f_arr=$f_arr2;
                        }
                        
                        // free memory
                        $csv_line = '';
                        
                        $csv_line = implode($f_arr, ',');
                        
                        // free memory;
                        $f_arr = 0;
                        
                        fwrite($f_log, $csv_line."\r\n");
            
                        // free memory
                        $csv_line = '';
                    } else {
                        $lines--;
                        if ($DEBUG)
                            print("Skipping line... ".intval(intval($f_arr[0])/60)." ".$_GLOBALS['QOS_interval']."\r\n");
                    }
    		    
        		}
        		
        		$has_data=1;
        		$last_export_filepos = ftell($f_csv_log);
        		if ($DEBUG) {
        		    debug_print("update last_export_file=" . $last_export_file,"file","green");
        		}
        		ini_set($prefix."/logs/qos_status.ini", "export", "filepos", $last_export_filepos);
        		ini_set($prefix."/logs/qos_status.ini", "export", "last_export", time());
        		ini_set($prefix."/logs/qos_status.ini", "export", "file", $last_export_file);
        		
        		
                fclose($f_csv_log);
            }
            fclose($f_log);
            
            if (!$lines) {
                if ($DEBUG) {
                    print("Deleting QOS file as lines=" . $lines . "\r\n");
                    log("[qos] Deleting temp csv as there is no data to upload.");
                }                
                unlink($base_dir . 'QDATA.csv');
                
                // Automatically reboot when "QDATA.csv" freezes and cannot be deleted
                if (file_exists($base_dir . 'QDATA.csv')) {
                    log("[QOSMin] - reboot due to frozen QDATA.csv");
                    reboot();
                }
                
                $has_data=0;
            }
            
		}
		
        if ($has_data) {
            
            $res = ftp_command("cwd " . $folder_path);
            
            if ($DEBUG) {
                log("Upload " . $base_dir . "QDATA.csv to " . $folder_paqosth . $log_file);
            }
            
            $res = ftp_upload($folder_path . $log_file, $base_dir . "QDATA.csv", 0, 0);
            
            if ($DEBUG) {
                print ("[qos] Upload result is " . $res . "\r\n");
            }
            
            $last_position = 0;
            $last_update_time = time();
            
            // wait for the upload to complete
            $ftp_status = ftp_status();
            
            while ($ftp_status['status'] <= 1) {
                
                if ($DEBUG) {
                    print_r($ftp_status);
                }
                
                log($ftp_status['file_position'] . "/" . $ftp_status['file_size']);
                
                if ($last_position != $ftp_status['file_position']) {
                    $last_update_time = time();
                    $last_position = $ftp_status['file_position'];
                }
                
                if (time() - $last_update_time > 30) {
                    print("No change in file position...");
                    if ($DEBUG) {
                        log("[qos] Aborting the FTP upload since it appears to be stuck");
                    }
                    
                    $skip_qos=1;
                    
                    // reboot due to stuck upload
                    log("[QOSMin] - reboot due to stuck FTP upload");
                    reboot();
					break;
                }

                sleep(5000);
                clear_watchdog();
                
                $ftp_status=ftp_status();
                
            }
            
            if (!$skip_qos) {
                
                log("[qos] Upload completed, status = ".$ftp_status['status']);
                
                if (intval($ftp_status['status'])==2) {
                    
                    // delete this file, it will auto create again on the next run with data from the main log file
                    
                    unlink($base_dir."QDATA.csv");
                    
                    // Automatically reboot when "QDATA.csv" freezes and cannot be deleted
                    if (file_exists($base_dir . 'QDATA.csv')) {
                        log("[QOSMin] - reboot due to frozen QDATA.csv");
                        reboot();
                    }
                    
                    
                    
                    $_GLOBALS['error3g']=0;
                } else {  
                    
                    // deal with dongle reconnection issue
                    $stat=get3gstat(); 
                    
                    if ($stat['enabled']) {
                        if ($stat['connected']) {
                            if ($stat['ip_address']!='0.0.0.0') {
                                $_GLOBALS['error3g']++;
                                if ($_GLOBALS['error3g']>=5) {
                                    log("Cellular link seems to have died, restarting USB power");
                                    setusbpower(0);
                                    sleep(100);
                                    setusbpower(1);
                                    $_GLOBALS['error3g']=0;
                                }
                                    
                            }
                        }
                    }
                }
                    
                
            }  // !skip_qos

        }  // has_data
        
    } // ftp connected
    
}

?>

