<?
/**
 * @package GridTieMeter
 * @author Akash Heimlich
 * @description This widget shows grid tie bidirectional meter production
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function GridTieMeter_install($val) {
        GridTieMeter_enable();
        return 1;
    }
     
    function GridTieMeter_uninstall() {
        setPackageStatus("GridTieMeter",0);
        return 1;
    }
    
    function GridTieMeter_enable() {
        setPackageStatus("GridTieMeter",2);
        addWidget("/package/GridTieMeter.inc","Grid Tie",12,"none",0,0); // enable
        return 1;
    }
    
    function GridTieMeter_disable() {
        setPackageStatus("GridTieMeter",3);
        addWidget("/package/GridTieMeter.inc","Grid Tie",12,"none",0,1); // disable
        return 1;
    }
    
    /* this is called at system boot */
    function GridTieMeter_init() {

             // load the test Value into the globals
        $_GLOBALS['gt_watt_role1']=ini_get("/config/GridTieMeter.ini","config","watt_role1","0");
        $_GLOBALS['gt_watt_role2']=ini_get("/config/GridTieMeter.ini","config","watt_role2","0");
        $_GLOBALS['gt_watt_role3']=ini_get("/config/GridTieMeter.ini","config","watt_role3","0");
        $_GLOBALS['gt_total_import_role']=ini_get("/config/GridTieMeter.ini","config","total_import_role","0");
        $_GLOBALS['gt_total_export_role']=ini_get("/config/GridTieMeter.ini","config","total_export_role","0");
        /**
         * Install the widget in the control panel using this
         **/
        $arr=array();
        $arr['script']='/package/GridTieMeter.cgi?action=configure';
        $arr['title']='Test';
        $arr['icon']='icon-hdd';
        $arr['desc']='Grid Tie Meter Settings';
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        
        // generate ajax data for front end processing
        if (file_exists('/package/GridTieMeterAjax.inc')) 
            $_GLOBALS['hooks']['ajax'][]='/package/GridTieMeterAjax.inc';

        return 1;
    }
    
    function GridTieMeter_configure() {
        include("/app/config.inc");
        $bodyid='rootscope';
        $angular_controller="GridTieMeter"; 
        $title='GridTieMeter Widget Configuration';
        $config_file="GridTieMeter.ini";
        $config_section="config";

        include("/app/header.inc");
        print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
        ?> <div class="row-fluid">
       <form name="form" class="css-form  form-horizontal" novalidate>
        <div class="span12">    
        <ul class="breadcrumb">
            <li><a href="/">Home</a> <span class="divider">/</span></li>
            <li><a href="/app/settings.cgi">Control Panel</a> <span class="divider">/</span></li>
            <li class="active">GridTieMeter Widget</li>
        </ul>
        
<div class="page-header">
  <h1><i class="icon-suitcase icon-2x"></i> GridTieMeter Widget Configuration</h1>
</div>
<div id="nav-wrapper">
    <div id="nav">
        <div class="navbar well">
            <div class='container'>
                <div id='navcontent'><div class='navtext'>Configure widget here.</div>
        
                    <button class="btn btn-primary btn-large pull-right" ng-click="saveSettings()" ng-disabled="form.$invalid"><i class="icon-check"></i> Apply Changes</button>
                    <button class="btn btn-large pull-right" onclick="document.location='/app/settings.cgi';">Close</button> 
                    <button class="btn btn-large pull-right" ng-show='helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-up"></i> Less</button>
                    <button class="btn btn-large pull-right" ng-show='!helpvisible' ng-click="helpvisible=!helpvisible"><i class="icon-chevron-down"></i> More</button>
                </div>
        
                
            </div> <!-- container -->
<div class="bs-callout bs-callout-info" ng-cloak ng-show='helpvisible'>
This widget lets you associate roles with to gride tie variables for proper display on the front end. <br>
</div>            
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-error" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
        </div> <!-- navbar-inner -->
    </div> <!-- navbar -->
</div>     
<div class="row-fluid">
	<div class="box span12">
		<div class="box-header well">
			<h2><i class="icon-pencil"></i> Widget Settings</h2>
			<div class="box-icon">
				<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
			</div>
		</div>
		<div class="box-content">
		<div ng-init="watt_role1=<? print(ini_get("/config/".$config_file,$config_section,"watt_role1",0)); ?>;">
		<div ng-init="watt_role2=<? print(ini_get("/config/".$config_file,$config_section,"watt_role2",0)); ?>;">
		<div ng-init="watt_role3=<? print(ini_get("/config/".$config_file,$config_section,"watt_role3",0)); ?>;">
		<div ng-init="total_export_role=<? print(ini_get("/config/".$config_file,$config_section,"total_export_role",0)); ?>;">
		<div ng-init="total_import_role=<? print(ini_get("/config/".$config_file,$config_section,"total_import_role",0)); ?>;">
		<div ng-init="grid_group=<? print(ini_get("/config/".$config_file,$config_section,"grid_group",0)); ?>;">
		<div ng-init="kwh_rate='<? print(ini_get("/config/".$config_file,$config_section,"kwh_rate",0.0)); ?>';">
		<div ng-init="kwh_currency='<? print(ini_get("/config/".$config_file,$config_section,"kwh_currency",'INR')); ?>';">
		 <fieldset>
			    <div class="control-group">
		            <label class="control-label" for='watt_role1'>Role for Export Watts 1</label>
		            <div class="controls">
		                <select name='watt_role1' ng-model='watt_role1'>
		                    <? 
$role_ini="/config/roles.ini";
$role_section="roles";
$role_cnt=ini_get($role_ini,$role_section,'num_roles',0);

for ($i=0;$i<$role_cnt;$i++) {
  print("<option value='".$i."'>".ini_get($role_ini,$role_section,'role'.$i)."</option>\r\n");
}
		                    ?>
			            </select>
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='watt_role2'>Role for Export Watts 2</label>
		            <div class="controls">
		                <select name='watt_role2' ng-model='watt_role2'>
		                    <? 
$role_ini="/config/roles.ini";
$role_section="roles";
$role_cnt=ini_get($role_ini,$role_section,'num_roles',0);

for ($i=0;$i<$role_cnt;$i++) {
  print("<option value='".$i."'>".ini_get($role_ini,$role_section,'role'.$i)."</option>\r\n");
}
		                    ?>
			            </select>
			        </div>
		        </div>
			    <div class="control-group">
		            <label class="control-label" for='watt_role3'>Role for Export Watts 3</label>
		            <div class="controls">
		                <select name='watt_role3' ng-model='watt_role3'>
		                    <? 
$role_ini="/config/roles.ini";
$role_section="roles";
$role_cnt=ini_get($role_ini,$role_section,'num_roles',0);

for ($i=0;$i<$role_cnt;$i++) {
  print("<option value='".$i."'>".ini_get($role_ini,$role_section,'role'.$i)."</option>\r\n");
}
		                    ?>
			            </select>
			        </div>
		        </div>	
                <div class="control-group">
		            <label class="control-label" for='total_export_role'>Role for Total KwH Export</label>
		            <div class="controls">
		                <select name='total_export_role' ng-model='total_export_role'>
		                    <? 
$role_ini="/config/roles.ini";
$role_section="roles";
$role_cnt=ini_get($role_ini,$role_section,'num_roles',0);

for ($i=0;$i<$role_cnt;$i++) {
  print("<option value='".$i."'>".ini_get($role_ini,$role_section,'role'.$i)."</option>\r\n");
}
		                    ?>
			            </select>
			        </div>
		        </div>			        
            <div class="control-group">
		            <label class="control-label" for='total_import_role'>Role for Total KwH Import</label>
		            <div class="controls">
		                <select name='total_import_role' ng-model='total_import_role'>
		                    <? 
$role_ini="/config/roles.ini";
$role_section="roles";
$role_cnt=ini_get($role_ini,$role_section,'num_roles',0);

for ($i=0;$i<$role_cnt;$i++) {
  print("<option value='".$i."'>".ini_get($role_ini,$role_section,'role'.$i)."</option>\r\n");
}
		                    ?>
			            </select>
			        </div>
		        </div>			        
        <div class="control-group">
		            <label class="control-label" for='grid_group'>Data Group</label>
		            <div class="controls">
		                <select name='watt_role' ng-model='grid_group'>
		                    <? 
$ini="/config/groups.ini";
$section="groups";
$cnt=ini_get($ini,$section,'num_groups',0);

for ($i=0;$i<$cnt;$i++) {
  print("<option value='".$i."'>".ini_get($ini,$section,'group'.$i)."</option>\r\n");
}
		                    ?>
			            </select>
			        </div>
		        </div>		        
		        
                <div class="control-group">
		            <label class="control-label" for='kwh_rate'>Rate per kWh</label>
		            <div class="controls">
			            <input type='text' ng-model="kwh_rate"  name='kwh_rate' title="Enter a price per kWH hour" data-rel="tooltip"> 
			        </div>
		        </div>
                <div class="control-group">
		            <label class="control-label" for='kwh_currency'>Currency</label>
		            <div class="controls">
			            <input type='text' ng-model="kwh_currency"  name='kwh_currency' title="Enter 3-character Currency (i.e. EUR, INR, USD)" data-rel="tooltip"> 
			        </div>
		        </div>
		        
		</fieldset>
		<div class="clearfix"></div>
					</div>
				</div>
			</div>  		        
</form>
			

        </div><!--/span-->
      </div><!--/row-->
        <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);
function GridTieMeter($scope, $timeout,$http) {
   var self = this;
   //alert('init');
   $scope.loading=0;
   $gscope=$scope;
   $scope.saveSettings=function() {
       post_data="watt_role1="+$scope.watt_role1;
       post_data+="&watt_role2="+$scope.watt_role2;
       post_data+="&watt_role3="+$scope.watt_role3;
       post_data+="&total_export_role="+$scope.total_export_role;
       post_data+="&total_import_role="+$scope.total_import_role;
       post_data+="&kwh_currency="+$scope.kwh_currency;
       post_data+="&kwh_rate="+$scope.kwh_rate;
       post_data+="&grid_group="+$scope.grid_group;
       post_config="GridTieMeter.ini";
       post_section="config";
       $http.post('/app/configsave.cgi?config='+post_config+'&section='+post_section,post_data)
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
        });
   }
}
   </script>
   
        <?
        include("/app/footer.inc");?>
        <script>$(function() {
    $('#navcontent').width($("#nav").width()-10);
    $('#nav').affix({
        offset: { top: $('#nav').offset().top }
    });
});</script><?
        return 1;
    }
    execute(); // process the package and run the correct function

    
?>


