<pre><?
/**
 * @package OpenWeather
 * @author Akash Heimlich
 * @description Runs once a minute and takes care of rainfall and other calculations for a weather station
 */
    // get hour and minute
    $hour=intval(strftime("%H",time()));
    $day=intval(strftime("%d",time()));
    $minute=intval(strftime("%M",time()));
    // the 24-hour weather is from 8:30 am one day till 8-30 am next day in India
    $rainfall_multiplier=floatval(ini_get("/config/OpenWeather.ini","config","rain_pulse_mul",1.0));
    $rf_role=ini_get("/config/OpenWeather.ini","config","rain_role",0);
    $rf_24_hour=ini_get("/config/OpenWeather.ini","config","rain_24h_hour",8);
    $rf_24_min=ini_get("/config/OpenWeather.ini","config","rain_24h_min",30);
    $rf_year_month=ini_get("/config/OpenWeather.ini","config","rain_year_month",6);
    
    $rf_total=floatval(ini_get("/config/OpenWeather.ini","data","rain_pulse_total",0.0));

    $rf_year=floatval(ini_get("/config/OpenWeather.ini","data","rain_pulse_year",0.0));
    $rf_month=floatval(ini_get("/config/OpenWeather.ini","data","rain_pulse_month",0.0));
    $rf_day=floatval(ini_get("/config/OpenWeather.ini","data","rain_pulse_day",0.0));
    //print($rf_day." ".$rf_month." ".$rf_year." ".$rainfall_multiplier);
    if (!$rf_role) {
        $_GLOBALS['sysmsg']='Openweather Package needs to be configured';
    } else {
        $pulse=mb_get_val_by_role($rf_role);
        if (!$_GLOBALS['owc_counter']) $_GLOBALS['owc_counter']=$pulse;
        // only if the values change
        if ($pulse>$_GLOBALS['owc_counter'])  {
            $diff=$pulse-$_GLOBALS['owc_counter'];
            $rf_total+=$diff;
            $rf_year+=$diff;
            $rf_month+=$diff;
            $rf_day+=$diff;
            $_GLOBALS['rf_hour']+=$diff;
            $_GLOBALS['rf_minute']=$diff;
            ini_set("/config/OpenWeather.ini","data","rain_pulse_total",$rf_total);
            ini_set("/config/OpenWeather.ini","data","rain_pulse_year",$rf_year);
            ini_set("/config/OpenWeather.ini","data","rain_pulse_month",$rf_month);
            ini_set("/config/OpenWeather.ini","data","rain_pulse_day",$rf_day);
            $_GLOBALS['owc_counter']=$pulse;
            
            $f=fopen("/logs/rainfall_log.csv","a");
            $str=strftime("%Y-%m-%d %H:%M:%S",time());
            $str.=",".$_GLOBALS['rf_hour'].",".$_GLOBALS['rf_minute'].",".($_GLOBALS['rf_hour']*$rainfall_multiplier).",".($diff*$rainfall_multiplier)."\r\n";
            fwrite($f,$str);
            fclose($f);
            
            
        } else $_GLOBALS['rf_minute']=0;
        
        
        $_GLOBALS['rainfall_24h']=$rf_day*$rainfall_multiplier;
        $_GLOBALS['rainfall_month']=$rf_month*$rainfall_multiplier;
        $_GLOBALS['rainfall_year']=$rf_year*$rainfall_multiplier;
        
        $export=ini_get("/config/OpenWeather.ini","config","export_interval",0);  
        if ($export) {
            $_GLOBALS['ow_interval']++;
            if ($_GLOBALS['ow_interval']>=$export) {
                $username=ini_get("/config/OpenWeather.ini","config","username","");  
                $password=ini_get("/config/OpenWeather.ini","config","password","");  
                
                $fp = fsockopen("openweathermap.org", 80,15);
                if ($fp) {
                    fwrite($fp, "POST /data/post HTTP/1.0\r\n");
                    fwrite($fp, "Host: openweathermap.org\r\n");
    
                    fwrite($fp, "Authorization: Basic " .
                        base64_encode($username.":".$password) .
                    "\r\n");
    
                    fwrite($fp, "\r\n");
                    
                    $st="stations_list=Maitreye&name=Maitreye&lat=12.000200&long=79.818058";
                    $radiation_role=ini_get("/config/OpenWeather.ini","config","radiation_role",0);  
                    if ($radiation_role) 
                        $st.="&radiation=".mb_get_val_by_role($radiation_role);

                    $temp_role=ini_get("/config/OpenWeather.ini","config","temperature_role",0);  
                    if ($temp_role) 
                        $st.="&temp=".mb_get_val_by_role($temp_role);
    
                    $st.="&rain_1h=".$_GLOBALS['rf_hour'];
                    $st.="&rain_24h=".$_GLOBALS['rainfall_24h'];
                    print("Sending: ".$st);
                    fwrite($fp,$st);
                    $done=0;
            	    $start=microtime();
            	    // if we received anything back, assume the export succeeded
            	    $done=0;
            	    while (!$done) {
            		    $str=fgets($fp);
            		    print("IN2: ".$str+"\r\n");

            		    if ($str==-1) {
            		        log("Connection broken");
            		        die();
            		    }
            		    if (strlen($str)==0) $done=1;
            	    }
            	    $str=fread($fp,filesize($fp));
            	    print("\r\nBody:".$str);
            	    fclose($fp);
                } else {
                    log("Error connecting to openweathermap.org");
                }
            }
        }
        
        if ($minute==$rf_min) {
            
            $_GLOBALS['rf_hour']=0;
        }
        // check for roll around for days
        if (($hour==$rf_24_hour) && ($minute==$rf_24_min)) {
            
            $f=fopen("/logs/daily_rainfall.csv","a");
            $str=strftime("%Y-%m-%d %H:%M:%S",time());
            $str.=",".$rf_day.",".$rf_day*$rainfall_multiplier."\r\n";
            fwrite($f,$str);
            fclose($f);
            $rf_day=0;
            ini_set("/config/OpenWeather.ini","data","rain_pulse_day",0);
            if ($day==1) {  // first of the month
                $f=fopen("/logs/monthly_rainfall.csv","a");
               $str=strftime("%Y-%m-%d %H:%M:%S",time());
                $str.=",".$rf_month.",".$rf_month*$rainfall_multiplier."\r\n";
                fwrite($f,$str);
                fclose($f);
                $rf_month=0;
                ini_set("/config/OpenWeather.ini","data","rain_pulse_month",0);
                $month=intval(strftime("%m",time()));
                if ($month==$rf_year_month) { // june
                    $f=fopen("/logs/annual_rainfall.csv","a");
                    $str=strftime("%Y-%m-%d %H:%M:%S",time());
                    $str.=",".$rf_year.",".$rf_year*$rainfall_multiplier."\r\n";
                    fwrite($f,$str);
                    fclose($f);
                    $rf_year=0;
                    ini_set("/config/OpenWeather.ini","data","rain_pulse_year",0);
                    
                }
            }
        }
    }
?>

