<?
/**
 * @package EnergyMeterWidget
 * @author Akash Heimlich
 * @description This widget integrates with a 3-phase energy meter IC over SPI
 */
 
// this will take care of the package management functions and call the right function based on the get parameters

    include("/app/package.inc"); 
    
    function Victron_install($val) {
        Victron_enable();
        return 1;
    }
     
    function Victron_uninstall() {
        setPackageStatus("Victron",0);
        return 1;
    }
    
    function Victron_enable() {
        setPackageStatus("Victron",2);
        addWidget("/package/Victron.inc","Victron",4,"icon-play",1,0); // enable
        return 1;
    }
    
    function Victron_disable() {
        setPackageStatus("Victron",3);
        addWidget("/package/Victron.inc","EnergyMeterWidget",4,"icon-play",1,1); // disable
        return 1;
    }
    
function send_cmd($a) {
    global $s;
    
    $send=array();
    $cks=0;
    $send[]=sizeof($a);
    for ($i=0;$i<sizeof($a);$i++) {
        $send[]=$a[$i];
    }

    for ($i=0;$i<sizeof($send);$i++) {
        $cks+=$send[$i];
    }
    $cks=0x100-($cks % 0x100);
    $send[]=$cks;
    for ($i=0;$i<sizeof($send);$i++) {
        fwrite($s,$send[$i]);
        printf("%02X ",$send[$i]);
    }
}


    $s=0;;

    /* this is called at system boot */
    function Victron_init() {
        global $s;
        $s=fseropen(2400,0,0,0); // even parity
//$a=array(0xFF,86);
        $a=array(0xFF,65,1,0);
        if (filesize($s)) {
            $st=fread($s,filesize($s));
        }
        send_cmd($a);
        
        /**
         * Install the widget in the control panel using this
         **/
/*        $arr=array();
        $arr['script']='/package/Victron.cgi?action=configure';
        $arr['title']='Victron';
        $arr['icon']='icon-hdd';
        $arr['desc']='EnergyMeterWidget settings';
        $_GLOBALS['vars'][]='meter_frequency';
        $_GLOBALS['vars'][]='meter_voltage';
        $_GLOBALS['vars'][]='meter_current1';
        $_GLOBALS['vars'][]='meter_current2';
        $_GLOBALS['vars'][]='meter_current3';
        
        $_GLOBALS['hooks']['cpanel'][]=$arr;
        */
        
        // generate ajax data for front end processing
//        if (file_exists('/package/EnergyMeterWidgetAjax.inc')) 
//            $_GLOBALS['hooks']['ajax'][]='/package/EnergyMeterWidgetAjax.inc';

        // runs this file once a second
        if (file_exists('/package/VictronSec.inc')) 
            $_GLOBALS['hooks']['sec'][]='/package/VictronSec.inc';
            
        // runs this file once a minute
//        if (file_exists('/package/EnergyMeterWidgetMin.inc')) 
//            $_GLOBALS['hooks']['min'][]='/package/EnergyMeterWidgetMin.inc';
            
        // runs this file once a day
//        if (file_exists('/package/EnergyMeterWidgetDay.inc')) 
//            $_GLOBALS['hooks']['sec'][]='/package/EnergyMeterWidgetDay.inc';            
        return 1;
    }
    
    function EnergyMeterWidget_configure() {
       
        return 1;
    }
    execute(); // process the package and run the correct function
    
?>

