<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : actionedit.cgi
 * 
 *  Description: Action Editor page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       08/12/13    v1.1 removed ini_get_array
 * Akash Heimlich       15/03/14    v1.2 lowered memory requirement
 *			04/10/14	added delay time and variable
 *					manipulation actions
 * Akash Heimlich       06/07/18    v2.0 WattmonOS3
 *						23/10/20	added SNMP trap message
 ********************************************************************/
include("/app/config.inc");
max_execution_time(30);
$angular_controller="ActionEditCtrl"; 
$title=lang('CONFIGURE_ACTION','actionedit');
include("/app/header.inc");
?>
      <div class="row-fluid">
        <div class='span12' >    
        <?
  
  //$actions=ini_get_array("/config/actions.ini","actions");
  
 // $roles=ini_get_array("/config/roles.ini","roles");
  if ($_GET['new']==1) {
    $_GET['action_idx']=ini_get("/config/actions.ini","actions","num_actions");
    for ($i=0;$i<$_GET['action_idx'];$i++) {
        if (ini_get("/config/actions.ini","actions","a".$i."status",0)==10) {
            $_GET['action_idx']=$i;
            break;
        }
    }
    $idx=$_GET['action_idx'];
    $actions['a'+$idx+'name']='New Action';
    $actions['a'+$idx+'start']='00:00';
    $actions['a'+$idx+'end']='23:59';
    $actions['a'+$idx+'status']=1;
    $actions['a'+$idx+'match']=0;
    $actionarr=array();
  } else {
      $actionarr=ini_get_array("/config/action".$_GET['action_idx'].".ini","actions");
  }
  $idx=$_GET['action_idx'];
  
  //print_r($arr);
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/actions.cgi"><? print(lang('ACTIONS','actionedit')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('CONFIGURE_ACTIONS','actionedit')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','actionedit')) ?> <? print(ini_get("/config/actions.ini","actions",'a'+$idx+'name',lang('NEW_ACTION','actionedit'))); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','actionedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/actions.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','actionedit')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','actionedit')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','actionedit')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','actionedit')) ?></div>

<form name="form" class="css-form form-horizontal" novalidate>

<!-- VARIABLES -->

<div ng-init="action_index=<? print($_GET['action_idx']); ?>;"></div>
<div ng-init="action_id=<? print($idx); ?>;"></div>
<div ng-init="action_name='<? print(ini_get("/config/actions.ini","actions",'a'+$idx+'name',"New Action")); ?>';"></div>
<div ng-init="action_match='<? print(ini_get("/config/actions.ini","actions",'a'+$idx+'match',0)); ?>';"></div>
<div ng-init="action_status=<? $stat=ini_get("/config/actions.ini","actions",'a'+$idx+'status',1); if ($stat==10) $stat=1;print($stat); ?>;"></div>
<div ng-init="action_numcond=<? print(ini_get("/config/actions.ini","actions",'a'+$idx+'numcond',0)); ?>;"></div>
<div ng-init="action_numact=<? print(ini_get("/config/actions.ini","actions",'a'+$idx+'numact',0)); ?>;"></div>
<div ng-init="action_start='<? print(ini_get("/config/actions.ini","actions",'a'+$idx+'start','00:00')); ?>';"></div>
<div ng-init="action_end='<? print(ini_get("/config/actions.ini","actions",'a'+$idx+'end','23:59')); ?>';"></div>
<div ng-init="action_delay=<? print(intval(ini_get("/config/actions.ini","actions",'a'+$idx+'delay',0))); ?>;"></div>
<? 
$numcond=ini_get("/config/actions.ini","actions",'a'+$idx+'numcond');
$numact=ini_get("/config/actions.ini","actions",'a'+$idx+'numact');
for ($i=0;$i<$numcond;$i++) {
  print('<div ng-init="conditions.push({var1type:\''+$actionarr['cond'+$i+'var1type']+'\',var2type:\''+$actionarr['cond'+$i+'var2type']+'\',var1val:\''+($actionarr['cond'+$i+'var1val'])+'\',type:\''+($actionarr['cond'+$i+'type'])+'\',var2val:\''+($actionarr['cond'+$i+'var2val'])+'\'})"></div>');
}  
for ($i=0;$i<$numact;$i++) {
  print('\r\n<div ng-init="actions.push({type:\''+$actionarr['act'+$i+'type']+'\',val1:\''+$actionarr['act'+$i+'val1']+'\',val2:\''+htmlspecialchars(strval($actionarr['act'+$i+'val2']))+'\'})"></div>');
}  
$num_sysvars=ini_get("/config/sysvars.ini","sysvars","num_sysvars",0);
//$sysvars=ini_get_array("/config/sysvars.ini","sysvars");
?>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ACTION_TITLE','actionedit')) ?></h5>
        <p class="card-text">    
        
            <div class="form-group">
                <label for="action_name"><? print(lang('ACTION_NAME','actionedit')) ?></label>
                <input type="text" class="form-control" ng-model="action_name"  class='span12' ng-maxlength=32 name='action_name' required aria-describedby="rnHelp" my-directive placeholder="<? print(lang('ACTION_NAME','actionedit')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('ACTION_NAME_HELP','actionedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.action_name.$invalid"><? print(lang('ACTION_NAME_INVALID','actionedit')) ?></small>
            </div>	        
            <div class="form-group">
                <label for="status"><small class='text-muted'><? print(lang('ACTION_MATCH','actionedit')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_match" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('ANY','actionedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_match" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('ALL','actionedit')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('ACTION_MATCH_HELP','actionedit')) ?></small>
            </div> 
            <div class="form-group">
                <label for="action_delay"><? print(lang('DELAY','actionedit')) ?></label>
                <input class="form-control" type='number' ng-model="action_delay"  class='span12' name='role_id' required integer aria-describedby="rHelp" placeholder="<? print(lang('DELAY','actionedit')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('DELAY_HELP','actionedit')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.action_delay.$invalid"><? print(lang('DELAY_INVALID','actionedit')) ?></small>
            </div>
			 <div class="form-group">
                <label for="action_status"><small class='text-muted'><? print(lang('ACTION_STATUS','actionedit')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_status" value="0">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED','actionedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_status" value="1">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ALWAYS_ENABLED','actionedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_status" value="2">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('ENABLED_DURING_TIME','actionedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_status" value="3">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('DISABLED_DURING_TIME','actionedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_status" value="4">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('AT_FIXED_TIME','actionedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_status" value="6">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('AT_FIXED_INTERVAL','actionedit')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="action_status" value="5">
                  <label class="form-check-label">
                    &nbsp;<? print(lang('MANUALLY','actionedit')) ?>
                  </label>
                </div>
                
                <small id="ddHelp" class="form-text text-muted"><? print(lang('ACTION_STATUS_HELP','actionedit')) ?></small>
                
            </div> 		
            
          <div class="form-group" ng-cloak ng-show="action_status==3 || action_status==2">
            <label for="action_start"><? print(lang('BETWEEN','actionedit')) ?></label>
            <div class="form-row" style='line-height:40px'>
                <div class="col-1">
                  <input type="text" class="form-control" ng-model="action_start" name='action_start' required placeholder="Start Time">
                </div> and <div class="col-1">
                  <input type="text" class="form-control" ng-model="action_end" name='action_end' required placeholder="End Time">
                </div> (HH:MM) 
              </div>
            <small id="dtHelp" class="form-text text-muted"><? print(lang('BETWEEN_HELP','actionedit')) ?></small>
             <small ng-cloak class='text-danger' ng-show="form.action_start.$invalid"><? print(lang('BETWEEN_INVALID','actionedit')) ?></small>
          </div>
          <div class="form-group" ng-cloak ng-show="action_status==4">
            <label for="user_name"><? print(lang('AT_TIME','actionedit')) ?></label>
            <input type="text" class="form-control" ng-model="action_start" name='action_start'> 
            <small id="dtHelp" class="form-text text-muted"><? print(lang('AT_TIME_HELP','actionedit')) ?></small>
             <small ng-cloak class='text-danger' ng-show="form.action_start.$invalid"><? print(lang('AT_TIME_INVALID','actionedit')) ?></small>
          </div> 
        </p>
    </div>
</div>
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('TRIGGER_TITLE','actionedit')) ?></h5>
        <p class="card-text">
            <div style='float:right'><a name='addcond'></a><button class="btn btn-large" ng-click="conditions.push({edit:1})"><i class="icon-plus"></i> <? print(lang('ADD','actionedit')) ?></button></div>
            
            <table class='table table-striped' summary="Conditions" >
                <tr>
                    <td scope="col">ID</td>
                    <td scope="col"><? print(lang('VALUE_TYPE','actionedit')) ?></td>
                    <td scope="col"><? print(lang('VALUE_1','actionedit')) ?></td>
                    <td scope="col"><? print(lang('COMPARISON','actionedit')) ?></td>
                    <td scope="col"><? print(lang('VALUE_2','actionedit')) ?></td>
                    <td scope="col"><? print(lang('VALUE_2_TYPE','actionedit')) ?></td>
                    <td scope="col"><? print(lang('OPTIONS','actionedit')) ?></td>
                </tr>
                <tr ng-repeat="item in conditions">
                    <td><a name='cond{{$index}}'></a><span class="badge badge-inverse">{{$index+1}}</span></td>
                    <td><strong>{{makeValue1Type(item)}}</strong><div ng-show='item.edit==1'>
                        <select class="form-control" ng-model="item.var1type">
                            <option value='1'>System Variable</option>
                            <option value='2'>Device Variable</option>
                            <option value='3'>Fixed Value</option>
                            <option value='4'>Global Variable</option>            
                            </select>
                        </div></td>            
                    <td><strong>{{makeValue1(item)}}</strong><div ng-show='item.edit==1 && item.var1type==1'>
                        <select class="form-control" ng-model="item.var1val">
                        <? //$num_sysvars=ini_get("/config/sysvars.ini","sysvars","num_sysvars",0);
                          for ($i=1;$i<$num_sysvars;$i++) {
                            $st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title');
                            print("<option value='".$i."'>".$st."</option>\r\n");
                        } ?>
                            </select>
                        </div><div ng-show='item.edit==1 && item.var1type==2'>
                        <select class="form-control" ng-model="item.var1val">
                        <? $nr=ini_get("/config/roles.ini","roles","num_roles",0);
                            for ($i=0;$i<$nr;$i++) { 
                            print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
                            }
                            ?>
                            </select>
                        </div><div ng-show='item.edit==1 && item.var1type==3'><div class="form-group"><label class='bmd-label-static'><? print(lang('FIXED','actionedit')) ?></label><input class="form-control" type='text' ng-model='item.var1val'></div></div>
                        <div ng-show='item.edit==1 && item.var1type==4'><div class="form-group"><label class='bmd-label-static'><? print(lang('GLOBAL','actionedit')) ?></label><input class="form-control" type='text' ng-model='item.var1val'></div></div></td>            
                    <td>{{makeComparison(item)}}<div ng-show='item.edit==1'>
                        <select class="form-control" ng-model="item.type">
                            <option value='1'>Is Less than</option>
                            <option value='2'>Is Greater than</option>
                            <option value='3'>Is Equal To</option>
                            <option value='4'>Is Less Or Equal</option>
                            <option value='5'>Is Greater Or Equal</option>
                            <option value='6'>Not Equal</option>
                            </select>
                        </div></td>
                   <td><strong>{{makeValue2Type(item)}}</strong><div ng-show='item.edit==1'>
                        <select class="form-control" ng-model="item.var2type">
                            <option value='1'>System Variable</option>
                            <option value='2'>Device Variable</option>
                            <option value='3'>Fixed Value</option>
                            <option value='4'>Global Variable</option>
                            </select>
                        </div></td>            
                    <td><strong>{{makeValue2(item)}}</strong><div ng-show='item.edit==1 && item.var2type==1'>
                        <select class="form-control" ng-model="item.var2val">
                            <? for ($i=1;$i<$num_sysvars;$i++) {
                            //$st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title',"");
                            $st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title');
                            print("<option value='".$i."'>".$st."</option>\r\n");
                        } ?>
                            
                            </select>
                        </div><div ng-show='item.edit==1 && item.var2type==2'>
                        <select class="form-control" ng-model="item.var2val">
                        <?  $nr=ini_get("/config/roles.ini","roles","num_roles",0);
                            for ($i=0;$i<$nr;$i++) { 
                            print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
                            }
                            ?>
                            </select>
                        </div><div ng-show='item.edit==1 && item.var2type==3'><div class="form-group"><label class='bmd-label-static'><? print(lang('FIXED','actionedit')) ?></label><input type='text' class="form-control" ng-model='item.var2val'></div></div>
                        <div ng-show='item.edit==1 && item.var2type==4'><div class="form-group"><label class='bmd-label-static'><? print(lang('GLOBAL','actionedit')) ?></label><input type='text' class="form-control" ng-model='item.var2val'></div></div></td>    
                    <td>
                        <div class="pull-right btn-group">
                        <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
                        Action
                        <span class="caret"></span>
                        </a>
                        <ul class="dropdown-menu">
                        <!-- dropdown menu links -->
                        <li ng-show='item.edit!=1'><a ng-click='item.edit=1' href='#cond{{$index}}'><i class="icon-pencil"></i> Edit</a></li>
                        <li ng-show='item.edit==1'><a ng-click='item.edit=0' href='#cond{{$index}}'><i class="icon-pencil"></i> Stop Edit</a></li>
                         <li><a ng-click='conditions.splice($index,1)' href='#addcond'><i class="icon-remove"></i> Delete</a></li>
                        </ul>
                        </div>
                    </td>
                </tr>
            </table> 
        </p>
    </div>
</div>
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('ACTIONS_TITLE','actionedit')) ?></h5>
        <p class="card-text">
            <div style='float:right'><a name='addact'></a><button class="btn btn-large" ng-click="actions.push({edit:1})"><i class="icon-plus"></i> <? print(lang('ADD','actionedit')) ?></button></div>
            <table class='table table-striped' summary="Actions">
                <tr>
                    <th scope="col"></th>
                    <th scope="col">ID</th>
                    <th scope="col"><? print(lang('ACTION','actionedit')) ?></th>
                    <th scope="col"><? print(lang('VARIABLE','actionedit')) ?></th>
                    <th scope="col"></th>
                    <th scope="col"><? print(lang('OPTIONS','actionedit')) ?></th>
                </tr>
                <tr ng-repeat="item in actions">
                    <td><a name='act{{$index}}'></a></td>
                    <td><span class="badge badge-inverse">{{$index+1}}</span></td>
                    <td><strong>{{makeActionType(item)}}</strong><div ng-show='item.edit==1'><label><small class='text-muted'><? print(lang('TYPE','actionedit')) ?></small></label>
                        <select class="form-control" ng-model="item.type">
                            <option value='1'>Switch On</option>
                            <option value='2'>Switch Off</option>
                            <option value='3'>Send Email</option>
                            <option value='5'>Set Global Variable</option>
                            <option value='8'>Add to Global Variable</option>
                            <option value='9'>Toggle Global Variable</option>
                            <option value='7'>Set Role Value</option>
                            <option value='6'>Exec Script</option>
                            <option value='10'>Set Global Variable from Role</option>
                            <option value='11'>Multiply Global Variable</option>
                            <option value='12'>Add Global to Global Variable</option>
                            <option value='14'>Delay (ms)</option>
                            <option value='15'>Set Global Variable from NVRAM variable</option>
                            <option value='16'>Set NVRAM Variable from Global variable</option>              
                            <option value='17'>Add Alert</option>
                            <option value='18'>Set Role From Global</option>              
                            <option value='19'>Send SNMP Trap Message</option>
                             
                            </select>
                        </div>
                    </td>            
                    <td><strong>{{makeActionVal1(item)}}</strong><div ng-show='item.edit==1 && (item.type==1 || item.type==2)'>
                        <label><small class='text-muted'><? print(lang('ROLE','actionedit')) ?></small></label>
                        <select class="form-control" ng-model="item.val1"><?
                        $nr=ini_get("/config/roles.ini","roles","num_roles",0);
                        for ($i=0;$i<$nr;$i++) {
                            
                            if (ini_get("/config/roles.ini","roles",'role'+$i+'type')==0) {                
                                print('<option value="'+$i+'">'+ini_get("/config/roles.ini","roles",'role'+$i));        
                                print('</option>'); 
                            }
                        }
                        ?>
                        </select></div>
                        <div ng-show='item.edit==1 && ((item.type==7) || (item.type==18))'><label><small class='text-muted'><? print(lang('ROLE','actionedit')) ?></small></label>
                        
                        <select class="form-control" ng-model="item.val1"><?
                        $nr=ini_get("/config/roles.ini","roles","num_roles",0);
                        for ($i=0;$i<$nr;$i++) {
                            $rt=ini_get("/config/roles.ini","roles",'role'+$i+'type');
                            if ($rt==0||$rt==3) {                
                                print('<option value="'+$i+'">'+ini_get("/config/roles.ini","roles",'role'+$i));        
                                print('</option>'); 
                            }
                        }
                        ?>
                        </select></div>
                        </div><div ng-show='item.edit==1 && item.type==3'>
                        <label><small class='text-muted'><? print(lang('EMAIL','actionedit')) ?></small></label>
                        <input type='text' class="form-control" ng-model="item.val1">
                        </div>
                        <div ng-show='item.edit==1 && item.type==4'><label><small class='text-muted'><? print(lang('URL','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==5'><label><small class='text-muted'><? print(lang('VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==8'><label><small class='text-muted'><? print(lang('VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==9'><label><small class='text-muted'><? print(lang('VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==6'><label><small class='text-muted'><? print(lang('SCRIPT_PATH','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==10'><label><small class='text-muted'><? print(lang('VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==11'><label><small class='text-muted'><? print(lang('VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==12'><label><small class='text-muted'><? print(lang('VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==14'><label><small class='text-muted'><? print(lang('DELAY_MS','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==15'><label><small class='text-muted'><? print(lang('GLOBAL_VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==16'><label><small class='text-muted'><? print(lang('GLOBAL_VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==17'><label><small class='text-muted'><? print(lang('ALERT_MESSAGE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                        <div ng-show='item.edit==1 && item.type==19'><label><small class='text-muted'><? print(lang('SNMP_TRAP_MESSAGE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val1'></div>
                    </td>   
                    <td><strong>{{makeActionVal2(item)}}</strong><div ng-show='item.edit==1 && item.type==3'>
                        <label><small class='text-muted'><? print(lang('SUBJECT','actionedit')) ?></small></label><input class='span12' type='text' ng-model="item.val2">
                        </div>
                        <div ng-show='item.edit==1 && item.type==4'><label><small class='text-muted'><? print(lang('TITLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && item.type==5'><label><small class='text-muted'><? print(lang('VALUE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && item.type==8'><label><small class='text-muted'><? print(lang('VALUE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && item.type==7'><label><small class='text-muted'><? print(lang('VALUE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && item.type==11'><label><small class='text-muted'><? print(lang('VALUE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && item.type==12'><label><small class='text-muted'><? print(lang('FROM_VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        
                        <div ng-show='item.edit==1 && item.type==15'><label><small class='text-muted'><? print(lang('NVRAM_VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && item.type==16'><label><small class='text-muted'><? print(lang('NVRAM_VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && item.type==18'><label><small class='text-muted'><? print(lang('FROM_VARIABLE','actionedit')) ?></small></label><input type='text' class='form-control' ng-model='item.val2'></div>
                        <div ng-show='item.edit==1 && (item.type==10)'><label><small class='text-muted'><? print(lang('ROLE','actionedit')) ?></small></label>
                        
                        <select class='form-control' ng-model="item.val2"><?
                        $nr=ini_get("/config/roles.ini","roles","num_roles",0);
                        for ($i=0;$i<$nr;$i++) {
                            //$rt=ini_get("/config/roles.ini","roles",'role'+$i+'type');
                            //if ($rt==0||$rt==3) {                
                                print('<option value="'+$i+'">'+ini_get("/config/roles.ini","roles",'role'+$i));        
                                print('</option>'); 
                            //}
                        }
                        ?>
                        </select></div>
                    </td>   
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <? print(lang('ACTION','actionedit')) ?> <span class="caret"></span>
                            </button>
                    
                            <div class="dropdown-menu dropdown-menu-right text-dark" >
                                <a class="dropdown-item" ng-show='item.edit!=1' ng-click='item.edit=1' href='#act{{$index}}'><i class="icon-pencil"></i>&nbsp;<? print(lang('EDIT','actionedit')) ?></a>
                                <a class="dropdown-item" ng-show='item.edit==1' ng-click='item.edit=0' href='#act{{$index}}'><i class="icon-pencil"></i>&nbsp;<? print(lang('STOP_EDIT','actionedit')) ?></a>
                                <a class="dropdown-item" ng-show='$index>0' ng-click='moveUp(actions,$index)' href='#act{{$index}}'><i class="icon-up"></i>&nbsp;<? print(lang('MOVE_UP','actionedit')) ?></a>
                                <a class="dropdown-item" ng-show='$index<actions.length-1' ng-click='moveDown(actions,$index)' href='#act{{$index}}'><i class="icon-down"></i>&nbsp;<? print(lang('MOVE_DOWN','actionedit')) ?></a>
                                <a class="dropdown-item" ng-click='deleteAction($index)' href='#addact'><i class="icon-remove"></i>&nbsp;<? print(lang('DELETE','devices')) ?></a>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
        </p>
	</div>
</div>  

</form>
<script>
    var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid) {
    return $http.get('/app/dev_ajax.cgi?action=get&index='+devid)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        alert('Failed: ' + reason);
        $timeout(poll, 100);  // try again
    });
    
  };
  
  return this;
});



function ActionEditCtrl(dataService,$scope, $timeout,$http) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
  $scope.conditions = [];
  $scope.actions = [];
  $scope.infomsg="";
  function swapElement(array, indexA, indexB) {
     var tmp = array[indexA];
    array[indexA] = array[indexB];
    array[indexB] = tmp;
  }
  $scope.moveUp=function(arr,idx) {
     if (idx>0)
        swapElement(arr,idx-1,idx);
  }
  $scope.moveDown=function(arr,idx) {
     if (idx<arr.length-1)
        swapElement(arr,idx,idx+1);
  }  
  $scope.deleteAction = function ( idx ) {
      var person_to_delete = $scope.actions[idx];

    //API.DeleteAction({ id: person_to_delete.id }, function (success) {
        $scope.actions.splice(idx, 1);
    //});
};

  //$scope.data=dataService.async($scope.device_index)
  $scope.restoreDefaults=function() {
  
//      $scope.device_id=$scope.saved_device_id;
      $scope.infomsg="Default values loaded.  Settings will not be saved until you click <i>Update Settings</i>."
      
  }
  $scope.calibrateDevice=function () {
    document.location="/app/devcalib.cgi?device_idx="+$scope.device_index;
  }
  
  $scope.makeComparison=function(item) {
    if (item.edit) return '';
    str='';
    switch (Number(item.type)) {
        case 1: str="Is Less than";break;
        case 2: str="Is Greater than";break;
        case 3: str="Is Equal To";break;
        case 4: str="Is Less Or Equal";break;
        case 5: str="Is Greater Or Equal";break;    }
    return str;
  }
  $scope.makeValue1Type=function(item) {
    if (item.edit) return '';
    str='';
    switch (Number(item.var1type)) {
        case 0: str="Undefined";break;
        case 1: str="System Variable";break;
        case 2: str="Device Variable";break;
        case 3: str="Fixed Value";break;
        case 4: str="Global Variable";break;
    }
    return str;
  }
  $scope.makeActionType=function(item) {
    if (item.edit) return '';
    str='';
    switch (Number(item.type)) {
        case 0: str="Undefined";break;
        case 1: str="Switch On";break;
        case 2: str="Switch Off";break;
        case 3: str="Send Email";break;
        case 4: str="Send HTTP Request";break;
        case 5: str="Set Global Var";break;
        case 6: str="Exec Script";break;
        case 7: str="Set Role";break;
        case 8: str="Add to Global Var";break;
        case 9: str="Toggle Variable";break;
        case 10: str="Set Variable from Role";break;
        case 11: str="Multiply Variable";break;
        case 12: str="Add Global To Global";break;
        case 14: str="Delay (ms)";break;
        case 15: str="Set Global Var from NVRAM";break;
        case 16: str="Set NVRAM Var from Global";break;
        case 17: str="Add Alert";break;
        case 18: str="Set Role From Global";break;
        case 19: str="Send SNMP Trap Message";break;        
    }
    return str;
  }
  $scope.makeActionVal1=function(item) {
    if (item.edit) return '';
    str='';
    if (Number(item.type)<=2 || Number(item.type)==7 || Number(item.type)==18)  { // switch, or set role
        switch (Number(item.val1)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
        }
      } else str=item.val1;
      if (Number(item.type)==6)  str+=" seconds";
      
      return str;
    
    return item.var1value;
  }
  $scope.makeActionVal2=function(item) {
    if (item.edit) return '';
    str='';
    if (Number(item.type)<=2)  { // switch
        return '';
     } else if (Number(item.type)<6) str=item.val2;
      if (Number(item.type)==8) str=item.val2;
      if (Number(item.type)==7) str=item.val2;
      if (Number(item.type)==11) str="* "+item.val2;
      if (Number(item.type)==12) str=item.val2;
      if (Number(item.type)==15) str=item.val2;
      if (Number(item.type)==16) str=item.val2;
      if (Number(item.type)==18) str=item.val2;
      if (Number(item.type)==10)  { // switch, or set role
        switch (Number(item.val2)) {
        <? //for ($i=0;$i<$roles['num_roles'];$i++) { 
            $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
            //print("<option value='"+$i+"'>"+ini_get("/config/roles.ini","roles",'role'+$i)+"</option>");
            print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            
            //}
            ?>
        }
      } 
      
      return str;
    
    return item.var1value;
  }
  $scope.makeValue1=function(item) {
    if (item.edit) return '';
    str='';
    if (Number(item.var1type)==1)  { // preset role
      switch (Number(item.var1val)) {
      <? for ($i=0;$i<$num_sysvars;$i++) {
            $st=ini_get("/config/sysvars.ini","sysvars",'sysvar'.$i.'title',"");            
            //$st=$sysvars['sysvar'.$i.'title'];
            print("case ".$i.":str='".$st."';break;\r\n");
        } ?>
        
      }
    }
    if (Number(item.var1type)==2)  { // role role
        switch (Number(item.var1val)) {
        <? $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
                print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            ?>
        }
      }
       if (Number(item.var1type)==3)  { // fixed value
        str=item.var1val;
      }
      if (Number(item.var1type)==4)  { // global value
        str=item.var1val;
      }
      return str;
    
    return item.var1value;
  }
  
  $scope.makeValue2Type=function(item) {
    if (item.edit) return '';
    str='';
    switch (Number(item.var2type)) {
        case 0: str="Undefined";break;
        case 1: str="System Variable";break;
        case 2: str="Device Variable";break;
        case 3: str="Fixed Value";break;
        case 4: str="Global Variable";break;
    }
    return str;
  }
  
  $scope.makeValue2=function(item) {
    if (item.edit) return '';
    str='';
    if (Number(item.var1type)==2)  { // preset role
      switch (Number(item.var2val)) {
        <?  $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
                print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            ?>

      }
    }
    if (Number(item.var2type)==2)  { // role role
        switch (Number(item.var2val)) {
        <?   $nr=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($i=0;$i<$nr;$i++) { 
                print("case "+$i+":str='"+ini_get("/config/roles.ini","roles",'role'+$i)+"';break;");
            }
            ?>
        }
      }
      if (Number(item.var2type)==3)  { // fixed value
        str=item.var2val;
      }
      if (Number(item.var2type)==4)  { // fixed value
        str=item.var2val;
      }
      return str;
  }
   $scope.saveSettings=function () {
     if ($scope.form.$invalid) {
        $scope.errormsg="<? print(lang('FORM_INVALID','actionedit')) ?>";
        return;
     }
      if ($scope.action_status>1) {
         if ($scope.action_start>$scope.action_end) {
            $scope.errormsg="Start action time should be less than end time!";
            return;
         }
      }
      if (!$scope.actions.length) {
            $scope.errormsg="No action defined.  Please add an action to perform.";
            return;
      
      }
      for (i=0;i<$scope.actions.length;i++) {
        if (($scope.actions[i].val1=='') || (!$scope.actions[i].type)) {
            $scope.errormsg="Action is incorrectly configured.";
            return;
        }
        if (((($scope.actions[i].type==1) || ($scope.actions[i].type==2)) && ((typeof($scope.actions[i].val1)=='undefined') || ($scope.actions[i].val1)<=1)) || (typeof($scope.actions[i].val1)=='undefined')) {
            $scope.errormsg="Action not fully defined, please configure parameters properly.";
            return;
        }
      }
      $scope.loading=1;
      $scope.successmsg="";
      $scope.errormsg="";  $scope.infomsg="";
      astr="name="+encodeURIComponent($scope.action_name);
      astr+="&type="+encodeURIComponent($scope.action_type);
      astr+="&roleid="+encodeURIComponent($scope.action_roleid);
      astr+="&start="+($scope.action_start);
      astr+="&delay="+($scope.action_delay);
      astr+="&end="+($scope.action_end);
      astr+="&status="+encodeURIComponent($scope.action_status);
      astr+="&match="+encodeURIComponent($scope.action_match);
      astr+="&numact="+$scope.actions.length;
      astr+="&numcond="+$scope.conditions.length;
      for (i=0;i<$scope.conditions.length;i++) {
        astr+="&cond"+i+"type="+$scope.conditions[i].type;     
        astr+="&cond"+i+"var1type="+$scope.conditions[i].var1type;     
        astr+="&cond"+i+"var1val="+encodeURIComponent($scope.conditions[i].var1val);     
        astr+="&cond"+i+"var2type="+$scope.conditions[i].var2type;   
        astr+="&cond"+i+"var2val="+encodeURIComponent($scope.conditions[i].var2val);     
      }
      for (i=0;i<$scope.actions.length;i++) {
        astr+="&act"+i+"type="+$scope.actions[i].type;     
        astr+="&act"+i+"val1="+encodeURIComponent($scope.actions[i].val1);     
        astr+="&act"+i+"val2="+encodeURIComponent($scope.actions[i].val2);     
        
      }
      //alert(astr);
      $http.post('/app/action_ajax.cgi?action=save&action_id='+$scope.action_id,astr)
        .then(function (response) {
            $scope.loading=0;
        //alert(response.data);
          var data = response.data;
          //alert(data);
          if (data.status)
            $scope.successmsg="Settings saved.";
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            $scope.loading=0;
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}

</script>
<? include("/app/footer.inc"); ?>

