<?    
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : dev_ajax.cgi
 * 
 *  Description: Ajax used for communication of device settings
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      29/11/13    v1.1 - lower memory footprint using
 *                                  optimized ini_get
 ********************************************************************/
error_reporting(0);
    print("{");
    /**
     * list all devices in the system in json encoded format
     * @param action list
     * @param verbose 1=output verbose details, 0=output minimal details
     */
function is_ok($str) {
    $res=1;
    
    for ($x=0;$x<strlen($str);$x++) {
        $o=charat($str,$x);
        //$o=ord($c);
        if ((($o >= 65) && ($o < 91)) || (($o >= 97) && ($o <= 122)) || (($o >= 40) && ($o <=57 )) || ($o==32) || ($o==45) || ($o==46)) {
            $ok=1;
        } else {
            $res=0;
        }
    }
    if (strlen($str)<3) $res=0;
    if (!$str) $res=0;
    return $res;
}
    if ($_GET['action']=='list') {
            
            print('"loggedin": '+$_SESSION['logged_in']+',\n');
            
            /**
            * get the number of devices
            */
            $num_dev=mb_num_devices();
            print('"count":'+$num_dev+",\n");
            if (function_exists("mb_poll_time")) {
                print('"poll_time":'+mb_poll_time()+",\n");
            } else {
                print("\"poll_time\":0,\n");
            }
            $stat=getmbstat();
            print('"error":'+$stat['ERROR']+",\n");
            print('"e_ovr":'+$stat['ERROR_OVERRUN']+",\n");
            print('"e_par":'+$stat['ERROR_PARITY']+",\n");
            print('"e_frm":'+$stat['ERROR_FRAME']+",\n");
            print('"rx":'+$stat['RXPKT']+",\n");
            print('"tx":'+$stat['TXPKT']+",\n");
            print('"en":'+$stat['ENABLED']+",\n");
            print('"device_limit":'+(intval($stat['DEVICE_LIMIT'])>0?intval($stat['DEVICE_LIMIT']):25)+",\n");
            if ($_SERVER['HW_PLATFORM']==11 || $_SERVER['HW_PLATFORM']>=20) {
                print('"rx2":'+$stat['RXPKT2']+",\n");
                print('"tx2":'+$stat['TXPKT2']+",\n");
                print('"en2":'+$stat['ENABLED2']+",\n");
                print('"poll_time2":'+mb_poll_time(1)+",\n");
            }
            /**
            * get the device scan status - the mb_scan_complete function returns the status of the modbus scanning 
            * 0=not scanning, 1=scanning
            */
            
            print('"scanning":'+(mb_scan_percent()==100?0:1)+",\n");
            /**
            * if a scan is ongoing, put the scan completion percantage using mb_scan_percent()
            */
            print('"scanpercent":'+mb_scan_percent()+",\n");
            if (function_exists('mb_poll_time')) {
                print('"poll_time":'+mb_poll_time()+",\n");
            }
            
            /**
            * load all roles into the $roles array
            */
            //$roles=ini_get_array("/config/roles.ini","roles");
            
            print('"devices": [');
            
            /**
            * iterate through all devices and output json encoded device information
            */            
            for ($i=0;$i<$num_dev;$i++) {
                print('{');
                $dev=0;
                /**
                * Load device variables into array $dev
                * The mb_get_dev_by_index() function takes an integer index parameter and returns an array
                */                
                $dev=mb_get_dev_by_index($i);
                //print("<pre>");print_r($dev);
                /**
                * load device config file into array $info
                */
                $info=0;
                $dev_ini="/dev/dev"+$dev['device_type_id']+".ini";
                //$info=ini_get_array("/dev/dev"+$dev['device_type_id']+".ini","config");
                
                /**
                * verbose output will send out all variables
                */
                if ($_GET['verbose']==1) {
                    print('"description": "'+ini_get($dev_ini,"config","name")+'",\n');
                    $keys = array_keys($dev);
                    for ($j=0;$j<sizeof($keys);$j++) {
                        print('"'+$keys[$j]+'" : "'+$dev[$j]+'",\n');
                    }
                } else {
                    /**
                    * id of modbus or wireless device
                    */
                    print('"id": "'+$dev['slave_id']+'",\n');
                    /**
                    * type id of modbus or wireless device
                    */
                    print('"type_id": "'+$dev['device_type_id']+'",\n');
                    /**
                    * device name
                    */
                    print('"name": "'+$dev['name']+'",\n');
                    /**
                    * description of device
                    */
                    print('"description": "'+ini_get($dev_ini,"config","name")+'",\n');
                    /**
                    * last response time (milliseconds since successful communication occured)
                    */
                    print('"last_response": "'+(time()-intval($dev['last_response']))+'",\n');
                    /**
                    * status of device (1=active, 0= disables)
                    */
                    print('"status": "'+$dev['status']+'",\n');
                    print('"exceptions": "'+$dev['exceptions']+'",\n');
                    print('"poll_time": "'+$dev['poll_time']+'",\n');
                    /**
                    * extra parameter to indicate which bus the device is on (0=wired bus, 1=wireless bus)
                    */
                    print('"params": "'+$dev['params']+'",\n');                    
                    /**
                    * RSSI (Receiver Signal Strength Indicator) is used for wireless devices
                    * Output value is in DBM
                    */
                    print('"rssi": "'+$dev['rssi']+'",\n');                    
                    
                    /**
                    * user parameters
                    */
                    if ($dev['serial']) {
                        if (is_ok($dev['serial'])) 
                            print('"serial": "'+$dev['serial']+'",\n');
                    }
                    if (is_ok($dev['model']))
                        print('"model": "'+$dev['model']+'",\n');
					
					if ($_SERVER['HW_PLATFORM']<8) {                    
                    
		                $nroles=intval(ini_get($dev_ini,"config","num_roles",0));
		                print('"num_roles": '+$nroles+',\n');
		                print('"roles":[');
		                if ($_GET['roles']==1) {
    		                /**
    		                * iterate through the different roles this device handles
    		                */            
    		                $rc1=0;
    		                for ($c=0;$c<$nroles;$c++) {
    		                    if ($dev["role"+$c]) {
    		                        if ($rc1) print(", ");
    		                        $rc1++;
        		                    print('{"var":"'+ini_get($dev_ini,"config",'role_var_'+$c)+'", "idx": '+ini_get($dev_ini,"config",'role_idx_'+$c)+',"type":'+ini_get($dev_ini,"config",'role_type_'+$c)+', "assign": "'+ini_get($dev_ini,"config",'role_assign_'+$c)+'"');
        		                    
        		                    print(',"role_id":'+$dev["role"+$c]);
        		                    /**
        		                    * output description for digital output role (role type 0)
        		                    */
        		                    $cidx=ini_get($dev_ini,"config",'role_idx_'+$c);
        		                    $ctype=ini_get($dev_ini,"config",'role_type_'+$c);
        		                    //print(',"cidx":'+$cidx+" "+$ctype);                        
        		                    if ($ctype==0) {
        		                        print(',"desc":"'+ini_get($dev_ini,"config","do_desc_"+$cidx)+'",');    
        		                    } else {
        		                        /**
        		                        * output description for digital input role (role type 1)
        		                        */
        		                        if ($ctype==1) {
        		                            print(',"desc":"'+ini_get($dev_ini,"config","di_desc_"+$cidx)+'",');    
        		                        } else {
        		                            /**
        		                            * output description for read only register role (role type 2)
        		                            */
        		                            if (($ctype==2) || ($ctype==22)  || ($ctype==31)  || (($ctype>=24) && ($ctype<=28))) {
        		                                print(',"desc":"'+ini_get($dev_ini,"config","ro_desc_"+$cidx)+'",');    
        		                            } else {
        		                                /**
        		                                * output description for read/write role (role type 3)
        		                                */
        		                                if (($ctype==3) || ($ctype==23) || ($ctype==29) || ($ctype==30) || ($ctype==34) || ($ctype==35)) {
        		                                    print(',"desc":"'+ini_get($dev_ini,"config","rw_desc_"+$cidx)+'",');    
        		                                } else print(",");
        		                            }
        		                        }
        		                    }
        		                    
        		                    print('"role": "'+ini_get("/config/roles.ini","roles",'role'+intval($dev["role"+$c]))+'"}\n');
        		                    //if ($c<($nroles-1)) print(", ");
    		                    }
    		                }
		                }
					} else {
					    if ($_GET['roles']==1) {
					    $dev_array=0;
					    $role_arr=0;
						$dev_array=ini_get_array($dev_ini,"config");
						//print_r($dev_arr);
						$role_arr=ini_get_array("/config/roles.ini","roles");
						
						$nroles=intval($dev_array["num_roles"]);
		                print('"num_roles": '+$nroles+',\n');
		                print('"roles":[');
					    } else {
		                print('"num_roles": 0,\n');
		                print('"roles":[');
					        
					    }
		                if ($_GET['roles']==1) {
		                 
    		                /**
    		                * iterate through the different roles this device handles
    		                */            
    		    
    		                for ($c=0;$c<$nroles;$c++) {
    		                    print('{"var":"'+$dev_array['role_var_'+$c]+'", "idx": '+$dev_array['role_idx_'+$c]+',"type":'+$dev_array['role_type_'+$c]+', "assign": "'+$dev_array['role_assign_'+$c]+'"');
    		                    
    		                    print(',"role_id":'+$dev["role"+$c]);
    		                    /**
    		                    * output description for digital output role (role type 0)
    		                    */
    		                    $cidx=$dev_array['role_idx_'+$c];
    		                    $ctype=$dev_array['role_type_'+$c];
    		                    //print(',"cidx":'+$cidx+" "+$ctype);                        
    		                    if ($ctype==0) {
    		                        print(',"desc":"'+$dev_array["do_desc_"+$cidx]+'",');    
    		                    } else {
    		                        /**
    		                        * output description for digital input role (role type 1)
    		                        */
    		                        if ($ctype==1) {
    		                            print(',"desc":"'+$dev_array["di_desc_"+$cidx]+'",');    
    		                        } else {
    		                            /**
    		                            * output description for read only register role (role type 2)
    		                            */
    		                            if (($ctype==2) || ($ctype==31) || ($ctype==22)  || (($ctype>=24) && ($ctype<=28))) {
    		                                print(',"desc":"'+$dev_array["ro_desc_"+$cidx]+'",');    
    		                            } else {
    		                                /**
    		                                * output description for read/write role (role type 3)
    		                                */
    		                                if (($ctype==3) || ($ctype==23) || ($ctype==29) || ($ctype==30) || ($ctype==34) || ($ctype==35)) {
    		                                    print(',"desc":"'+$dev_array["rw_desc_"+$cidx]+'",');    
    		                                } else print(",");
    		                            }
    		                        }
    		                    }
    		                    
    		                    print('"role": "'+$role_arr['role'+intval($dev["role"+$c])]+'"}\n');
    		                    if ($c<($nroles-1)) print(", ");
    
    		                }
		                 }
					}
                    print("]");
                }
                print('}');
                if ($i<($num_dev-1)) print(",");
            }
            print(']');
        } else {
            /**
             * scan start command
             * @param max - maximum ID to scan until
             * @param bus - bus ID to scan (0=wired, 1= wireless)
             */            
            if ($_GET['action']=='scan') {
                $max=intval($_GET['max']);
                if ($max==0) $max=252;
                mb_start_scan(0,$max,$_GET['bus']);
                while ((mb_scan_percent()<1) || (mb_scan_percent()==100)) sleep(1);
                print('"scanning":1');
            }
            
            /**
             * update device status command
             * @param id - device ID
             * @param status - active=1, inactive=0
             */            
            if ($_GET['action']=='update') {
                if ($_GET['name']) {
                    $id = $_GET['name'];
                } else 
                    $id=intval($_GET['id']);
                
                $errors=0;
                if ($id) {                    
                    mb_set_dev_var($id,"status",$_GET['status']);
                    if (!$errors) {
                        print('"status":1');
                    }
                } else {
                    print('"status":0');
                }
            }
            
            /**
            * delete device command
            @param device_idx - index of device to delete (NOT device ID)
            */
            if ($_GET['action']=='delete') {
                $id=intval($_GET['id']);
                $arr = mb_get_dev_by_index($_GET['device_idx']);
                $errors=0;
                if (($arr['slave_id']>=0)) {                    
                    mb_delete_dev($arr['slave_id']);
                    print('"status":1');                
                } else {
                    print('"status":0');
                }
            }
            
            /**
            * save settings command.  Parameters are posted via ajax
            * @param device_idx - index of device (NOT device id)
            * @param slave_id - POST - device id
            * @param poll_interval - POST - poll interval in milliseconds
            * @param status - POST - device status
            * @param device_name - POST - device name
            */
            if ($_GET['action']=='save') {
                $id=intval($_GET['id']);
                $error="";
                $arr = mb_get_dev_by_index($_GET['device_idx']);
                
                if (intval($arr['slave_id']) != intval($_POST['slave_id'])) { 
                    $dev2=mb_get_dev_by_id($_POST['slave_id'],$arr['params']);
                    if ($dev2) {
                        $error = $error+"Unable to set Device ID, the ID is already in use! ";
                    } else {
                        log("Changing device address from "+$arr['slave_id']+" to "+$_POST['slave_id']);
                        $arr['slave_id']=$_POST['slave_id'];
                        if (!mb_set_dev_var($arr['name'],"slave_id",$_POST['slave_id'])) {
                            $error = $error+"Unable to set device address  from ".$arr['slave_id'] +" to "+$_POST['slave_id'];
                        } 
                    }
                }
                if ($_POST['poll_interval'] != $arr['poll_interval']) {
                    if (!mb_set_dev_var($arr['name'],"poll_interval",$_POST['poll_interval'])) 
                        $error = $error+"Unable to set poll interval. ";
                }
                
                //$info=ini_get_array("/dev/dev"+$arr['device_type_id']+".ini","config");
                $num_roles=ini_get("/dev/dev"+$arr['device_type_id']+".ini","config",'num_roles',0);
                for ($r=0;$r<$num_roles;$r++) {
                    if (intval($_POST['role'+$r]) != intval($arr['role'+$r])) {
                        if ($_POST['role'+$r]==-1) {
                            $need_refresh=1;
                            $rv=ini_get("/dev/dev"+$arr['device_type_id']+".ini","config",'role_var_'.$r,'');
                            $rt=ini_get("/dev/dev"+$arr['device_type_id']+".ini","config",'role_type_'.$r,0);
                            $_POST['role'+$r]=add_role(-1,$_POST['device_name']."_".$rv,0,$rt,1,0,$arr['device_type_id']);
                            //$id,$role_name,$role_group,$role_type,$role_show,$role_def,$role_devices) {
                        }
                        if ($_POST['role'+$r]==-2) { // logged
                            max_execution_time(30);
                            $need_refresh=1;
                            $rv=ini_get("/dev/dev"+$arr['device_type_id']+".ini","config",'role_var_'.$r,'');
                            $rt=ini_get("/dev/dev"+$arr['device_type_id']+".ini","config",'role_type_'.$r,0);
                            $_POST['role'+$r]=add_role(-1,$_POST['device_name']."_".$rv,0,$rt,1,0,$arr['device_type_id']);
                            
                            $gnum=0;
                            
                            $num_items=ini_get("/config/datalog.ini","data",'group'.$gnum.'numvar',0);
                            /*  for ($item=0;$item<$num_items;$item++) {
                                     $vartype=ini_get("/config/datalog.ini","data",'group'.$gnum.'var'.$item.'vartype',0);;
                                     //print($vartype);
                                     if ($vartype==2) {
                                         if ($id==ini_get("/config/datalog.ini","data",'group'.$gnum.'var'.$item.'varval',0)) {
                                             $found=1;
                                         };
                                     }
                              } */
                              //print($id." ".$found);
                              //if (!$found) {    // need to add the role
                                  ini_set("/config/datalog.ini","data",'group'.$gnum.'numvar',$num_items+1);
                                  ini_set("/config/datalog.ini","data",'group'.$gnum.'var'.$num_items.'vartype',2);
                                  ini_set("/config/datalog.ini","data",'group'.$gnum.'var'.$num_items.'varval',$_POST['role'+$r]);
                                  ini_set("/config/datalog.ini","data",'group'.$gnum.'var'.$num_items.'varscale',1);
                                  ini_set("/config/datalog.ini","data",'group'.$gnum.'var'.$num_items.'varfn',0);
                                  $found=1;
                              //}

                    
                            //$id,$role_name,$role_group,$role_type,$role_show,$role_def,$role_devices) {
                        }
                        if (!mb_set_dev_var($arr['name'],"role".$r,$_POST['role'+$r])) 
                            $error = $error+"Unable to set device ".$arr['name']." role role".$r." to ".$_POST['role'+$r].". ";
                    }    
                }
                if ($_POST['status'] != $arr['status']) {
                    if (!mb_set_dev_var($arr['name'],"status",$_POST['status'])) 
                        $error = $error+"Unable to set status. ";
                }
                if ($_POST['params'] != $arr['params']) {
                    
                    $dev2=mb_get_dev_by_id($_POST['slave_id'],intval($_POST['params']));
                    if ($dev2) {
                        $error = $error+"Unable to change the channel as a different device with the same id is already present on it.";
                    } else {
                        if (!mb_set_dev_var($arr['name'],"params",$_POST['params'])) 
                            $error = $error+"Unable to set bus. ";
                    }
                }
                if ($_POST['device_name'] != $arr['name']) {
                    if (strlen($_POST['device_name'])>2) {
                        if (!mb_set_dev_var(intval($arr['slave_id']),"name",$_POST['device_name'])) 
                            $error = $error+"Unable to set device name. ";
                    } else {
                        $error = $error+"Device name too short. ";
                    }
                }
                
                if ($error!="") {
                    
                    print('"status":0, "error":"'+$error+'"');
                } else {
                    ini_set("/config/setup.ini","setup","setup3status",1);
                    $_GLOBALS['needreboot']=1;
                    $_GLOBALS['sysmsg']='A reboot may be required for changes to take effect.';
                    print('"status":1');
                    if ($need_refresh) print(",\"needrefresh\":1");
                }
            }
            /**
             * add device command
             * 
             * Used for manual device addition
             * 
             * @param slave_id - POST - id of device
             * @param device_type_id - POST - device type id
             * @param slave_id - POST - device id
             * @param poll_interval - POST - poll interval in milliseconds
             * @param status - POST - device status
             * @param device_name - POST - device name
             */            
            if ($_GET['action']=='add') {
                $id=intval($_GET['id']);
                $error="";
                $slaveid=intval($_POST['slave_id']);
                $devtypeid=intval($_POST['device_type_id']);
                $devname=$_POST['device_name'];
                $pollinterval=intval($_POST['poll_interval']);
                $status=intval($_POST['status']);
                $params=intval($_POST['params']);

                if (strlen($_POST['device_name'])>2) {
                } else {
                        $error = $error+"Device name too short. ";
                }
                if (!$error) {
                    $res=mb_add_dev($slaveid,$devtypeid,$devname,$pollinterval,$status,$params);
                    if ($res!=0) $error="Error adding device.";
                }
                if ($error!="") {
                    print('"status":0, "error":"'+$error+'"'); 
                } else {
                    print('"status":1');
                }
            }
        }
        
      function add_role($id,$role_name,$role_group,$role_type,$role_show,$role_def,$role_devices) {
        if ($id==-1)  {
            $num_r=ini_get("/config/roles.ini","roles","num_roles",0);
            for ($j=0;$j<$num_r;$j++) { 
                if ($role_name==ini_get("/config/roles.ini","roles","role"+$j,'')) {
                    break;
                }
            }
            $id=$j;
            if ($role_type==31) $role_type=2;
            if ($role_type==22) $role_type=2;
            if ($role_type==23) $role_type=3;
            if ($role_type==24) $role_type=2;
            if ($role_type==25) $role_type=2;
            if ($role_type==26) $role_type=2;
            if ($role_type==27) $role_type=2;
            if ($role_type==28) $role_type=2;
            if ($role_type==29) $role_type=3;
            
            if ($role_type==30) $role_type=3;
            if ($role_type==32) $role_type=3;
            if ($role_type==33) $role_type=3;
            if ($role_type==34) $role_type=3;
            if ($role_type==35) $role_type=3;
            //print("found role at ".$id."\r\n");
            if ($id==$num_r)  {
                ini_set("/config/roles.ini","roles","num_roles",$id+1);
                $f=fopen("/config/roles.ini",'a+');
                $st="role"+$id+"=".$role_name."\r\n".
                    "role"+$id+"group=".$role_group."\r\n".
                    "role"+$id+"type=".$role_type."\r\n".
                    "role"+$id+"ids=".$role_devices."\r\n".
                    "role"+$id+"def=".$role_def."\r\n".
                    "role"+$id+"show=".$role_show."\r\n";
                fwrite($f,$st);
                fclose($f);
                
            /*    ini_set("/config/roles.ini","roles","role"+$id,$role_name);
                ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
                ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
                ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
                ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
                ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);*/
            }
            return $id;
        } else {
            if (ini_get("/config/roles.ini","roles","role"+$id)!=$role_name)
                        ini_set("/config/roles.ini","roles","role"+$id,$role_name);
            if (ini_get("/config/roles.ini","roles","role"+$id+"group")!=$role_group)                    
                        ini_set("/config/roles.ini","roles","role"+$id+"group",$role_group);
            if (ini_get("/config/roles.ini","roles","role"+$id+"type")!=$role_type)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"type",$role_type);
            if (ini_get("/config/roles.ini","roles","role"+$id+"ids")!=$role_devices)                                            
                        ini_set("/config/roles.ini","roles","role"+$id+"ids",$role_devices);
            if (ini_get("/config/roles.ini","roles","role"+$id+"def")!=$role_def)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"def",$role_def);
            if (ini_get("/config/roles.ini","roles","role"+$id+"show",0)!=$role_show)                                        
                        ini_set("/config/roles.ini","roles","role"+$id+"show",$role_show);
        }
    }
    ?>
}       











