<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : devicecalib.cgi
 * 
 *  Description: Calibration page for devices
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       23/05/18    v2.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="DeviceCalibCtrl"; 
$title='Device Calibration';
include("/app/header.inc");

$arr = mb_get_dev_by_index($_GET['device_idx']);
if (file_exists("/scripts/calib/dev".$arr['device_type_id'].".inc")) {
    include("/scripts/calib/dev".$arr['device_type_id'].".inc");
    die();
}
$info_ini="/dev/dev"+$arr['device_type_id']+".ini";
$info_section="config";
$role_ini="/config/roles.ini";
$role_section="roles";

$dev_ini="/dev/dev"+$arr['device_type_id']+".ini";
$role_ini="/config/roles.ini";
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/devices.cgi"><? print(lang('MODBUS_DEVICES','devicecalib')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('DEVICE_CALIBRATE','devicecalib')) ?></li>
  </ol>
</nav>
<div ng-init="device_index=<? print($_GET['device_idx']); ?>;"></div>
<!-- NAVBAR -->
<h4 ><i class="icon-cog"></i>&nbsp;<? print(lang('CONFIGURE_TITLE','deviceedit')) ?>&nbsp;<small> <? print(ini_get($info_ini,$info_section,'description')." (".$arr['device_type_id'].")"); ?></small></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/devices.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/deviceedit.cgi?device_idx=<? print($_GET['device_idx']); ?>'"><i class="icon-wrench"></i> <? print(lang('EDIT','devicecalib')) ?></a>
  </li>
 
  <li ng-hide='settings_locked' class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','devicecalib')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','devicecalib')) ?>
    <? print(lang('HELP2','devicecalib')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','devicecalib')) ?></div>

<form id="form" name="form" class="css-form">

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('RW_TITLE','devicecalib')) ?></h5>
        <p class="card-text">   
        
            <div class="form-group" ng-repeat="field in rwfields">
                
                <ng-form name="urlForm">
                    <label for="formVal">{{field.name}}</label>    
                    <input type='number' ng-model="field.value" name="formVal" class="form-control" min="{{field.min}}" max="{{field.max}}"  name="{{field.fieldname}}"  integer required placeholder="Value">
                    <small ng-cloak class='text-danger' ng-show="urlForm.formVal.$invalid"><? print(lang('RW_INVALID','devicecalib')) ?></small>
                </ng-form>
            </div>	        
        </p>
	</div>
</div>  
<br/>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('RO_TITLE','devicecalib')) ?></h5>
        <p class="card-text">   
        <div ng-repeat="field in rofields" class='table-striped'>
                <div class="row">
                    <div class='col-md-6 text-right'>
                        {{field.name}}
                    </div>
                    <div>
                        <strong>{{field.value}}</strong>
                    </div>
                    <div ng-show='myFilter(field)'><a class='btn' href='/app/calibdevinput.cgi?dev=<? print($_GET['device_idx']); ?>&channel_idx={{makeIdx($index)}}'>Calibrate Channel</a></div>
                </div>
            </div>
        </p>
    </div>
</div>

</form>

    <script>
var gItems,gHttp;
var count=0;
var app = angular.module('myApp', []);

app.factory('dataService', function($http, $q,$timeout) {
  
  this.async = function(devid,all) {
    config = new Object();
    config.timeout=30000;
    config.method="GET";
    config.url='/app/devcalib_ajax.cgi?action=get'+(all?"all":"ro")+'&device_idx='+devid;
    //$http(timeout:8000});
//    return $http.get()
    
    return $http(config)
    .then(function (response) {
        //alert(response.data);
      var data = response.data;
      return data;
    }, function(reason) {
        //alert('Failed: ' + reason);
          // try again
    });
    
  };
  
  return this;
});



function DeviceCalibCtrl(dataService,$scope, $timeout,$http) {
    
//app.controller('ItemListCtrl', function( dataService,$scope,$timeout) {
    
  var self = this;
    $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

  $scope.infomsg="";
  $scope.myFilter = function(user) {
   x= /^Raw(.)*$/.test(user.name);
   //alert(x);
   if (x) return 1;
   return 0;
  };
  $scope.getClass=function() {
    if ($scope.form.$invalid) return "disabled";
    return "";
  }
  // get data once a second to update ro vars
  function poll() {
    $scope.asyncData=dataService.async($scope.curDevIndex,(!$scope.rwfields || $scope.rwfields.length==0));
    
  }
  $timeout(poll, 2000);  // start after two seconds
  
  /*$scope.rwfields=[
            {fieldname:"rwvar1",name:"Current Offset",value:2048,original:2048,min:0,max:4096},
            {fieldname:"rwvar2",name:"Current Multiplier",value:1,original:1,min:0,max:10000},
            {fieldname:"rwvar3",name:"Current Divisor",value:1,min:1,original:1,max:10000}
            ];
            */
  
  $scope.$watch('asyncData', function(asyncData) {
    if(angular.isDefined(asyncData)) {
        if (asyncData.rwvars) {
            //alert('got rwvars');
            $scope.rwfields = asyncData.rwvars;
        }
        if (asyncData.rovars) {
            $scope.rofields = asyncData.rovars;
        }
        $timeout(poll, 1500);
    }
  });
  $scope.restoreDefaults=function() {
  
//      $scope.device_id=$scope.saved_device_id;
      $scope.infomsg="Default values loaded.  Settings will not be saved until you click <i>Update Settings</i>."
      
  }
  $scope.calibrateDevice=function () {
    document.location="/app/devcalib.cgi?device_idx="+$scope.device_index;
  }
  $scope.makeIdx=function(index) {
    return Math.floor(index/2);
  }
   $scope.saveSettings=function () {
      $scope.successmsg="";
      $scope.errormsg="";
      $scope.infomsg="";
      output="save=1";
      $scope.loading=1;
      for (i=0;i<$scope.rwfields.length;i++) {
          //if ($scope.rwfields[i].original != $scope.rwfields[i].value) {
              output=output+"&"+$scope.rwfields[i].fieldname+"="+$scope.rwfields[i].value;
          //}
      }
      //alert(output);
//      $scope.form.$setPristine();
      $http.post('/app/devcalib_ajax.cgi?action=save&device_idx='+$scope.device_index,output)
        .then(function (response) {
        //alert(response.data);
          var data = response.data;
          //alert(data);
          $scope.loading=0;
          if (data.status)
            $scope.successmsg="Settings saved.";
          else {
            $scope.errormsg=data.error;
          }
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.loading=0;
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
   
  
  $scope.$watch('device_index', function(devindex) {
    
        $scope.asyncData=dataService.async(devindex,1)  
        $scope.curDevIndex=devindex;
        
  });
  //poll();

}
//);
//app.ItemListCtrl.$inject=['$defer'];

</script>
<? include("/app/footer.inc"); ?>

