<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : graphview.cgi
 * 
 *  Description: Graph view page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Akash Heimlich       15/11/13    v1.1
 * Akash Heimlich       03/12/13    v1.2 - removed ini-get_array 
 *			19/01/15	allow modified csv files, 
					ignore missing elements
 ********************************************************************/
$guest_ok=1;
include("/app/config.inc");
$angular_controller="GraphDayCtrl"; 
$title=lang('GRAPH_VIEW','graphview');
include("/app/header.inc");

$msg='';
$group_id=intval($_GET['group_id']);
$data_ini="/config/groups.ini";
$title=ini_get($data_ini,"groups",'group'.$group_id)." kWH Totals";

// index in daily_kwh, skip the first two timestamp fields
$idx_in=$group_id*2+1;
$idx_out=$group_id*2+2;

print('<link href="'.$url_prefix.'/lib/fontawesome/css/font-awesome.css" rel="stylesheet">');
?>
 <script src="<? print($url_prefix); ?>/lib/angularcookies.js"></script>
<link rel="stylesheet" type="text/css" media="all" href="<? print($url_prefix); ?>/css/jsDatePick_ltr.min.css" />
<!-- 
    OR if you want to use the calendar in a right-to-left website
	just use the other CSS file instead and don't forget to switch g_jsDatePickDirectionality variable to "rtl"!
	
	<link rel="stylesheet" type="text/css" media="all" href="jsDatePick_ltr.css" />
-->

<!-- 
	After you copied those 2 lines of code , make sure you take also the files into the same folder :-)
    Next step will be to set the appropriate statement to "start-up" the calendar on the needed HTML element.
    
    The first example of Javascript snippet is for the most basic use , as a popup calendar
    for a text field input.
-->
<script type="text/javascript">
	
</script>
<style type="text/css">
      #containergraph {
        /*width : 600px;*/
        height: 384px;
        margin: 8px auto;
      }
    </style>
<ul class="breadcrumb">
  <li><a href="/"><? print(lang('HOME','graphview')) ?></a> <span class="divider">/</span></li>
  <li><a href="/app/graphlist.cgi"><? print(lang('GRAPHS','graphview')) ?></a> <span class="divider">/</span></li>
  <li class="active"><? print($title); ?></li>
</ul>
<div >
<div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-calender"></i> <? print($title); ?> </h2>
						<div class="box-icon">
							<a href="#" class="btn btn-minimize btn-round"><i class="icon-chevron-up"></i></a>
							<a href="#" class="btn btn-close btn-round"><i class="icon-remove"></i></a>
						</div>
					</div>
					<div class="box-content">
					
    <div class='span8'>    
         <span style="margin-left: 25px">
         <button class='btn btn-small' ng-click='prevDay();'>Zoom Out</button>
         
            {{curdate}}
            <button class='btn btn-small' ng-click='nextDay();'>Zoom In</button>&nbsp;
            <button class='btn btn-small' ng-click='showAll();'>Show All</button>
        </span>
        
    </div><div class='span4 pull-right' ng-cloak ng-show='loading==1' ><img src="/img/ajax-loader-1.gif" title="img/ajax-loader-1.gif" > {{msg}} <progress min="0" max="100" value="0">0% complete</progress></div>       
    
    
	                    <div class="clearfix"></div>
					</div>
				</div>
			</div>    
    <div class="row-fluid">
				<div class="box span12">
					<div class="box-header well">
						<h2><i class="icon-th-list"></i> <? print(lang('DATA_FOR','graphview')); ?> {{curdate}}</h2>
					</div>
					<div class="box-content">

    
<div ><div><? 
$points=array();
$p1=array();
$p2=array();
$p1['func']=7;
$p2['func']=7;
$p1['color']='#74DF00';
$p2['color']='#B45F04';
$p1['title']='kWH in';
$p2['title']='kWH out';
$p1['idx']=$idx_in;
$p2['idx']=$idx_out;
$points[]=$p1;
$points[]=$p2;
$numpoints=2;
for ($i=0;$i<$numpoints;$i++) {
            if ($points[$i]['func']>1) {
                print("<span ng-cloak class='label ' style='background:".$points[$i]['color']."'>".$points[$i]['title'].": {{points[".$i."].result | number:2}}");
                if ($points[$i]['func']==3) print(" ".lang('PER_HOUR','graphview'));
                if ($points[$i]['func']==5) print(" ".lang('PER_HOUR','graphview'));
                if ($points[$i]['func']==6) print(" ".lang('AVERAGE','graphview'));
                if ($points[$i]['func']==7) print(" ".lang('KWH','graphview'));
                if ($points[$i]['func']==9) print(" ".lang('HOURS_ZERO','graphview'));
                if ($points[$i]['func']==10) print(" ".lang('HOURS_NONZERO','graphview'));
                print("</span>&nbsp;");
            }
            if ($points[$i]['func']==1) {
                print("<span ng-cloak class='label'  style='background:".$points[$i]['color']."'>".$points[$i]['title'].": {{points[".$i."].last | number:2}}");                
                print("</span>&nbsp;");
                
            }
        }
        
        ?>
        </div>
            
    <div id="containergraph" class="span11"></div>
    <!--[if IE]>
    <script type="text/javascript" src="/static/lib/FlashCanvas/bin/flashcanvas.js"></script>
    <![endif]-->
        
        </div>    
          <div class="clearfix"></div>
					</div>
				</div>
			</div>    
			
        </div>

</div><!--/span-->

      
     <script>
var app = angular.module('myApp', ['ngCookies']);     
function GraphDayCtrl($scope,$http,$timeout,$cookies) {
   var self = this;
   
    <? 
if ($_GET['yr_from'])  {
    print("yr_from='"+$_GET['yr_from']+"';"); 
    $yr_from=intval($_GET['yr_from']);
}    
else {
    print("yr_from='"+strftime("%Y",time())+"';\r\n");
    $yr_from=intval(strftime("%Y",time()));
}
if ($_GET['m_from']) {
    print("m_from='"+$_GET['m_from']+"';\r\n"); 
    $m_from=intval($_GET['m_from']);
} else  {
    print("m_from='"+strftime("%m",time())+"';\r\n");
    $m_from=intval(strftime("%m",time()));
}
if ($_GET['d_from']) {
    print("d_from='"+$_GET['d_from']+"';\r\n"); 
    $d_from=intval($_GET['d_from']);
} else {
    print("d_from='1';\r\n");
    $d_from=1;
}

if ($_GET['yr_to']) {
    print("yr_to='"+$_GET['yr_to']+"';"); 
    $yr_to=intval($_GET['yr_to']);
} else  {
    print("yr_to='"+strftime("%Y",time())+"';\r\n");
    $yr_to=intval(strftime("%Y",time()));
}
if ($_GET['m_to']) {
    print("m_to='"+$_GET['m_to']+"';\r\n"); 
    $m_from=intval($_GET['m_to']);
} else {
    print("m_to='"+strftime("%m",time())+"';\r\n");
    $m_to=intval(strftime("%m",time()));
}
if ($_GET['d_to']) {
    print("d_to='"+$_GET['d_to']+"';\r\n"); 
    $d_to=intval($_GET['d_to']);
} else {
    print("d_to='31';\r\n");    
    $d_to=31;
}

?>       
  
    
        
    l   = 0; // The letter 'L' - NOT a one    
    <? 
    
    print('time_from = Math.round((Date.UTC(yr_from,m_from-1,d_from))/1000);\r\n');
    print('time_to = Math.round((Date.UTC(yr_to,m_to-1,d_to))/1000);\r\n');
    print('min_date = Math.round((Date.UTC(yr_from,m_from-1,d_from))/1000);\r\n');
    print("max=(time_to-time_from)/86400; \r\n");
    ?>
  //  alert(time_from);
//    alert(time_to);
    //alert(max);
    maxval1=0;
    minval1=0;
    minval2=0;
    maxval2=0;
    numaxis=1;
    
    axis1="kWH";
    axis2=<? print($axis2); ?>;

    points=[<? for ($i=0;$i<$numpoints;$i++) {
        print("{idx:".$points[$i]["idx"].",color:'".$points[$i]['color']."',error:".$points[$i]['error'].",opt:".$points[$i]['opt'].",func:".$points[$i]['func'].",data:[],axis:".$points[$i]['axis'].",title:'".$points[$i]['title']."',result:0}"); 
        if ($i<($numpoints-1)) print(",");
    }
        ?>];
    $scope.points=points;
    container=document.getElementById("containergraph");
    var
        ticks = [
            [-40, "Lower"], 20, 0, 20, [40, "Upper"]
        ],
        // Ticks for the Y-Axis
        graph;

    function ticksFn(n) {
        return (n/60) + ':00';
    }

    function myFormat(a) {
        return a.y+" ";
    }
    
    

    function updateGraph() {
//        if ($scope.view==0)
  //          $scope.curdate=d+"/"+m+"/"+yr;
        //else 
            $scope.curdate=d_from+"/"+m_from+"/"+yr_from+" - "+d_to+"/"+m_to+"/"+yr_to;

//alert("max1="+maxval1+" min1="+minval1+" max2="+maxval2+" min2="+minval2);
            if ((minval1<0) || (minval2<0)) {
                
                if (maxval2>-minval2) {
                    minval2=-maxval2;                    
                } else maxval2=-minval2;
                if (maxval1>-minval1) {
                    minval1=-maxval1;
                } else maxval1=-minval1;
            }
        //alert("max1="+maxval1+" min1="+minval1+" max2="+maxval2+" min2="+minval2);
        ticks2 = [
                minval2, Math.round((maxval2-minval2)*0.25+minval2),Math.round((maxval2-minval2)*0.5+minval2),Math.round((maxval2-minval2)*0.75+minval2), [Math.round(maxval2),Math.round(maxval2)]
            ];
        ticks = [
            minval1, Math.round((maxval1-minval1)*0.25+minval1),Math.round((maxval1-minval1)*0.5+minval1),Math.round((maxval1-minval1)*0.75+minval1), [Math.round(maxval1),Math.round(maxval1)]
        ];
        pointarr=[];
        colorarr=[];
        for (i=0; i < points.length; i++) {
            if ((points[i].axis==axis1) || (points[i].axis==axis2)) {
                pointarr[pointarr.length]={data:points[i].data,label:points[i].title,lines:{show:false,fill:((points[i].opt==1)||(points[i].opt==3))?true:false},yaxis:(points[i].axis==axis1?1:2)};
                colorarr[colorarr.length]=points[i].color;
            }
        }
        
        ts_from=Date.UTC(yr_from,m_from-1,d_from);
        time_from = Math.round((Date.UTC(yr_from,m_from-1,d_from))/1000);
        time_to = Math.round((Date.UTC(yr_to,m_to-1,d_to))/1000);
        max=(time_to-time_from)/86400; 
        tickObject={margin:false,
            //tickFormatter: ticksFn,
            // Displays tick values between brackets.
            min: 0,
            // Part of the series is not displayed.
            max: max // Part of the series is not displayed.
        };
        if (max<=31) {
            tickObject.noTicks=31;
            tickArray=[];
            for (i=0;i<31;i++) {
                tickArray[i]=[i,i+1];
            }
        } else {
            
            tickObject.noTicks=1;
            monthNames=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
            tickArray=[];
            dt=new Date(ts_from);
            tickArray[0]=[0,monthNames[dt.getMonth()]];
            
            lastm=dt.getMonth();
            //Date(ts_from+i*86400).getMonth()
            for (i=0;i<max;i++) {
                dt=new Date(ts_from+i*86400000);
                //alert(lastm+" "+dt.getMonth());        
                if (dt.getMonth()!=lastm) {
                    //alert(lastm+" "+dt.getMonth());        
                    lastm=dt.getMonth();
                    tickArray[tickObject.noTicks]=[i,monthNames[dt.getMonth()]];
                    tickObject.noTicks++;    
                }
                
            }
            
            
        }
        tickObject.ticks=tickArray;  
            
          
        //graph = Flotr.draw(container, pointarr, 
        options={
        colors: colorarr,
       
        xaxis: tickObject,
        yaxis: {
            <? if ($numaxis>1) print("ticks: ticks,"); ?>
            // Set Y-Axis ticks
            autoscale:<? if ($numaxis>1) print("false"); else print("true"); ?>,
            <? if ($numaxis>1) print("min:minval1,"); ?>
            <? if ($numaxis>1) print("max: maxval1,"); ?>
            labelsAngle:90
        },
        y2axis:{
            <? if ($numaxis>1) print("ticks: ticks2,"); ?>
            autoscale:<? if ($numaxis>1) print("false"); else print("true"); ?>,
            <? if ($numaxis>1) print("min:minval2,"); ?>
            <? if ($numaxis>1) print("max: maxval2,"); ?>
            labelsAngle:90
            
             // Maximum value along Y-Axis
        },
       /*grid: {
            verticalLines: true,
            backgroundColor: {
                colors: [
                    [0, '#fff'],
                    [1, '#fff']
                ],
                start: 'top',
                end: 'bottom'
            }
        },*/
        
        legend: {
            show:false,
            position: 'none'
        },
        mouse: {
            track:true,
        //    trackAll: true,
            trackFormatter:myFormat,
            relative:true
        },
        series:{lines:{show:false},bars:{show:true}},
        lines: {
            show: false,
            lineWidth: 0,
        },
        bars: {
            show: true,
            order:1,
            //barWidth: 1000000,
            barWidth: 0.5,
            stacked:true,
            lineWidth: 0,
/*            fillColor: {
                colors: ['#74DF00', '#74DF00'],
                start: 'top',
                end: 'bottom'
            },*/
            fillOpacity: 1
        },
        selection: {
            mode: 'x',
            fps: 30
        }
    };
/******** 
*  drawGraph
********/
     function drawGraph(opts) {

            // Clone the options, so the 'options' variable always keeps intact.
            var o = Flotr._.extend(Flotr._.clone(options), opts || {});
    
            // Return a new graph.
            return Flotr.draw(
                container, pointarr, o);
        }
        
    graph=drawGraph();
        
    // Hook into the 'flotr:select' event.
    Flotr.EventAdapter.observe(container, 'flotr:select', function(area) {
        ts_from=Date.UTC(yr_from,m_from-1,d_from)+area.x1*86400000;

        max=(area.x2-area.x1); 
        tickObject={margin:false,
            //tickFormatter: ticksFn,
            // Displays tick values between brackets.
            min: 0,
            // Part of the series is not displayed.
            max: max // Part of the series is not displayed.
        };
        noTicks=0;
        //if (max<=31) {
            noTicks=max;
            tickArray=[];
            dt=new Date(ts_from);
            lastm=dt.getMonth();
            monthNames=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
            for (i=0;i<max;i++) {
                dt=new Date(ts_from+i*86400000);
                d_start=dt.getDate();
                
                if (dt.getMonth()!=lastm) {
                    //alert(lastm+" "+dt.getMonth());        
                    lastm=dt.getMonth();
                    tickArray[i]=[i+area.x1,monthNames[dt.getMonth()]];
                } else 
                {
                    tickArray[i]=[i+area.x1,d_start];
                }
            }
        /*} else {
            
            noTicks=1;
            monthNames=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
            tickArray=[];
            dt=new Date(ts_from);
            tickArray[0]=[0,monthNames[dt.getMonth()]];
            
            lastm=dt.getMonth();
            //Date(ts_from+i*86400).getMonth()
            for (i=0;i<max;i++) {
                dt=new Date(ts_from+i*86400000);
                //alert(lastm+" "+dt.getMonth());        
                if (dt.getMonth()!=lastm) {
                    //alert(lastm+" "+dt.getMonth());        
                    lastm=dt.getMonth();
                    tickArray[tickObject.noTicks]=[i+area.x1,monthNames[dt.getMonth()]];
                    noTicks++;    
                }
                
            }
            
            
        }*/
        //alert(noTicks);
        // Draw graph with new area
        graph = drawGraph({
            xaxis: {
                min: area.x1,
                max: area.x2,
                noTicks:noTicks,
                ticks:tickArray
                
//                ticks:[[area.x1/60,area.x1/60],[(area.x1+(area.x2-area.x1)/4)/60,(area.x1+(area.x2-area.x1)/4)/60],[(area.x1+2*(area.x2-area.x1)/4)/60,(area.x1+2*(area.x2-area.x1)/4)/60],
                    //[(area.x1+3*(area.x2-area.x1)/4)/60,(area.x1+3*(area.x2-area.x1)/4)/60]]   
            },
            yaxis: {
                min: area.y1,
                max: area.y2
            }
            ,series:{bars:{show:true}}
        });
    });

    // When graph is clicked, draw the graph with default area.
    Flotr.EventAdapter.observe(container, 'flotr:click', function() {
        drawGraph();
    });
    
    }
    //setTimeout(update,1000);

$scope.getData = function() {
    //alert('get');
    fn="/logs/daily_kwh.csv";
     time_from = Math.round((Date.UTC(yr_from,m_from-1,d_from))/1000);
        time_to = Math.round((Date.UTC(yr_to,m_to-1,d_to))/1000);
        max=(time_to-time_from)/86400; 
      
     for (var j=0;j<points.length;j++) {
                points[j].data.length=0;
                points[j].result=0;
                points[j].time=0;
            }
            for (var i=0;i<max;i++) {                
                for (var j=0;j<points.length;j++) {
                    points[j].data.push([i,0]);
                }
            }
            
            
      var x = new XMLHttpRequest();
      $scope.loading=1;
      //$scope.msg='Downloading CSV file';
      var progressBar = document.querySelector('progress');
      
       
      x.open('GET', fn, true);
      //x.responseType = "blob";
      x.onprogress = function(e) {
                if (e.lengthComputable) {
                    progressBar.value = Math.round((e.loaded / e.total) * 100);
                    progressBar.textContent = Math.round(progressBar.value*100)/100; // Fallback for unsupported browsers.
                }
                };
            //});      
            
    //$http.get(fn)
    //    .then(function (response) {
    
      x.onload=function() {
        $scope.$apply(function() {
        //alert('load '+m_from+" "+m_to);
            $scope.msg='';
            var sdata = x.response;//.data;      
            $scope.loading=0;
          //  var sdata = response.data;      
            var data = sdata.split('\n');
            maxval=0;
            minval=100;
            
        // IMPORTANT: Must convert the data (which is a string) to numbers
           
            div=86400;
            maxlen=0;
            for (var i=0; i < data.length; ++i) {
                        
                var lst = data[i].split(',');  
                if (lst.length>maxlen) maxlen=lst.length;
                for (var j=0; j<lst.length; ++j) {        
                        lst[j] = Math.abs(Number(lst[j]));
                }
                // for newly added csv, just pad with 0
                if (lst.length<maxlen) {
                    for (var j=lst.length; j<maxlen; ++j) {        
                        lst[j] = 0;
                    }
                }
                if ((Math.round(lst[0])>0) && (Math.round(lst[0])<min_date)) {
                    min_date=Math.round(lst[0]);//*1000;
                    //alert(min_date+" "+i);
                }
                idx = Math.round((Math.round(lst[0])-time_from)/div);
                //alert(idx);
                if ((idx>=0) && (idx<max) && (lst.length>=points.length))
                {
            //        alert('add point '+idx+" idx="+points[0].idx+" val= "+lst[1+points[0].idx]);
                    for (j=0;j<points.length;j++) {
                        // get rid of noise
                        if (Math.abs(lst[1+points[j].idx]) < Number(points[j].error)) {
                           // alert('made '+points[j].error+', val was '+lst[1+points[j].idx]);
                            lst[1+points[j].idx]=0; 
                            
                        } 
                        if (1+points[j].idx>=lst.length) {
                            lst[1+points[j].idx]=0;
                        
                        }
                            points[j].result+=lst[1+points[j].idx];
                            points[j].last=lst[1+points[j].idx];                        
                        
                        if (points[j].opt<2) {
                            if (points[j].func==4) {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,points[j].result];
                            } else if (points[j].func==5) {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,points[j].result/60];
                            } else if (points[j].func==8) {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,points[j].result/(60*1000)]; //*1000
                            } else {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,lst[1+points[j].idx]];
                                if (points[j].func==9) {
                                    if (Math.abs(lst[1+points[j].idx])<1) points[j].time++;
                                }
                                if (points[j].func==10) {
                                    if (Math.abs(Number(lst[1+points[j].idx]))>=1) points[j].time++;
                                }
                                
                            }
                        }
                        else {
                            if ((points[j].func==4) ) {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,-points[j].result];
                            } else if (points[j].func==5) {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,-points[j].result/60];
                            } else if (points[j].func==8) {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,-points[j].result/60000];
                                                            
                            } else {
                                points[j].data[Math.round((Math.round(lst[0])-time_from)/div)]=[idx,-lst[1+points[j].idx]];
                                 if (points[j].func==9) {
                                    if (Math.abs(lst[1+points[j].idx])<1) points[j].time++;
                                }
                                if (points[j].func==10) {
                                    if (Math.abs(Number(lst[1+points[j].idx]))>=1) points[j].time++;
                                }
                            }
                        }
                        if (points[j].axis==axis1) {
                            if (points[j].data[Math.round((Math.round(lst[0])-time_from)/div)][1] > maxval1)  {
                               maxval1 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]+1;
                            }
                            
                            if (points[j].data[Math.round((Math.round(lst[0])-time_from)/div)][1]<minval1)  {
                                minval1 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]-2;
                            }
                        }
                        if ((points[j].axis==axis2) && (numaxis>1)) {
                            if (points[j].data[Math.round((Math.round(lst[0])-time_from)/div)][1] > maxval2)  {
                               maxval2 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]+1;
                            }
                            
                            if (points[j].data[Math.round((Math.round(lst[0])-time_from)/div)][1]<minval2)  {
                                minval2 = points[j].data[Math.round((Math.round(lst[0])-time)/div)][1]-2;
                            }
                        }
                    }
                }
            }
            for (i=0;i<points.length;i++) {
                if ($scope.view==0) {
                    if (points[i].func==3) points[i].result/=60;
                    if (points[i].func==5) points[i].result/=60;
                    if (points[i].func==7) points[i].result/=60000;
                    //if (points[i].func==8) points[i].result/=60000;
                
                    if (max>0) if (points[i].func==6) points[i].result/=max;
                    if (points[i].func==9) points[i].result=points[i].time/60;
                    if (points[i].func==10) points[i].result=points[i].time/60;
                } else {
                  //  if (points[i].func==7) points[i].result/=1000;
                //    if (points[i].func==8) points[i].result/=1000;
                
                    if (points[i].func==9) points[i].result=points[i].time;
                    if (points[i].func==10) points[i].result=points[i].time;
                
                }
                
            }
              // alert(maxval);
            $scope.points=points;
            if ($scope.all) {
                $scope.all=0;
                $scope.showAll();
            } else 
              updateGraph();
            return data;
        });
      };
        /*, 
            function(reason) {
                    updateGraph();
                    $scope.successmsg="";
            
           
                });
            
        
        
    }    */
    x.send();
 }
    $scope.nextDay=function() {
            ts_from2=Date.UTC(yr_from,m_from,d_from)/1000;
            if (ts_from2>time_to) {
                alert("Cannot zoom further in");
                return;
            }
            var date=new Date(yr_from, m_from, d_from, 0, 0, 1, 0);
            //time = date.getTime();
            time = Math.round((Date.UTC(yr_from,m_from,1))/1000);
            //alert(time);
            yr_from=Number(date.getYear())+1900;
            m_from=date.getMonth()+1;
            if (m_from<10) m_from='0'+m_from;
            d_from=date.getDate();
            if (d_from<10) d='0'+d_from;
            $scope.curdate=d_from+"/"+m_from+"/"+yr_from+" - "+d_to+"/"+m_to+"/"+yr_to;
        
        maxtime=time+max*3600;
        //$scope.getData();
    }
    

    $scope.showAll=function() {
            //alert(min_date);
            var date=new Date(min_date*1000);
            //alert(time);
            yr_from=date.getYear()+1900;
            m_from=date.getMonth()+1;
            if (m_from<10) m_from='0'+m_from;
            d_from=1;//date.getDate();
            if (d_from<10) d_from='0'+d_from;
            $scope.curdate=d_from+"/"+m_from+"/"+yr_from+" - "+d_to+"/"+m_to+"/"+yr_to;
        
        maxtime=time+max*3600;
        //$scope.getData();
    
    }
    
    $scope.prevDay=function() {
        
            var date=new Date(yr_from, m_from-2, d_from, 0, 0, 1, 0);
            time = Math.round((Date.UTC(yr_from,m_from-2,d_from))/1000);
            //alert(time);
            yr_from=date.getYear()+1900;
            m_from=date.getMonth()+1;
            if (m_from<10) m_from='0'+m_from;
            d_from=date.getDate();
            if (d_from<10) d_from='0'+d_from;
            $scope.curdate=d_from+"/"+m_from+"/"+yr_from+" - "+d_to+"/"+m_to+"/"+yr_to;
        
        maxtime=time+max*3600;
        //$scope.getData();
    
    }

    $scope.reload=function() {
        $scope.getData();
    }
    $scope.clearDate=function() {
        $cookies.dateSet=0;
   

    }
    
    //alert('here');
    //$timeout($scope.getData(),1000);
    
 $scope.$watch('curdate', function(curdate) {
    if(angular.isDefined(curdate)) {
        //dat=new Date(curdate);
  //      alert(curdate);
        $scope.getData();
    }
  });
  
//  $scope.getData();
  $scope.curdate=d_from+"/"+m_from+"/"+yr_from+" - "+d_to+"/"+m_to+"/"+yr_to;
  $scope.all=<? print(intval($_GET['all'])); ?>;
  $scope.loading=0;
  $gscope=$scope;
  


 
}
</script>
<? include("/app/footer.inc"); ?>
<script type="text/javascript" src="<? print($url_prefix); ?>/lib/jsDatePick.jquery.min.1.3.js"></script>





