<?  
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : http.cgi
 * 
 *  Description: Web server settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 * Ruchir Sharma        17/10/17    v1.1
 * Akash Heimlich       09/07/18    v2.0    WattmonOS 3
 ********************************************************************/
include("/app/config.inc");
$angular_controller="HTTPEditCtrl"; 
$title=lang('PAGE_TITLE','http');
include("/app/header.inc");
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('PAGE_TITLE','http')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h4><i class="icon-cog"></i>&nbsp;<? print(lang('PAGE_TITLE','http')) ?></h4>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    <? print(lang('HELP','roleedit')) ?>
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/settings.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','http')) ?></a>
  </li>
  <li ng-hide='settings_locked' class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='loading==1' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','http')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','http')) ?>
    <? print(lang('HELP2','http')) ?>
    <? print(lang('HELP3','http')) ?>
    <? print(lang('HELP4','http')) ?>
    <? print(lang('HELP5','http')) ?>
    <? print(lang('HELP6','http')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<div class="alert alert-secondary" ng-cloak ng-show="loading"><i id='iconRepeatMain' class='icon-spinner icon-spin' style='font-size:36px; color:red'></i>&nbsp;<? print(lang('PLEASE_WAIT','http')) ?></div>
<form name="form" class="css-form form-horizontal" novalidate>
<!-- VARIABLES -->
<? 
  $arr=ini_get_array("/config/uphp.ini","http");
  $accesslog=$arr["accesslog"];
  $accessfile=$arr["accessfile"];
  $server_port=$arr["server_port"];  
  $secureputvar=$arr["secureputvar"];
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="accesslog=<? print($accesslog); ?>;"></div><div ng-init="secureputvar='<? print($secureputvar); ?>';"></div><div ng-init="accessfile='<? print($accessfile); ?>';"></div>
<div ng-init="server_port=<? print($server_port); ?>;"></div>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('PAGE_TITLE','http')) ?></h5>
        <p class="card-text">    
            <div class="form-group">
                <label for="accesslog"><small class='text-muted'><? print(lang('ACCESS_LOG','http')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="accesslog" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('DO_NOT_GENERATE','http')) ?>
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="accesslog" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('GENERATE','http')) ?>
                  </label>
                </div>  
                <small id="ddHelp" class="form-text text-muted"><? print(lang('ACCESS_LOG_HELP','http')) ?></small>
            </div>       

	        <div class="form-group">
                <label for="accessfile"><? print(lang('ACCESS_FILE','http')) ?></label>
                <input type="text" class="form-control" ng-model="accessfile"  class='span12' ng-maxlength=30 name='accessfile' aria-describedby="rnHelp" my-directive placeholder="<? print(lang('ACCESS_FILE','http')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('ACCESS_FILE_HELP','http')) ?></small>
                <button class="btn btn-outline" ng-click="viewLog();"><i class="icon-file-alt"></i> View</button>
            </div>	        

            <div class="form-group">
                <label for="role_id"><? print(lang('SERVER_PORT','http')) ?></label>
                <input class="form-control" type='number' ng-model="server_port"  class='span12' name='server_port' integer required min=10 max=60000 aria-describedby="rHelp" placeholder="<? print(lang('SERVER_PORT','http')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('SERVER_PORT_HELP','http')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.server_port.$invalid"><? print(lang('SERVER_PORT_INVALID','http')) ?></small>
            </div>      

	        <div class="form-group">
                <label for="secureputvar"><? print(lang('SECURE_PUT','http')) ?></label>
                <input type="text" class="form-control" ng-model="secureputvar"  class='span12' ng-maxlength=30 name='secureputvar' requierd aria-describedby="rnHelp" my-directive placeholder="<? print(lang('SECURE_PUT','http')) ?>">
                <small id="rnHelp" class="form-text text-muted"><? print(lang('SECURE_PUT_HELP','http')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.secureputvar.$invalid"><? print(lang('SECURE_PUT_INVALID','roleedit')) ?></small>
            </div>	        
		</p>
	</div>
</div>  		       		        
 </form>

<script>
var app = angular.module('myApp', []);

function HTTPEditCtrl($scope, $http) {
 var self = this;
 $scope.infomsg = "";
     $scope.settings_locked=settings_locked;
    if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";

 $scope.viewLog = function() {
  window.open($scope.accessfile, '_blank');
 }

 $scope.saveSettings = function() {
    if ($scope.form.$invalid) {
        $scope.errormsg="<? print(lang('FORM_INVALID','actionedit')) ?>";
        return;
     }
    $scope.loading=1;
    $scope.successmsg = "";
    $scope.errormsg = "";
    $scope.infomsg = "";
  //alert();
  //
    $http.post('/app/configsave.cgi?config=uphp.ini&section=http', "accesslog=" + $scope.accesslog + "&accessfile=" + $scope.accessfile + "&server_port=" + $scope.server_port + "&secureputvar=" + $scope.secureputvar)
       .then(function(response) {
            var data = response.data;
            $scope.successmsg = (data.status == 1) ? "Saved Settings" : "";
            $scope.errormsg = data.error;
            $scope.sysmsg = data.sysmsg;
            $scope.loading=0;            
            return data;
       }, function(reason) {
            $scope.errormsg = "Error saving settings";
            $scope.successmsg = "";
            $scope.loading=0;
       });
 }

 //poll();

}
</script>
<? include("/app/footer.inc"); ?>

