<? 
/*********************************************************************
 *
 *  Wattmon
 *    
 *  File : modbusconfig.cgi
 * 
 *  Description: Modbus port settings page
 *
 *********************************************************************
 * Company:         Cynergy Software
 *
 * Software License Agreement
 *
 * Copyright (c) 2013 Cynergy Software.  All rights reserved.
 *
 * Cynergy licenses to you the right to use, modify, copy, and 
 * distribute: 
 * (i)  the Software when used on a Wattmon device
 * (ii) the Software on any platform or device for personal use
 *
 * For commercial use please contact us via http://www.wattmon.com
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT 
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT 
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL 
 * CYNERGY BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR 
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF 
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS 
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE 
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER 
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT 
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Akash Heimlich       20/08/13    v1.0
 *                      25/04/16    Added MAX_RETRIES
 *                      25/11/16    Modbus TCP support
 * Ruchir Sharma        17/10/17    v1.3
 * Akash Heimlich		30/01/18	v1.4 added support for TCP auto close
 * Akash Heimlich       19/05/18    v2.0
 *                      02/10/18    v3.0
 ********************************************************************/
include("/app/config.inc");
$angular_controller="UserEditCtrl"; 
$title='Modbus Settings';
include("/app/header.inc");
?>

<!-- BREADCRUMBS -->
<nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="/"><? print(lang('HOME','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/settings.cgi"><? print(lang('CONTROL_PANEL','settings')) ?></a></li>
    <li class="breadcrumb-item"><a href="/app/devices.cgi"><? print(lang('MODBUS_DEVICES','modbusconfig')) ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><? print(lang('MODBUS_CONFIG_TITLE','modbusconfig')) ?></li>
  </ol>
</nav>

<!-- NAVBAR -->
<h3><i class="icon-cog"></i> <? print(lang('MODBUS_CONFIG_TITLE','modbusconfig')) ?></h3>
<ul class="nav justify-content-end">
  <li class="nav-item">
    <a class="nav-link active" data-toggle="collapse" href="#collapseHelp" role="button" aria-expanded="false" aria-controls="collapseExample">
    HELP
  </a>
  </li>
  <li class="nav-item">
    <a class="nav-link" onclick="document.location='/app/devices.cgi';"><i class="icon-remove"></i> <? print(lang('CLOSE','user')) ?></a>
  </li>
  <li class="nav-item">
    <a class="nav-link {{getClass()}}" ng-hide='settings_locked' ng-click="saveSettings()" ><i class="icon-check"></i> <? print(lang('APPLY','modbusconfig')) ?></a>
  </li>
</ul>
<!-- HELP -->
<div class="collapse" id="collapseHelp">
  <div class="card card-body">
    <? print(lang('HELP1','modbusconfig')) ?>
    <? print(lang('HELP2','modbusconfig')) ?>
    <? print(lang('HELP3','modbusconfig')) ?>
  </div>
</div>
<div class="alert alert-success" ng-cloak ng-show="successmsg"> <button type="button" class="close" ng-click='successmsg=""'>&times;</button>{{successmsg}}</div>
<div class="alert alert-danger" ng-cloak ng-show="errormsg"> <button type="button" class="close" ng-click='errormsg=""'>&times;</button>{{errormsg}}</div>
<div class="alert alert-info" ng-cloak ng-show="infomsg"> <button type="button" class="close" data-dismiss="alert">&times;</button>{{infomsg}}</div>
<form id="form" name="form" class="css-form">
<? 
  //$users=ini_get_array("/config/user.ini");
  if (nvram_get('use_nvram')==1) {
      $baud=nvram_get("modbus_baud",9600);
      $enabled=nvram_get("modbus_enabled",1);
      $parity=nvram_get("modbus_parity",0);
  } else {
      $baud=ini_get("/config/device.ini","general","baud",9600);
      $parity=ini_get("/config/device.ini","general","parity",0);
      $enabled=ini_get("/config/device.ini","general","enabled",1);
      $delay=ini_get("/config/device.ini","general","delay",10);
      $retry=ini_get("/config/device.ini","general","retry",1000);
      $timeout=ini_get("/config/device.ini","general","timeout",1000);
      $max_retries=ini_get("/config/device.ini","general","max_retries",5);

      $baud2=ini_get("/config/device.ini","general","baud2",9600);
      $parity2=ini_get("/config/device.ini","general","parity2",0);
      $enabled2=ini_get("/config/device.ini","general","enabled2",1);
      $delay2=ini_get("/config/device.ini","general","delay2",10);
      $retry2=ini_get("/config/device.ini","general","retry2",1000);
      $timeout2=ini_get("/config/device.ini","general","timeout2",1000);
      $max_retries2=ini_get("/config/device.ini","general","max_retries2",5);

      $rs232_baud=ini_get("/config/device.ini","general","rs232_baud",9600);
      $rs232_parity=ini_get("/config/device.ini","general","rs232_parity",0);
      $rs232_enabled=ini_get("/config/device.ini","general","rs232_enabled",0);
      $rs232_delay=ini_get("/config/device.ini","general","rs232_delay",10);
      $rs232_retry=ini_get("/config/device.ini","general","rs232_retry",1000);
      $rs232_max_retries=ini_get("/config/device.ini","general","rs232_max_retries",5);
      $rs232_timeout=ini_get("/config/device.ini","general","rs232_timeout",1000);
      
      $tcp_delay=ini_get("/config/device.ini","general","tcp_delay",500);
      
      $tcp_retry=ini_get("/config/device.ini","general","tcp_retry",1000);
      
      $tcp_max_retries=ini_get("/config/device.ini","general","tcp_max_retries",1);
      
      $tcp_auto_close=ini_get("/config/device.ini","general","tcp_auto_close",0);
      $tcp_timeout=ini_get("/config/device.ini","general","tcp_timeout",500);
      
      $modbus_tcp_enabled=ini_get("/config/device.ini","general","modbus_tcp_enabled",0);
      $is_mega = $_SERVER['HW_PLATFORM']>=8;
      $modbus_tcp_port=array();
      $modbus_tcp_server=array();
      $modbus_tcp_ip_address=array();
      // single modbus TCP for non-mega
      if (!$is_mega) {
            $max_tcp=1;
            $modbus_tcp_port[0]=ini_get("/config/device.ini","general","modbus_tcp_port",502);
            $modbus_tcp_ip_address[0]=ini_get("/config/device.ini","general","modbus_tcp_ip_address","0.0.0.0");
      } else {
            $max_tcp = 1;
            if (function_exists('sysvar')) {
              $max_tcp=intval(sysvar("MODBUS_TCP_CONNECTION_COUNT"));
            }
            for ($i=0;$i<$max_tcp;$i++) {
                $modbus_tcp_port[$i]=ini_get("/config/device.ini","general","modbus_tcp_port".$i,502);
                $modbus_tcp_ip_address[$i]=ini_get("/config/device.ini","general","modbus_tcp_ip_address".$i,"0.0.0.0");
                $modbus_tcp_server[$i]=ini_get("/config/device.ini","general","modbus_tcp_server".$i,0);
            }
          
      }
  }
?>
<div ng-init="sysmsg='<? if ($_GLOBALS['needreboot']) print("You will need to reboot the device for changes to take effect."); ?>';"></div>
<div ng-init="baud=<? print($baud); ?>;"></div>
<div ng-init="parity='<? print($parity); ?>';"></div>
<div ng-init="enabled=<? print($enabled); ?>;"></div>
<div ng-init="retry=<? print($retry); ?>;"></div>
<div ng-init="delay=<? print($delay); ?>;"></div>
<div ng-init="timeout=<? print($timeout); ?>;"></div>

<? if ($_SERVER['HW_PLATFORM']==11 || $_SERVER['HW_PLATFORM']>=20) { ?>
<div ng-init="baud2=<? print($baud2); ?>;"></div>
<div ng-init="parity2='<? print($parity2); ?>';"></div>
<div ng-init="enabled2=<? print($enabled2); ?>;"></div>
<div ng-init="retry2=<? print($retry2); ?>;"></div>
<div ng-init="delay2=<? print($delay2); ?>;"></div>
<div ng-init="timeout2=<? print($timeout2); ?>;"></div>
<div ng-init="max_retries2=<? print($max_retries2); ?>;"></div>
<? } ?>

<div ng-init="rs232_baud=<? print($rs232_baud); ?>;"></div>
<div ng-init="rs232_parity='<? print($rs232_parity); ?>';"></div>
<div ng-init="rs232_enabled=<? print($rs232_enabled); ?>;"></div>
<div ng-init="rs232_retry=<? print($rs232_retry); ?>;"></div>
<div ng-init="rs232_delay=<? print($rs232_delay); ?>;"></div>
<div ng-init="rs232_max_retries=<? print($rs232_max_retries); ?>;"></div>
<div ng-init="rs232_timeout=<? print($rs232_timeout); ?>;"></div>

<div ng-init="tcp_retry=<? print($tcp_retry); ?>;"></div>
<div ng-init="max_retries=<? print($max_retries); ?>;"></div>
<div ng-init="tcp_max_retries=<? print($tcp_max_retries); ?>;"></div>
<div ng-init="tcp_timeout=<? print($tcp_timeout); ?>;"></div>
<div ng-init="tcp_auto_close=<? print($tcp_auto_close); ?>;"></div>
<div ng-init="tcp_delay=<? print($tcp_delay); ?>;"></div>
<div ng-init="modbus_tcp_enabled=<? print($modbus_tcp_enabled); ?>;"></div>
<div ng-init="modbus_tcp_count=<? print($max_tcp); ?>;"></div>
<? for ($i=0;$i<$max_tcp;$i++) { ?>
<div ng-init="modbus_tcp_port<? print($i."=".$modbus_tcp_port[$i]); ?>;"></div>
<div ng-init="modbus_tcp_ip_address<? print($i."='".$modbus_tcp_ip_address[$i]); ?>';"></div>
<div ng-init="modbus_tcp_server<? print($i."='".$modbus_tcp_server[$i]); ?>';"></div>
<? } ?>
<div class="card">
  <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS_TITLE','modbusconfig')) ?></h5>
        <p class="card-text">
            <div class="form-group">
                <label for="enabled"><small class='text-muted'><? print(lang('STATUS','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('STATUS_ENABLED','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('STATUS_DISABLED','modbusconfig')) ?>
                  </label>
                </div>
                
                <small id="dnHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','modbusconfig')) ?></small>
            </div>
    
        </p>
    </div>
</div>
<br/>
<div class="card" ng-show='enabled==1'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS_RTU_TITLE','modbusconfig')) ?></h5>
        <p class="card-text">    

            <div class="form-group">
                <label for="baud"><? print(lang('BAUD','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="baud"  class='span12' name='baud' required min="1200" max="115200" integer aria-describedby="bHelp" placeholder="<? print(lang('BAUD','modbusconfig')) ?>">
                <small id="bHelp" class="form-text text-muted"><? print(lang('BAUD_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.baud.$invalid"><? print(lang('BAUD_INVALID','modbusconfig')) ?></small>
            </div>
            
            <div class="form-group">
                <label for="parity"><small class='text-muted'><? print(lang('PARITY','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity" id="parity0" value="0">
                  <label class="form-check-label" for="parity0">
                    &nbsp;<? print(lang('PARITY_NONE','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity" id="parity1" value="1">
                  <label class="form-check-label" for="parity1">
                    &nbsp;<? print(lang('PARITY_EVEN','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity" id="parity2" value="2">
                  <label class="form-check-label" for="parity2">
                    &nbsp;<? print(lang('PARITY_ODD','modbusconfig')) ?>
                  </label>
                </div>  
                
                <small id="pHelp" class="form-text text-muted"><? print(lang('PARITY_HELP','modbusconfig')) ?></small>
            </div>
            <div class="form-group">
                <label for="delay"><? print(lang('DELAY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="delay"  class='span12' name='delay' required min="1" max="30000" integer aria-describedby="dHelp" placeholder="<? print(lang('DELAY','modbusconfig')) ?>">
                <small id="dHelp" class="form-text text-muted"><? print(lang('DELAY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.delay.$invalid"><? print(lang('DELAY_INVALID','modbusconfig')) ?></small>
            </div>   
            <div class="form-group">
                <label for="timeout"><? print(lang('TIMEOUT','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="timeout"  class='span12' name='timeout' required min="5" max="10000" integer aria-describedby="tHelp" placeholder="<? print(lang('TIMEOUT','modbusconfig')) ?>">
                <small id="tHelp" class="form-text text-muted"><? print(lang('TIMEOUT_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.timeout.$invalid"><? print(lang('TIMEOUT_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="retry"><? print(lang('RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="retry"  class='span12' name='retry' required min="0" max="30000" integer aria-describedby="rHelp" placeholder="<? print(lang('RETRY','modbusconfig')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.retry.$invalid"><? print(lang('RETRY_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="max_retries"><? print(lang('MAX_RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="max_retries"  class='span12' name='max_retries' required min="0" max="20" integer aria-describedby="mrHelp" placeholder="<? print(lang('MAX_RETRY','modbusconfig')) ?>">
                <small id="mrHelp" class="form-text text-muted"><? print(lang('MAX_RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.max_retries.$invalid"><? print(lang('MAX_RETRY_INVALID','modbusconfig')) ?></small>
            </div>   		
        </p>    
    </div>
</div>
<br>
<? if ($_SERVER['HW_PLATFORM']<=10) { ?>
<div class="card">
  <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS_RS232_TITLE','modbusconfig')) ?></h5>
        <p class="card-text">
            <div class="form-group">
                <label for="rs232_enabled"><small class='text-muted'><? print(lang('STATUS','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="rs232_enabled" id="exampleRadios4" value="1">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;<? print(lang('STATUS_RS232_ENABLED','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="rs232_enabled" id="exampleRadios5" value="0">
                  <label class="form-check-label" for="exampleRadios5">
                    &nbsp;<? print(lang('STATUS_RS232_DISABLED','modbusconfig')) ?>
                  </label>
                </div>
                
                <small id="dnHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','modbusconfig')) ?></small>
            </div>
    
        </p>
    </div>
</div>
<br/>
<div class="card" ng-show='rs232_enabled==1'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS_RS232_TITLE','modbusconfig')) ?></h5>
        <p class="card-text">    

            <div class="form-group">
                <label for="rs232_baud"><? print(lang('BAUD','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="rs232_baud"  class='span12' name='rs232_baud' required min="1200" max="115200" integer aria-describedby="bHelp" placeholder="<? print(lang('BAUD','modbusconfig')) ?>">
                <small id="bHelp" class="form-text text-muted"><? print(lang('BAUD_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.rs232_baud.$invalid"><? print(lang('BAUD_INVALID','modbusconfig')) ?></small>
            </div>
            
            <div class="form-group">
                <label for="rs232_parity"><small class='text-muted'><? print(lang('PARITY','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="rs232_parity" id="parity3" value="0">
                  <label class="form-check-label" for="parity3">
                    &nbsp;<? print(lang('PARITY_NONE','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="rs232_parity" id="parity4" value="1">
                  <label class="form-check-label" for="parity4">
                    &nbsp;<? print(lang('PARITY_EVEN','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="rs232_parity" id="parity5" value="2">
                  <label class="form-check-label" for="parity5">
                    &nbsp;<? print(lang('PARITY_ODD','modbusconfig')) ?>
                  </label>
                </div>  
                
                <small id="pHelp" class="form-text text-muted"><? print(lang('PARITY_HELP','modbusconfig')) ?></small>
            </div>
            <div class="form-group">
                <label for="rs232_delay"><? print(lang('DELAY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="delay"  class='span12' name='rs232_delay' required min="1" max="30000" integer aria-describedby="dHelp" placeholder="<? print(lang('DELAY','modbusconfig')) ?>">
                <small id="dHelp" class="form-text text-muted"><? print(lang('DELAY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.rs232_delay.$invalid"><? print(lang('DELAY_INVALID','modbusconfig')) ?></small>
            </div>   
            <div class="form-group">
                <label for="rs232_timeout"><? print(lang('TIMEOUT','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="rs232_timeout"  class='span12' name='rs232_timeout' required min="5" max="10000" integer aria-describedby="tHelp" placeholder="<? print(lang('TIMEOUT','modbusconfig')) ?>">
                <small id="tHelp" class="form-text text-muted"><? print(lang('TIMEOUT_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.rs232_timeout.$invalid"><? print(lang('TIMEOUT_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="rs232_retry"><? print(lang('RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="rs232_retry"  class='span12' name='rs232_retry' required min="0" max="30000" integer aria-describedby="rHelp" placeholder="<? print(lang('RETRY','modbusconfig')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.rs232_retry.$invalid"><? print(lang('RETRY_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="rs232_max_retries"><? print(lang('MAX_RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="rs232_max_retries"  class='span12' name='rs232_max_retries' required min="0" max="20" integer aria-describedby="mrHelp" placeholder="<? print(lang('MAX_RETRY','modbusconfig')) ?>">
                <small id="mrHelp" class="form-text text-muted"><? print(lang('MAX_RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.rs232_max_retries.$invalid"><? print(lang('MAX_RETRY_INVALID','modbusconfig')) ?></small>
            </div>   		
        </p>    
    </div>
</div>
<? } else if ($_SERVER['HW_PLATFORM']!=12) { ?>
<div class="card">
  <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS2_TITLE','modbusconfig')) ?></h5>
        <p class="card-text">
            <div class="form-group">
                <label for="enabled2"><small class='text-muted'><? print(lang('STATUS','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled2" id="exampleRadios2" value="1">
                  <label class="form-check-label" for="exampleRadios2">
                    &nbsp;<? print(lang('STATUS_ENABLED','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled2" id="exampleRadios1" value="0">
                  <label class="form-check-label" for="exampleRadios1">
                    &nbsp;<? print(lang('STATUS_DISABLED','modbusconfig')) ?>
                  </label>
                </div>
<? if ($_GLOBALS['VERMINOR'] >= 1297) { ?>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="enabled2" id="exampleRadios3" value="2">
                  <label class="form-check-label" for="exampleRadios3">
                    &nbsp;RTU Bridge
                  </label>
                </div>  
<? } ?>                
                <small id="dnHelp" class="form-text text-muted"><? print(lang('STATUS_HELP','modbusconfig')) ?></small>
            </div>
    
        </p>
    </div>
</div>
<br/>
<div class="card" ng-show='enabled2>=1'>
    <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS2_RTU_TITLE','modbusconfig')) ?></h5>
        <p class="card-text">    

            <div class="form-group">
                <label for="baud2"><? print(lang('BAUD','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="baud2"  class='span12' name='baud2' required min="1200" max="115200" integer aria-describedby="bHelp" placeholder="<? print(lang('BAUD','modbusconfig')) ?>">
                <small id="bHelp" class="form-text text-muted"><? print(lang('BAUD_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.baud2.$invalid"><? print(lang('BAUD_INVALID','modbusconfig')) ?></small>
            </div>
            
            <div class="form-group">
                <label for="parity2"><small class='text-muted'><? print(lang('PARITY','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity2" id="parity02" value="0">
                  <label class="form-check-label" for="parity02">
                    &nbsp;<? print(lang('PARITY_NONE','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity2" id="parity12" value="1">
                  <label class="form-check-label" for="parity12">
                    &nbsp;<? print(lang('PARITY_EVEN','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="parity2" id="parity22" value="2">
                  <label class="form-check-label" for="parity22">
                    &nbsp;<? print(lang('PARITY_ODD','modbusconfig')) ?>
                  </label>
                </div>  
                
                <small id="pHelp" class="form-text text-muted"><? print(lang('PARITY_HELP','modbusconfig')) ?></small>
            </div>
            <div class="form-group">
                <label for="delay2"><? print(lang('DELAY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="delay2"  class='span12' name='delay2' required min="1" max="30000" integer aria-describedby="dHelp" placeholder="<? print(lang('DELAY','modbusconfig')) ?>">
                <small id="dHelp" class="form-text text-muted"><? print(lang('DELAY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.delay2.$invalid"><? print(lang('DELAY_INVALID','modbusconfig')) ?></small>
            </div>   
            <div class="form-group">
                <label for="timeout2"><? print(lang('TIMEOUT','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="timeout2"  class='span12' name='timeout2' required min="5" max="10000" integer aria-describedby="tHelp" placeholder="<? print(lang('TIMEOUT','modbusconfig')) ?>">
                <small id="tHelp" class="form-text text-muted"><? print(lang('TIMEOUT_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.timeout2.$invalid"><? print(lang('TIMEOUT_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="retry2"><? print(lang('RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="retry2"  class='span12' name='retry2' required min="0" max="30000" integer aria-describedby="rHelp" placeholder="<? print(lang('RETRY','modbusconfig')) ?>">
                <small id="rHelp" class="form-text text-muted"><? print(lang('RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.retry2.$invalid"><? print(lang('RETRY_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="max_retries2"><? print(lang('MAX_RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="max_retries2"  class='span12' name='max_retries2' required min="0" max="20" integer aria-describedby="mrHelp" placeholder="<? print(lang('MAX_RETRY','modbusconfig')) ?>">
                <small id="mrHelp" class="form-text text-muted"><? print(lang('MAX_RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.max_retries2.$invalid"><? print(lang('MAX_RETRY_INVALID','modbusconfig')) ?></small>
            </div>   		
        </p>    
    </div>
</div>
<br>
<? } ?>
<br>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS_TCP_TITLE','modbusconfig')) ?></h5>
        <p class="card-text">    
             <div class="form-group">
                <label for="modbus_tcp_enabled"><small class='text-muted'><? print(lang('TCPSTATUS','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="modbus_tcp_enabled" id="exampleRadios4" value="1">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;<? print(lang('TCPSTATUS_ENABLED','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="modbus_tcp_enabled" id="exampleRadios5" value="0">
                  <label class="form-check-label" for="exampleRadios5">
                    &nbsp;<? print(lang('TCPSTATUS_DISABLED','modbusconfig')) ?>
                  </label>
                </div>
                
                <small id="dnHelp" class="form-text text-muted"><? print(lang('TCPSTATUS_HELP','modbusconfig')) ?></small>
            </div>
      	    <div class="form-group">
                <label for="tcp_delay"><? print(lang('DELAY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="tcp_delay"  class='span12' name='tcp_delay' required min="1" max="30000" integer aria-describedby="tdHelp" placeholder="<? print(lang('DELAY','modbusconfig')) ?>">
                <small id="tHelp" class="form-text text-muted"><? print(lang('DELAY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.tcp_delay.$invalid"><? print(lang('DELAY_INVALID','modbusconfig')) ?></small>
            </div>   
            <div class="form-group">
                <label for="tcp_timeout"><? print(lang('TIMEOUT','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="tcp_timeout"  class='span12' name='tcp_timeout' required min="5" max="10000" integer aria-describedby="ttHelp" placeholder="<? print(lang('TIMEOUT','modbusconfig')) ?>">
                <small id="ttHelp" class="form-text text-muted"><? print(lang('TIMEOUT_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.tcp_timeout.$invalid"><? print(lang('TIMEOUT_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="tcp_retry"><? print(lang('RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="tcp_retry"  class='span12' name='tcp_retry' required min="0" max="30000" integer aria-describedby="trHelp" placeholder="<? print(lang('RETRY','modbusconfig')) ?>">
                <small id="trHelp" class="form-text text-muted"><? print(lang('RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.tcp_retry.$invalid"><? print(lang('RETRY_INVALID','modbusconfig')) ?></small>
            </div>   		
            <div class="form-group">
                <label for="tcp_max_retries"><? print(lang('MAX_RETRY','modbusconfig')) ?></label>
                <input class="form-control" type='number' ng-model="tcp_max_retries"  class='span12' name='tcp_max_retries' required min="0" max="20" integer aria-describedby="tmrHelp" placeholder="<? print(lang('MAX_RETRY','modbusconfig')) ?>">
                <small id="tmrHelp" class="form-text text-muted"><? print(lang('MAX_RETRY_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.tcp_max_retries.$invalid"><? print(lang('MAX_RETRY_INVALID','modbusconfig')) ?></small>
            </div>   
	        <div class="form-group">
                <label for="tcp_auto_close"><small class='text-muted'><? print(lang('TCPCLOSE','modbusconfig')) ?></small></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="tcp_auto_close" id="exampleRadios4" value="1">
                  <label class="form-check-label" for="exampleRadios4">
                    &nbsp;<? print(lang('TCPCLOSE_ENABLED','modbusconfig')) ?>
                  </label>
                </div>  
                <div class="form-check">
                  <input class="form-check-input" type="radio" ng-model="tcp_auto_close" id="exampleRadios5" value="0">
                  <label class="form-check-label" for="exampleRadios5">
                    &nbsp;<? print(lang('TCPCLOSE_DISABLED','modbusconfig')) ?>
                  </label>
                </div>
                
                <small id="tdnHelp" class="form-text text-muted"><? print(lang('TCPCLOSE_HELP','modbusconfig')) ?></small>
            </div>
		</p>
	</div>
</div>		

		
		
<? for ($i=0;$i<$max_tcp;$i++) { ?>
<div class="card">
    <div class="card-body">
        <h5 class="card-title"><? print(lang('MODBUS_TCP_CHANNEL','modbusconfig')." ".($i+1)) ?></h5>
        <p class="card-text">    
        	<div class="form-group">
                <label for="modbus_tcp_server<? print($i); ?>"><? print(lang('SERVER','modbusconfig')) ?></label>
                
                <input type="checkbox" ng-model="modbus_tcp_server<? print($i); ?>" ng-true-value="1" ng-false-value="0">

                <small id="dnHelp<? print($i); ?>" class="form-text text-muted"><? print(lang('SERVER_HELP','modbusconfig')) ?></small>
            </div>
            <div class="form-group" ng-show="modbus_tcp_server<? print($i); ?>==1">
                <a href='/app/modbus_report.cgi' target="_blank" class='btn btn-primary'>View Register Map</a>
            </div>
        	<div class="form-group" ng-hide="modbus_tcp_server<? print($i); ?>==1">
                <label for="modbus_tcp_ip_address<? print($i); ?>"><? print(lang('IP_ADDRESS','modbusconfig')) ?></label>
                <input type="text" class="form-control" ng-model="modbus_tcp_ip_address<? print($i); ?>"  class='span12' name='modbus_tcp_ip_address<? print($i); ?>' required aria-describedby="dnHelp<? print($i); ?>" my-directive placeholder="<? print(lang('IP_ADDRESS','modbusconfig')) ?>">
                <small id="dnHelp<? print($i); ?>" class="form-text text-muted"><? print(lang('IP_ADDRESS_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.modbus_tcp_ip_address<? print($i); ?>.$invalid"><? print(lang('IP_ADDRESS_INVALID','modbusconfig')) ?></small>
            </div>
        	<div class="form-group">
                <label for="modbus_tcp_port<? print($i); ?>"><? print(lang('PORT','modbusconfig')) ?></label>
                <input type="number" class="form-control" ng-model="modbus_tcp_port<? print($i); ?>"  min="0" max="65535" class='span12' name='modbus_tcp_port<? print($i); ?>' required aria-describedby="dnpHelp<? print($i); ?>"  placeholder="<? print(lang('PORT','modbusconfig')) ?>">
                <small id="dnpHelp<? print($i); ?>" class="form-text text-muted"><? print(lang('PORT_HELP','modbusconfig')) ?></small>
                <small ng-cloak class='text-danger' ng-show="form.modbus_tcp_port<? print($i); ?>.$invalid"><? print(lang('PORT_INVALID','modbusconfig')) ?></small>
            </div>
        </p>
    </div>
</div>		
<? } ?>		
      
</form>

     <script>
     var app = angular.module('myApp', []);
      app.directive('myDirective', function() {
  return {
    require: 'ngModel',
    link: function(scope, element, attr, mCtrl) {
      function myValidation(value) {
        console.log(value);
        
        var regex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
        if(regex.test(value) == false){
            mCtrl.$setValidity('charE', false);
          
        } else {
            mCtrl.$setValidity('charE', true);
        }
        return value;
      }
      mCtrl.$parsers.push(myValidation);
    }
  };
});
     function UserEditCtrl($scope,$http) {
   var self = this;
   $scope.infomsg="";
   
   $scope.settings_locked=settings_locked;
   if (settings_locked) 
        $scope.errormsg="Unable to save settings since the Flash is locked.  Please unlock first.";
   
    $scope.getClass=function() {
    if ($scope.form.$invalid) return "disabled";
    return "";
  }
 
   $scope.saveSettings=function () {
       $scope.successmsg="";
       $scope.errormsg="";
       $scope.infomsg="";
    if ($scope.form.$invalid) {
        $scope.errormsg="One or more fields have invalid values.  Please fix that and try again.";
        return;
    }
       
       if ($scope.baud < 300) {
            $scope.errormsg="Invalid baud rate";
            return;
       }
       <? if (nvram_get("use_nvram")==1) { ?>
       $http.post('/app/configsavenvram.cgi',"modbus_baud="+$scope.baud+"&modbus_parity="+$scope.parity+"&modbus_enabled="+$scope.enabled+"&retry="+$scope.retry)
       <? } else { ?>
       $http.post('/app/configsave.cgi?config=device.ini&section=general',"baud="+$scope.baud+
            "&parity="+$scope.parity+
            "&enabled="+$scope.enabled+
            "&delay="+$scope.delay+
            "&timeout="+$scope.timeout+
            "&retry="+$scope.retry+
            "&max_retries="+$scope.max_retries+
<? if ($_SERVER['HW_PLATFORM']<=10) { ?>
            "&rs232_baud="+$scope.rs232_baud+
            "&rs232_parity="+$scope.rs232_parity+
            "&rs232_enabled="+$scope.rs232_enabled+
            "&rs232_delay="+$scope.rs232_delay+
            "&rs232_timeout="+$scope.rs232_timeout+
            "&rs232_retry="+$scope.rs232_retry+
            "&rs232_max_retries="+$scope.rs232_max_retries+
<? } else { ?>            
            "&baud2="+$scope.baud2+
            "&parity2="+$scope.parity2+
            "&enabled2="+$scope.enabled2+
            "&delay2="+$scope.delay2+
            "&timeout2="+$scope.timeout2+
            "&retry2="+$scope.retry2+
            "&max_retries2="+$scope.max_retries2+
<? } ?>
            "&max_retries="+$scope.max_retries+
            "&tcp_delay="+$scope.tcp_delay+
            "&tcp_timeout="+$scope.tcp_timeout+
            "&tcp_retry="+$scope.tcp_retry+
            "&tcp_max_retries="+$scope.tcp_max_retries+
            "&tcp_auto_close="+$scope.tcp_auto_close+
            "&modbus_tcp_enabled="+$scope.modbus_tcp_enabled+
<? if ($max_tcp==1) { ?>            
            "&modbus_tcp_port="+$scope.modbus_tcp_port0+
            "&modbus_tcp_ip_address="+$scope.modbus_tcp_ip_address0+
<? } else { 
        for ($i=0;$i<$max_tcp;$i++) {
            print('"&modbus_tcp_port'.$i.'="+$scope.modbus_tcp_port'.$i."+\r\n".
            '"&modbus_tcp_ip_address'.$i.'="+$scope.modbus_tcp_ip_address'.$i."+\r\n");
            print('"&modbus_tcp_server'.$i.'="+$scope.modbus_tcp_server'.$i."+\r\n");
        }
} 
?>
            ""
            )
       <? } ?>
        .then(function (response) {
          var data = response.data; 
          $scope.successmsg=(Number(data.status)==1)?"Saved Settings":"Error Saving";
          $scope.errormsg=data.error;
          $scope.sysmsg=data.sysmsg;
          return data;
        }, function(reason) {
            $scope.errormsg="Error saving settings";
            $scope.successmsg="";
            //alert('Failed: ' + reason);
           
        });
   }
    
  //poll();

}</script>
<? include("/app/footer.inc"); ?>





